/* This header should be included by all other source files in the
 * ms2-extra project.
 */

/* $Id: ms2_extra.h,v 1.2 2007-05-05 22:18:50 jsmcortina Exp $ */
#ifndef _MS2_EXTRA_H
#define _MS2_EXTRA_H

#include "hcs12def.h"      /* common defines and macros */
#include "flash.h"         /* flashburner defines, structures */
#include <string.h>

extern void _start(void);       /* Startup routine */

//#define CAN_TEST

#define EEPROM_ATTR __attribute__ ((section (".eeprom")))
#define TEXT3_ATTR __attribute__ ((section (".text3")))
#define INTERRUPT
#define POST_INTERRUPT __attribute__((interrupt))
#define POST_INTERRUPT_TEXT3 __attribute__ ((section (".text3"))) __attribute__((interrupt))
#define POST_INTERRUPT_TEXT3d __attribute__ ((section (".text3d"))) __attribute__((interrupt))
#define ENABLE_INTERRUPTS __asm__ __volatile__ ("cli");
#define DISABLE_INTERRUPTS __asm__ __volatile__ ("sei");
#define NEAR
#define VECT_ATTR __attribute__ ((section (".vectors")))

INTERRUPT void UnimplementedISR(void) POST_INTERRUPT;

INTERRUPT void ISR_TimerOverflow(void) POST_INTERRUPT;
INTERRUPT void ISR_Timer_Clock(void) POST_INTERRUPT;
INTERRUPT void ISR_SCI_Comm(void) POST_INTERRUPT;

typedef void (* NEAR tIsrFunc)(void);

#define NO_TBLES 	9
#define NO_FMAPS 	12
#define NO_SMAPS 	12
#define NO_FRPMS 	12
#define NO_SRPMS 	12
#define NO_ARPMS  6
#define NO_ATPSS  6
#define NO_INJ		2
#define NO_TEMPS 	10
#define NO_MAT_TEMPS 	6
#define NO_BARS 	6
#define NO_MATS 	6
#define NO_TPS_DOTS   4
#define NO_MAP_DOTS   4
#define NO_KNKRPMS  6
#define NPORT    7
#define NO_COILCHG_PTS  6
#define EGODT  78        /* 78 .128 ms tics = 10 ms */
#define END_SYNCH  3
#define MAXNUMTEETH 120
#define SIZEOFTXBUF 141 // be sure to update ms2extrah.inc as well

#define	MSG_CMD	0
#define	MSG_REQ	1
#define	MSG_RSP	2
#define	MSG_XSUB	3
#define	NO_VAR_BLKS	16
#define NO_CANMSG 10
#define NO_CANBOARDS 16
#define CANID_THIS_BOARD 0
// Error status words:
//    -bits 0-7 are current errors
//    -bits 8-15 are corresponding latched errors
#define	XMT_ERR			0x0101
#define	CLR_XMT_ERR		0xFFFE
#define	XMT_TOUT		0x0202
#define	CLR_XMT_TOUT	0xFFFD
#define	RCV_ERR			0x0404
#define	CLR_RCV_ERR		0xFFFB
#define	SYS_ERR		0x0808

// User inputs - 1 set in flash, 1 in ram
typedef struct {
    unsigned char no_cyl,no_skip_pulses,      // skip >= n pulses at startup
		  ICIgnOption,     // Bit 0: Input capture: 0 = falling edge, 1 rising
                  // bit 3: 0 = evenfire, 1 = oddfire
                  // bit 4 = spk out hi/lo 0 = spk low (gnd)

		  XXspkout_hi_lo,    // Ign Output compare: 0 = spark low (gnd)
		  max_coil_dur,max_spk_dur,DurAcc;        // ms x 15 (10* 3/2)
    unsigned char deltV_table[NO_COILCHG_PTS],deltDur_table[NO_COILCHG_PTS], // Vx10,%age/2
     PredOpt;          // Option for prediction algorithm for next tach plse
    //  0=use last time interval
    //  1=use 1st deriv prediction; 2=use 1st deriv at hi
    //   rpm, 2nd deriv prediction at lo rpm;
    //  3=use 2nd deriv prediction always.
    int crank_rpm;        // rpm at which cranking is through (~300 - 400 rpm)
    int cold_adv_table[NO_TEMPS],
	adv_offset,        // all in deg x 10
	//     adv_offset is no deg(x10) between trigger (Input Capture) and TDC.
	//     It may be +btdc (IC1 to TDC) or -atdc (TDC to IC2).
	//
	//    |               |     |
	//    |               |     |
	//   -|---------------|-----|-
	//   IC1             TDC    IC2
	RevLimRpm1,RevLimRpm2;  // Optn 1:Retard spk by 0 deg at Rpm1 and increase
    //    to RevLimMaxRtd at Rpm2
    // Optn 2:Cut fuel above Rpm2, restore below Rpm1
    unsigned char afr_table[NO_INJ][NO_FMAPS][NO_FRPMS],            // afr x 10
		  warmen_table[NO_TEMPS], // % enrichment vs temp
		  tpsen_table[NO_TPS_DOTS], // accel enrichment pw in .1 ms units vs tpsdot
		  mapen_table[NO_MAP_DOTS]; // accel enrichment pw in .1 ms units vs mapdot
    int iacstep_table[NO_TEMPS]; // iac steps vs temp
    unsigned int frpm_tablea[NO_INJ][NO_FRPMS];  // fuel, spk rpm tables
    int fmap_tablea[NO_INJ][NO_FMAPS],	    // kpa x 10,
	temp_table[NO_TEMPS],             // deg x 10 (C or F)
	tpsdot_table[NO_TPS_DOTS],        // change in % x 10 per .1 sec
	mapdot_table[NO_MAP_DOTS];        // change in kPa x 10 per .1 sec
    int map0,mapmax,clt0,cltmult,mat0,matmult,tps0,tpsmax,batt0,battmax,
	// kPa x 10, deg F or C x 10, adc counts, volts x 10
	ego0,egomult,baro0,baromax,bcor0,bcormult,knock0,knockmax;
    // afr x 10, kpa x 10, volts x 100
    int Dtpred_Gain;  // %
    unsigned char CrnkTol,ASTol,PulseTol,   // % tolerance for next input pulse
		  // timing during cranking, after start/warmup and normal running
		  IdleCtl,         // idle: 0 = none, 1= solenoid, 2= iac stepper motor
		  //  - enabled only when moving, 3 = iac motor - always enabled.
		  // 4 = Ford pwm, 5 = 3 for 15 min, then = 2.
		  IACtstep,        // iac stepper motor nominal time between steps (.1 ms units)
		  IACaccstep,      // iac stepper motor accel/decel step time (.1 ms)-future use
		  IACnaccstep,     // iac stepper motor no. of accel/decel steps - future use
		  dwellduty;       // dwell duty%
    int IACStart,     // no. of steps to send at startup to put stepper
	//    motor at reference (wide open) position
	IdleHyst,        // amount clt temp must move before Idle position is changed
	IACcrankpos,     // IAC pos must be open(<) at least this much(steps) in cranking
	IACcrankxt,      // no. seconds from end of cranking for IAC pos to blend into
	// coolant dependent pos.
	IACcoldtmp,IACcoldpos,IACcoldxt;
    char crap1[16];
    unsigned char  Tpsacold,     // cold (-40F) accel amount in .1 ms units
		   AccMult,         // cold (-40F) accel multiply factor (%)
		   TpsThresh,       // tpsdot threshhold for acc/decel enrichment(change in %x10 per .1 sec)
		   MapThresh,       // mapdot threshhold for acc/decel enrichment(change in kPax10 per .1 s)
		   TpsAsync,        // clock duration (in .1 sec tics) for accel enrichment
		   TPSDQ;           // deceleration fuel cut option (%)
    int TPSWOT,       // TPS value at WOT (for flood clear) in %x10
	TPSOXLimit;      // Max tps value (%x10) where O2 closed loop active
    unsigned char Tps_acc_wght,    // weight (0-100) to be given to tpsdot for accel enrichment.
		  //  100 - Tps_acc_wght will then be given to mapdot.
		  BaroOption,      // 0=no baro, 1=baro is 1st reading of map (before cranking),
		  // 2=independent barometer (=> EgoOption not 2 or 4)
		  EgoOption,       // 0 = no ego;1= nb o2;2=2 nb o2;3=single wbo2;4=dual wbo2. NOTE:
		  //  BaroOption MUST be < 2 if EgoOption = 2 or 4.
		  EgoCountCmp,     // Ign Pulse counts between when EGO corrections are made
		  EgoStep,         // % step change for EGO corrections
		  EgoLimit,        // Upper/Lower rail limit (egocorr inside 100 +/- limit)
		  AFRTarget,       // NBO2 AFR determining rich/ lean
		  Temp_Units,      // 0= coolant & mat in deg F; 1= deg C
		  MafOption,cpad2; // MAF options - (future use)
    int FastIdle,     // fast idle Off temperature (idle_ctl = 1 only)
	EgoTemp,         // min clt temp where ego active
	RPMOXLimit;      // Min rpm where O2 closed loop is active
    unsigned int ReqFuel;     // fuel pulsewidth (usec) at wide open throttle
    unsigned char Divider,    // divide factor for input tach pulses
		  Alternate,       // option to alternate injector banks. bit 0 normal function, bit 1 means /2 during crank
		  InjOpen,         // Injector open time (.1 ms units)
		  InjPWMTim,       // Time (.1 ms units) after Inj opening to start pwm
		  InjPWMPd,        // Inj PWM period (us) - keep between 10-25 KHz (100-40 us)
		  InjPWMDty,       // Inj PWM duty cycle (%)
		  BatFac,          // Battery fuel pw correction factor (msx10)
		  EngStroke,       // 0 = 4 stroke
		  // 1 = 2 stroke
		  InjType,         // 0 = port injection
		  // 1 = throttle body
		  NoInj;           // no. of injectors (1-12)
unsigned int	  OddFireang;        //  smaller angle bet firings (deg*10)
unsigned char	  rpmLF,mapLF,tpsLF,   // Lag filter coefficient for Rpm,Map,Tps. Acts like
		  egoLF,           // averager: xnew = xold + xLF * (xmeas - xold), so xLF=0
		  adcLF,knkLF,     // means value will never change, xLF=100 means no filtering.
		  // egoLF is coefficient for ego filter, adcLF is for clt,mat,batt,
		  // knkLF is for knock.
		  AMCOption,       // Automatic Mixture Control Option: 0 = none; 1= automatic updates
		  // to ram ve table(s); 2= also automatically updates flash ve tables.
		  dual_tble_optn,  // 1 = use dual table option - ve, afr tables for each inj
		  FuelAlgorithm,       // option for alpha-N mode: 0=none;1=use map,tps blend algorithm;
		  //   2=same as 1, but don't use kpa multiplier in plsewidth eq.
		  //   3=%Baro
		  IgnAlgorithm,        // option to use map,tps(alphaN) blend algorithm for ignition
		  AfrAlgorithm,        // option to use map,tps(alphaN) blend algorithm for WBO2 AFR
		  dwelltime;       // time in 0.1ms
    unsigned int trigret_ang; // angle between trigger and return
    char RevLimOption,     // 0=none, 1=spark retard, 2=fuel cut
	 RevLimMaxRtd;     // max amount of spark retard (degx10) (at Rpm2 below)
    int dummy[47];
    char dummy2;
    unsigned char loadopts; // bit 0: 1 mult for fuel, 0 add for fuel
    			    // bit 2: 1 multiply "load" into final equation, 2 don't
    unsigned long baud;         // baud rate
    int MAPOXLimit;   // Max map value (kPax10) where O2 closed loop active
    unsigned char board_id_type[NO_CANBOARDS];  // board type (1-255) of ith board;
    // type=0, no board present at ith slot.
    // type=1, ECU (MS II)
    // type=2. Router board
    // type=3, I/O board, ......
    // Generic spare port parameters: spr_port = 0(don't use)/1(use),where
    // spr_port[0-7] = PM2 - PM5; PTT6,7; PORTA0; they are set as outs to main
    //  pcb; out_offset,out_byte= byte offset from start of outpc structure and
    // size in bytes of 1st, 2nd variables to be tested for setting port;
    // condition='<', '>', '=';cond12 = '&','|',' ' connects the conditions for
    // the two variables with ' ' meaning only the first variable condition is
    // desired; thresh = value for the condition(e.g., var1 > thresh1); init_val,
    // port_val=value (0/1) to which the pin will be set at startup and when the
    // condition(s) is met; hyst is a hysteresis delta and works as ff: if a
    // setpoint condition is > and it is met, set port to val and leave until
    // variable is < thresh - hyst, then set pin back to 1 - val. Similarly if
    // condition is <, wait til var > thresh + hyst. For dual conditions, the
    // hysteresis conditions are evaluated the same way, but use the opposite
    // of cond12 to connect them (if cnd12 is &, use | and vice versa).
    char
	spr_port   [NPORT], // NPORT == 7
		   condition1 [NPORT],
		   condition2 [NPORT],
		   cond12     [NPORT],
		   init_val   [NPORT],
		   port_val   [NPORT],
		   out_byte1  [NPORT],
		   out_byte2  [NPORT];
    int
	out_offset1[NPORT],
	out_offset2[NPORT],
	thresh1    [NPORT],
	thresh2    [NPORT],
	hyst1      [NPORT],
	hyst2      [NPORT];
    unsigned char
	TpsAsync2,  // accel tailoff duration (sec x 10)
	cpad4;
    int
	TpsAccel2;      // end pulsewidth of accel enrichment (ms x 10)
    unsigned char
	EgoAlg, // 0=simple prop error algorithm;
	// 1=same algorithm with variable transport delay;
	// 2=full PID with Smith Pred correction.
	egoKP,
	egoKI,
	egoKD;    // PID coefficients in %; egoKP also gain for
    // EgoAlg=0, with 100 = no gain; egoKD includes
    // 1/dt factor since fixed time step.
    unsigned int
	egoKdly1, // coefficients used to calculate ego transport
	egoKdly2;      // delay (ms) = Kdly1 + Kdly2*120000 / (map(kPax10)*rpm)
    unsigned char
	FlexFuel, // Flex fuel option - modifies pw and spk adv based on % alcohol.
	fuelFreq[2],	  // Table of fuel sensor freq(Hz) vs %fuel corr;
	fuelCorr[2],
	dwellmode, // dwell mode
	AMCStep,		    // % of AMC correction to be applied when ramve updated.
	AMCdve;        // AMC correction must be > AMCdve to be applied in burn
    unsigned int
	AMCve_drpm,AMCve_dmap,  // current rpm, map(kPax10) must be within this
	AMCramve_dt,			// tolerance of a ve table vertex for AMCramve_dt secs
	// before AMC ve correction is applied
	AMCT_thresh,     // Min time (secs) between flash burns of ram ve table
	AMCupdate_thresh;// Min number of AMC ram ve updates before burn table.
    unsigned char
	CWOption,        // Cold warmup option - 0 = linear, 1 = custom table.
	knk_option,      // Bits 0-3: 0=no knock detection;1=operate at table value or 1
	// step below knock; 2=operate at table value or edge of knock.
	// Bits 4-7: 0/1 = knock signal < or > knk_thresh indicates knock occurred.
	knk_maxrtd,      // max total retard when knock occurs, (degx10),
	knk_step1,knk_step2, // ign retard/ adv steps when 1st knock or after stopped,
	// (degx10); step1 large to quickly retard/ stop knock
	knk_trtd,knk_tadv,   // time between knock retard, adv corrections, (secx10);
	// allows short time step to quickly retard, longer to try advancing.
	knk_dtble_adv, // change in table advance required to restart adv til knock or
	// reach table value (0 knock retard) process, deg x10.
	// This only applies with knk_option = 1.
	knk_ndet,    // number knock detects required for valid detection; pad byte.
	EAEOption;   // Bits 0-1: 1: on or off, 2: Use MAPdot prediction
    unsigned int
	knk_maxmap,        // no knock retard above this map (kPax10).
	knk_lorpm,knk_hirpm,  // no knock retard below, above these rpms.
	knk_rpm[NO_KNKRPMS],  // tables of rpm vs knock threshhold(Vx100).
	knk_thresh[NO_KNKRPMS],
	No_Teeth;          // Nominal (include missing) teeth for wheel decoding
    unsigned char
	No_Miss_Teeth;     // Number of consecutive missing teeth.
    unsigned int
	Miss_ang;     // Position of missing tooth BTDC deg*10
    unsigned char
	ICISR_tmask,				// Time (msx10) after tach input capture during which further
	// interrupts are inhibited to mask coil ring or VR noise.
	ICISR_pmask,				// % of dtpred after tach input capture during which further
	// interrupts are inhibited to mask coil ring or VR noise.
	// This and prior mask not applicable with wheel decoding.
	xxxxxxunused;
    unsigned int
	ae_lorpm,ae_hirpm; // lorpm is rpm at which normal accel enrichment just starts
    // to scale down, and is reduced to 0 at ae_hirpm. To omit scaling, set _lorpm
    // = _hirpm= very large number.
    int
	ffSpkDel[2];	  // Table of fuel sensor freq(Hz) vs spk corr (degx10);
    char pad41[5];

    unsigned char
        spk_conf2, // various see ini
	spk_config,    // config byte
	// bit0 sparkA 0=JS6 (MS2 default) 1= D14 (MS1/Extra default)
	// when num_spk_op > 3 always D14 as JS6 = sparkD
	// bit1 0=360deg 1=720
	// bit3,2 = 0 invalid, 1 = missing crank, 2 = 2nd trig, 3 = both
	// bit5,4 = 0 invalid, 1 rising, 2 falling, 3 rising&falling
	spk_mode,      // defines standard/EDIS/toothed wheel + num/type of coils
	userlevel,     // defines basic/intermediate/advanced and hides features
	rtbaroport,    // defines AD port used for RT baro 2nd sensor, MS2/GPIO
	//AD ports bottom three bits are AD0-7, upper bits
	// 0 = MS2, 1= GPIO1, 2=GPIO2
	ego2port,      // defines AD port used for 2nd EGO sensor MS2/GPIO
	knkport,       // defines AD port used for knock sensor must be on MS2 only
	flexport,      // defines freq capture port used for flex fuel sensor MS2/GPIO
	revlimcutx,
	revlimcuty,
	feature4_0;      // various settings
    //bit 0 = simple/advanced false trigger protection when userlevel>191
    //bit 1 = enable middle LED as ignition trigger. Certain modes prevent this.
    int pwmidle_table[NO_TEMPS];  // 10 pwm
    unsigned char timing_flags, crank_dwell;
    int crank_timing, fixed_timing;
#define TIMING_FIXED 0x1
#define USE_PREDICTION 0x2
} page4_data;

// flash copy of inputs - initialized

#define SECTOR_BYTES         1024 // bytes
#define SECTOR_WORDS         ((int)(SECTOR_BYTES/2))
#define N_SECTORS(theStruct) ((int)((sizeof(theStruct)+SECTOR_BYTES-1)/SECTOR_BYTES))
//#define N_PADDING(theStruct) ((int)(N_SECTORS(theStruct)*SECTOR_BYTES - sizeof(theStruct)))

extern const page4_data flash4 EEPROM_ATTR;
extern const unsigned char IACCoilA[8];
extern const unsigned char IACCoilB[8];
extern const char RevNum[20];
extern const char Signature[32];

extern char ram_data[1024];
extern page4_data *pg4_ptr;

/* Coil bits for an ign event */

#define		TRIGA		0
#define		TRIGB		1
#define		TRIGC		2
#define		TRIGD		3
#define		TRIGE		4
#define		TRIGF		5
#define		TRIGG		6
#define		TRIGH		7

typedef union _ign_time {
    unsigned long time_32_bits;
    unsigned int time_16_bits[2];
} ign_time;

typedef struct _ign_event {
    ign_time		time;		// time after the tooth to fire
    char		tooth;		// the tooth to schedule an event from
    unsigned char	coil;
    char                ftooth;         // "force dwell" tooth
    unsigned char       fs;             // "force spark" flag (only really need a byte)
} ign_event;

#define time32 time.time_32_bits
#define time16_high time.time_16_bits[0]
#define time16_low time.time_16_bits[1]

#define NUM_TRIGS 10
extern ign_event dwell_events_a[NUM_TRIGS];
extern ign_event spark_events_a[NUM_TRIGS];
extern ign_event dwell_events_b[NUM_TRIGS];
extern ign_event spark_events_b[NUM_TRIGS];
extern ign_event *dwell_events;
extern ign_event *spark_events;
extern ign_event next_spark;
extern ign_event next_dwell;
extern ign_event next_dwl_trl;
extern ign_event next_spk_trl;
extern ign_time dwl_time_ovflo;
extern ign_time spk_time_ovflo;
extern ign_time dwl_time_ovflo_trl;
extern ign_time spk_time_ovflo_trl;
extern ign_time spk_trl_sametooth;
extern unsigned char wheeldec_ovflo;
#define OVFLO_SPK 0x1
#define OVFLO_DWL 0x2
#define OVFLO_ROT_SPK 0x4
#define OVFLO_ROT_DWL 0x8
extern unsigned char next_fuel;
extern unsigned char trigger_teeth[NUM_TRIGS];
extern int trig_angs[NUM_TRIGS];
extern int trig_ang;

/* ignition macros */

#define FIRE_COIL \
    if (flash4.ICIgnOption & 0x10) { \
	if (flash4.spk_mode & 0x20) { \
	    PTM &= ~0x08; \
	} else { \
	    if (coilsel & COILABIT) { \
		if ((flash4.spk_config & 0x01) || (num_spk > 3)) { \
		    PTM &= ~0x08; \
		} else { \
		    PTT &= ~0x20; \
		} \
	    } else if (coilsel & COILBBIT) { \
		PTM &= ~0x10; \
	    } else if (coilsel & COILCBIT) { \
		PTM &= ~0x20; \
	    } else if (coilsel & COILDBIT) { \
		PORTA &= ~0x01; \
	    } \
	} \
    } else { \
	if (flash4.spk_mode & 0x20) { \
	    PTM |= 0x08; \
	} else { \
	    if (coilsel & COILABIT) { \
		if ((flash4.spk_config & 0x01) || (num_spk > 3)) { \
		    PTM |= 0x08; \
		} else { \
		    PTT |= 0x20; \
		} \
	    } else if (coilsel & COILBBIT) { \
		PTM |= 0x10; \
	    } else if (coilsel & COILCBIT) { \
		PTM |= 0x20; \
	    } else if (coilsel & COILDBIT) { \
		PORTA |= 0x01; \
	    } \
	} \
    } \
    coilsel = 0;

#define FIRE_COIL_ROTARY \
    if (rotaryspksel & COILCBIT) { \
	PTM &= ~0x20; \
	PTM |= 0x10; \
    } else if (rotaryspksel & COILDBIT) { \
	PTM |= 0x20; \
	PTM |= 0x10; \
    } \
    rotaryspksel = 0;

#define DWELL_COIL_ROTARY \
    if (flash4.ICIgnOption & 0x10) { \
	    PTM &= ~0x10; \
    } \
    rotarydwlsel = 0;

#define FIRE_ALL \
    if (flash4.ICIgnOption & 0x10) { \
	if ((flash4.spk_config & 0x01) || (num_spk > 3)) { \
	    PTM &= ~0x08; \
	} else { \
	    PTT &= ~0x20; \
	} \
	if (num_spk > 1) { \
	    PTM &= ~0x10; \
	} \
	if (num_spk > 2) { \
	    PTM &= ~0x20; \
	} \
	if (num_spk > 3) { \
	    PORTA &= ~0x01; \
	} \
    } else { \
	if ((flash4.spk_config & 0x01) || (num_spk > 3)) { \
	    PTM |= 0x08; \
	} else { \
	    PTT |= 0x20; \
	} \
	if (num_spk > 1) { \
	    PTM |= 0x10; \
	} \
	if (num_spk > 2) { \
	    PTM |= 0x20; \
	} \
	if (num_spk > 3) { \
	    PORTA |= 0x01; \
	} \
    }

#define DWELL_COIL \
    if (!flash4.ICIgnOption & 0x10) { \
	if (flash4.spk_mode & 0x20) { \
	    PTM &= ~0x08; \
	} else { \
	    if (dwellsel & COILABIT) { \
		if ((flash4.spk_config & 0x01) || (num_spk > 3)) { \
		    PTM &= ~0x08; \
		} else { \
		    PTT &= ~0x20; \
		} \
	    } else if (dwellsel & COILBBIT) { \
		PTM &= ~0x10; \
	    } else if (dwellsel & COILCBIT) { \
		PTM &= ~0x20; \
	    } else if (dwellsel & COILDBIT) { \
		PORTA &= ~0x01; \
	    } \
	} \
    } else { \
	if (flash4.spk_mode & 0x20) { \
	    PTM |= 0x08; \
	} else { \
	    if (dwellsel & COILABIT) { \
		if ((flash4.spk_config & 0x01) || (num_spk > 3)) { \
		    PTM |= 0x08; \
		} else { \
		    PTT |= 0x20; \
		} \
	    } else if (dwellsel & COILBBIT) { \
		PTM |= 0x10; \
	    } else if (dwellsel & COILCBIT) { \
		PTM |= 0x20; \
	    } else if (dwellsel & COILDBIT) { \
		PORTA |= 0x01; \
	    } \
	} \
    } \
    dwellsel = 0;

#define SET_COIL(coil, bits) \
    if (flash4.spk_mode & 0x20) { \
	if ((coil == TRIGA || coil == TRIGB)) { \
	    bits = COILABIT; \
	} else if (coil == TRIGC) { \
	    bits = COILCBIT; \
	} else if (coil == TRIGD) { \
	    bits = COILDBIT; \
	} \
    } else { \
	if (coil == TRIGA) { \
	    bits = COILABIT; \
	} else if (coil == TRIGB) { \
	    if (num_spk == 1) { \
		bits = COILABIT; \
	    } else { \
		bits = COILBBIT; \
	    } \
	} else if (coil == TRIGC) { \
	    if (num_spk == 1) { \
		bits = COILABIT; \
	    } else if (num_spk == 2) { \
		bits = COILABIT; \
	    } else { \
		bits = COILCBIT; \
	    } \
	} else if (coil == TRIGD) { \
	    if (num_spk == 1) { \
		bits = COILABIT; \
	    } else if (num_spk == 2) { \
		bits = COILBBIT; \
	    } else if (num_spk == 3) { \
		bits = COILABIT; \
	    } else { \
		bits = COILDBIT; \
	    } \
	} else if (coil == TRIGE) { \
	    if (num_spk == 1) { \
		bits = COILABIT; \
	    } else if (num_spk == 2) { \
		bits = COILABIT; \
	    } else if (num_spk == 3) { \
		bits = COILBBIT; \
	    } else if (num_spk == 4) { \
		bits = COILABIT; \
	    } else { \
		bits = COILEBIT; \
	    } \
	} else if (coil == TRIGF) { \
	    if (num_spk == 1) { \
		bits = COILABIT; \
	    } else if (num_spk == 2) { \
		bits = COILBBIT; \
	    } else if (num_spk == 3) { \
		bits = COILCBIT; \
	    } else if (num_spk == 4) { \
		bits = COILBBIT; \
	    } else { \
		bits = COILFBIT; \
	    } \
	} else if (coil == TRIGG) { \
	    if (num_spk == 1) { \
		bits = COILABIT; \
	    } else if (num_spk == 2) { \
		bits = COILABIT; \
	    } else if (num_spk == 4) { \
		bits = COILCBIT; \
	    } else { \
		bits = COILGBIT; \
	    } \
	} else if (coil == TRIGH) { \
	    if (num_spk == 1) { \
		bits = COILABIT; \
	    } else if (num_spk == 2) { \
		bits = COILBBIT; \
	    } else if (num_spk == 4) { \
		bits = COILDBIT; \
	    } else { \
		bits = COILHBIT; \
	    } \
	} \
    }

#define COILABIT 0x1
#define COILBBIT 0x2
#define COILCBIT 0x4
#define COILDBIT 0x8
#define COILEBIT 0x10
#define COILFBIT 0x20
#define COILGBIT 0x40
#define COILHBIT 0x80

#define OUTPUT_LATENCY 6  // known latency in code from outpc compare to bit flipping
#define SPK_TIME_MIN 110 // minimum time after tooth before stepping back

extern unsigned char coilsel;
extern unsigned char dwellsel;
extern unsigned char rotaryspksel;
extern unsigned char rotarydwlsel;

// rs232 Outputs to pc
typedef struct {
unsigned int seconds,pw1,pw2,rpm;           // pw in usec
int adv_deg;                                // adv in deg x 10
unsigned char squirt,engine,afrtgt1,afrtgt2;    // afrtgt in afr x 10
/*
; Squirt Event Scheduling Variables - bit fields for "squirt" variable above
inj1:    equ    0       ; 0 = no squirt; 1 = inj squirting
inj2:    equ    1

; Engine Operating/Status variables - bit fields for "engine" variable above
ready:  equ     0       ; 0 = engine not ready; 1 = ready to run
                                               (fuel pump on or ign plse)
crank:  equ     1       ; 0 = engine not cranking; 1 = engine cranking
startw: equ     2       ; 0 = not in startup warmup; 1 = in startw enrichment
warmup: equ     3       ; 0 = not in warmup; 1 = in warmup
tpsaen: equ     4       ; 0 = not in TPS acceleration mode; 1 = TPS acceleration mode
tpsden: equ     5       ; 0 = not in deacceleration mode; 1 = in deacceleration mode
*/

unsigned char wbo2_en1,wbo2_en2; // from wbo2 - indicates whether wb afr valid
int baro,map,mat,clt,tps,batt,ego1,ego2,knock,   // baro - kpa x 10
                                                 // map - kpa x 10
                                                 // mat, clt deg(C/F)x 10
                                                 // tps - % x 10
                                                 // batt - vlts x 10
                                                 // ego1,2 - afr x 10
                                                 // knock - volts x 100
 egocor1,egocor2,aircor,warmcor,                 // all in %
 tpsaccel,tpsfuelcut,barocor,gammae,             // tpsaccel - acc enrich(.1 ms units)
                                                 // tpsfuelcut - %
                                                 // barocor,gammae - %
 vecurr1,vecurr2,iacstep,cold_adv_deg,           // vecurr - %
                                                 // iacstep - steps
                                                 // cold_adv_deg - deg x 10
tpsdot,mapdot;                                   // tps, map rate of change - %x10/.1 sec,
                                                 // kPax10 / .1 sec
unsigned int coil_dur;                           // msx10 coil chge set by ecu
int maf, fuelload,                                    // maf for future; kpa (=map or tps)
fuelcor;                                         // fuel composition correction - %
unsigned char port_status,                       // Bits indicating spare port status.
  knk_rtd;               // amount of ign retard (degx10) subtracted from normal advance.
unsigned int EAEfcor;
int egoV1,egoV2;				                         // ego sensor readbacks in Vx100
unsigned char status1, status2, status3, status4;   // added ms2extra
                       // status1 bit0 = needs burn, bit1 = lost data
unsigned int looptime;
unsigned int istatus5;
unsigned int tpsadc; //lets do a real calibration
int fuelload2;
int ignload;
int ignload2;
int spare[5];
unsigned char sync_status;
unsigned char sparechar;
unsigned long dt3;                               // delta t bet. rpm pulses (us)
unsigned long wallfuel;
unsigned int gpioadc[8]; // capture values of gpioadc ports
unsigned int gpiopwmin[4];
unsigned char gpioport[3]; // capture values from gpio digi ports
} variables;

extern variables outpc;
extern variables txbuf;

// Prototypes - Note: ISRs prototyped above.
int main(void);
void set_prime_ASE(void);
void main_init(void);
int intrp_2ditable(unsigned int x, int y, unsigned char nx, unsigned char ny,
  unsigned int * x_table, int * y_table, int * z_table);
void Flash_Init(void);
void udvd64(unsigned long long *dividend, unsigned long long *divisor);

void realtime(void);
unsigned char afrLF_calc(long t);

// for ASM routines the memory allocation is set in the source file
void ResetCmd(void);
void monitor(void);
void SpSub(void);
void NoOp(void);
void burntbl(void);
void erasefactor(void);
void progfactor(void);

extern void do_idle(void);
extern void ckstall(void);

// sensor variables
extern int last_tps,last_map,tpsdot_ltch,mapdot_ltch;
// fuel variables
extern unsigned int pwcalc1,pwcalc2,pw_open,PrimeP,AWEV,AWC;
extern unsigned char pwm1_on,pwm2_on,cut_fuel;
// ignition variables
extern unsigned char SPK,CHG, pulse_no,ign_state,ign_setpin,
  IgnOCpinstate,first_edis,PulseTol;
extern long charge_time,coil_dur_set;
extern unsigned int coil_dur;
extern unsigned long IgnTimerComp,dtpred,dtpred_last,NoiseFilterMin;
// IAC variables
extern unsigned long motor_time;
extern int IACmotor_pos,last_iacclt;
extern char IAC_moving,IACmotor_reset,IdleCtl,motor_step;
// General variables
extern unsigned int iacpwmctr, TC_ovflow;
extern unsigned long lmms,t_enable_IC,Rpm_Coeff,ltch_lmms,rcv_timeout,adc_lmms;
extern unsigned int asecount;
extern unsigned char flocker,tpsaclk,egocount,igncount,altcount,next_adc,first_adc,
	txmode,tble_idx,burn_idx,synch,
	egopstat,afrSL, FSensStat,knk_clk,knk_clk_test,knk_stat,knk_count,mms,millisec;
#define SYNC_SYNCED	0x1
#define SYNC_FIRST	0x2
#define SYNC_RPMCALC	0x4
#define SYNC_SEMI	0x8
#define SYNC_SEMI2	0x10

extern int ego1err,ego1errm1,ego2err,ego2errm1,sego1err,sego2err,egoKPX;
extern unsigned int afrdl1,afrdl2,afrtgt_skip, FSens_Pd,FSensFreq;
extern unsigned long tegoclk,tegoXpt,tegoupdate;
/* Clocks:
  	- igncount: counts up each tach pulse, cleared when hit Divider pulses
               (and injection occurs).
  	- asecount: counts up each time igncount = 0 (each Divider pulses).
  	- egocount: counts up each tach pulse, cleared when hits EgoCountCmp
  	- tpsaclk: counts every .1 sec
  	- altcount: flips 0,1,0,1... on each injection, resulting in firing alternate
                injector banks if Alternate option.
*/
extern unsigned int txcnt,txgoal,rxoffset,rxnbytes,rxcnt,tble_word,ntword;
extern char AMCmode,ego_cloop,bad_ego_flag,bad_ego_ltch,first_clt;
extern unsigned int AMCclk,AMCve_clk,AMCNSum,AMCburn_clk,AMCram_updates;
extern int knk_tble_adv,warmup_Tclt,ffspkdel;
extern long sumegocor1,sumegocor2;
extern unsigned long WF;
extern unsigned long AWA, SOA;
extern unsigned long tooth_diff_last_2, tooth_diff_last_1, tooth_diff_last, tooth_diff_this;
extern ign_time tooth_diff_rpm, tooth_diff_rpm_last;
extern unsigned char no_triggers;
extern unsigned char no_teeth;
extern unsigned char tooth_no;
extern unsigned char last_tooth;
extern unsigned char mid_last_tooth;

//had to add these when main_init broken off
extern unsigned int tcrank_done,tcold_pos;
extern int start_clt;

// CAN variables
extern unsigned long cansendclk,ltch_CAN;
extern char *canvar_blkptr[NO_VAR_BLKS];
extern unsigned int can_status;
extern unsigned char can_clr_stat,can_reset,can_id,getCANdat;
typedef struct {
  /* CAN Xmt mssge ring buffer:
      can[0] is to hold Rx,TxISR messages,
      can[1] for main loop messages (so don't get clobbered by ISR)
      cxno = no msgs in queue waiting to be sent out
      cxno_in = index for inserting a msg in queue (incr after insert)
      cxno_out = index for sending out a msg (incr after load CAN buf)
      msg_type = CMD,REQ,RESP,XSUB (= set value, request value, respond
          to a request for value, execute a subroutine)
      varblk,varoffset,varbyte = blk no of data structure, byte offset
          from start of structure, no. bytes of data
      datbuf = the actual data (max of 8 bytes)
      dest = id no. of device to which msg being sent.
  */
  unsigned char cxno,cxno_in,cxno_out;
  unsigned char cx_msg_type[NO_CANMSG], cx_varblk[NO_CANMSG],
	  cx_dest[NO_CANMSG],cx_varbyt[NO_CANMSG];
  unsigned short cx_varoff[NO_CANMSG];
  unsigned char cx_datbuf[NO_CANMSG][8];  // max msg data = 8 bytes
} canmsg;
extern canmsg can[];

// pointers for spare port pins
extern volatile unsigned char *pPTMpin[8], *pPTTpin[8], *pPTApin0, *pPTEpin[2];
extern unsigned char dummyReg,lst_pval[NPORT];

// allocate space in ram for flash burner core
extern volatile unsigned char RamBurnPgm[36];

// vars added for MS2/Extra
extern unsigned char page;  // which flash data page is presently in ram
extern unsigned char num_spk; // calculated number of spark outputs
extern unsigned char conf_err; // set if configuration error
extern unsigned int adc67[2];
extern unsigned int mltimestamp; // time the mainloop
extern unsigned char pwm1div, pwm2div, pwm3div, pwm4div; // rate dividers
extern unsigned char pwm1cnt, pwm2cnt, pwm3cnt, pwm4cnt; // counters

// these were static in sci isr, asm needs them as global (same thing)
//extern int vfy_fail,;
extern unsigned char CANid,ibuf, next_txmode, rd_wr;
extern unsigned char flagbyte0;
#define flagbyte0_50ms    1   // use bits of this byte
#define flagbyte0_to      2   // tacho out divider
#define flagbyte0_revlim  4   //hard limiter on
#define flagbyte0_launch  8   // launch active
#define flagbyte0_flatshift  0x10   // flatshift active
#define flagbyte0_spkcut 0x20 // doing spk cut
#define flagbyte0_tthlog  0x40 // logging teeth
#define flagbyte0_trglog  0x80 // logging triggers

extern unsigned char flagbyte1;
#define flagbyte1_trig2active 1
#define flagbyte1_tstmode  2   // test mode enable - set to 1 turns off normal functions
#define flagbyte1_ovfclose 4   // nearly going to overflow
#define flagbyte1_bothedge 8   // use both edges input capture
#define flagbyte1_noisefilter 0x10 // noise filter on (reduces tests in ISR)
#define flagbyte1_igntrig 0x20 // ignition trigger LED feature on
#define flagbyte1_trig2 0x40  // 2nd trigger (cam) input being used
#define flagbyte1_trig2statl 0x80  // 2nd trigger state in previous ISR (used by 6g72)

extern unsigned char flagbyte2;
#define flagbyte2_twintrig 1   // for quick checking
#define flagbyte2_twintrignow 2   // event happened just now
#define flagbyte2_crank_ok 4   // ok to go to crank mode (rock crawler / hei bypass)
#define flagbyte2_tfi_ps 8   // Push Start TFI mode enabled
#define flagbyte2_tc0stat 0x10   // Status of crank tach input when 2nd trigger (CAS4/2)

//extern unsigned char scidiag[];      // this is for debug only and should be removed in future

extern unsigned long stall_timeout; // save doing long div each 0.128ms
extern unsigned char last_fsensdat;
extern unsigned short FPdcounter;
extern unsigned char fc_counter, adc_ctr;
extern unsigned int lowres, lowres_ctr, tacho_targ; // 0.128ms period counters (like MS1) for tacho
//spark cut
extern unsigned char spk_cutx, spk_cuty, spk_cuti;
extern unsigned char staged_num_events; /* number of events into staging trasition */
extern unsigned long pw_staged1, pw_staged2; /* staged pulsewidths */
extern unsigned int spk_mult; // save doing some long divs in ISR
//tooth / trigger logger
extern unsigned int log_offset;
//dwell exec software 0.128ms timers
extern unsigned char dwl[], mindwl, nomdwl, maxdwl, testcnt, rtsci, rtcksum, offender;
extern unsigned int swtimer;
extern unsigned int deg_per_tooth[]; // deg*10 AHEAD of tooth-1 i.e. runs 0->, teeth are 1->
extern ign_time act_tooth_time[];
extern unsigned int act_tooth_ang[];
extern unsigned char pwmd1, pwmd2, trig2cnt, bl_timer;
#endif
