; crc32.s
;*********************************************************************
; $Id: crc32.s,v 1.2 2010-10-01 00:32:46 jsmcortina Exp $

; code derived from public domain crc32.c
; I release this implementation back to the public domain. James Murray 2009.
; recoded for S12

.sect .text39
.globl crc32buf
.globl crc32byte
;*********************************************************************
;macros to make up for missing instructions on S12
.macro comx
    xgdx
    coma
    comb
    xgdx
.endm
;end macros

; unsigned long crc32buf(unsigned long crcin, *buf, unsigned int bufsize)
crc32buf:
; on entry input crc is in X:D
; buffer is on first word on stack
; bufsize is second word on stack

    leas	0xfffffff8,SP    ;   /-- usage in this function
    movw	0x3008, 0x2,-SP  ; crc32H
    movw	0x300a, 0x2,-SP  ; crc32L
    movw	0x300c, 0x2,-SP  ; bufptr
    movw	0x300e, 0x2,-SP  ; not used
    movw	0x3010, 0x2,-SP  ; buf size
    ldy	    0x17,SP ; off by one due to "call"
    sty	    0x3010

;    /** accumulate crc32 for buffer **/
;    crc32 = inCrc32 ^ 0xFFFFFFFF;
    comb
    coma
    comx
    std	 0x300a
    stx	 0x3008

;    byteBuf = (unsigned char*) buf;
    ldx	    0x15,SP
    stx	    0x300c

.LM4:
;    for (i=0; i < bufLen; i++) {
    clr    0x3002  ; i
    clr    0x3003
    tbeq	Y, .LM7

.LM5:
;        crc32 = (crc32 >> 8) ^ crcTable[ (crc32 & 0xff) ^ byteBuf[i] ];
    ldd     0x3009      ; crc32>>8
    std     0x10, SP    ; save the 24bits into the 32bit temp space
    clra
    ldab    0x3008
    std     0x0e, SP

    ldd	    0x300c ; buf
    ldx	    0x3002 ; [i]
    leay	D,X
    clra
    ldab    0x300b
    eorb	0x0,Y
    ldy	    #4
    emul
    tfr	    D,Y         ; table pointer of u32

    ldx     0xe,SP
    xgdx
    eora    crcTable, Y
    eorb    crcTable+1, Y
    xgdx
    stx	    0x3008

    ldx     0x10,SP
    xgdx
    eora    crcTable+2, Y
    eorb    crcTable+3, Y
    xgdx
    stx	    0x300a

;    /** accumulate crc32 for buffer **/
    ldx	    0x3002
    inx
    stx	    0x3002
    cpx     0x3010
    bcs	    .LM5

.LM7:
    ldd	    0x300a
    ldx	    0x3008
    comb
    coma
    comx

.LM8:
    movw	0x2,SP+,  0x3010
    movw	0x2,SP+,  0x300e
    movw	0x2,SP+,  0x300c
    movw	0x2,SP+,  0x300a
    movw	0x2,SP+,  0x3008
    leas	0x8,SP
    rtc

;*********************************************************************
crc32byte:
; This still needs significant optimisation
; reads from and stores back to sd_crc
; Caution! Ensure only one instance of this is running.
; Intended to be used from isr_sci for SD readback only.
; byte is in B

    pshb

;    /** accumulate crc32 for buffer **/
;    crc32 = inCrc32 ^ 0xFFFFFFFF;
    ldy     sd_crc+2    ; save low byte
    ldx     sd_crc+1
    comx
    stx	 sd_crc+2
    clra
    ldab     sd_crc
    comb
    std     sd_crc

;        crc32 = ((inCrc32 ^ 0xFFFFFFFF) >> 8) ^ crcTable[ (crc32 & 0xff) ^ byteBuf[i] ];
;        crc32 = crc32 ^ 0xffffffff
    tfr     y,d         ; retrieve low byte
    clra
    comb
    eorb	1,sp+       ; inbyte
    ldy	    #4
    emul
    tfr	    D,Y         ; table pointer of u32

    ldx     sd_crc
    xgdx
    eora    crcTable, Y
    eorb    crcTable+1, Y
    coma
    comb
    xgdx
    stx	    sd_crc

    ldx     sd_crc+2
    xgdx
    eora    crcTable+2, Y
    eorb    crcTable+3, Y
    coma
    comb
    xgdx
    stx	    sd_crc+2

    rtc


crcTable:
   fdb 0x0000,0x0000,0x7707,0x3096,0xEE0E,0x612C,0x9909,0x51BA,0x076D,0xC419,0x706A,0xF48F,0xE963,0xA535,0x9E64,0x95A3 ; 00
   fdb 0x0EDB,0x8832,0x79DC,0xB8A4,0xE0D5,0xE91E,0x97D2,0xD988,0x09B6,0x4C2B,0x7EB1,0x7CBD,0xE7B8,0x2D07,0x90BF,0x1D91 ; 08
   fdb 0x1DB7,0x1064,0x6AB0,0x20F2,0xF3B9,0x7148,0x84BE,0x41DE,0x1ADA,0xD47D,0x6DDD,0xE4EB,0xF4D4,0xB551,0x83D3,0x85C7 ; 10
   fdb 0x136C,0x9856,0x646B,0xA8C0,0xFD62,0xF97A,0x8A65,0xC9EC,0x1401,0x5C4F,0x6306,0x6CD9,0xFA0F,0x3D63,0x8D08,0x0DF5 ; 18
   fdb 0x3B6E,0x20C8,0x4C69,0x105E,0xD560,0x41E4,0xA267,0x7172,0x3C03,0xE4D1,0x4B04,0xD447,0xD20D,0x85FD,0xA50A,0xB56B ; 20
   fdb 0x35B5,0xA8FA,0x42B2,0x986C,0xDBBB,0xC9D6,0xACBC,0xF940,0x32D8,0x6CE3,0x45DF,0x5C75,0xDCD6,0x0DCF,0xABD1,0x3D59 ; 28
   fdb 0x26D9,0x30AC,0x51DE,0x003A,0xC8D7,0x5180,0xBFD0,0x6116,0x21B4,0xF4B5,0x56B3,0xC423,0xCFBA,0x9599,0xB8BD,0xA50F ; 30
   fdb 0x2802,0xB89E,0x5F05,0x8808,0xC60C,0xD9B2,0xB10B,0xE924,0x2F6F,0x7C87,0x5868,0x4C11,0xC161,0x1DAB,0xB666,0x2D3D ; 38
   fdb 0x76DC,0x4190,0x01DB,0x7106,0x98D2,0x20BC,0xEFD5,0x102A,0x71B1,0x8589,0x06B6,0xB51F,0x9FBF,0xE4A5,0xE8B8,0xD433 ; 40
   fdb 0x7807,0xC9A2,0x0F00,0xF934,0x9609,0xA88E,0xE10E,0x9818,0x7F6A,0x0DBB,0x086D,0x3D2D,0x9164,0x6C97,0xE663,0x5C01 ; 48
   fdb 0x6B6B,0x51F4,0x1C6C,0x6162,0x8565,0x30D8,0xF262,0x004E,0x6C06,0x95ED,0x1B01,0xA57B,0x8208,0xF4C1,0xF50F,0xC457 ; 50
   fdb 0x65B0,0xD9C6,0x12B7,0xE950,0x8BBE,0xB8EA,0xFCB9,0x887C,0x62DD,0x1DDF,0x15DA,0x2D49,0x8CD3,0x7CF3,0xFBD4,0x4C65 ; 58
   fdb 0x4DB2,0x6158,0x3AB5,0x51CE,0xA3BC,0x0074,0xD4BB,0x30E2,0x4ADF,0xA541,0x3DD8,0x95D7,0xA4D1,0xC46D,0xD3D6,0xF4FB ; 60
   fdb 0x4369,0xE96A,0x346E,0xD9FC,0xAD67,0x8846,0xDA60,0xB8D0,0x4404,0x2D73,0x3303,0x1DE5,0xAA0A,0x4C5F,0xDD0D,0x7CC9 ; 68
   fdb 0x5005,0x713C,0x2702,0x41AA,0xBE0B,0x1010,0xC90C,0x2086,0x5768,0xB525,0x206F,0x85B3,0xB966,0xD409,0xCE61,0xE49F ; 70
   fdb 0x5EDE,0xF90E,0x29D9,0xC998,0xB0D0,0x9822,0xC7D7,0xA8B4,0x59B3,0x3D17,0x2EB4,0x0D81,0xB7BD,0x5C3B,0xC0BA,0x6CAD ; 78
   fdb 0xEDB8,0x8320,0x9ABF,0xB3B6,0x03B6,0xE20C,0x74B1,0xD29A,0xEAD5,0x4739,0x9DD2,0x77AF,0x04DB,0x2615,0x73DC,0x1683 ; 80
   fdb 0xE363,0x0B12,0x9464,0x3B84,0x0D6D,0x6A3E,0x7A6A,0x5AA8,0xE40E,0xCF0B,0x9309,0xFF9D,0x0A00,0xAE27,0x7D07,0x9EB1 ; 88
   fdb 0xF00F,0x9344,0x8708,0xA3D2,0x1E01,0xF268,0x6906,0xC2FE,0xF762,0x575D,0x8065,0x67CB,0x196C,0x3671,0x6E6B,0x06E7 ; 90
   fdb 0xFED4,0x1B76,0x89D3,0x2BE0,0x10DA,0x7A5A,0x67DD,0x4ACC,0xF9B9,0xDF6F,0x8EBE,0xEFF9,0x17B7,0xBE43,0x60B0,0x8ED5 ; 98
   fdb 0xD6D6,0xA3E8,0xA1D1,0x937E,0x38D8,0xC2C4,0x4FDF,0xF252,0xD1BB,0x67F1,0xA6BC,0x5767,0x3FB5,0x06DD,0x48B2,0x364B ; a0
   fdb 0xD80D,0x2BDA,0xAF0A,0x1B4C,0x3603,0x4AF6,0x4104,0x7A60,0xDF60,0xEFC3,0xA867,0xDF55,0x316E,0x8EEF,0x4669,0xBE79 ; a8
   fdb 0xCB61,0xB38C,0xBC66,0x831A,0x256F,0xD2A0,0x5268,0xE236,0xCC0C,0x7795,0xBB0B,0x4703,0x2202,0x16B9,0x5505,0x262F ; b0
   fdb 0xC5BA,0x3BBE,0xB2BD,0x0B28,0x2BB4,0x5A92,0x5CB3,0x6A04,0xC2D7,0xFFA7,0xB5D0,0xCF31,0x2CD9,0x9E8B,0x5BDE,0xAE1D ; b8
   fdb 0x9B64,0xC2B0,0xEC63,0xF226,0x756A,0xA39C,0x026D,0x930A,0x9C09,0x06A9,0xEB0E,0x363F,0x7207,0x6785,0x0500,0x5713 ; c0
   fdb 0x95BF,0x4A82,0xE2B8,0x7A14,0x7BB1,0x2BAE,0x0CB6,0x1B38,0x92D2,0x8E9B,0xE5D5,0xBE0D,0x7CDC,0xEFB7,0x0BDB,0xDF21 ; c8
   fdb 0x86D3,0xD2D4,0xF1D4,0xE242,0x68DD,0xB3F8,0x1FDA,0x836E,0x81BE,0x16CD,0xF6B9,0x265B,0x6FB0,0x77E1,0x18B7,0x4777 ; d0
   fdb 0x8808,0x5AE6,0xFF0F,0x6A70,0x6606,0x3BCA,0x1101,0x0B5C,0x8F65,0x9EFF,0xF862,0xAE69,0x616B,0xFFD3,0x166C,0xCF45 ; d8
   fdb 0xA00A,0xE278,0xD70D,0xD2EE,0x4E04,0x8354,0x3903,0xB3C2,0xA767,0x2661,0xD060,0x16F7,0x4969,0x474D,0x3E6E,0x77DB ; e0
   fdb 0xAED1,0x6A4A,0xD9D6,0x5ADC,0x40DF,0x0B66,0x37D8,0x3BF0,0xA9BC,0xAE53,0xDEBB,0x9EC5,0x47B2,0xCF7F,0x30B5,0xFFE9 ; e8
   fdb 0xBDBD,0xF21C,0xCABA,0xC28A,0x53B3,0x9330,0x24B4,0xA3A6,0xBAD0,0x3605,0xCDD7,0x0693,0x54DE,0x5729,0x23D9,0x67BF ; f0
   fdb 0xB366,0x7A2E,0xC461,0x4AB8,0x5D68,0x1B02,0x2A6F,0x2B94,0xB40B,0xBE37,0xC30C,0x8EA1,0x5A05,0xDF1B,0x2D02,0xEF8D ; f8

