;*********************************************************************
; ISR_INJ_TIMER OUT
;*********************************************************************
; $Id: isr_inj.s,v 1.10 2011-10-28 20:40:42 racingmini Exp $

.sect .text3
.globl ISR_Inj1_TimerOut
.globl ISR_Inj2_TimerOut
.globl ISR_Inj3_TimerOut
.globl ISR_Inj4_TimerOut

             nolist               ;turn off listing
             include "s12asmdefs.inc"
             include "ms2extra_structs.inc"
             include "ms2extrah.inc"
             list                 ;turn listing back on

;*********************************************************************
ISR_Inj1_TimerOut:
; Enter here when OC match to cease firing Inj1.
; At entry here the pin will automatically turn off injector;
.ifndef MICROSQUIRT
;   brset   flash8.seq_inj,0x04,no_pwm1
   bclr	   PWME,#0x04 ;  also turn off pwm1 (this not necessary since nanded)
   clr     pwm1_on;
;no_pwm1:
.endif
   bclr	   outpc.squirt,#0x01  ; inj1 stopped squirting

   ldab    outpc.squirt
   andb    #3
   bne     ii1to_neither  ; branch if still one inj squirting

   ldx	   pPTMpin+0x6  ;    *pPTMpin[3] &= ~0x08
   bclr	   0,X, #0x08   ; turn off inj led

ii1to_neither:
;  Disable Inj1 OC interrupt - will re-enable on next tach pulse
   bclr	   TIE,#0x02
   movb	   #0x02, TFLG1 ; clear OC interrupt flag
   rti

;*********************************************************************
ISR_Inj2_TimerOut:
; Enter here when OC match to cease firing Inj2.
; At entry here the pin will automatically turn off injector;
.ifndef MICROSQUIRT
;   brset   flash8.seq_inj,0x04,no_pwm2
   bclr	   PWME,#0x10 ;  also turn off pwm1 (this not necessary since nanded)
   clr     pwm2_on;
;no_pwm2:
.endif
   bclr	   outpc.squirt,#0x02  ; inj2 stopped squirting

   ldab    outpc.squirt
   andb    #3
   bne     ii2to_neither  ; branch if still one inj squirting

   ldx	   pPTMpin+0x6  ;    *pPTMpin[3] &= ~0x08
   bclr	   0,X, #0x08   ; turn off inj led

ii2to_neither:
;  Disable Inj2 OC interrupt - will re-enable on next tach pulse
   bclr	   TIE,#0x08
   movb    #0x08, TFLG1 ; clear OC interrupt flag
   rti

;*********************************************************************
ISR_Inj3_TimerOut:
; Enter here when OC match to cease firing Inj3.
; At entry here the pin will automatically turn off injector;
   bclr	   outpc.squirt,#0x04  ; inj3 stopped squirting

   ldab    outpc.squirt
   andb    #15
   bne     ii3to_neither  ; branch if still one inj squirting

   ldx	   pPTMpin+0x6  ;    *pPTMpin[3] &= ~0x08
   bclr	   0,X, #0x08   ; turn off inj led

ii3to_neither:
;  Disable Inj3 OC interrupt - will re-enable on next tach pulse
   bclr	   TIE,#TFLG_rotINJ3
   movb    #TFLG_rotINJ3, TFLG1 ; clear OC interrupt flag
   rti

;*********************************************************************
ISR_Inj4_TimerOut:
; Enter here when OC match to cease firing Inj4.
; At entry here the pin will automatically turn off injector;
   bclr	   outpc.squirt,#0x08  ; inj4 stopped squirting

   ldab    outpc.squirt
   andb    #15
   bne     ii4to_neither  ; branch if still one inj squirting

   ldx	   pPTMpin+0x6  ;    *pPTMpin[3] &= ~0x08
   bclr	   0,X, #0x08   ; turn off inj led

ii4to_neither:
;  Disable Inj4 OC interrupt - will re-enable on next tach pulse
   bclr	   TIE,#TFLG_rotINJ4
   movb    #TFLG_rotINJ4, TFLG1 ; clear OC interrupt flag
   rti

.nolist
