;*********************************************************************
; config error   (C) 2006 James Murray
;*********************************************************************
; $Id: ms2_conferr.s,v 1.33 2011-06-20 14:33:01 jsmcortina Exp $

.sect .text3a   ; was text3
.globl configerror,realtime
.globl conf_err

             nolist               ;turn off listing
             include "s12asmdefs.inc"
             include "ms2extrah.inc"
             include "ms2extra_structs.inc"
             list                 ;turn listing back on

;kill just about everything and send config error down serial port,
; then sit in loop turning fuel pump on and off
;*********************************************************************
; on entry A contains the config error
;*********************************************************************
.sect .text3a
configerror:
            ldaa        conf_err
            cmpa        #200
            bhs         ce_nosei
            bset        outpc.status1, #status1_conferr;
            sei                        ; disable ints until we've sent the message
ce_nosei:
            movb        #0x00,SCI0CR1
            movb        #0x08,SCI0CR2  ; disable SCI ints, enable tx
			ldx			#20
			bsr			delaylp1		; short delay to ensure everything is ready
;send CR,NL as pre-amble to avoid missed first bytes
            ldx         #cr
            bsr         sendstr        ; uses X

            ldab        conf_err
            decb
            clra
            lslb
            rola
            tfr         d,x
            ldx         errtbl,x
            bsr         sendstr        ; uses X
            cli
            movb        #0x00,SCI0CR1
            movb        #0x24,SCI0CR2  ; set back to normal


            ldab        conf_err
            cmpb        #200
            blo         ce_rpm
            clr         conf_err
            rtc

ce_rpm:
;fake rpm with conf_err in it
            clra
            addd        #65000   ; rpm = 65000 + conf_err
            std         outpc.rpm

            leas        -1,sp
            movb        #3, 0,sp
celoop:
            bset        PORTE,PTE4   ; pulse fuel pump
            bsr         delay       ; on for ~1s
            bclr        PORTE,PTE4
            bsr         delay       ; off for ~3s
            bsr         delay
            bsr         delay
            dec         0,sp
            bne         celoop
            leas        +1,sp
            ldaa        conf_err
            cmpa        #190
            blo         dead_loop
            clr         conf_err
            bclr        outpc.status1, #status1_conferr
            rtc                     ; if a soft config error then we _can_ return
dead_loop:
            bsr         delay
            bra         dead_loop

;*********************************************************************
;sendstr:      ; send text string down serial port
; on entry X points to start of zero terminated string
;*********************************************************************
sendstr:
            ldaa        SCI0SR1    ; ensure stat reg read as part of sequence
sendstrlp:
            ldaa        ,x
            beq         ssdone
            staa        SCI0DRL
            inx
sswait:
            brset       SCI0SR1,#0x80,sendstrlp ; wait for byte to be sent
            movb        #0x55,ARMCOP      ; keep COP happy
            movb        #0xAA,ARMCOP
            bra         sswait
ssdone:
            rts

;*********************************************************************
;delay:      ; busy wait
;*********************************************************************
delay:
            ldx         #0
delaylp1:
            ldy         #16
delaylp2:
            movb        #0x55,ARMCOP      ; keep COP happy
            movb        #0xAA,ARMCOP
            nop
            nop
            nop
            nop
            dbne        y,delaylp2
            pshx
            pshy
            call         realtime       ; be prepared to send realtime data
            call        chk_crc
            puly
            pulx
            dbne        x,delaylp1
            rts

;*********************************************************************
errtbl:
            fdb         err1
            fdb         err2
            fdb         err3
            fdb         err4
            fdb         err5
            fdb         err6
            fdb         err7
            fdb         err8
            fdb         err9
            fdb         err10
            fdb         err11
            fdb         err12
            fdb         err13
            fdb         err14
            fdb         err15
            fdb         err16
            fdb         err17
            fdb         err18
            fdb         err19
            fdb         err20
            fdb         err21
            fdb         err22
            fdb         err23
            fdb         err24
            fdb         err25
            fdb         err26
            fdb         err27
            fdb         err28
            fdb         err29
            fdb         err30
            fdb         err31
            fdb         err32
            fdb         err33
            fdb         err34
            fdb         err35
            fdb         err36
            fdb         err37
            fdb         err38
            fdb         err39
            fdb         err40
            fdb         err41
            fdb         err42
            fdb         err43
            fdb         err44
            fdb         err45
            fdb         err46
            fdb         err47
            fdb         err48
            fdb         err49
            fdb         err50
            fdb         err51
            fdb         err52
            fdb         err53
            fdb         err54
            fdb         err55
            fdb	        err56
            fdb	        err57
            fdb	        err58
            fdb	        err59
            fdb	        err60
            fdb	        err61
            fdb	        err62
            fdb	        err63
            fdb	        err64
            fdb	        err65
            fdb	        err66
            fdb	        err67
            fdb	        err68
            fdb	        err69
            fdb	        err70
            fdb	        err71
            fdb	        err72
            fdb         err73
            fdb         err74
            fdb	        err75
            fdb	        err76
            fdb	        err77
            fdb	        err78
            fdb	        err79
            fdb	        err80
            fdb	        err81
            fdb	        err82
            fdb	        err83
            fdb	        err84
            fdb	        err85
            fdb	        err86
            fdb	        err87
            fdb	        err88
            fdb	        err89
            fdb	        err90
            fdb	        err91
            fdb	        err92
            fdb	        err93
            fdb	        err94
            fdb	        err95
            fdb	        err96
            fdb	        err97
            fdb	        err98
            fdb	        err99
            fdb	        err100
            fdb         err101
            fdb         err102
            fdb         err103
            fdb         err104
            fdb         err105
            fdb         err106
            fdb         err107
            fdb         err108
            fdb         err109
            fdb         err110
            fdb         err111
            fdb         err112
            fdb         err113
            fdb         err114
            fdb         err115
            fdb         err116
            fdb         err117
            fdb         err118
            fdb         err119
            fdb         err120
            fdb         err121
            fdb         err122
            fdb         err123
            fdb         err124
            fdb         err125
            fdb         err126
            fdb         err127
            fdb         err128
            fdb         err129
            fdb         err130
            fdb         err131
            fdb         err132
            fdb         err133
            fdb         err134
            fdb         err135
            fdb         err136
            fdb         err137
            fdb         err138
            fdb         err139
            fdb         err140
            fdb         err141
            fdb         err142
            fdb         err143
            fdb         err144
            fdb         err145
            fdb         err146
            fdb         err147
            fdb         err148
            fdb         err149
            fdb         err150
            fdb         err151
            fdb         err152
            fdb         err153
            fdb         err154
            fdb         err155
            fdb         err156
            fdb         err157
            fdb         err158
            fdb         err159
            fdb         err160
            fdb         err161
            fdb         err162
            fdb         err163
            fdb         err164
            fdb         err165
            fdb         err166
            fdb         err167
            fdb         err168
            fdb         err169
            fdb         err170
            fdb         err171
            fdb         err172
            fdb         err173
            fdb         err174
            fdb         err175
            fdb         err176
            fdb         err177
            fdb         err178
            fdb         err179
            fdb         err180
            fdb         err181
            fdb         err182
            fdb         err183
            fdb         err184
            fdb         err185
            fdb         err186
            fdb         err187
            fdb         err188
            fdb         err189
            fdb         err190
            fdb         err191
            fdb         err192
            fdb         err193
            fdb         err194
            fdb         err195
            fdb         err196
            fdb         err197
            fdb         err198
            fdb         err199
            fdb         err200
            fdb         err201
            fdb         err202
            fdb         err203
            fdb         err204
            fdb         err205
            fdb         err206
            fdb         err207
            fdb         err208
            fdb         err209
            fdb         err210
            fdb         err211
            fdb         err212
            fdb         err213
            fdb         err214
            fdb         err215
            fdb         err216
            fdb         err217

cr:         fcb         0x0d,0x0a,0

err1:
            fcc         "Number of teeth/cylinders conflict"
            fcb         0x0d,0x0a,0
err2:
            fcc         "Conflict on realtime baro input pin"
            fcb         0x0d,0x0a,0
err3:
            fcc         "Conflict on 2nd ego input pin"
            fcb         0x0d,0x0a,0
err4:
            fcc         "Conflict on knock sensor input pin"
            fcb         0x0d,0x0a,0
err5:
            fcc         "Conflict on flex fuel input pin"
            fcb         0x0d,0x0a,0
err6:
            fcc         "Conflict with Tacho Output"
            fcb         0x0d,0x0a,0
err7:
            fcc         "Conflict with Launch input"
            fcb         0x0d,0x0a,0
err8:
            fcc         "7, 9, 11, 13+ cyl not supported"
            fcb         0x0d,0x0a,0
err9:
            fcc         "Trigger return needs larger trigger angle e.g. 60BTDC"
            fcb         0x0d,0x0a,0
err10:
            fcc         "Staged injection primary or secondary injector size zero"
            fcb         0x0d,0x0a,0
err11:
            fcc         "Staged triggers cannot be the same"
            fcb         0x0d,0x0a,0
err12:
            fcc         "Staged trigger param 1 or 2 zero"
            fcb         0x0d,0x0a,0
err13:
			fcc         "Second parameter enabled but with zero parameter"
            fcb         0x0d,0x0a,0
err14:
            fcc         "Staged transition enabled with zero events"
            fcb         0x0d,0x0a,0
err15:
            fcc         "Staged injection can only be used with simultaneous"
            fcb         0x0d,0x0a,0
err16:
            fcc         "Dual table and secondary load cannot be enabled together"
            fcb         0x0d,0x0a,0

err17:
            fcc         "Spark mode requires 4 cylinders"
            fcb         0x0d,0x0a,0

err18:
            fcc         "4G63 requires 4 cylinders"
            fcb         0x0d,0x0a,0

err19:
            fcc         "6G72 requires 6 cylinders"
            fcb         0x0d,0x0a,0

err20:
            fcc         "Daihatsu 3 cyl requires 3 cylinders"
            fcb         0x0d,0x0a,0

err21:
            fcc         "Daihatsu 4 cyl requires 4 cylinders"
            fcb         0x0d,0x0a,0

err22:
            fcc         "Vitara 2.0 requires 4 cylinders"
            fcb         0x0d,0x0a,0

err23:
            fcc         "Suzuki Swift requires 4 cylinders"
            fcb         0x0d,0x0a,0

err24:
            fcc         "IAW Weber Marelli requires 4 cylinders"
            fcb         0x0d,0x0a,0

err25:
            fcc         "Failed to calculate trigger teeth, check settings"
            fcb         0x0d,0x0a,0

err26:
            fcc         "Staging and Dual Table cannot be used together"
            fcb         0x0d,0x0a,0

err27:
            fcc         "Conflict with boost control pins"
            fcb         0x0d,0x0a,0

err28:
            fcc         "Conflict with nitrous pins and IAC"
            fcb         0x0d,0x0a,0

err29:
            fcc         "Twin Trigger mode is designed for bike type ignition - invalid settings"
            fcb         0x0d,0x0a,0

err30:
            fcc         "Only two spark outputs allowed on Microsquirt"
            fcb         0x0d,0x0a,0

err31:
	    	fcc			"Dizzy mode with negative angle"
			fcb			0x0d,0x0a,0

err32:
            fcc         "COP set, but second trigger resets every crank rotation. Try wasted spark or change your 2nd trigger hardware to every cam rotation"
            fcb         0x0d,0x0a,0

err33:
            fcc         "Oddfire not allowed in this ignition mode"
            fcb         0x0d,0x0a,0

err34:
            fcc         "VTR1000 mode requires 2 cyl and oddfire and wasted spark"
            fcb         0x0d,0x0a,0

err35:
            fcc         "Spark mode requires 4cyl and single coil"
            fcb         0x0d,0x0a,0
err36:
            fcc         "Conflict with nitrous input"
            fcb         0x0d,0x0a,0

err37:
            fcc         "Too many spark outputs required with your settings"
            fcb         0x0d,0x0a,0

err38:
            fcc         "COP set, but crank speed trigger wheel. Try wasted spark, install a cam trigger or mount your wheel on the cam"
            fcb         0x0d,0x0a,0
err39:
            fcc         "Conflict with nitrous pins and FIDLE"
            fcb         0x0d,0x0a,0
err40:
            fcc         "Conflict with nitrous pins and D15"
            fcb         0x0d,0x0a,0
err41:
            fcc         "Oddfire required"
            fcb         0x0d,0x0a,0
err42:
            fcc         "Staging and Sequential Siamese cannot be used without additional drivers"
            fcb         0x0d,0x0a,0
err43:
            fcc         "Too many triggers"
            fcb         0x0d,0x0a,0
err44:
            fcc         "Number of injectors and cylinders not supported"
            fcb         0x0d,0x0a,0
err45:
            fcc         "Conflict with additional injectors"
            fcb         0x0d,0x0a,0
err46:
            fcc         "Trigger offset must be zero in EDIS and trigger wheel mode"
            fcb         0x0d,0x0a,0
err47:
            fcc         "MAF port conflict"
            fcb         0x0d,0x0a,0
err48:
            fcc         "MAFMAP enabled when MAF is not"
            fcb         0x0d,0x0a,0
err49:
            fcc         "'Toothed wheel' required"
            fcb         0x0d,0x0a,0
err50:
            fcc         "More 'squirts' required"
            fcb         0x0d,0x0a,0
err51:
            fcc         "Sequential cannot be used with Twin Trigger"
            fcb         0x0d,0x0a,0
err52:
            fcc         "LS1 only supported on even V8"
            fcb         0x0d,0x0a,0
err53:
            fcc         "YZF1000 only supported on even 4cyl"
            fcb         0x0d,0x0a,0
err54:
            fcc         "CAN transceiver broken - send MS2 for repair"
            fcb         0x0d,0x0a,0

err55:
            fcc         "Sequential/Semi-sequential cannot be used with EDIS, EDIS Multispk, Basic trigger or Trigger return"
            fcb         0x0d,0x0a,0
err56:
            fcc         "Toyota DLI only permitted on 4 or 6cyl even fire with wasted spark"
            fcb         0x0d,0x0a,0
err57:
            fcc         "Conflict between spare output ports and spark outputs"
            fcb         0x0d,0x0a,0
err58:
            fcc         "Invalid MAP sampling angles. Needs to be less than 180deg for a 4cyl or 90deg for a V8 etc."
            fcb         0x0d,0x0a,0
err59:
err60:
err61:
err62:
err63:
err64:
err65:
err66:
err67:
err68:
err69:
err70:
err71:
err72:
err73:
err74:
err75:
err76:
err77:
err78:
err79:
err80:
err81:
err82:
err83:
err84:
err85:
err86:
err87:
err88:
err89:
err90:
err91:
err92:
err93:
err94:
err95:
err96:
err97:
err98:
err99:
err100:
err101:
err102:
err103:
err104:
err105:
err106:
err107:
err108:
err109:
err110:
err111:
err112:
err113:
err114:
err115:
err116:
err117:
err118:
err119:
err120:
err121:
err122:
err123:
err124:
err125:
err126:
err127:
err128:
err129:
err130:
err131:
err132:
err133:
err134:
err135:
err136:
err137:
err138:
err139:
err140:
err141:
err142:
err143:
err144:
err145:
err146:
err147:
err148:
err149:
err150:
err151:
err152:
err153:
err154:
err155:
err156:
err157:
err158:
err159:
err160:
err161:
err162:
err163:
err164:
err165:
err166:
err167:
err168:
err169:
err170:
err171:
err172:
err173:
err174:
err175:
err176:
err177:
err178:
err179:
err180:
err181:
err182:
err183:
err184:
err185:
err186:
err187:
err188:
err189:
err190:
err191:
err192:
err193:
err194:
err195:
err196:
err197:
err198:
err199:
            fcc         "Undefined config error"
            fcb         0x0d,0x0a,0

err200:
            fcc         "Sensor calibration tables currently locked!  Unlock before writing."
            fcb         0x0d,0x0a,0
err201:
            fcc         "VE1 in flash is out of range - report this to the forum!"
            fcb         0x0d,0x0a,0
err202:
            fcc         "VE1 in RAM is out of range - report this to the forum!"
            fcb         0x0d,0x0a,0
err203:
            fcc         "Serial problem - parity error - possible cable, computer hardware or settings problem"
            fcb         0x0d,0x0a,0
err204:
            fcc         "Serial problem - framing error - possible cable, computer hardware or settings problem"
            fcb         0x0d,0x0a,0
err205:
            fcc         "Serial problem - noise - possible cable or computer hardware problem"
            fcb         0x0d,0x0a,0
err206:
            fcc         "Serial problem - overrun"
            fcb         0x0d,0x0a,0
err207:
            fcc         "Serial problem - Receive txmode - driver or computer software problem"
            fcb         0x0d,0x0a,0
err208:
            fcc         "Serial problem - Transmit txmode0 - driver or computer software problem"
            fcb         0x0d,0x0a,0
err209:
            fcc         "Serial problem - CANid out of range - driver or computer software problem"
            fcb         0x0d,0x0a,0
err210:
            fcc         "Serial problem - Table out of range - driver or computer software problem"
            fcb         0x0d,0x0a,0
err211:
            fcc         "Serial problem - Address out of range - driver or computer software problem"
            fcb         0x0d,0x0a,0
err212:
            fcc         "Serial problem - mode10 error - driver or computer software problem"
            fcb         0x0d,0x0a,0
err213:
            fcc         "Serial problem - table calibration - driver or computer software problem"
            fcb         0x0d,0x0a,0
err214:
            fcc         "Serial problem - Transmit txmode range - driver or computer software problem"
            fcb         0x0d,0x0a,0
err215:
            fcc         "Serial problem - mode 10 mainloop - driver or computer software problem"
            fcb         0x0d,0x0a,0
err216:
            fcc         "Serial problem - other error - likely driver or computer software problem"
            fcb         0x0d,0x0a,0
err217:
            fcc         "Serial problem - err217"
            fcb         0x0d,0x0a,0

.nolist                      ;skip the symbol table
