;*********************************************************************
; Misc asm
;*********************************************************************
; $Id: ms2_extra_asm.s,v 1.15 2010-10-01 00:32:46 jsmcortina Exp $

.sect .text
.globl UnimplementedISR, ckstall, muldiv

             nolist               ;turn off listing
             include "s12asmdefs.inc"
             include "ms2extrah.inc"
             include "ms2extra_structs.inc"
             list                 ;turn listing back on

;**************************************************************************
; Miscellaneous code in asm
; **************************************************************************
UnimplementedISR:
   ; Unimplemented ISRs trap
   rti

ckstall:
   brset   synch,#1,cont_ckstall   ; skip if not synced
   jmp	   LM73 

;  check rpm for stall condition (< 50 rpm) after engine synch
;          if((lmms - ltch_lmms) > (18750/num_cyl))  {
cont_ckstall:
   sei
   ldx     lmms
   ldd     lmms+0x2
   subd    ltch_lmms+0x2
   xgdx
   sbcb    ltch_lmms+0x1
   sbca    ltch_lmms      ; result now in d:x
   cli
   cpd     stall_timeout
   blo     end_stall
   bhi     LM70
   cpx     stall_timeout+0x2
   blo     end_stall

LM70:
;              // Engine is stalled, clear all in engine
;    tst     conf_err
;    bne     LM70skip2

   ldab    IdleCtl
   cmpb    #1
   bne	   LM70skip

   ldx     pPTMpin+0x4
   bclr	   0,X #0x04  ; ON/OFF idle turned off
LM70skip:
   call    ign_reset
LM70skip2:
   ldd	   #0
   std    outpc.pw1
   std    req_pw1
   std    outpc.pw2
   std    req_pw2
   std    outpc.pw3
   std    req_pw3
   std    outpc.pw4
   std    req_pw4
   bset   flagbyte2,#0x04
   movw   #0xFFFF,tcrank_done
   clr    running_seconds
   brset   flash4.EAEOption,0x1,EAESet
   jmp     end_stall

EAESet:
   ldd	   #100
   std	   outpc.EAEfcor1
   std     outpc.EAEfcor2
   ldd	   #0
   std	   outpc.wallfuel1
   std     outpc.wallfuel1+0x02
   std     outpc.wallfuel2
   std     outpc.wallfuel2+0x02
   std	   WF1
   std	   WF1+0x02
   std     AWA1
   std     AWA1+0x02
   std	   SOA1
   std	   SOA1+0x02
   std	   WF2
   std	   WF2+0x02
   std     AWA2
   std     AWA2+0x02
   std	   SOA2
   std	   SOA2+0x02
   bra     end_stall

LM73:
;   tst      conf_err
;   bne      do_skipstall
   brclr   flagbyte1,#2,check_for_stall  
;      // if no tach pulse within 2 sec
;      else if((lmms - ltch_lmms) > 15625)  {
do_skipstall:
   jmp     end_stall ; skip if in test mode
check_for_stall:
   ldx     lmms
   ldd     lmms+0x2
   subd    ltch_lmms+0x2
   xgdx
   sbcb    ltch_lmms+0x1
   sbca    ltch_lmms      ; result now in d:x
   tbne    D,LM74
   cpx     #15625
   bls     end_stall

LM74:
   bclr	   PORTE, #0x10   ; // Turn off fuel Pump

   ldab    IdleCtl
   cmpb    #1
   bne	   LM74skip

   ldx     pPTMpin+0x4
   bclr	   0,X #0x04  ; ON/OFF idle turned off
LM74skip:

   movw    #0,outpc.pw1
   movw    #0,outpc.pw2
   movw	   #0xFFFF,tcrank_done
   clr     running_seconds
   bset	   flagbyte2,#0x04
   brclr   flash4.EAEOption,0x1,end_stall
   ldd	   #100
   std	   outpc.EAEfcor1
   std     outpc.EAEfcor2
   ldd	   #0
   std	   outpc.wallfuel1
   std     outpc.wallfuel1+0x02
   std     outpc.wallfuel2
   std     outpc.wallfuel2+0x02
   std	   WF1
   std	   WF1+0x02
   std     AWA1
   std     AWA1+0x02
   std	   SOA1
   std	   SOA1+0x02
   std	   WF2
   std	   WF2+0x02
   std     AWA2
   std     AWA2+0x02
   std	   SOA2
   std	   SOA2+0x02

end_stall:

; also setup PWM duties (also moved from 0.128ms)
;; need to change to pointer to allow realtime tuning
   ldy     pg4_ptr
   ldab	   flash4.InjPWMPd-0x4000,Y  ; HARDCODING
   ldaa    flash4.InjPWMDty-0x4000,Y ; HARDCODING
;   ldab    flash4.InjPWMPd
;   ldaa    flash4.InjPWMDty
;      PWMDTY2 = (unsigned char)((flash4.InjPWMDty * PWMPER2) / 100);
   mul
   ldx     #100
   idivs   ; why signed?
   xgdx
   stab    pwmd1
   brset   flash4.ICIgnOption,#0x20,pwmd_2
   stab    pwmd2   ; same at the moment, but ought to extend so each channel different
   bra     pwmc_end
pwmd_2:
   ldy     pg4_ptr
   ldab	   flash4.InjPWMPd2-0x4000,Y   ; HARDCODING
   ldaa    flash4.InjPWMDty2-0x4000,Y  ; HARDCODING
;   ldab    flash4.InjPWMPd2
;   ldaa    flash4.InjPWMDty2
   mul
   ldx     #100
   idivs
   xgdx
   stab    pwmd2

   pwmc_end:
rts ; in non-banked

.sect .text
;U32 x U16 / 65536
; put this in low mem, so jsr gets us here
; on entry:
; D is U16
; U32 on stack at 2,SP and 4,SP
; returns result in X:D
muldiv:
    pshd
    clr 1,-sp ; lower word of U32 result 0,SP
    clr 1,-sp ; (no clrw on S12)
;now U16 is 2,SP
;    U32 is 6,SP  8,SP

    ldd     8,SP
    ldy     2,SP
    emul
    sty     0,SP
    ldd     6,SP
    ldy     2,SP
    emul
    addd    0,SP
    std     0,SP
    bcc     noaddy
    iny
noaddy:
    tfr     y,x
    leas    4,SP
    rts
