; $Id: ms2_extra_burnfactor.s,v 1.3 2010-10-01 00:32:46 jsmcortina Exp $
.sect .text3c
.globl erasefactor
.globl progfactor
.globl RamBurnPgm
.globl cltfactor_table
.globl matfactor_table
.globl egofactor_table
.globl maffactor_table
.globl tble_idx
.globl ntword

;.nolist
include "s12asmdefs.inc"
;.list

;*********************************************************************
; burn a lookup table from SCI
; first step erase sector(s)
;
;*********************************************************************
erasefactor:
       pshd
       pshx
       pshy
       ldaa    flocker
       cmpa    #0xcc
       bne     erend

       ldaa    tble_idx
       cmpa    #4
       bhs     erend
       asla
       tfr     a,x
       ldx     burnflookup,x

       brclr   FSTAT,#CBEIF,.   ; loop until no command in action

;table 0,1,3 are 2k long, 2 is 1k sector
       ldaa    FSTAT
       anda    #0x30
       beq     erfact1
       movb    #ACCERR|PVIOL,FSTAT
erfact1:
       ldd     #0xffff
       std     0,x
       movb    #SecErase,FCMD
       ldaa    #CBEIF
       jsr     RamBurnPgm

       ldaa    tble_idx
       cmpa    #2
       beq     erend

       movb    #ACCERR|PVIOL,FSTAT
       std     1024,x
       movb    #SecErase,FCMD
       ldaa    #CBEIF
       jsr     RamBurnPgm

erend:
nop  ; provide BP ability in here
       puly
       pulx
       puld
       rtc    ; in banked mem

;*********************************************************************
; second step, burn a word at a time
;*********************************************************************
progfactor:
       pshd
       pshx
       pshy
       ldaa    flocker
       cmpa    #0xcc
       bne     progend

       ldaa    tble_idx
       cmpa    #4
       bhs     progend
       asla
       tfr     a,x
       ldd     burnflookup,x
       addd    ntword     ; add on byte offset (word *2)
       addd    ntword
       tfr     d,x

       movb    #ACCERR|PVIOL,FSTAT
       ldd     tble_word
       std     0,x
       movb    #ProgWord,FCMD
       ldaa    #CBEIF
       jsr     RamBurnPgm

nop  ; provide BP ability in here

progend:
nop  ; provide BP ability in here
       puly
       pulx
       puld
       rtc   ; in banked mem

;*********************************************************************
; lookup table of locs
;*********************************************************************
burnflookup:
       fdb  cltfactor_table
       fdb  matfactor_table
       fdb  egofactor_table
       fdb  maffactor_table
