/* $Id: ms2_extra_inj.c,v 1.35 2011-10-28 20:40:42 racingmini Exp $ */
#include "ms2_extra.h"

static unsigned int staging_percent;
static unsigned char squirts_per_rev;

/* staging parameters from user are size of primaries and size of secondaries.
 * we will calculate a percentage (100% means same-size injectors) and store
 * in RAM for the staged pw calc
 */
void setup_staging(void)
{
    staging_percent = ((unsigned long)flash10.staged_pri_size * 100) /
        (flash10.staged_pri_size + flash10.staged_sec_size);
    flagbyte4 &= ~flagbyte4_staging_on;
    squirts_per_rev = (num_cyl / divider) >> 1;
}

unsigned char calc_duty(unsigned long base_pw)
{
    unsigned long time_per_rev;
    unsigned long dtpred_time;
    unsigned int duty;
     
    /* add this since it's really part of the duty...
     * Divide by 100 because we were doing our calcs in
     * usec * 100 resolution before.
     */
    base_pw = (base_pw / 100) + pw_open1;

    base_pw *= squirts_per_rev;

    base_pw = (base_pw*3)>>1;

    /* how long is 1 rev right now */
    DISABLE_INTERRUPTS;
    dtpred_time = dtpred;
    ENABLE_INTERRUPTS;

    time_per_rev = (num_cyl >> 1) * dtpred_time;

    /* rolled over, but we don't want to stage b/c of that */
    if (time_per_rev < dtpred_time) {
        return 0;
    }

    duty = (unsigned int)((base_pw * 100) / time_per_rev);

    if (duty > 255) {
        duty = 255;
    }

    return (unsigned char)duty;
}

/* determine if staging should be on or not */
unsigned char staging_on(unsigned long base_pw)
{
    unsigned char param;
    static unsigned char staged_first_param_on = 0, staged_second_param_on = 0;
    int param_to_check;

    param = flash10.staged & 0x7;
    /* First parameter */

    if (param == 0x1 ) {
        param_to_check = outpc.rpm;
    } else if (param == 0x2) {
        param_to_check = outpc.map / 10;
    } else if (param == 0x3) {
        param_to_check = outpc.tps / 10;
    } else {
        /* calc duty and check against setting */
        param_to_check = calc_duty(base_pw);
    }

    if (param_to_check >= flash10.staged_param_1) {
        staged_first_param_on = 1;
    } else if (param_to_check < (flash10.staged_param_1 - flash10.staged_hyst_1)) {
        staged_first_param_on = 0;
    }

    param = flash10.staged & 0x38;

    /* only one param, so return the result */
    if (!param) {
        return (staged_first_param_on);
    }

    if (param == 0x8) {
        param_to_check = outpc.rpm;
    } else if (param == 0x10) {
        param_to_check = outpc.map / 10;
    } else if (param == 0x18) {
        param_to_check = outpc.tps / 10;
    } else {
        param_to_check = calc_duty(base_pw);
    }

    if (param_to_check >= flash10.staged_param_2) {
        staged_second_param_on = 1;
    } else if ( param_to_check < (flash10.staged_param_2 - flash10.staged_hyst_2)) {
        staged_second_param_on = 0;
    }

    if (flash10.staged & 0x80) {
        return (staged_first_param_on && staged_second_param_on);
    } else {
        return (staged_first_param_on || staged_second_param_on);
    }

    return 0;
}

/* now we calculate the staged pulse-width based on the staging percent, and
 * conditions for staging
 */
void calc_staged_pw(unsigned long base_pw1, unsigned long base_pw2)
{
    unsigned long calculated_pw1, calculated_pw2, calculated_pw3=0, calculated_pw4=0,
                  calculated_base_pw1, calculated_base_pw2=0, calculated_secondary_enriched1, calculated_secondary_enriched2=0;
    unsigned long per_ignevent_amt_pw1, per_ignevent_amt_pw2, per_ignevent_amt_pw3=0, per_ignevent_amt_pw4=0;
    unsigned char staged_num_events_pri;
    unsigned int staged_transition_percent;

    if ((flash10.staged & 0x7) == 5) {
        /* This mode is a bit more complicated... we look up a value in an loadxRPM table,
         * and use the percent there to figure out what percentage through the staging process
         * the user wants to be at... 0% is no staging, and 100% is fully staged
         */
        staged_transition_percent = intrp_2dctable(outpc.rpm, outpc.fuelload, 6, 6,
                pg10_ptr->staged_rpms,
                pg10_ptr->staged_loads,
                (unsigned char *)pg10_ptr->staged_percents, 1);

        /* percent in .1% units */
        calculated_base_pw1 = (base_pw1 * (unsigned long) staging_percent) / 100;
        if (base_pw2 != 0) {
            calculated_base_pw2 = (base_pw2 * (unsigned long) staging_percent) / 100;
        }

        /* Hard code 0% and 100% to avoid doing the long math when we can */
        if (staged_transition_percent == 0) {
            flagbyte4 &= ~flagbyte4_staging_on;
            pw_staged1 = base_pw1;
            pw_staged2 = 0;
            if (base_pw2 !=0) {
                pw_staged3 = base_pw2;
                pw_staged4 = 0;
            }
        } else if (staged_transition_percent == 100) {
            flagbyte4 |= flagbyte4_staging_on;
            pw_staged1 = pw_staged2 = calculated_base_pw1;
            if (base_pw2 !=0) {
                pw_staged3 = pw_staged4 = calculated_base_pw2;
            }
        } else {
            flagbyte4 |= flagbyte4_staging_on;

            /* pw1 is (base pw - (starting pw - the ending pw) * the commanded percent)
             * so that pw1 is scaled down by the same amt that pw2 is scaled up by given the
             * size difference between the injectors
             */
            calculated_pw1 = base_pw1 - (((long)(staged_transition_percent) *
                        (base_pw1 - calculated_base_pw1)) / 1000L);

            /* pw2 is (commanded percent * base pw) */

            calculated_pw2 = (calculated_base_pw1 * staged_transition_percent) / 1000L;

            pw_staged1 = calculated_pw1;
            pw_staged2 = calculated_pw2;
            if (base_pw2 != 0) {
                calculated_pw3 = base_pw2 - (((long)(staged_transition_percent) *
                            (base_pw2 - calculated_base_pw2)) / 1000L);

                calculated_pw4 = (calculated_base_pw2 * staged_transition_percent) / 1000L;

                pw_staged3 = calculated_pw2;
                pw_staged4 = calculated_pw4;
            }
        }
    } else if(staging_on(base_pw1)) {
        flagbyte4 |= flagbyte4_staging_on;
        /* staging should be on, calculate staged pw */
        calculated_base_pw1 = (base_pw1 * (unsigned long)staging_percent) / 100;
        if (base_pw2 != 0) {
            calculated_base_pw2 = (base_pw2 * (unsigned long)staging_percent) / 100;
        }

        /* did staging just come on? if so, pw_staged2 will be 0... use that to reset
         * the transition count if necessary */

        if ((flash10.staged & 0x40) && (!(flagbyte4 & flagbyte4_transition_done))) {
            if (pw_staged2 == 0) {
                DISABLE_INTERRUPTS;
                staged_num_events = 1;
                ENABLE_INTERRUPTS;
            }

            calculated_secondary_enriched1 = (calculated_base_pw1 + ((long)flash10.staged_secondary_enrichment *
                        100));

            per_ignevent_amt_pw1 = (base_pw1 - calculated_base_pw1) / flash10.staged_transition_events;
            per_ignevent_amt_pw2 = (calculated_secondary_enriched1 - calculated_base_pw1) /
                flash10.staged_transition_events;

            if (base_pw2 != 0) {
                calculated_secondary_enriched2 = (calculated_base_pw2 + ((long)flash10.staged_secondary_enrichment *
                            100));

                per_ignevent_amt_pw3 = (base_pw2 - calculated_base_pw2) / flash10.staged_transition_events;
                per_ignevent_amt_pw4 = (calculated_secondary_enriched2 - calculated_base_pw2) /
                    flash10.staged_transition_events;
            }

            staged_num_events_pri = staged_num_events - flash10.staged_primary_delay;
            if (staged_num_events_pri > staged_num_events) {
                /* rolled over */
                staged_num_events_pri = 0;
            }

            calculated_pw2 = calculated_secondary_enriched1 - (staged_num_events * per_ignevent_amt_pw2);
            calculated_pw1 = base_pw1 - (staged_num_events_pri * per_ignevent_amt_pw1);

            if (base_pw2 != 0) {
                calculated_pw4 = calculated_secondary_enriched2 - (staged_num_events * per_ignevent_amt_pw4);
                calculated_pw3 = base_pw2 - (staged_num_events_pri * per_ignevent_amt_pw3);
            }

            if (calculated_pw2 < calculated_base_pw1) {
                calculated_pw2 = calculated_base_pw1;
            }

            if ((base_pw2 !=0) && (calculated_pw4 < calculated_base_pw2)) {
                calculated_pw4 = calculated_base_pw2;
            }

            if (staged_num_events_pri >= flash10.staged_transition_events) {
                flagbyte4 |= flagbyte4_transition_done;
            }

            if (flagbyte4 & flagbyte4_transition_done) {
                calculated_pw2 = calculated_pw1 = calculated_base_pw1;
                if (base_pw2 != 0) {
                    calculated_pw4 = calculated_pw3 = calculated_base_pw2;
                }
            }
        } else {
            calculated_pw2 = calculated_pw1 = calculated_base_pw1;
            if (base_pw2 != 0) {
                calculated_pw4 = calculated_pw3 = calculated_base_pw2;
            }
        }

        pw_staged1 = calculated_pw1;
        pw_staged2 = calculated_pw2;
        if (base_pw2 != 0) {
            pw_staged3 = calculated_pw3;
            pw_staged4 = calculated_pw4;
        }
    } else {
        flagbyte4 &= ~flagbyte4_staging_on;
        /* staging should be off, just set the pulse-width to the base_pw */

        pw_staged1 = base_pw1;
        pw_staged2 = 0;
        if (base_pw2 !=0) {
            pw_staged3 = base_pw2;
            pw_staged4 = 0;
        }
        flagbyte4 &= ~flagbyte4_transition_done;
    }
}

/**************************************************************************
 **
 **  EAE Transient Enrichment Section:
 **
 BF = Basic Fuel amount
 P = MAP value
 EXC = EGO correction factor
 TCC = Corrections for temperature, barometric pressure, etc...
 DFC = Desired Amount of Fuel
 WF = total amt of fuel adhering to walls
 AWC = Adhere to wall coefficient: proportion of the fuel injected in next pulse which will adhere.
 AWA = actual amount that'll adhere in the next pulse
 SOC = proportion of fuel injected in next pulse which will be sucked off the walls
 SOA = actual amt of fuel injected in next pulse which will be sucked off the walls
 SQF = actual amt of fuel squirted for this pulse
 AFC = time that injector is commanded to be open
 DT = injector opening time
 BAWC = AWC but only with reference to manifold pressure.
 BSOC = same as BAWC but for SOC
 AWW = correction to AWC based on CLT
 SOW = correction to SOC based on CLT
 AWN = correction to AWC based on engine speed
 SON = correction to SOC based on engine speed
 AWF = correction to AWC based on air velocity
 SOF = correction to SOC based on air velocity

 AWC = BAWC*AWW*AWN*AWF
 SOC = BSOC*SOW*SON*SOF

 SOA = SOC * WF
 SQF = (DFC - SOA)/(1-AWC)
 AWA = SQF * AWC

 if (fuelcut)
 WF = WF - SOA
 else
 WF = WF + AWA - SOA

 AFC = SQF + DT

 calculation of WF should be done in ISR, the rest can and will be done
 in main loop.
 **
 **************************************************************************/

void run_EAE_calcs (void)
{
    if(flash4.EAEOption)  {
        unsigned long wflocal1, wflocal2;
        unsigned long SQF1, SQF2, SOAtmp1, SOAtmp2, AWAtmp1, AWAtmp2;
        unsigned char BAWC, AWN, SOC, BSOC, SON, AWC, AWW, SOW;


        BAWC = (unsigned char)intrp_1dctable(outpc.eaeload,NO_FMAPS,(int *)flash5.EAEAWCKPAbins,
                0, (unsigned char *)flash5.EAEBAWC);
        AWN = (unsigned char)intrp_1dctable(outpc.rpm,NO_FRPMS,(int *)flash5.EAEAWCRPMbins, 0,
                (unsigned char *)flash5.EAEAWN);
        AWW = (unsigned char)intrp_1dctable(outpc.clt,12,(int *)flash5.EAEAWWCLTbins,
                0, (unsigned char *)flash5.EAEAWW);
        /* BAWC in 1% units, so 100 = 100%, but make end result in .1% units */

        AWC = ((unsigned long)BAWC * AWN * AWW) / 10000;
        if (AWC >= 100) AWC = 99; /* avoid div by 0 below */

        BSOC = (unsigned char)intrp_1dctable(outpc.eaeload,NO_FMAPS,(int *)flash5.EAESOCKPAbins,
                0, (unsigned char *)flash5.EAEBSOC);
        SON = (unsigned char)intrp_1dctable(outpc.rpm,NO_FRPMS,(int *)flash5.EAESOCRPMbins, 0,
                (unsigned char *)flash5.EAESON);
        SOW = (unsigned char)intrp_1dctable(outpc.clt,12,(int *)flash5.EAESOWCLTbins,
                0, (unsigned char *)flash5.EAESOW);

        /* units here are .1% */
        SOC = ((unsigned long)BSOC * SON * SOW) / 10000;

        /* table lookups done, do calcs */

        /* calculate actual amt "sucked off" the walls */

        DISABLE_INTERRUPTS;
        wflocal1 = WF1;
        ENABLE_INTERRUPTS;

        SOAtmp1 = (SOC * wflocal1) / 1000;

        DISABLE_INTERRUPTS;
        SOA1 = SOAtmp1;
        ENABLE_INTERRUPTS;

        if (SOAtmp1 > tmp_pw1)
            SOAtmp1 = tmp_pw1;

        /* Calc actual amt of fuel to be injected in next pulse */
        SQF1 = ((unsigned long)((unsigned long)(tmp_pw1 - SOAtmp1) * 100)) / (100 - AWC);

        if (SQF1 > 3200000) {
            SQF1 = 3200000;
        }

        /* do % calc */

        outpc.EAEfcor1 = ((unsigned long)SQF1 * 100) / tmp_pw1;

        AWAtmp1 = ((unsigned long)SQF1 * AWC) / 100;

        DISABLE_INTERRUPTS;
        AWA1 = AWAtmp1;
        ENABLE_INTERRUPTS;
        outpc.wallfuel1 = wflocal1;

        if(!(outpc.engine & ENGINE_CRANK)) {
            tmp_pw1 = SQF1;
        }

        /* do this optionally to speed up the code when we don't need it */

        if (flash4.dual_tble_optn || (flash10.staged & 0x7)) {
            DISABLE_INTERRUPTS;
            wflocal2 = WF2;
            ENABLE_INTERRUPTS;

            SOAtmp2 = (SOC * wflocal2) / 1000;

            DISABLE_INTERRUPTS;
            SOA2 = SOAtmp2;
            ENABLE_INTERRUPTS;

            if (SOAtmp2 > tmp_pw2)
                SOAtmp2 = tmp_pw2;

            /* Calc actual amt of fuel to be injected in next pulse */
            SQF2 =
                ((unsigned long) ((unsigned long) (tmp_pw2 - SOAtmp2) * 100)) /
                (100 - AWC);

            if (SQF2 > 3200000) {
                SQF2 = 3200000;
            }

            /* do % calc */

            outpc.EAEfcor2 = ((unsigned long) SQF2 * 100) / tmp_pw2;

            AWAtmp2 = ((unsigned long) SQF2 * AWC) / 100;

            DISABLE_INTERRUPTS;
            AWA2 = AWAtmp2;
            ENABLE_INTERRUPTS;
            outpc.wallfuel2 = wflocal2;

            if (!(outpc.engine & ENGINE_CRANK)) {
                tmp_pw2 = SQF2;
            }
        } else {
            DISABLE_INTERRUPTS;
            AWA2 = AWAtmp1;
            SOA2 = SOAtmp1;
            outpc.EAEfcor2 = outpc.EAEfcor1;
            ENABLE_INTERRUPTS;
            tmp_pw2 = tmp_pw1;
        }

        /* WF calc in interrupt */
    }
}

void INJ1(void)
{
    if (req_pw1 > 100) {
#ifndef MICROSQUIRT
        if (seq_inj_ctrl & SEQ_STD_INJ) {
            PWMPER2 = pg4_ptr->InjPWMPd;    // set PWM period (us)
            PWMDTY2 = PWMPER2;              // set PWM duty to 100 %
            pwm1_on = pg4_ptr->InjPWMTim;   // .128 ms
            PWMCNT2 = 0x00;                 // clear counter
            PWME |= 0x04;                   // enable PWM2
        }
#endif

        TCTL2 |= 0x04;          // set output hi in OL1
        CFORC |= 0x02;          // force high
        TC1 = TCNT + req_pw1;   // load OC compare reg
        TCTL2 &= ~0x04;         // set output lo in OL1
        TIE |= 0x02;            // Enable Inj1 OC interrupt
        TFLG1 = 0x02;           // clear OC interrupt flag
        *pPTMpin[3] |= 0x08;    // turn on inj led
        outpc.squirt |= 0x01;   // inj1 squirting
        if ((!(seq_inj_ctrl & SEQ_STD_INJ)) && (no_inj < 3) && (!(flash10.staged & 0x07))) {
            // Start injection on INJ3 if using additional injectors
#ifndef MICROSQUIRT
            TCTL2 |= 0x10;      // set output hi in OL2
#else
            TCTL1 |= 0x10;      // set output hi in OL6
#endif
            CFORC |= TFLG_rotINJ3;          // force high
            TC_rotINJ3 = TCNT + req_pw1;    // load OC compare reg
#ifndef MICROSQUIRT
            TCTL2 &= ~0x10;     // set output lo in OL2
#else
            TCTL1 &= ~0x10;     // set output lo in OL6
#endif
            TIE |= TFLG_rotINJ3;    // Enable Inj3 OC interrupt
            TFLG1 = TFLG_rotINJ3;   // clear OC interrupt flag
            outpc.squirt |= 0x04;   // inj3 squirting
        }
    } else {
        TIE &= ~0x02;   // disable int
        CFORC &= ~0x02; // don't force high
    }
}

void INJ2(void)
{
    if (req_pw2 > 100) {
#ifndef MICROSQUIRT
        if (seq_inj_ctrl & SEQ_STD_INJ) {
            if (flash4.ICIgnOption & 0x20) {    // if using own settings
                PWMPER4 = pg4_ptr->InjPWMPd2;   // set PWM period (us)
                pwm2_on = pg4_ptr->InjPWMTim2;  // .128 ms
            } else {
                PWMPER4 = pg4_ptr->InjPWMPd;    // set PWM period (us)
                pwm2_on = pg4_ptr->InjPWMTim;   // .128 ms
            }
            PWMDTY4 = PWMPER4;                  // set PWM duty to 100 %
            PWMCNT4 = 0x00;                     // clear counter
            PWME |= 0x10;                       // enable PWM4
        }
#endif
        TCTL2 |= 0x40;          // set output hi in OL3
        CFORC |= 0x08;          // force high
        TC3 = TCNT + req_pw2;   // load OC compare reg
        TCTL2 &= ~0x40;         // set output lo in OL3
        TIE |= 0x08;            // Enable Inj2 OC interrupt
        TFLG1 = 0x08;           // clear OC interrupt flag
        *pPTMpin[3] |= 0x08;    // turn on inj led
        outpc.squirt |= 0x02;   // inj2 squirting
        if ((!(seq_inj_ctrl & SEQ_STD_INJ)) && (no_inj < 3) && (!(flash10.staged & 0x07))) {
            // Start injection on INJ4 if using additional injectors
#ifndef MICROSQUIRT
            TCTL1 |= 0x01;      // set output hi in OL4
#else
            TCTL1 |= 0x40;      // set output hi in OL7
#endif
            CFORC |= TFLG_rotINJ4;          // force high
            TC_rotINJ4 = TCNT + req_pw2;    // load OC compare reg
#ifndef MICROSQUIRT
            TCTL1 &= ~0x01;     // set output lo in OL4
#else
            TCTL1 &= ~0x40;     // set output lo in OL7
#endif
            TIE |= TFLG_rotINJ4;    // Enable Inj4 OC interrupt
            TFLG1 = TFLG_rotINJ4;   // clear OC interrupt flag
            outpc.squirt |= 0x08;   // inj4 squirting
        }
    } else {
        TIE &= ~0x08;   // disable int
        CFORC &= ~0x08; // don't force high
    }
}

void INJ3(void)
{
    if (req_pw3 > 100) {
#ifndef MICROSQUIRT
        TCTL2 |= 0x10;  // set output hi in OL2
#else
        TCTL1 |= 0x10;  // set output hi in OL6
#endif
        CFORC |= TFLG_rotINJ3;          // force high
        TC_rotINJ3 = TCNT + req_pw3;    // load OC compare reg
#ifndef MICROSQUIRT
        TCTL2 &= ~0x10; // set output lo in OL2
#else
        TCTL1 &= ~0x10; // set output lo in OL6
#endif
        TIE |= TFLG_rotINJ3;    // Enable Inj3 OC interrupt
        TFLG1 = TFLG_rotINJ3;   // clear OC interrupt flag
        *pPTMpin[3] |= 0x08;    // turn on inj led
        outpc.squirt |= 0x04;   // inj3 squirting
    } else {
        TIE &= ~TFLG_rotINJ3;   // disable int
        CFORC &= ~TFLG_rotINJ3; // don't force high
    }
}

void INJ4(void)
{
    if (req_pw4 > 100) {
#ifndef MICROSQUIRT
        TCTL1 |= 0x01;  // set output hi in OL4
#else
        TCTL1 |= 0x40;  // set output hi in OL7
#endif
        CFORC |= TFLG_rotINJ4;          // force high
        TC_rotINJ4 = TCNT + req_pw4;    // load OC compare reg
#ifndef MICROSQUIRT
        TCTL1 &= ~0x01; // set output lo in OL4
#else
        TCTL1 &= ~0x40; // set output lo in OL7
#endif
        TIE |= TFLG_rotINJ4;    // Enable Inj4 OC interrupt
        TFLG1 = TFLG_rotINJ4;   // clear OC interrupt flag
        *pPTMpin[3] |= 0x08;    // turn on inj led
        outpc.squirt |= 0x08;   // inj4 squirting
    } else {
        TIE &= ~TFLG_rotINJ4;   // disable int
        CFORC &= ~TFLG_rotINJ4; // don't force high
    }
}

void schedule_fuel(unsigned int TC0this)
{
    unsigned char next;
    unsigned char sched_now;

    /************* Injector Channel 1 *******************/
    if (seq_inj_ctrl & SEQ_MASK_INJ1) {
        // Set next event
        /* explicitly copy each member of the struct...
         * otherwise gcc jumps to memcpy.. which is
         * notoriously slow
         */
        if ((flash8.seq_inj & 0x03) == 1) {
            if (next_fuel1_event.inj == no_squirts - 1) {
                next = 0;
            } else {
                next = next_fuel1_event.inj + 1;
            }
        } else {
            if (next_fuel1_event.inj == (no_triggers>>1) - 1) {
                next = 0;
            } else {
                next = next_fuel1_event.inj + 1;
            }
        }

        // Check if the next event is due this tooth; if so, it is for the next cycle
        if ((fuel1_events[next].inj == next_fuel1_event.inj) && (fuel1_events[next].tooth == tooth_no)) {
            // This the next cycle event
            sched_now = 0;
        } else {
            // This is for this cycle
            sched_now = 1;
        }

        next_fuel1_event.time = fuel1_events[next].time;
        next_fuel1_event.tooth = fuel1_events[next].tooth;
        next_fuel1_event.inj = fuel1_events[next].inj;

        seq_inj_ctrl &= ~SEQ_MASK_INJ1;
    } else {
        // Normal sequence
        sched_now = 1;
    }

    if (sched_now && (next_fuel1_event.tooth == tooth_no)) {
        if ((flash8.seq_inj & 0x03) == 3) {
            if (next_fuel1_event.inj == 0) {
                req_pw1 = add_open(pwcalc1, pw_open1);
            } else {
                req_pw1 = add_open(pwcalc2, pw_open1);
            }
        } else {
            req_pw1 = add_open(pwcalc1, pw_open1);
        }
        outpc.pw1 = add_open(pwcalc1, pw_open1);
        // Schedule event if pulse width is large enough
        if (req_pw1 > 100) {
            inj1_count = next_fuel1_event.time;
        }

        // Mask injection for next tooth
        seq_inj_ctrl |= SEQ_MASK_INJ1;
    }

    /************* Injector Channel 2 *******************/
    if (seq_inj_ctrl & SEQ_MASK_INJ2) {
        // Set next event
        /* explicitly copy each member of the struct...
         * otherwise gcc jumps to memcpy.. which is
         * notoriously slow
         */
        if ((flash8.seq_inj & 0x03) == 1) {
            if (next_fuel2_event.inj == no_squirts - 1) {
                next = 0;
            } else {
                next = next_fuel2_event.inj + 1;
            }
        } else {
            if (next_fuel2_event.inj == (no_triggers>>1) - 1) {
                next = 0;
            } else {
                next = next_fuel2_event.inj + 1;
            }
        }

        // Check if the next event is due this tooth; if so, it is for the next cycle
        if ((fuel2_events[next].inj == next_fuel2_event.inj) && (fuel2_events[next].tooth == tooth_no)) {
            // This the next cycle event
            sched_now = 0;
        } else {
            // This is for this cycle
            sched_now = 1;
        }

        next_fuel2_event.time = fuel2_events[next].time;
        next_fuel2_event.tooth = fuel2_events[next].tooth;
        next_fuel2_event.inj = fuel2_events[next].inj;

        seq_inj_ctrl &= ~SEQ_MASK_INJ2;
    } else {
        // Normal sequence
        sched_now = 1;
    }

    if (((flash8.seq_inj & 0x03) == 2) && (flash10.staged & 0x7) && !(flagbyte4 & flagbyte4_staging_on)) {
        outpc.pw2 = 0;
    } else {
        if (sched_now && (next_fuel2_event.tooth == tooth_no)) {
            if ((flash8.seq_inj & 0x03) == 3) {
                if (next_fuel2_event.inj == 0) {
                    req_pw2 = add_open(pwcalc2, pw_open2);
                } else {
                    req_pw2 = add_open(pwcalc1, pw_open2);
                }
            } else {
                req_pw2 = add_open(pwcalc2, pw_open2);
            }
            outpc.pw2 = add_open(pwcalc2, pw_open2);
            // Schedule event if pulse width is large enough
            if (req_pw2 > 100) {
                inj2_count = next_fuel2_event.time;
            }

            // Mask injection for next tooth
            seq_inj_ctrl |= SEQ_MASK_INJ2;
        }
    }

    if (!(seq_inj_ctrl & SEQ_STD_INJ)) {
        /************* Injector Channel 3 *******************/
        if (seq_inj_ctrl & SEQ_MASK_INJ3) {
            // Set next event
            /* explicitly copy each member of the struct...
             * otherwise gcc jumps to memcpy.. which is
             * notoriously slow
             */
            if ((flash8.seq_inj & 0x03) == 1) {
                if (next_fuel3_event.inj == no_squirts - 1) {
                    next = 0;
                } else {
                    next = next_fuel3_event.inj + 1;
                }
            } else {
                if (next_fuel3_event.inj == (no_triggers>>1) - 1) {
                    next = 0;
                } else {
                    next = next_fuel3_event.inj + 1;
                }
            }

            // Check if the next event is due this tooth; if so, it is for the next cycle
            if ((fuel3_events[next].inj == next_fuel3_event.inj) && (fuel3_events[next].tooth == tooth_no)) {
                // This the next cycle event
                sched_now = 0;
            } else {
                // This is for this cycle
                sched_now = 1;
            }

            next_fuel3_event.time = fuel3_events[next].time;
            next_fuel3_event.tooth = fuel3_events[next].tooth;
            next_fuel3_event.inj = fuel3_events[next].inj;

            seq_inj_ctrl &= ~SEQ_MASK_INJ3;
        } else {
            // Normal sequence
            sched_now = 1;
        }

        if ((flash10.staged & 0x07) && !(flagbyte4 & flagbyte4_staging_on)) {
            outpc.pw3 = 0;
        } else {
            if (sched_now && (next_fuel3_event.tooth == tooth_no)) {
                if (next_fuel3_event.inj == 0) {
                    req_pw3 = add_open(pwcalc3, pw_open3);
                } else {
                    req_pw3 = add_open(pwcalc4, pw_open3);
                }
                outpc.pw3 = add_open(pwcalc3, pw_open3);
                // Schedule event if pulse width is large enough
                if (req_pw3 > 100) {
                    inj3_count = next_fuel3_event.time;
                }

                // Mask injection for next tooth
                seq_inj_ctrl |= SEQ_MASK_INJ3;
            }
        }

        /************* Injector Channel 4 *******************/
        if (seq_inj_ctrl & SEQ_MASK_INJ4) {
            // Set next event
            /* explicitly copy each member of the struct...
             * otherwise gcc jumps to memcpy.. which is
             * notoriously slow
             */
            if ((flash8.seq_inj & 0x03) == 1) {
                if (next_fuel4_event.inj == no_squirts - 1) {
                    next = 0;
                } else {
                    next = next_fuel4_event.inj + 1;
                }
            } else {
                if (next_fuel4_event.inj == (no_triggers>>1) - 1) {
                    next = 0;
                } else {
                    next = next_fuel4_event.inj + 1;
                }
            }

            // Check if the next event is due this tooth; if so, it is for the next cycle
            if ((fuel4_events[next].inj == next_fuel4_event.inj) && (fuel4_events[next].tooth == tooth_no)) {
                // This the next cycle event
                sched_now = 0;
            } else {
                // This is for this cycle
                sched_now = 1;
            }

            next_fuel4_event.time = fuel4_events[next].time;
            next_fuel4_event.tooth = fuel4_events[next].tooth;
            next_fuel4_event.inj = fuel4_events[next].inj;

            seq_inj_ctrl &= ~SEQ_MASK_INJ4;
        } else {
            // Normal sequence
            sched_now = 1;
        }

        if ((flash10.staged & 0x07) && !(flagbyte4 & flagbyte4_staging_on)) {
            outpc.pw4 = 0;
        } else {
            if (sched_now && (next_fuel4_event.tooth == tooth_no)) {
                if (next_fuel4_event.inj == 0) {
                    req_pw4 = add_open(pwcalc4, pw_open4);
                } else {
                    req_pw4 = add_open(pwcalc4, pw_open4);
                }
                outpc.pw4 = add_open(pwcalc4, pw_open4);
                // Schedule event if pulse width is large enough
                if (req_pw4 > 100) {
                    inj4_count = next_fuel4_event.time;
                }

                // Mask injection for next tooth
                seq_inj_ctrl |= SEQ_MASK_INJ4;
            }
        }
    }
}

unsigned int add_open(unsigned int pwcalc, unsigned int pw_open)
{
        unsigned int utmp1=0;

        if (pwcalc) {
                utmp1 = pwcalc + pw_open;
                utmp1 = ((unsigned long)utmp1 * 3)>>1;
        }

        return(utmp1);
}

void add_vetrim(void)
{
        if (outpc.vetrim[0]) {
                //Use trim table
                tmp_pw1 += (((long)tmp_pw1 * outpc.vetrim[0]) / 10) >> 10;
        }
        if (outpc.vetrim[1]) {
                //Use trim table
                tmp_pw2 += (((long)tmp_pw2 * outpc.vetrim[1]) / 10) >> 10;
        }
        if (outpc.vetrim[2]) {
                //Use trim table
                tmp_pw3 += (((long)tmp_pw3 * outpc.vetrim[2]) / 10) >> 10;
        }
        if (outpc.vetrim[3]) {
                //Use trim table
                tmp_pw4 += (((long)tmp_pw4 * outpc.vetrim[3]) / 10) >> 10;
        }
}
