/*************************************************************************
 **************************************************************************
 **   M E G A S Q U I R T  II - 2 0 0 4 - V1.000
 **
 **   (C) 2003 - B. A. Bowling And A. C. Grippo
 **
 **   This header must appear on all derivatives of this code.
 **
 ***************************************************************************
 **************************************************************************/

/*************************************************************************
 **************************************************************************
 **   GCC Port
 **
 **   (C) 2004,2005 - Philip L Johnson
 **
 **   This header must appear on all derivatives of this code.
 **
 ***************************************************************************
 **************************************************************************/

/*************************************************************************
 **************************************************************************
 **   MS2/Extra
 **
 **   (C) 2006,2007,2008 - Ken Culver, James Murray (in either order)
 **
 **   This header must appear on all derivatives of this code.
 **
 ***************************************************************************
 **************************************************************************/
/* $Id: ms2_extra_main.c,v 1.257 2011-12-21 14:40:56 jsmcortina Exp $ */


/*------------------------
  Version 1.000
  This version has all the basic capabilities of MS, but much higher precision -
  in the usec range. It adds larger tuning tables (12x12), WBO2, IAC, dual tables,
  and ignition control which assumes 1 coil and a mechanical distributor to
  distribute spark or EDIS for multicoil wasted spark.
  Version 1.100
  Made serial comms more robust: added one word read, write + verify commands,
  write to ram inhibit when overrun detection, receiver timeout check.
  Version 1.200
  Fixed various problems with trigger offsets ATDC (charge time can occur after
  input capture at very low rpms and other related ignition timing problems.)
  Version 1.300
  Changed tps, tpsdot units to % x 10; added accel tailoff algorithm.
  Version 2.000
  This version works with the CAN v3 pcb and has a template for CAN comms.
  Additional changes: increased input area to 4 x 512 byte blocks;
  inhibit coil charge 2 sec after turning ign key on;
  changed ports for FP, Idle (but connect to same pins on motherboard);
  knock ADC input in Vx100; all unused ports initialized as inputs.
  Made IACstart, PrimeP, CWU,CWH, AWEV,AWC,asecount ints instead of bytes.
  PrimeP,AWEV,AWC made function of initial coolant temperature.
  Expanded IAC control options for cranking plus switch to time based after
  start; added pulse tolerance inputs for cranking and after start; IAC
  option(5) to always enable stepper motor chip for 15 minutes after start,
  then revert to option 2.
  Version 2.100
  Added crank trigger mode.Ignition fires with only mech adv during cranking;
  added kpa to display outputs.
  Version 2.200
  Modified/ added ADC averaging: provided lag filter averaging for all
  ADC inputs (also for rpm). Relocated VE tables in anticipation of
  Block Learn Mode.
  Version 2.300
  Improved ego closed loop correction algorithms; flex fuel correction for
  alternative fuels; generic spare output ports;fixed logic error for IdleCtl=5;
  added fix to maintain coherence of inputs when changed thru serial port.
  Version 2.310, 2.320, 2.330, 2340, 2.350
  Fixed bug in ASE logic;set PW=0 in RevLimit mode;gcc compatibility changes;
  fixed bug in spare port hysteresis; changed some defaults; fixed bug in masking
  of TimerIn interrupts for dt/2; limited pw_open in case of battery spikes.
  Version 2.400
  Added automatic mixture control;mod to AE;expanded warmup inputs;
  moved DoOnStack to permanent ram;added option for 2 NBs;added knock
  retard based on ADC7 sensor.
  Version 2.500
  Added wheel decoding; added simple AE taper based on rpm;added time,% parameters
  to control tach input interrupt masking; 5 sec min for persistence of AS pulse
  tolerance; extended pulse tol range from 100 to 255.
  Version 2.510, 2.520, 2.530, 2.540
  Added fix to extend rpm range for wheel decoding; fixed AMC logic.
  Version 2.600, 2.610, 2.620, 2.630, 2.640, 2.66
  Added small model multi-page memory; added X-tau transient compensation; spark
  retard as function of manifold air temperature; added table fuel corrections for
  air density and barometric pressure; added spk retard correction for flex fuel;
  added injector test mode. Fixed bug in table burner; added ego volt outputs;
  shortened serial ISR time to expand wheel decoder range.

  MS2/Extra code branch by Ken Culver and James Murray
  Code split into files, more data pages, advanced wheel decoding, multiple spark outputs
  Add in AG's 2.36 stepper idle fix

  May/June 06 KC. Every tooth wheel decoder
  31 Aug 06  JSM. Cranking PW% and alternate option
   1 Sep 06  JSM. EGO2, FF, BARO2 can choose ADC ports (untested) Added start of 2nd trigger code
   2 Sep 06  JSM  Fixed memory.x and moved main into page 3d. Simplified PWM idle.
   3 Sep 06  KC. More wheel decoder fixes, make main loop not block interrupts for nearly
                 as long, add 32-bit calculation and timer capability for wheels with
                 small numbers of teeth
   4 Sep 06  KC. Add Cranking advance, Cranking dwell, and fixed timing.
     Nov 06      First alpha
     lack of notes
   4 Dec 08  KC. Restart Changelog. Redo EGO PID math and fix Boost PID. 
                 Recent changes also include Closed loop idle PID fixes and
                 several other bugfixes.
  -----------------------*/
#include "ms2_extra.h"
#include "cltfactor.inc"
#include "matfactor.inc"
#include "egofactor.inc"
#include "maffactor.inc"

const tIsrFunc _vect[] VECT_ATTR = {      /* Interrupt table */
    UnimplementedISR,                 /* vector 63 */
    UnimplementedISR,                 /* vector 62 */
    UnimplementedISR,                 /* vector 61 */
    UnimplementedISR,                 /* vector 60 */
    UnimplementedISR,                 /* vector 59 */
    UnimplementedISR,                 /* vector 58 */
    UnimplementedISR,                 /* vector 57 */
    UnimplementedISR,                 /* vector 56 */
    UnimplementedISR,                 /* vector 55 */
    UnimplementedISR,                 /* vector 54 */
    UnimplementedISR,                 /* vector 53 */
    UnimplementedISR,                 /* vector 52 */
    UnimplementedISR,                 /* vector 51 */
    UnimplementedISR,                 /* vector 50 */
    UnimplementedISR,                 /* vector 49 */
    UnimplementedISR,                 /* vector 48 */
    UnimplementedISR,                 /* vector 47 */
    UnimplementedISR,                 /* vector 46 */
    UnimplementedISR,                 /* vector 45 */
    UnimplementedISR,                 /* vector 44 */
    UnimplementedISR,                 /* vector 43 */
    UnimplementedISR,                 /* vector 42 */
    UnimplementedISR,                 /* vector 41 */
    UnimplementedISR,                 /* vector 40 */
    CanTxIsr,                         /* vector 39 */
    CanRxIsr,                         /* vector 38 */
    CanRxIsr,                         /* vector 37 */
    UnimplementedISR,                 /* vector 36 */
    UnimplementedISR,                 /* vector 35 */
    UnimplementedISR,                 /* vector 34 */
    UnimplementedISR,                 /* vector 33 */
    UnimplementedISR,                 /* vector 32 */
    UnimplementedISR,                 /* vector 31 */
    UnimplementedISR,                 /* vector 30 */
    UnimplementedISR,                 /* vector 29 */
    UnimplementedISR,                 /* vector 28 */
    UnimplementedISR,                 /* vector 27 */
    UnimplementedISR,                 /* vector 26 */
    UnimplementedISR,                 /* vector 25 */
    UnimplementedISR,                 /* vector 24 */
    UnimplementedISR,                 /* vector 23 */
    UnimplementedISR,                 /* vector 22 */
    UnimplementedISR,                 /* vector 21 */
    ISR_SCI_Comm,                     /* vector 20 */
    UnimplementedISR,                 /* vector 19 */
    UnimplementedISR,                 /* vector 18 */
    UnimplementedISR,                 /* vector 17 */
    ISR_TimerOverflow,                /* vector 16 */
#ifndef MICROSQUIRT
    ISR_Ign_TimerOut,                 /* vector 15 timer 7*/
#else
    ISR_Rot_SpkTimerOut,              /* vector 15 timer 7*/  //*** JB INJ4 on uS module
#endif
#ifndef MICROSQUIRT
    ISR_Dwl_TimerOut,                 /* vector 14 timer 6*/
#else
    ISR_Rot_TimerOut,                 /* vector 14 timer 6*/  //*** JB INJ3 on uS module
#endif
#ifndef MICROSQUIRT
    ISR_TC5,                          /* vector 13 timer 5*/
#else
    ISR_Ign_TimerOut,                 /* vector 13 timer 5*/
#endif
#ifndef MICROSQUIRT
    ISR_Rot_SpkTimerOut,              /* vector 12 timer 4*/  //*** JB INJ4 on MS2
#else
    ISR_Dwl_TimerOut,                 /* vector 12 timer 4*/
#endif
    ISR_Inj2_TimerOut,                /* vector 11 timer 3*/
#ifndef MICROSQUIRT
    ISR_Rot_TimerOut,                 /* vector 10 timer 2*/  //*** JB INJ3 on MS2
#else
    ISR_TC5,                          /* vector 10 timer 2*/
#endif
    ISR_Inj1_TimerOut,                /* vector 09 timer 1*/
    ISR_Ign_TimerIn,                  /* vector 08 timer 0*/
    ISR_Timer_Clock,                  /* vector 07 */
    UnimplementedISR,                 /* vector 06 */
    UnimplementedISR,                 /* vector 05 */
    UnimplementedISR,                 /* vector 04 */
    UnimplementedISR,                 /* vector 03 */
    UnimplementedISR,                 /* vector 02 */
    UnimplementedISR,                 /* vector 01 */
    _start                            /* Reset vector */
};

const page4_data flash4 EEPROM_ATTR = {
    4,               // no_cyl (1-12)   
    3,               // no_skip_pulses, don't need if wheel decode mode
    0x15, 1,         // ICIgnOption,XXXXspkout_hi_lo,
    46, 10, 9,       // max_coil_dur,max_spk_dur,DurAcc   msx10
    {60,80,100,120,140,160},   // deltaV_table[], Vx10 = batt_voltx10 - 120
    {250,  124, 84,64,51,44},   // deltaDur_table[], %age correction for batt_volt. 50 = 100%
// MS1/Extra uses these
//dwelltv: db     51T,68T,85T,102T,119T,136T    ; 6v,8v,10v,12v,14v,16v
//dwelltf: db     250T,124T,84T,64T,51T,44T
//Values in table are /4 (i.e. 250 = 250/256*4 = x 3.9)

    2,           // PredOpt      (For EDIS PredOpt=0 is sufficient)
    // For EDIS keep total adv (incl. offset & cold adv) < 60 deg
//    50,         // rpm at which cranking through //***** testing
    300,         // rpm at which cranking through
    {60,              // cold_adv_table[TEMP no = 0], deg x 10
        50,40,30,20,10,0,0,0,0},
    0,                // adv_offset,   deg x 10
    900, 500,       // TpsBypassCLTRevlim , RevLimRpm2
    {{{130,             // afr_table[inj1][MAP/tps no =0][RPM no = 0], afrx10
          135,160,160,160,149,143,132,131,132,131,130},
    {132,             // afr_table[inj1][MAP/tps no =1][RPM no = 0], afrx10
        137,157,157,155,149,142,132,130,129,128,127},
    {134,             // afr_table[inj1][MAP/tps no =2][RPM no = 0], afrx10
        139,155,155,154,149,141,130,129,128,127,127},
    {135,             // afr_table[inj1][MAP/tps no =3][RPM no = 0], afrx10
        140,152,152,150,147,140,130,129,128,127,126},
    {136,             // afr_table[inj1][MAP/tps no =4][RPM no = 0], afrx10
        141,150,149,147,147,140,129,128,127,126,126},
    {135,             // afr_table[inj1][MAP/tps no =5][RPM no = 0], afrx10
        138,145,143,141,141,135,128,127,126,126,126},
    {134,             // afr_table[inj1][MAP/tps no =6][RPM no = 0], afrx10
        134,139,137,136,136,131,127,126,126,126,126},
    {132,             // afr_table[inj1][MAP/tps no =7][RPM no = 0], afrx10
        132,135,133,133,132,130,126,125,125,125,125},
    {130,             // afr_table[inj1][MAP/tps no =8][RPM no = 0], afrx10
        130,131,130,130,129,130,125,125,125,125,125},
    {130,             // afr_table[inj1][MAP/tps no =9][RPM no = 0], afrx10
        129,129,128,128,127,126,125,125,125,125,124},
    {130,             // afr_table[inj1][MAP/tps no =10][RPM no = 0], afrx10
        129,129,128,128,127,126,125,125,125,123,123},
    {130,             // afr_table[inj1][MAP/tps no =11][RPM no = 0], afrx10
        129,129,128,128,127,126,125,125,122,122,122}},

    {{130,             // afr_table[inj2][MAP/tps no =0][RPM no = 0], afrx10
         135,160,160,160,149,143,132,131,132,131,130},
    {132,             // afr_table[inj2][MAP/tps no =1][RPM no = 0], afrx10
        137,157,157,155,149,142,132,130,129,128,127},
    {134,             // afr_table[inj2][MAP/tps no =2][RPM no = 0], afrx10
        139,155,155,154,149,141,130,129,128,127,127},
    {135,             // afr_table[inj2][MAP/tps no =3][RPM no = 0], afrx10
        140,152,152,150,147,140,130,129,128,127,126},
    {136,             // afr_table[inj2][MAP/tps no =4][RPM no = 0], afrx10
        141,150,149,147,147,140,129,128,127,126,126},
    {135,             // afr_table[inj2][MAP/tps no =5][RPM no = 0], afrx10
        138,145,143,141,141,135,128,127,126,126,126},
    {134,             // afr_table[inj2][MAP/tps no =6][RPM no = 0], afrx10
        134,139,137,136,136,131,127,126,126,126,126},
    {132,             // afr_table[inj2][MAP/tps no =7][RPM no = 0], afrx10
        132,135,133,133,132,130,126,125,125,125,125},
    {130,             // afr_table[inj2][MAP/tps no =8][RPM no = 0], afrx10
        130,131,130,130,129,130,125,125,125,125,125},
    {130,             // afr_table[inj2][MAP/tps no =9][RPM no = 0], afrx10
        129,129,128,128,127,126,125,125,125,125,124},
    {130,             // afr_table[inj2][MAP/tps no =10][RPM no = 0], afrx10
        129,129,128,128,127,126,125,125,125,123,123},
    {130,             // afr_table[inj2][MAP/tps no =11][RPM no = 0], afrx10
        129,129,128,128,127,126,125,125,122,122,122}}},

    {180,             // warmen_table[TEMP no = 0],   % enrichment vs temp
        180,160,150,135,125,113,108,102,100},
    {20,              // tpsen_table[TPS_DOT no = 0], enrichment in .1ms vs tpsdot
        50,105,150},
    {0,               // mapen_table[TPS_DOT no = 0], enrichment in .1ms vs mapdot
        0,0,0},
    {160,150,140,130,120,105,90,75,60,40}, //iacstep_table
    {{500,             // frpm_table1[RPM no = 0] , use in  AFR tables
         800,1100,1400,2000,2600,3100,3700,4300,4900,5400,6000},
    {500,             // frpm_table2[RPM no = 0] , use in AFR table
        800,1100,1400,2000,2600,3100,3700,4300,4900,5400,6000}},
    {{300,             // fmap_table[MAP/tps no = 0], kPa x 10 , use for AFR
         350,450,500,550,600,700,750,800,850,950,1000},
    {300,             // fmap_table2[MAP/tps no = 0], kPa x 10 , use for AFR
        350,450,500,550,600,700,750,800,850,950,1000}},
    {-400,            // temp_table[TEMP no = 0],  deg x 10
        -200,0,200,400,600,800,1000,1300,1600},
    {2100,              // tpsdot_table[TPS_DOT no =0],
        4000,8000,15400},   //    change in % x 10 per .1 sec
    {0,               // mapdot_table[TPS_DOT no =0],
        0,0,0},         //    change in kPa x 10 per .1 sec
    93,              // map0,         kPa x 10, value @ 0 ADC counts
    2609,            // mapmax,       kPa x 10, value @ max(1023) ADC counts
    0,               // clt0,         deg (C or F) x 10
    100,             // cltmult,      %
    0,               // mat0,         deg (C or F) x 10
    100,             // matmult,      %
    0,               // tps0,         adc counts
    1023,            // tpsmax,       adc counts
    1,               // batt0,        v x 10
    297,             // battmax,      v x 10
    0,               // ego0,         afr x 10
    100,             // egomult,      %
    93,              // baro0,        kPa x 10
    2609,            // baromax,      kPa x 10
    147, -47,        // bcor0,bcormult  kpax10, slope
    0,               // knock0,       v x 100
    500,             // knockmax,     v x 100
    20,              // Dtpred_Gain,  %
    50,70,25,        // PulseTol,     % tolerance for next input pulse timing during
    // cranking, after start/ warmup, normal running
    5,               // IdleCtl, idle: 0 = none, 1= solenoid, 2= iac stepper motor
    //  - enabled only when moving, 3 = iac motor - always enabled.
    // 4 = Ford PWM iac, 5 = 3 for 15 min, then = 2
    20,              // IACtstep,  .128 ms units (25 gives pulse freq of 400 Hz)
    40,               // IAC_tinitial_step
    1,               // IACminstep
    127,             // dwell duty%
    160,             // IACStart,  no. of steps to send at startup to put stepper
    //    motor at reference (wide open) position
    50,              // IdleHyst amount (degx10)
    100,5,           // > IAC opening (< steps) during cranking and few secs after
    0,120,40,        // when startup coolant temp < IACcoldtmp (degx10),
    // then when reach (>=) IACcoldpos switch to time based ctl: interpolate
    // bet IACcoldpos and final table IAC pos for period IACcoldxt secs.
    1000, // InjOpen
//    0, // BatFac //***** testing
    1200, // BatFac
    0, //OverBoostOption
    1000, //OverBoostKpa
    100, //OverBoostHyst
    0, //overboostcutx
    0, //overboostcuty
    0, //secondtrigopts
    2000,             // TpsThresh, tpsdot threshhold for accel enrichment(change in %x10 per .1 s)
    100,             // MapThresh, mapdot threshhold for accel enrichment(change in kPax10 per .1 s)
    30,              // Tpsacold,  cold (-40F) accel amount in .1 ms units
    130,             // AccMult,   cold (-40F) accel multiply factor (%)
    400,             // mapsample_angle
    2,               // TpsAsync,  clock duration (in .1 sec tics) for accel enrichment
    90,              // TPSDQ,  deceleration fuel cut option (%)
    700,             // TPSWOT, TPS value at WOT (for flood clear), %x10
    700,             // TPSOXLimit,  Max tps value (%x10) where O2 closed loop active
    100,             // Tps_acc_wght, weight to be given to tpsdot for accel enrichment.
    //  100 - Tps_acc_wght will then be given to mapdot.
    1,               // BaroOption,  0=no baro, 1=baro is 1st reading of map (before cranking),
    //   2=independent barometer
//    0,               // 0 = no ego;1= nb o2;2=2 nb o2;3=single wbo2;4=dual wbo2. //***** testing
    1,               // 0 = no ego;1= nb o2;2=2 nb o2;3=single wbo2;4=dual wbo2.
    16,              // EgoCountCmp,  Ign Pulse counts between when EGO corrections are made
    1,               // EgoStep,   % step change for EGO corrections
    15,              // EgoLimit,  Upper/Lower rail limit (egocorr inside 100 +/- limit)
    140,             // AFRTarget,  NBO2 afr (afrx10) determining rich/ lean
    0,               // Temp_Units,    0= coolant & mat in deg F; 1= deg C
    0,0,             // MAF options(future),cpad byte
    1400,            // FastIdle, fast idle temperature (degx10) (idle_ctl = 1 only)
    1600,            // EgoTemp,  min clt temp where ego active, degx10
    1300,            // RPMOXLimit,  Min rpm where O2 closed loop is active
//    5000,           // ReqFuel;  fuel pulsewidth (usec) at wide open throttle //***** testing
    15500,           // ReqFuel;  fuel pulsewidth (usec) at wide open throttle
    2,               // Divider,   divide factor for input tach pulses  
//    0,               // Simultaneaous,   option to alternate injector banks //***** testing
    1,               // Alternate,   option to alternate injector banks
    10,              //
    200,             // InjPWMTim,   Time (.128 ms units) after opening to start pwm
    66,              // InjPWMPd,    Injector PWM period (us)
    75,              // InjPWMDty,   Injector PWM duty cycle (%)
    12,
    0,               // EngStroke,  0 = 4 stroke,  1 = 2 stroke
    0,               // InjType,  0 = port injection,  1 = throttle body
    4,               // NoInj,    no. of injectors (1-12)       
    900,               // OddFire smaller angle between firings
    50,50,50,        // Lag filter coefficients (1-100%) for Rpm,Map,Tps,
    60,              // ego1,2
    50,80,           // Lag filter coefficients for other adc(clt,mat,batt), knock.
    0,               // AMC option
    0,               // dual table option
    1,               // fuel alpha-N, map blend option
    1,               // ign alpha-N, map blend option
    1,               // WBO2 AFR alpha-N, map blend option
    10,              // dwell time in 0.1ms
    500,              // trigger to return angle
    1,           // RevLimOption:0,none; 1,retard spk; 2,fuel cut + more (see ini)
    120,         // RevLimMaxRtd,   deg x 10
    8,66,50,1000,1200,0,  // injector channel 2 parameters
    1050,800,1000, // baro upper, lower, default
    6000, //RevLimTPSbypassRPM
    5500, //RevLimNormal1
    6000, //RevLimNormal2
    625, //TC5_required_width
    150, //EgoLimit
    147, //stoich
        0, //enable_poll bit 0: enable ADC; bit 1: enable PWM; bit 2: enable digital I/O ports
        {7,7,7}, //poll_tables[3] Remote table numbers for ADC, PWM and ports data defaults to I/O Extender tables
        {2,58,75}, //poll_offset[3] Offset in the table (ADC, PWM, ports). Defaults to I/O Extender offsets
        0, //ports_dir Direction of the 3 remote ports: 0=input, 1=output
        0, // Select which port will be used as generic spare port: 0: use MS ports; 1,2,3: Remote ports
        350,
                24, // remotePWMfreq: Remote PWM clock frequency  (in MHz)
                128, // remotePWMprescale: Remote PWM clock prescale
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,0,0,
     0,0,0,0},
     0,
     0x5, //loadopts, default to old behavior
    115200,                   // baud rate
    900,          // MAPOXLimit, Max MAP value (kPax10) where O2 closed loop active
    1,0,            // board_type, mycan_id
    0,0,0,0,      // adjustments to timing and such. Won't work.
    10,
    0,5,    // can_poll=off, can_poll_id defaults to 5 and master
        200,          // MAPOXMin , Min MAP value (kpa*10)  where 02 closed loop active  --- KG was spare took one 0 away below (753)
    {0},    // spares
    {0,0,0,0,0,0,0}, // spr_port
    {'<','<','<','<','<','<','<'}, // condition1
    {'<','<','<','<','<','<','<'}, // condition2
    {' ',' ',' ',' ',' ',' ',' '}, // cond12
    {0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0},{0,0,0,0,0,0,0},{0,0,0,0,0,0,0},  {0,0,0,0,0,0,0},{0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0},{0,0,0,0,0,0,0},{0,0,0,0,0,0,0},{0,0,0,0,0,0,0},  // spr pin params
    1,0,          // accel tail duration (sec x 10), cpad byte
    20,           // accel end pwidth enrichment (ms x 10)
    0,            // EgoAlg, 0=simple algorithm; 1=Prop err alg;2=PID w. Smith pred
    100,20,0,      // KP,KI,KD, PID coefficients in %
    10,4000,      // egoKdly1,2 = coefficients used to calculate ego transport
    //   delay (ms) = Kdly1 + Kdly2*120000 / (map(kPax10)*rpm).
    //   Defaults based on xpt delay of .1 s at wot, 1 s at idle
    0,          // Flex fuel option - modifies pw and spk adv based on freq signal
    //  for % alcohol
    {50, 150},          // Table of fuel sensor freq(Hz) vs
    {100,163},    // fuel pw corr in %; 1st element is pure gas, 2nd is pure Alcohol.
    0, // dwell mode   "std dwell", "fixed duty", "time after spk", "chg at trigger"
    10,      // AMCStep, % of AMC correction to be applied when ramve updated.
    10,      // AMCdve,  % AMCcorrection must be > AMCdve to be applied for burn
    200,100,   // AMCve_drpm,AMCve_dmap,  current rpm, map(kPax10) must be within
    // this tolerance of a ve table vertex for
    20,        // AMCramve_dt secs before AMC correction is applied
    300,      // AMCT_thresh, min time (secs) between flash burns of ram ve table
    2,         // AMCupdate_thresh, min number of AMC ram ve updates before burn table.
    0,         // CWOption, cold warmup option - 0 = linear, 1 = custom table.
    0x00,    // knk_option: Bits 0-3: 0=no knock detection;1=operate at table value or 1
    // step below knock; 2=operate at table value or edge of knock.
    // Bits 4-7: 0/1 = knock signal < / > knk_thresh indicates knock occurred.
    100,     // knk_maxrtd, max total retard when knock, (degx10).
    30,10,   // knk_step1, _step2, ign retard/ adv steps when 1st knock or after stopped,
    // (degx10); step1 large to quickly retard/ stop knock
    2,20,    // knk_trtd,_tadv, time between knock retard, adv corrections, (secx10);
    // allows short time step to quickly retard, longer to try advancing.
    30,      // knk_dtble_adv, change in table advance required to restart adv til knock
    // or reach table value (0 knock retard) process, deg x10.
    // This only applies with knk_option = 1.
    2,     // knk_ndet, number of knock detects required for valid detection; pad byte.
    0,     //Xtau option
    700,     // knk_maxmap, no knock retard above this map (kPax10).
    700,3500,  // knk_lorpm,knk_hirpm,  no knock retard below, above these rpms.
    {500,       // knk_rpm[0-NO_KNKRPMS], tables of rpm vs knock threshhold.
        1000,
        2000,
        3000,
        4000,
        5000},
    {200,       //knk_thresh[NO_KNKRPMS], Vx100
        200,
        200,
        200,
        200,
        200},
    36,         // No_Teeth, nominal (include missing) teeth for wheel decoding. (0=
    // no wheel decoding).
    1,         // No_Miss_Teeth, number of consecutive missing teeth.
    0,         // Angle of missing tooth BTDC
    01,         // (0.1ms) ICISR_tmask, time (msx10) after tach input capture during which further
    // interrupts are inhibited to mask coil ring or VR noise.
    10,        // ICISR_pmask, % of dtpred after tach input capture during which further
    // interrupts are inhibited to mask coil ring or VR noise.
    0,         // spare
    2500, 5000, // ae_lorpm,ae_hirpm, lorpm is rpm at which normal accel enrichment just
    // starts to scale down, and is reduced to 0 at ae_hirpm. To omit scaling, set
    //  _lorpm = _hirpm= very large number.
    {0,-130},  // flex fuel spk corr (degx10); 1st element for pure gas, 2nd for pure
    // Alcohol; last is normally - to retard spk since Alch burns faster.
    02,20,    // cam input mask time and %age settings
    0,  // noise filter options
    0,     // spare
    0,
    0,         // spk_conf2
#ifdef MICROSQUIRT
    0x14,      // spk_config use JS10 for spark A, crank wheel
#else
    0x15,      // spk_config use D14 for spark A, crank wheel
#endif
    4,         // spk_mode, "toothed wheel" and single coil
    255,      // userlevel - alpha code so assume Advanced user
    6,      // rtbaroport
    6,      // ego2port
    0,      // egoport: 0 means local port; > 0 means remote CAN port
    1,      // flex port (default is PE0)

    4,5,    // spark cut 4 of 5
    0,      // use simple false trig as should be working now
    {60, 54, 49, 44, 38, 32, 27, 21, 13, 5},  // pwm idle table
    2,90,100,100   // timing_flags, crank_dwell, crank_timing, fixed_timing
};

const page5_data flash5 EEPROM_ATTR = {
    {1500,1400,1300,1200,1100,1000,900,800}, // pwmidle_target_rpms
    {700,800,900,1000,1100,1200,1300,1400}, // pwmidle_clt_temps
    200, // pwmidle_ms
    3,  // pwmidle_close_delay
    60, // pwmidle_open_duty
    15, // pwmidle_closed_duty
    5, // pwmidle_pid_wait_timer
    20, // pwmidle_min_duty
    300, // pwmidle_engage_rpm_adder
    20, // pwmidle_tps_thresh
    3, // pwmidle_dp_adder
    50, // pwmidle_rpmdot_threshold
    250, // pwmidle_decelload_threshold
    1000, // pwmidle_Kp
    50, // pwmidle_Ki
    0, // pwmidle_Kd
    2,
    500,
    1600,
    2,
    100,
        0,  // Local port
    {0,0,0,0},
    1, 8, // boost_ctl_settings
    0, 0, 0, 0, 0, 10, // boost_ctl_Kp,Ki,Kd,boost_ctl_closeduty, boost_ctl_openduty,boost_ctl_ms
    {{0,0,0,0,0,0,0,0}, // boost_ctl_load_targets
     {0,0,0,0,0,0,0,0},
     {0,0,0,0,0,0,0,0},
     {0,0,0,0,0,0,0,0},
     {0,0,0,0,0,0,0,0},
     {0,0,0,0,0,0,0,0},
     {0,0,0,0,0,0,0,0},
     {0,0,0,0,0,0,0,0}},
    {0,0,0,0,0,0,0,0}, //boost_ctl_loadtarg_tps_bins
    {0,0,0,0,0,0,0,0}, //boost_ctl_loadtarg_rpm_bins
    {{0,0,0,0,0,0,0,0}, //boost_ctl_pwm_targets
     {0,0,0,0,0,0,0,0},
     {0,0,0,0,0,0,0,0},
     {0,0,0,0,0,0,0,0},
     {0,0,0,0,0,0,0,0},
     {0,0,0,0,0,0,0,0},
     {0,0,0,0,0,0,0,0},
     {0,0,0,0,0,0,0,0}},
    {0,0,0,0,0,0,0,0}, //boost_ctl_pwmtarg_tps_bins
    {0,0,0,0,0,0,0,0}, //boost_ctl_pwmtarg_rpm_bins
    {153,140,127,102}, //pwmidle_crank_dutyorsteps
    {300,1000,1300,1750}, //pwmidle_crank_clt_temps
    {{900,900,900,900,900,900},  // inj_adv_table3[0][0-5]      
     {900,900,900,900,900,900},  // inj_adv_table3[1][0-5]      
     {900,900,900,900,900,900},  // inj_adv_table3[2][0-5]      
     {900,900,900,900,900,900},  // inj_adv_table3[3][0-5]      
     {900,900,900,900,900,900},  // inj_adv_table3[4][0-5]      
     {900,900,900,900,900,900}}, // inj_adv_table3[5][0-5]      
        {800,2000,4000,5000,6000,7000},  //srpm_inj_adv3[0-5]; injection advance rpm tables     
        {300,500,700,800,900,1000},  // smap_inj_adv3[0-5]; kpa x 10,   
    { 60, 56, 52, 48, 44, 40, 36, 32, 26, 20},   // CWPrime, (msx10)
    {325, 300, 275, 250, 225, 200, 175, 150, 125, 100},   // CrankPctTable,   (%age)
    { 45, 43, 41, 39, 37, 35, 33, 31, 28, 25},   // CWAWEV,  %
    {350,330,310,290,270,250,230,210,180,150},   // CWAWC,   cycles
    {1600,1800,2000,2200,2400,2600},        // MatTemps, degx10 F or C
    {0,0,20,40,60,80},                      // MatSpkRtd, degx10 matretard
    {800,1000,1500,2000,2500,3000,3500,4000,4500,5000,5500,6000}, // AWCRPM
    {800,1000,1500,2000,2500,3000,3500,4000,4500,5000,5500,6000}, // SOCRPM
    {300,350,400,450,500,550,600,650,700,800,900,1000}, //AWCKPA
    {300,350,400,450,500,550,600,650,700,800,900,1000}, //SOCKPA
    {22,28,30,32,38,40,42,48,50,52,58,60}, //BAWC in 1% units
    {22,28,30,32,38,40,42,48,50,52,58,60}, //BSOC in 0.1% units
    {100,95,90,85,80,75,70,65,60,55,50,45}, //AWN
    {45,50,55,60,65,70,75,80,85,90,95,100}, //SWN
    {100,100,100,100,100,100,100,100,100,100,100,100},
    {100,100,100,100,100,100,100,100,100,100,100,100},
    {    // BaroVals[NO_BARS]: barometric pressures, (kPa x 10)) for baro correction table
        800, 900, 1000, 1050, 1100, 1200 },
    {    // MatVals[NO_MATS]: air temperatures (degx10) for air density correction table
        400, 600, 1000, 1300, 1600, 1800 },
    {    // BaroCorDel[NO_BARS], barometric correction table(%) - added to eq. value
        0, 0, 0, 0, 0, 0 },
    {    // AirCorDel[NO_MATS], air density correction table(%) - added to eq. value
        0, 0, 0, 0, 0, 0 },
            /* temp_table_p5 */
    {100,300,500,700,900,1100,1300,1500,1700,1800},
    6000,1000,800, // fuel table switch rpm, load, tps
    6001,1001,801, // spark table switch rpm, load, tps

    {0,200,400,600,800,1000,1200,1300,1400,1600,1700,1800},  // for EAE
    {0,200,400,600,800,1000,1200,1300,1400,1600,1700,1800},  // for EAE
    100, // airdensity scaling

    0,  // ts_remote: Bit 0: Remote fuel table switching; Bit 1-3: Port3 Bit selection; Bit 4: Remote spark table switching; Bit 5-7: Port3 Bit selection
    0,  // feature5_0 defaults to zero
    0,    // spare
    65, 5,    // cranking %, taper time
    0,        // pwm idle settings byte
    1500,     // fc >rpm
    400,      // fc <kpa
    50,       // fc <tps
    900,      // fc >clt
    15,       // fc >time
    0,        // no tacho out
    0,
    50,
    3000,
    0,
    1100,   // fc <rpm for recovery
    1500,
    3,
    {0,0,0,0,0,0,0,0,0,0},  // spare
    {0,0,0,0,0,0,0,0}, // spr_port
    {'<','<','<','<','<','<','<','<'}, // condition1
    {'<','<','<','<','<','<','<','<'}, // condition2
    {' ',' ',' ',' ',' ',' ',' ',' '}, // cond12
    {0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},  {0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0}  // spr pin params
};


const page10_data flash10 EEPROM_ATTR = {

    //spark table 1
    {{{157,             // adv_table[MAP/tps no=0][RPM no=0], deg x 10
          175,200,286,328,375,370,375,380,380,380,380},
    {157,             // adv_table[MAP/tps no=1][RPM no=0], deg x 10
        178,201,282,324,370,370,370,375,380,380,380},
    {156,             // adv_table[MAP/tps no=2][RPM no=0], deg x 10
        180,202,278,324,368,370,375,375,380,380,380},
    {155,             // adv_table[MAP/tps no=3][RPM no=0], deg x 10
        182,204,274,323,364,370,370,375,375,380,380},
    {155,             // adv_table[MAP/tps no=4][RPM no=0], deg x 10
        184,206,272,322,360,368,374,374,376,376,380},
    {157,             // adv_table[MAP/tps no=5][RPM no=0], deg x 10
        186,207,268,321,360,366,372,375,375,375,375},
    {158,             // adv_table[MAP/tps no=6][RPM no=0], deg x 10
        188,208,258,320,360,365,365,365,370,370,370},
    {160,             // adv_table[MAP/tps no=7][RPM no=0], deg x 10
        185,205,250,317,358,360,362,362,362,362,362},
    {160,             // adv_table[MAP/tps no=8][RPM no=0], deg x 10
        183,203,241,308,353,360,360,360,360,360,360},
    {155,             // adv_table[MAP/tps no=9][RPM no=0], deg x 10
        175,200,235,299,348,360,360,360,360,360,360},
    {151,             // adv_table[MAP/tps no=10][RPM no=0], deg x 10
        172,195,228,295,343,360,360,360,360,360,360},
    {148,             // adv_table[MAP/tps no=11][RPM no=0], deg x 10
        168,190,216,282,335,360,360,360,360,360,360}},

    //spark table 2 - always additive so needs to be zero
    {{0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0}}},

    {{701,             // srpm_table1[RPM no = 0] , use in spark advance table
         900,1200,1500,2000,2600,3100,3700,4300,4900,5400,6000},
    {702,             // srpm_table2[RPM no = 0] , use in spark advance table
        900,1200,1500,2000,2600,3100,3700,4300,4900,5400,6000}},

    {{201,             // smap_table1[MAP/tps no = 0], kPa x 10 , use for spk adv
         250,300,350,400,450,500,600,700,800,900,1000},
    {202,             // smap_table2[MAP/tps no = 0], kPa x 10 , use for spk adv
        250,300,350,400,450,500,600,700,800,900,1000}},
     0, //spare
     0,3900,10,4000,100,1,5,7,  // launch
     3000,4700,50,4800,         //flat shift
     0,0,0,0,0,0,0,0,           // staging
     1,3000,6000,800,1500,100,6000,3000,0,0,0, // nitrous
     5000,6000,10,50,3000,1500,

/* user defined initial configuration data */
    0, 0, 0,
/* end user defined */
    0, //staged_secondary_enrichment
  {{0, 0,  0, 0, 0, 0},
   {0, 5,  5,10,20,30},
   {0, 5, 10,20,30,40},
   {0,10, 20,30,40,50},
   {0,20,30,40,50, 60},
   {0,30,50,70,90,100}},
   {3000,4000,5000,5500,6000,7000},
   {500,600,700,800,900,1000},
        0, // Bit 0: remote input; Bit 1: remote outputs; Bits 2-4: remote input bit number on Port 3; Bits 5-7: remote ouputs bit number on Port 1 
   {0,0,0},
   {{0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0}},
   {300,400,500,600,700,800,900,1000},
   {800,1200,2000,3000,4000,5000,6000,7000},
   0,
   {500, 2500, 5500, 7500}, // NoiseFilterRpm
   {300,60,27,20}, // NoiseFilterLen - default values based on 15% of a 60-2 tooth
   0, // moved
   0, // staged_primary_delay

   {  3,10,20,50 }, //VariableLagTPSBins
   {  50,50,50,50 }, //VariableLagMapLags

/*    {  0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,
       0,0,0,0,0,0} normal 30 */
       { 0, 0,0,0,0, 0,0,0,0 }, // spare
       1, // tooth_init for injector sequencing
       0,
    {  0,0,0,0,0,0,0,  // the crap now 21
       0,0,0,0,0,0,0,0,
       0,0,0,0}
};

const page8_data flash8 EEPROM_ATTR = {
    // 1024 bytes = 1 block flash

     0,  // test mode zero
     0,  // no coils, no injectors
     30,1562, // 3.0ms 200ms interval
     0, // mode 0
     0, // zero pw
     0, // zero count

    //spark table 3
    {{157,             // adv_table[MAP/tps no=0][RPM no=0], deg x 10
          175,200,286,328,375,370,375,380,380,380,380},
    {157,             // adv_table[MAP/tps no=1][RPM no=0], deg x 10
        178,201,282,324,370,370,370,375,380,380,380},
    {156,             // adv_table[MAP/tps no=2][RPM no=0], deg x 10
        180,202,278,324,368,370,375,375,380,380,380},
    {155,             // adv_table[MAP/tps no=3][RPM no=0], deg x 10
        182,204,274,323,364,370,370,375,375,380,380},
    {155,             // adv_table[MAP/tps no=4][RPM no=0], deg x 10
        184,206,272,322,360,368,374,374,376,376,380},
    {157,             // adv_table[MAP/tps no=5][RPM no=0], deg x 10
        186,207,268,321,360,366,372,375,375,375,375},
    {158,             // adv_table[MAP/tps no=6][RPM no=0], deg x 10
        188,208,258,320,360,365,365,365,370,370,370},
    {160,             // adv_table[MAP/tps no=7][RPM no=0], deg x 10
        185,205,250,317,358,360,362,362,362,362,362},
    {160,             // adv_table[MAP/tps no=8][RPM no=0], deg x 10
        183,203,241,308,353,360,360,360,360,360,360},
    {155,             // adv_table[MAP/tps no=9][RPM no=0], deg x 10
        175,200,235,299,348,360,360,360,360,360,360},
    {151,             // adv_table[MAP/tps no=10][RPM no=0], deg x 10
        172,195,228,295,343,360,360,360,360,360,360},
    {148,             // adv_table[MAP/tps no=11][RPM no=0], deg x 10
        168,190,216,282,335,360,360,360,360,360,360}},

    {701,             // srpm_table3[RPM no = 0] , use in spark advance table
         900,1200,1500,2000,2600,3100,3700,4300,4900,5400,6000},
    {201,             // smap_table3[MAP/tps no = 0], kPa x 10 , use for spk adv
         250,300,350,400,450,500,600,700,800,900,1000},
         8,66,30,

       {320,680,1000,1200,1400,1600,1800,2000},                     // RevLimLookup
       {2500,3000,4000,4500,5000,5500,6000,6000},      // RevLimRpm1
       150, 160, 0, // idle valve test settings
       0, // idle_special_ops
       20, // idleadvance_tps
       1000, // idleadvance_rpm
       400, // idleadvance_load
       1400, // idleadvance_clt
       2, // idleadvance_delay
       {150,150,150,150}, // idleadvance_curve
       {300,320,340,380}, // idleadvance_loads
        0, // feature413

           0, // crapalign      
        // Siamese and sequential injection     
           0, // seq_inj;          Bit 0: 1 = Sequential        
                                                // Bit 1: 1 = Siamese   
                                                // Bit 2: 1 = Extra injector drivers    
                                                // Bit 3: 0 = Single timing value; 1 = Dual timing values       
                                                // Bit 5: 0 = Fixed timing; 1 = Use table       
                                                // Bit 6,7: 0 = Start-of-pulse; 1 = Mid-pulse; 2 = End-of-pulse 
       {900,2700,900,900,2700,900},   // inj_adv_fixed[6]; Fixed injection advance: advance 1, advance 2, advance 3, staged advance 1, staged advance 2, staged advance 3       
       {{{900,900,900,900,900,900},  // inj_adv_table[0][0][0-5]        
         {900,900,900,900,900,900},  // inj_adv_table[0][1][0-5]        
         {900,900,900,900,900,900},  // inj_adv_table[0][2][0-5]        
         {900,900,900,900,900,900},  // inj_adv_table[0][3][0-5]        
         {900,900,900,900,900,900},  // inj_adv_table[0][4][0-5]        
         {900,900,900,900,900,900}}, // inj_adv_table[0][5][0-5]        
        {{2700,2700,2700,2700,2700,2700},  // inj_adv_table[1][0][0-5]  
         {2700,2700,2700,2700,2700,2700},  // inj_adv_table[1][1][0-5]  
         {2700,2700,2700,2700,2700,2700},  // inj_adv_table[1][2][0-5]  
         {2700,2700,2700,2700,2700,2700},  // inj_adv_table[1][3][0-5]  
         {2700,2700,2700,2700,2700,2700},  // inj_adv_table[1][4][0-5]  
         {2700,2700,2700,2700,2700,2700}}},// inj_adv_table[1][5][0-5]  
         {{800,2000,4000,5000,6000,7000},  //srpm_inj_adv[0][0-5]; injection advance rpm tables 
          {800,2000,4000,5000,6000,7000}}, //srpm_inj_adv[1][0-5]; injection advance rpm tables 
         {{300,500,700,800,900,1000},  // smap_inj_adv[0][0-5]; kpa x 10,       
          {300,500,700,800,900,1000}}, // smap_inj_adv[1][0-5]; kpa x 10,       
       {900,2700},   // inj_adv_crank[2]; Injection advance for cranking 1, 2
                15000, // hybrid_rpm
                100, // hybrid_hyst
                1000, // InjOpen3
//              0, // BatFac3 //***** testing
        1200, // BatFac3
                1000, // InjOpen4
//              0, // BatFac4 //***** testing
        1200, // BatFac4

   // ** VE TRIM 1 ** //
                {{{0,            // ve_trim1[MAP/tps no =0][RPM no = 0]
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,              // ve_trim1[MAP/tps no =1][RPM no = 0]
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,              // ve_trim1[MAP/tps no =2][RPM no = 0]
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,              // ve_trim1[MAP/tps no =3][RPM no = 0]
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,              // ve_trim1[MAP/tps no =4][RPM no = 0]
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,              // ve_trim1[MAP/tps no =5][RPM no = 0]
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,              // ve_trim1[MAP/tps no =6][RPM no = 0]
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,              // ve_trim1[MAP/tps no =7][RPM no = 0]
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,              // ve_trim1[MAP/tps no =8][RPM no = 0]
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,              // ve_trim1[MAP/tps no =9][RPM no = 0]
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,              // ve_trim1[MAP/tps no =10][RPM no = 0]
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,              // ve_trim1[MAP/tps no =11][RPM no = 0]
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,              // ve_trim1[MAP/tps no =12][RPM no = 0]
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,              // ve_trim1[MAP/tps no =13][RPM no = 0]
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,              // ve_trim1[MAP/tps no =14][RPM no = 0]
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,              // ve_trim1[MAP/tps no =15][RPM no = 0]
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}}},

                {{501,             // frpm_tablev1[RPM no = 0] , use in VE   tables
                        801,1101,1401,2001,2601,3101,3700,4300,4900,5400,6000,6500,7000,7200,7500}},
                {{301,             // fmap_tablev1[MAP/tps no = 0], kPa x 10 , use for VE
        350,400,450,500,550,600,650,700,750,800,850,900,950,980,1000}},

       {0,0,0,0,0,0,0,0,0,0,0,0 //0 12
       },  // 10 in total       
       {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, //0 16
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, //1 16
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, //2 16
        0,0,0,0,0,0,0,0 //4 8
          // 56 in total for TS sensor data     
    }};

const page9_data flash9 EEPROM_ATTR = {
{{{{26,            // ve_table[inj1][MAP/tps no =0][RPM no = 0]
        26,29,34,40,46,50,55,58,61,61,60,59,59,58,58},
    {29,              // ve_table[inj1][MAP/tps no =1][RPM no = 0]
        29,32,38,46,53,56,60,63,66,65,62,60,58,58,57},
    {38,              // ve_table[inj1][MAP/tps no =2][RPM no = 0]
        37,39,44,53,61,65,67,69,73,71,66,64,62,60,58},
    {43,              // ve_table[inj1][MAP/tps no =3][RPM no = 0]
        42,43,45,54,63,66,69,71,75,73,67,65,63,61,59},
    {48,              // ve_table[inj1][MAP/tps no =4][RPM no = 0]
        46,48,50,58,65,69,71,73,77,75,69,67,65,63,61},
    {52,              // ve_table[inj1][MAP/tps no =5][RPM no = 0]
        51,52,55,62,67,71,73,75,79,77,71,69,67,65,63},
    {57,              // ve_table[inj1][MAP/tps no =6][RPM no = 0]
        59,61,65,69,72,76,78,81,85,85,80,78,76,74,72},
    {61,              // ve_table[inj1][MAP/tps no =7][RPM no = 0]
        62,65,69,72,75,79,82,85,89,88,84,82,80,78,76},
    {65,              // ve_table[inj1][MAP/tps no =8][RPM no = 0]
        66,69,73,76,78,82,86,90,93,92,88,86,84,82,80},
    {68,              // ve_table[inj1][MAP/tps no =9][RPM no = 0]
        70,73,78,81,83,86,90,94,98,97,93,91,89,87,85},
    {72,              // ve_table[inj1][MAP/tps no =10][RPM no = 0]
        77,82,87,90,93,95,100,105,109,108,103,101,99,97,95},
    {74,              // ve_table[inj1][MAP/tps no =11][RPM no = 0]
        81,86,91,95,97,100,105,111,114,113,108,106,104,102,100},
    {74,              // ve_table[inj1][MAP/tps no =11][RPM no = 0]
        82,87,92,96,98,101,106,112,115,114,109,107,105,103,101},
    {75,              // ve_table[inj1][MAP/tps no =11][RPM no = 0]
        83,88,93,97,99,102,107,113,116,115,110,108,106,104,102},
    {76,              // ve_table[inj1][MAP/tps no =11][RPM no = 0]
        84,89,94,98,100,103,108,114,117,116,111,109,107,105,103},
    {78,              // ve_table[inj1][MAP/tps no =11][RPM no = 0]
        85,90,95,99,101,104,109,115,118,117,112,110,108,106,104}},

    // ** VE TABLE 2 ** //
    {{26,            // ve_table[inj1][MAP/tps no =0][RPM no = 0]
        26,29,34,40,46,50,55,58,61,61,60,59,59,58,58},
    {29,              // ve_table[inj1][MAP/tps no =1][RPM no = 0]
        29,32,38,46,53,56,60,63,66,65,62,60,58,58,57},
    {38,              // ve_table[inj1][MAP/tps no =2][RPM no = 0]
        37,39,44,53,61,65,67,69,73,71,66,64,62,60,58},
    {43,              // ve_table[inj1][MAP/tps no =3][RPM no = 0]
        42,43,45,54,63,66,69,71,75,73,67,65,63,61,59},
    {48,              // ve_table[inj1][MAP/tps no =4][RPM no = 0]
        46,48,50,58,65,69,71,73,77,75,69,67,65,63,61},
    {52,              // ve_table[inj1][MAP/tps no =5][RPM no = 0]
        51,52,55,62,67,71,73,75,79,77,71,69,67,65,63},
    {57,              // ve_table[inj1][MAP/tps no =6][RPM no = 0]
        59,61,65,69,72,76,78,81,85,85,80,78,76,74,72},
    {61,              // ve_table[inj1][MAP/tps no =7][RPM no = 0]
        62,65,69,72,75,79,82,85,89,88,84,82,80,78,76},
    {65,              // ve_table[inj1][MAP/tps no =8][RPM no = 0]
        66,69,73,76,78,82,86,90,93,92,88,86,84,82,80},
    {68,              // ve_table[inj1][MAP/tps no =9][RPM no = 0]
        70,73,78,81,83,86,90,94,98,97,93,91,89,87,85},
    {72,              // ve_table[inj1][MAP/tps no =10][RPM no = 0]
        77,82,87,90,93,95,100,105,109,108,103,101,99,97,95},
    {74,              // ve_table[inj1][MAP/tps no =11][RPM no = 0]
        81,86,91,95,97,100,105,111,114,113,108,106,104,102,100},
    {74,              // ve_table[inj1][MAP/tps no =11][RPM no = 0]
        82,87,92,96,98,101,106,112,115,114,109,107,105,103,101},
    {75,              // ve_table[inj1][MAP/tps no =11][RPM no = 0]
        83,88,93,97,99,102,107,113,116,115,110,108,106,104,102},
    {76,              // ve_table[inj1][MAP/tps no =11][RPM no = 0]
        84,89,94,98,100,103,108,114,117,116,111,109,107,105,103},
    {78,              // ve_table[inj1][MAP/tps no =11][RPM no = 0]
        85,90,95,99,101,104,109,115,118,117,112,110,108,106,104}},


   // ** VE TABLE 3 ** //
   {{26,            // ve_table[inj1][MAP/tps no =0][RPM no = 0]
        26,29,34,40,46,50,55,58,61,61,60,59,59,58,58},
    {29,              // ve_table[inj1][MAP/tps no =1][RPM no = 0]
        29,32,38,46,53,56,60,63,66,65,62,60,58,58,57},
    {38,              // ve_table[inj1][MAP/tps no =2][RPM no = 0]
        37,39,44,53,61,65,67,69,73,71,66,64,62,60,58},
    {43,              // ve_table[inj1][MAP/tps no =3][RPM no = 0]
        42,43,45,54,63,66,69,71,75,73,67,65,63,61,59},
    {48,              // ve_table[inj1][MAP/tps no =4][RPM no = 0]
        46,48,50,58,65,69,71,73,77,75,69,67,65,63,61},
    {52,              // ve_table[inj1][MAP/tps no =5][RPM no = 0]
        51,52,55,62,67,71,73,75,79,77,71,69,67,65,63},
    {57,              // ve_table[inj1][MAP/tps no =6][RPM no = 0]
        59,61,65,69,72,76,78,81,85,85,80,78,76,74,72},
    {61,              // ve_table[inj1][MAP/tps no =7][RPM no = 0]
        62,65,69,72,75,79,82,85,89,88,84,82,80,78,76},
    {65,              // ve_table[inj1][MAP/tps no =8][RPM no = 0]
        66,69,73,76,78,82,86,90,93,92,88,86,84,82,80},
    {68,              // ve_table[inj1][MAP/tps no =9][RPM no = 0]
        70,73,78,81,83,86,90,94,98,97,93,91,89,87,85},
    {72,              // ve_table[inj1][MAP/tps no =10][RPM no = 0]
        77,82,87,90,93,95,100,105,109,108,103,101,99,97,95},
    {74,              // ve_table[inj1][MAP/tps no =11][RPM no = 0]
        81,86,91,95,97,100,105,111,114,113,108,106,104,102,100},
    {74,              // ve_table[inj1][MAP/tps no =11][RPM no = 0]
        82,87,92,96,98,101,106,112,115,114,109,107,105,103,101},
    {75,              // ve_table[inj1][MAP/tps no =11][RPM no = 0]
        83,88,93,97,99,102,107,113,116,115,110,108,106,104,102},
    {76,              // ve_table[inj1][MAP/tps no =11][RPM no = 0]
        84,89,94,98,100,103,108,114,117,116,111,109,107,105,103},
    {78,              // ve_table[inj1][MAP/tps no =11][RPM no = 0]
        85,90,95,99,101,104,109,115,118,117,112,110,108,106,104}}}},


    {{{501,             // frpm_tablev1[RPM no = 0] , use in VE   tables
         801,1101,1401,2001,2601,3101,3700,4300,4900,5400,6000,6500,7000,7200,7500},
    {502,             // frpm_tablev2[RPM no = 0] , use in spark advance table
        801,1101,1401,2001,2601,3101,3700,4300,4900,5400,6000,6500,7000,7200,7500},
    {502,             // frpm_tablev3[RPM no = 0] , use in spark advance table
        801,1101,1401,2001,2601,3101,3700,4300,4900,5400,6000,6500,7000,7200,7500}}},
    {{{301,             // fmap_tablev1[MAP/tps no = 0], kPa x 10 , use for VE
         350,400,450,500,550,600,650,700,750,800,850,900,950,980,1000},
    {302,             // fmap_tablev2[MAP/tps no = 0], kPa x 10 , use for VE2
        350,400,450,500,550,600,650,700,750,800,850,900,950,980,1000},
    {302,             // fmap_tablev3[MAP/tps no = 0], kPa x 10 , use for VE2
        350,400,450,500,550,600,650,700,750,800,850,900,950,980,1000}}},
     {    // MAFFlow[NO_MAFS], MAF flows (mg/ secx10) for below corrections.
  100, 2000, 4000, 6000, 8000, 10000, 12000, 14000, 16000, 18000, 20000, 25000 }, 
    {    // MAFCor[NO_MAFS], Corrections to maf factor table (%) for real time tuning/ 
  100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100 },
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,0,0}
};

const page11_data flash11 EEPROM_ATTR = {
   // ** VE TRIM 2 ** //
{{{{0,            // ve_trim[inj2][MAP/tps no =0][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj2][MAP/tps no =1][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj2][MAP/tps no =2][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj2][MAP/tps no =3][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj2][MAP/tps no =4][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj2][MAP/tps no =5][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj2][MAP/tps no =6][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj2][MAP/tps no =7][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj2][MAP/tps no =8][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj2][MAP/tps no =9][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj2][MAP/tps no =10][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj2][MAP/tps no =11][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj2][MAP/tps no =12][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj2][MAP/tps no =13][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj2][MAP/tps no =14][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj2][MAP/tps no =15][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},

    // ** VE TRIM 3 ** //
    {{0,            // ve_trim[inj3][MAP/tps no =0][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj3][MAP/tps no =1][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj3][MAP/tps no =2][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj3][MAP/tps no =3][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj3][MAP/tps no =4][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj3][MAP/tps no =5][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj3][MAP/tps no =6][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj3][MAP/tps no =7][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj3][MAP/tps no =8][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj3][MAP/tps no =9][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj3][MAP/tps no =10][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj3][MAP/tps no =11][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj3][MAP/tps no =12][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj3][MAP/tps no =13][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj3][MAP/tps no =14][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj3][MAP/tps no =15][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},


   // ** VE TRIM 4 ** //
   {{0,            // ve_trim[inj4][MAP/tps no =0][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj4][MAP/tps no =1][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj4][MAP/tps no =2][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj4][MAP/tps no =3][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj4][MAP/tps no =4][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj4][MAP/tps no =5][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj4][MAP/tps no =6][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj4][MAP/tps no =7][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj4][MAP/tps no =8][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj4][MAP/tps no =9][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj4][MAP/tps no =10][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj4][MAP/tps no =11][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj4][MAP/tps no =12][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj4][MAP/tps no =13][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj4][MAP/tps no =14][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,              // ve_trim[inj4][MAP/tps no =15][RPM no = 0]
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}}}},


    {{{501,             // frpm_trimv2[RPM no = 0]
         801,1101,1401,2001,2601,3101,3700,4300,4900,5400,6000,6500,7000,7200,7500},
    {501,             // frpm_trimv3[RPM no = 0]
        801,1101,1401,2001,2601,3101,3700,4300,4900,5400,6000,6500,7000,7200,7500},
    {501,             // frpm_trimv4[RPM no = 0]
        801,1101,1401,2001,2601,3101,3700,4300,4900,5400,6000,6500,7000,7200,7500}}},
    {{{301,             // fmap_trimv1[MAP/tps no = 0], kPa x 10
         350,400,450,500,550,600,650,700,750,800,850,900,950,980,1000},
    {301,             // fmap_trimv3[MAP/tps no = 0], kPa x 10
        350,400,450,500,550,600,650,700,750,800,850,900,950,980,1000},
    {301,             // fmap_trimv4[MAP/tps no = 0], kPa x 10
        350,400,450,500,550,600,650,700,750,800,850,900,950,980,1000}}},
    {900, 846, 791, 737, 628, 573, 463, 408, 354, 300},
    {50, 77, 104, 158, 185, 212, 266, 293, 320, 347},
    {800,1454,2109,3418,4072,5381,6036,6690,7345,8000},
    {0,0,0,0}
    };

// this gives warnings in gcc which is annoying, but using it does make some things easier
// now used by CAN and SCI routines that reference tables
// has a slightly different usage to MS2 2.8+
// It is important to note that although the tables are defined here, there are hardcoded refs to
// the tables within the code. Specifically in isr_sci.c and ms2_extra_can_isr.c
const tableDescriptor tables[NO_TBLES] =  { 
  { (unsigned int *)cltfactor_table,    (unsigned int *)cltfactor_table,    sizeof(cltfactor_table) }, 
  { (unsigned int *)matfactor_table,    (unsigned int *)matfactor_table,    sizeof(matfactor_table) }, 
  { (unsigned int *)egofactor_table,    (unsigned int *)egofactor_table,    sizeof(egofactor_table) }, 
  { (unsigned int *)maffactor_table,    (unsigned int *)maffactor_table,    sizeof(maffactor_table) }, 
  { (unsigned int *)&ram_data,          (unsigned int *)&flash4,            1024                    }, 
  { (unsigned int *)&ram_data,          (unsigned int *)&flash5,            1024                    },
  { (unsigned int *)&txbuf,             NULL,                               sizeof(txbuf)           },
  { (unsigned int *)&outpc,             NULL,                               sizeof(outpc)           },
  { (unsigned int *)&ram_data,          (unsigned int *)&flash8,            1024                    },
  { (unsigned int *)&ram_data,          (unsigned int *)&flash9,            1024                    },
  { (unsigned int *)&ram_data,          (unsigned int *)&flash10,           1024                    },
  { (unsigned int *)&ram_data,          (unsigned int *)&flash11,           1024                    },
  { NULL,                               NULL,                               0                       },
  { NULL,                               NULL,                               0                       },
  { (unsigned int *)&Signature,         (unsigned int *)&Signature,         60                      },
  { (unsigned int *)&RevNum,            (unsigned int *)&RevNum,            20                      }
};

// IAC stepper motor sequence
const unsigned char IACCoilA[8] = {0,0,1,1,0,0,1,1};
const unsigned char IACCoilB[8] = {1,0,0,1,1,0,0,1};

unsigned char page;
char ram_data[1024];
page4_data *pg4_ptr;
page5_data *pg5_ptr;
page10_data *pg10_ptr;
page8_data *pg8_ptr;
page9_data *pg9_ptr;
page11_data *pg11_ptr;

// ignition related (wheel decoder)
ign_event dwell_events_a[NUM_TRIGS];
ign_event spark_events_a[NUM_TRIGS];
fuel_event fuel1_events_a[5];   
fuel_event fuel2_events_a[5];   
fuel_event fuel3_events_a[3];   
fuel_event fuel4_events_a[3];   
ign_event dwell_events_b[NUM_TRIGS];
ign_event spark_events_b[NUM_TRIGS];
fuel_event fuel1_events_b[5];   
fuel_event fuel2_events_b[5];   
fuel_event fuel3_events_b[3];   
fuel_event fuel4_events_b[3];   
ign_event *dwell_events;
ign_event *spark_events;
fuel_event *fuel1_events;       
fuel_event *fuel2_events;       
fuel_event *fuel3_events;       
fuel_event *fuel4_events;       
ign_event next_spark;
ign_event next_dwell;
fuel_event next_fuel1_event;    
fuel_event next_fuel2_event;    
fuel_event next_fuel3_event;    
fuel_event next_fuel4_event;    
ign_event next_spk_trl;
ign_event next_dwl_trl;
unsigned char next_fuel;
unsigned int inj1_count, inj2_count, inj3_count, inj4_count;
unsigned char trigger_teeth[NUM_TRIGS];
int trig_angs[NUM_TRIGS];
int trig_ang;
unsigned char coilsel;
unsigned char dwellsel;
unsigned char rotaryspksel;
unsigned char rotarydwlsel;
unsigned char num_spk;

//misc
unsigned char conf_err;
unsigned int mltimestamp;

// rs232 structs
variables outpc, txbuf;
datax datax1;

// sensor variables
int last_tps,last_map,tpsdot_ltch,mapdot_ltch,old_map;
// fuel variables
unsigned int pwcalc1,pwcalc2,pwcalc3,pwcalc4,pw_open1,pw_open2,pw_open3,pw_open4,PrimeP,AWEV,AWC,pwcalc_eae1,pwcalc_eae2, req_pw1, req_pw2, req_pw3, req_pw4;
unsigned char pwm1_on,pwm2_on;
// ignition variables
unsigned char SPK,CHG, pulse_no,ign_state,ign_setpin,
              IgnOCpinstate,PulseTol;
long charge_time,coil_dur_set;
unsigned int coil_dur; // was signed
unsigned long IgnTimerComp,dtpred,dtpred_last,dtpred_last2,dtpred_last3,NoiseFilterMin;
// IAC variables
unsigned long motor_time;
int IACmotor_pos,IACmotor_pos_remainder, last_iacclt,tble_motor_pos;
unsigned char idle_wait_timer;
unsigned char pwmidle_reset;
unsigned int pwmidle_timer;
unsigned char boost_ctl_duty;
char IAC_moving,IACmotor_reset,IdleCtl,motor_step;
int IACmotor_last;
// General variables
unsigned int iacpwmctr, TC_ovflow;
unsigned long lmms,t_enable_IC,t_enable_IC2,Rpm_Coeff,ltch_lmms,ltch_lmms2,rcv_timeout,adc_lmms;
unsigned int asecount;
unsigned char flocker,tpsaclk,egocount,igncount,fuelcount,altcount,next_adc,first_adc,  
              txmode,tble_idx,burn_idx,synch,Tcksum,Tcntr,
              egopstat[2],FSensStat,knk_clk,knk_clk_test,knk_stat,knk_count,mms, millisec;
unsigned int boost_ctl_timer;
unsigned char seq_inj_ctrl;
unsigned int hybrid_rpm, hybrid_hyst;
long ego1errm1[2],ego2errm1[2];
unsigned int FSens_Pd,FSensFreq;
unsigned long tegoclk;
/* Clocks:
   - igncount: counts up each tach pulse, cleared when hit Divider pulses
   (and injection occurs).
   - asecount: counts up each time igncount = 0 (each Divider pulses).
   - egocount: counts up each tach pulse, cleared when hits EgoCountCmp
   - tpsaclk: counts every .1 sec
   - altcount: flips 0,1,0,1... on each injection, resulting in firing alternate
   injector banks if Alternate option.
 */
unsigned int txcnt,txgoal,rxoffset,rxnbytes,rxcnt,tble_word,ntword;
char bad_ego_flag,bad_ego_ltch,first_clt;
int knk_tble_adv,warmup_Tclt,ffspkdel;
unsigned long WF1, WF2;
unsigned long AWA1, AWA2, SOA1, SOA2;
unsigned long tooth_diff_last_2, tooth_diff_last_1, tooth_diff_last, tooth_diff_this;
ign_time tooth_diff_rpm, dwl_time_ovflo, spk_time_ovflo, fuel_time_ovflo, dwl_time_ovflo_trl;   
ign_time spk_time_ovflo_trl, tooth_diff_rpm_last;
ign_queue spkq[2], dwellq[2];
unsigned char wheeldec_ovflo;
unsigned char no_triggers;
unsigned char no_teeth;
unsigned char tooth_no, tooth_no_rpm;
unsigned char last_tooth;
unsigned char mid_last_tooth;
int cycle_deg;

int start_clt;
unsigned int tcrank_done,tcold_pos;
unsigned int EAEdivider;

// CAN variables
unsigned long cansendclk,ltch_CAN;
unsigned int can_status;
unsigned char can_clr_stat;
canmsg can[2];

// pointers for spare port pins
volatile unsigned char *pPTMpin[8], *pPTTpin[8], *pPTApin0, *pPTEpin[2];
volatile unsigned char *boostport;
unsigned char boostpin;

unsigned char dummyReg,lst_pval[NPORT];

// allocate space in ram for flash burner core
volatile unsigned char RamBurnPgm[36];

//global (static) vars for SCI, RTC ISR
unsigned char CANid, next_txmode, rd_wr, flagbyte0, flagbyte1, flagbyte2, flagbyte3, flagbyte4, flagbyte5, flagbyte6, flagbyte11;
//unsigned char scidiag[258];  //256 + 2 for counter
//
unsigned long stall_timeout;
unsigned char last_fsensdat;
unsigned short FPdcounter;
unsigned int lowres, lowres_ctr, tacho_targ, /*spk_mult,*/ log_offset;
unsigned char fc_counter, adc_ctr;
unsigned char spk_cutx, spk_cuty, spk_cuti;
unsigned char staged_num_events; /* number of events into staging trasition */
unsigned long pw_staged1, pw_staged2, pw_staged3, pw_staged4; /* staged pulsewidths */
unsigned char dwl[8], mindwl, nomdwl, maxdwl, testcnt, rtsci, rtcksum;
unsigned int swtimer, deg_per_tooth[MAXNUMTEETH], swtimer_TC5_last;
unsigned char pwmd1, pwmd2, trig2cnt, bl_timer, resetholdoff, n2o_act_timer, n2o2_act_timer;
unsigned int inj1cntdown, inj2cntdown, injtime, injtime_EAElagcomp;
map_event next_map_start_event, map_start_event[NUM_TRIGS];
unsigned int map_start_countdown, map_window_countdown, map_temp, map_temps[4];
unsigned int map_window_set;
unsigned int maf_temp, mafraw;
unsigned char map_temps_cnt, map_deadman;
long MAFCoef;
unsigned long ultmp,ultmp2;
unsigned char mmsDiv, boost_ctl_clock;
unsigned int n2o_addfuel;
unsigned int mapsample_time, tpssample_time;
unsigned char running_seconds;
unsigned char fc_off_time;
unsigned long tmp_pw1,tmp_pw2,tmp_pw3,tmp_pw4, ticks_per_deg;
unsigned char tmpdwellsel, tmpcoilsel;
unsigned char tooth_init, tooth_counter, tooth_counter_main;

ign_time act_tooth_time[WHEEL_NUM_TEETH];
unsigned char act_tooth_num[WHEEL_NUM_TEETH];

unsigned char fuel_cntr, firstsync_iter, set_count, EAElagcomp_squirts, EAElag_squirting;
unsigned char channel_squirted, squirtcount1, squirtcount2;
unsigned long dtpred_adder;
unsigned int RevLimRpm1, RevLimRpm2;
unsigned char syncerr;
unsigned int smallest_tooth_crk, smallest_tooth_cam, false_mask_crk, false_mask_cam, false_period_crk_tix, false_period_cam_tix;
unsigned char injbits;
unsigned int TC0_last, TC_trig2_last, TC_trig2_last2, TC5_last;
unsigned long TC5_32bits, TC5_trig_firstedge, TC5_required_width;
unsigned char idle_advance_timer;
unsigned long IC_last;
int gl_afrtgt1, gl_afrtgt2;
unsigned char num_cyl, divider;

unsigned char no_inj, no_squirts;
unsigned int dwell_us, dwell_us2;
unsigned int dizzy_scaler[NUM_TRIGS], trigret_scaler;
unsigned long dwell_long;
unsigned char dwellsel_next;
unsigned char spkmode;
unsigned char ls1_ls, ls1_sl;
unsigned char last_edge, last_edge2;
unsigned int rpmdot_data[RPMDOT_N][2];
unsigned long sd_crc;

unsigned int remotePWMfreq;
unsigned char remotePWMscale;

unsigned int srl_timeout;

/* Here are some variables defined to help the new programmer get started *
 *
 * They are defined in ms2_extra.h, ms2_extra_main.c
 * Initialised to zero in ms2_extra_init.c
 * There is a place to use them in ms2_extra_user.c
 * Tuning software configuration is in base.ini
 * - there is a menu for the settings, but commented out.
 *
 * Search for 'user defined' and you'll find these code segments.
 *
 * If you rename these variables you will also need to do the same in
 * all places search for 'user defined'
 *
 * 'user defined' variables */
unsigned long user_ulong;
unsigned int user_uint;
unsigned char user_uchar;
/* end user defined section */

int main(void)
{
    int ix;
    int tmp1=0,tmp2=0,tmp3 = 0,tmp4,wrmtmp,tpsatmp,tpsaccel_end=0,ae_scaler;
    unsigned int utmp1, utmp2;
    long lsum=0,lsum1=0,lsum2=0,lsum3=0;
    unsigned long ltmp1;
    //int start_clt;
    unsigned int tASTol = 0;
    unsigned char uctmp, uctmp1, uctmp2, uctmp3, uctmp4, uctmp5, uctmp6;
    unsigned char localflags = 0;
    int local_div;
#define LOCALFLAGS_RUNFUEL 0x1

    tmp_pw1 = tmp_pw2 = tmp_pw3 = tmp_pw4 = 0;
    injbits = 0;

    main_init(); // set up all timers, initialise stuff

    mltimestamp = TCNT;
    //  main loop
    for (;;)  {
        if (conf_err != 0) {
            configerror();          // only returns for errors >= 190
        }
        outpc.looptime = (outpc.looptime + TCNT - mltimestamp)>>1; // rolling avg
        mltimestamp = TCNT;

        //reset COP timer (That's Computer Operating Properly, not Coil On Plug...)
        ARMCOP = 0x55;
        ARMCOP = 0xAA;

        realtime();

        if (flagbyte1 & flagbyte1_tstmode) {
            get_adc(4,4); // do update battery voltage for display
            goto SKIP_THE_LOT;  // in special test mode don't do any of normal mainloop
        }

        if (flagbyte3 & flagbyte3_samplemap) {
            unsigned int tmp_mapsample_time;
            unsigned int map_local, maf_local;

            localflags |= LOCALFLAGS_RUNFUEL;

            DISABLE_INTERRUPTS;
            map_local = map_temp;
            maf_local = maf_temp;
            flagbyte3 &= ~flagbyte3_samplemap;
            ENABLE_INTERRUPTS;

            old_map = outpc.map;

            __asm__ __volatile__ (
                    "ldd    %1\n"
                    "subd   %2\n"
                    "ldy    %3\n"
                    "emul\n"
                    "ldx    #1023\n"
                    "ediv\n"
                    "tfr    y,d\n"
                    "addd   %2\n"
                    : "=d"(utmp1)
                    : "m"(flash4.mapmax),
                    "m"(flash4.map0),
                    //"m"(ATD0DR0)
                    "m"(map_local)
                    : "y", "x");

            __asm__ __volatile__ (
                    "ldd    %1\n"
                    "subd   %3\n"
                    "tfr    d,y\n"
                    "clra\n"
                    "ldab    %2\n"      // it is a uchar
                    "emuls\n"
                    "ldx     #100\n"
                    "edivs\n"
                    "tfr     y,d\n"
                    "addd    %3\n"
                    : "=d"(outpc.map)
                    : "m"(utmp1),
                    "m"(flash4.mapLF),
                    "m"(outpc.map)
                    : "x", "y" );

            if (flagbyte6 & FLAGBYTE6_USE_MAF) {
//                utmp1 = maffactor_table[maf_local]; // this will NOT work here
                utmp1 = maflookup(maf_local);

                __asm__ __volatile__(
                        "ldd    %1\n"
                        "subd   %3\n"
                        "tfr    d,y\n"
                        "clra\n"
                        "ldab    %2\n" // it is a uchar
                        "emuls\n"
                        "ldx     #100\n"
                        "edivs\n"
                        "tfr   y,d\n"
                        "addd    %3\n"
                        :"=d"(mafraw)
                        :"m"(utmp1), "m"(flash4.mapLF), "m"(mafraw)
                        :"x", "y");

                utmp1 = intrp_1dctable(mafraw, 12, (int *)flash9.MAFFlow, 0, (unsigned char *)
                        flash9.MAFCor);

                outpc.maf = ((unsigned long)mafraw * utmp1) / 100;

                /* outpc.aircor is in 1.0 units in MS2/Extra compared to 0.1 units in MS3 */
                if (outpc.rpm > 0) {
                    outpc.mafmap = (int)(((long)(MAFCoef / (outpc.aircor * 10)) * outpc.maf) / outpc.rpm);
                    if (outpc.mafmap < 100) {
                        outpc.mafmap = 100;
                    }
                } else {
                    outpc.mafmap = 1000;
                    outpc.maf = 0;
                }
            }

            // mapdot
            if (mapsample_time > 78) { // minimum 10ms
                DISABLE_INTERRUPTS;
                tmp_mapsample_time = mapsample_time;
                mapsample_time = 0;
                ENABLE_INTERRUPTS;
                if (flagbyte6 & FLAGBYTE6_USE_MAF_ONLY) {
                    /* not using real MAP anywhere, use mafmap for mapdot */
                    map_local = outpc.mafmap;
                } else {
                    map_local = outpc.map;
                }

                outpc.mapdot = (781L * (outpc.map - last_map)) / tmp_mapsample_time;
                last_map = outpc.map;
            }
        }

        // perform lag factors in mainloop instead of chewing time in interrupt
        if (flagbyte0 & flagbyte0_50ms) {
            unsigned int tmp_tpssample_time;

            DISABLE_INTERRUPTS;
            flagbyte0 &= ~flagbyte0_50ms; // clear flag
            tmp_tpssample_time = tpssample_time;
            tpssample_time = 0;
            ENABLE_INTERRUPTS;
            // get map, tps
            // map, tps lag(IIR) filters

            __asm__ __volatile__ (
                    "ldd %3\n"
                    "subd %2\n"
                    "tfr  d,y\n"
                    "ldd  %1\n"
                    "subd %2\n"
                    "pshd\n"
                    "ldd #1000\n"
                    "emuls\n"
                    "pulx\n"
                    "edivs\n"
                    : "=y"(tmp1)
                    : "m"(flash4.tpsmax),
                    "m"(flash4.tps0),
                    "m"(ATD0DR3)
                    : "d", "x");

            __asm__ __volatile__ (
                    "ldd    %1\n"
                    "subd   %3\n"
                    "tfr    d,y\n"
                    "clra\n"
                    "ldab    %2\n"      // it is a uchar
                    "emuls\n"
                    "ldx     #100\n"
                    "edivs\n"
                    "tfr     y,d\n"
                    "addd    %3\n"
                    : "=d"(outpc.tps)
                    : "m"(tmp1),
                    "m"(flash4.tpsLF),
                    "m"(outpc.tps)
                    : "x", "y" );

            outpc.tpsadc = ATD0DR3; // send back for TPS calib

            // save last tps, map for calculation of tpsdot, mapdot
            outpc.tpsdot = (7812L * (outpc.tps - last_tps)) / tmp_tpssample_time;
            last_tps = outpc.tps;

            ego_get_sample();
        }

        /* Noise Filter Table Lookup */
        noisefilter_lookup(); 

        if((lmms - adc_lmms) > 78)  {          // every 10 ms (78 x .128 ms clk)
            adc_lmms = lmms;
            // read 10-bit ADC results, convert to engineering units and filter
            next_adc++;
            if(next_adc > 7)next_adc = 1;
            if ((next_adc == 1) || (next_adc == 2) || (next_adc == 4)) {
                get_adc(next_adc,next_adc);    // get one channel on each pass
            } else if (next_adc >= 6) {
                get_adc(next_adc,next_adc);      // get one channel on each pass
            }
        }

        if ((localflags & LOCALFLAGS_RUNFUEL) || (outpc.engine & ENGINE_CRANK)) {

            if(flash4.BaroOption == 0)  {
                outpc.barocor = 100;
            } else {                                     // barometric correction (%)
                outpc.barocor = barocor_eq(outpc.baro) + intrp_1dctable(outpc.baro,
                        NO_BARS, (int *)flash5.BaroVals, 1, (unsigned char *)flash5.BaroCorDel);
            }
            // airdensity correction (%)
            outpc.aircor = aircor_eq(outpc.mat) + intrp_1dctable(outpc.mat,
                    NO_MATS, (int *)flash5.MatVals, 1, (unsigned char *)flash5.AirCorDel);

            tmp1 = outpc.map;

            realtime();
            uctmp1 = flash4.FuelAlgorithm & 0xF;
            uctmp2 = flash4.FuelAlgorithm & 0xF0;
            uctmp3 = flash4.IgnAlgorithm & 0xF;
            uctmp4 = flash4.IgnAlgorithm & 0xF0;
            uctmp5 = flash4.extra_load_opts & 0xF;
            uctmp6 = flash4.extra_load_opts & 0xF0;
            if ((uctmp1 == 2) || (uctmp2 == 0x20) ||
                (uctmp1 == 6) || (uctmp2 == 0x60) ||
                (uctmp3 == 2) || (uctmp4 == 0x20) ||
                (uctmp3 == 6) || (uctmp4 == 0x60) ||
                (uctmp5 == 2) || (uctmp5 == 6) ||
                (uctmp6 == 0x20) || (uctmp6 == 0x60)) {

                tmp2 = (int) (((long) tmp1 * 1000) / outpc.baro);
            }

            if ((uctmp1 == 6) || (uctmp2 == 0x60) ||
                    (uctmp3 == 6) || (uctmp4 == 0x60) ||
                    (uctmp5 == 6) || (uctmp6 == 0x60)) {
                tmp3 = calc_ITB_load(tmp2);
            }

            /* Fuel Load 1 */
            if (uctmp1 == 1) {
                outpc.fuelload = tmp1;  // kpa x 10, speed density
            } else if (uctmp1 == 2) {
                outpc.fuelload = tmp2; // % baro
            } else if (uctmp1 == 3) {
                outpc.fuelload = outpc.tps; // alpha-n
            } else if (uctmp1 == 4 || uctmp1 == 5) { // maf or mafmap
                outpc.fuelload = outpc.mafmap;
            } else if (uctmp1 == 6) { // ITB
                outpc.fuelload = tmp3;
            } else {
                /* somehow something is set wrong, just use map */
                outpc.fuelload = outpc.map;
            }

            if (!flash4.dual_tble_optn) {
                if (uctmp2 == 0x10) {
                    outpc.fuelload2 = tmp1;
                } else if (uctmp2 == 0x20) {
                    outpc.fuelload2 = tmp2;
                } else if (uctmp2 == 0x30) {
                    outpc.fuelload2 = outpc.tps;
                } else if (uctmp2 == 0x40 || uctmp2 == 0x50) {
                    outpc.fuelload2 = outpc.mafmap;
                } else if (uctmp2 == 0x60) {
                    outpc.fuelload2 = tmp3;
                } 
            } else {
                outpc.fuelload2 = outpc.fuelload; // needed for Megatune
            }

            /* Ign Load 1 */
            if (uctmp3 == 1) {
                outpc.ignload = outpc.map;
            } else if (uctmp3 == 2) {
                outpc.ignload = tmp2;
            } else if (uctmp3 == 3) {
                outpc.ignload = outpc.tps;
            } else if (uctmp3 == 4) {
                outpc.ignload = outpc.mafmap;
            } else if (uctmp3 == 6) {
                outpc.ignload = tmp3;
            } else {
                outpc.ignload = outpc.fuelload;
            }

            if (uctmp4 == 0x10) {
                outpc.ignload2 = outpc.map;
            } else if (uctmp4 == 0x20) {
                outpc.ignload2 = tmp2;
            } else if (uctmp4 == 0x30) {
                outpc.ignload2 = outpc.tps;
            } else if (uctmp4 == 0x40) {
                outpc.ignload2 = outpc.mafmap;
            } else if (uctmp4 == 0x60) {
                outpc.ignload2 = tmp3;
            }
            /* AFR load */
            if (uctmp5 == 1) {
                outpc.afrload = outpc.map;
            } else if (uctmp5 == 2) {
                outpc.afrload = tmp2;
            } else if (uctmp5 == 3) {
                outpc.afrload = outpc.tps;
            } else if (uctmp5 == 4) {
                outpc.afrload = outpc.mafmap;
            } else if (uctmp5 == 6) {
                outpc.afrload = tmp3;
            } else {
                outpc.afrload = outpc.fuelload;
            } 

            /* EAEload */
            if (uctmp6 == 0x10) {
                outpc.eaeload = outpc.map;
            } else if (uctmp6 == 0x20) {
                outpc.eaeload = tmp2;
            } else if (uctmp6 == 0x30) {
                outpc.eaeload = outpc.tps;
            } else if (uctmp6 == 0x40) {
                outpc.eaeload = outpc.mafmap;
            } else if (uctmp6 == 0x60) {
                outpc.eaeload = tmp3;
            } else {
                outpc.eaeload = outpc.fuelload;
            }

            realtime();
        }

        idle_firstrun();        

        if (IACmotor_reset && (pg8_ptr->iactest & 2)) {
            idle_test_mode ();
        }

        // check for stall
        if(((outpc.engine & ENGINE_READY) == 0) || (outpc.rpm == 0))goto EVERY_TOOTH;

        // check idle control
        // test mode first - only after stepper init

        idle_ctl();

        /* BOOST CONTROL */
        if (flash5.boost_ctl_settings & BOOST_CTL_ON) {
            boost_ctl();
            if (flash5.boost_ctl_settings & BOOST_CTL_REMOTE) {
                if (outpc.boostduty == 100) {
                    outpc.gpioport[(flash5.boost_ctl_pins>>4) - 1] = 255;
                } else {
                    outpc.gpioport[(flash5.boost_ctl_pins>>4) - 1] = (unsigned char)((((unsigned int)outpc.boostduty)<<8) / 100);
                }
            }
        }

        if (flash4.OverBoostOption) {
            if (outpc.map > flash4.OverBoostKpa) {
                outpc.status2 |= status2_overboost_active;
            }

            if (outpc.map < (flash4.OverBoostKpa - flash4.OverBoostHyst)) {
                outpc.status2 &= ~ status2_overboost_active;
            }
        }

        /**************************************************************************
         **
         ** Cranking Mode
         **
         ** Pulsewidth is directly set by the coolant temperature to a value of
         **  CWU (at temp_table[0]) and CWH (at temp_table[NO_TEMPS -1]).
         **  The value is interpolated at clt.
         **
         **************************************************************************/
        if ((outpc.rpm < flash4.crank_rpm) && (flagbyte2 & flagbyte2_crank_ok))  {
            if (flash4.userlevel > 191) {
                PulseTol = flash4.CrnkTol;
            } else {
                PulseTol = 50; // default 50%
            }
            tcrank_done = 0xFFFF;
            DISABLE_INTERRUPTS;
            running_seconds = 0;
            ENABLE_INTERRUPTS;
            outpc.engine |= ENGINE_CRANK;    // set cranking bit
            outpc.engine &= ~(ENGINE_ASE | ENGINE_WUE);   // clr starting warmup bit & warmup bit
            if(outpc.tps > flash4.TPSWOT)  {
                tmp_pw1 = 0;    // usec  (0 ms for Flood Clear)
                tmp_pw2 = 0;
                tmp_pw3 = 0;
                tmp_pw4 = 0;
                goto KNK;
            }

            // cranking pulse width now uses a %age lookup table calculated from ReqFuel.
            // Hopefully new users can leave this table alone and engine will start
            // Changing injector size is corrected by ReqFuel

            utmp1 = CW_table(outpc.clt,(int *)flash5.CrankPctTable, (int *)flash5.temp_table_p5);

            if ((flash8.seq_inj & 0x03) == 0) {
                                // Make adjustment when no sequential/semi-sequential mode is active
                    if (flash4.Alternate & 0x02) {
                        utmp1 <<= 1;
                    }

                    utmp1 /= flash4.Divider;

                                if (flash4.Alternate & 0x01) {
                                        utmp1 >>= 1;
                                }
                        }

            __asm__ __volatile__ ("emul\n"
                    "ldx #100\n"
                    "ediv\n":
                    "=y" (utmp1):
                    "y" (flash4.ReqFuel),
                    "d" (utmp1):
                    "x");

            calc_opentime();

            tmp_pw1 = (unsigned long)utmp1 * 100;
            tmp_pw2 = (unsigned long)utmp1 * 100;
//                      if ((flash8.seq_inj & 0x03) == 3) {     //*** JB
//                              tmp_pw3 = (unsigned long)utmp1 * 100;
//                              tmp_pw4 = (unsigned long)utmp1 * 100;
//                      }
            goto CHECK_STAGED;
        } else if (tcrank_done == 0xFFFF) {
            tcrank_done = outpc.seconds;
        } else {
            if (outpc.seconds > tcrank_done + 5) {
                flagbyte2 &= ~flagbyte2_crank_ok;
                if ((spkmode == 2) && (flash4.spk_conf2 & 1)) {
                    // Set HEI bypass to 5v
                    PTM &= ~0x10;
                }
            }
        }

        if ((localflags & LOCALFLAGS_RUNFUEL) || (outpc.engine & ENGINE_CRANK)) {
            /**************************************************************************
             **
             ** Warm-up and After-start Enrichment Section
             **
             ** The Warm-up enrichment is a linear interpolated value for the current clt
             ** temperature from warmen_table[NO_TEMPS] vs temp_table[NO_TEMPS]. The
             ** interpolation is done in subroutine warmcor_table.
             **
             ** Also, the after-start enrichment value is calculated and applied here - it
             **  is an added percent value on top of the warmup enrichment, and it is applied
             **  for the number of ignition cycles specified in AWC. This enrichment starts
             **  at a value of AWEV at first, then it linearly interpolates down to zero
             **  after AWC cycles.
             **
             **  If (startw, engine is set) then:
             **   compare if (AWC > 0) then:
             **    interpolate for warmup enrichment
             **   else clear startw bit in engine
             **
             **************************************************************************/
            wrmtmp = outpc.warmcor;
            if(outpc.engine & ENGINE_CRANK)  {     // if engine cranking
                outpc.engine &= ~ENGINE_CRANK;       // clear crank bit
                if (resetholdoff == 0) { // not within burn timeout period - i.e. normal
                    outpc.engine |= ENGINE_ASE | ENGINE_WUE;        // set starting warmup bit (ase) & warmup bit
                    asecount = 0;
                }
                if (flash4.userlevel > 191) {
                    PulseTol = flash4.ASTol;
                } else {
                    PulseTol = 50;
                }
                tASTol = outpc.seconds;

                set_prime_ASE();
                DISABLE_INTERRUPTS;
                running_seconds = 0;
                ENABLE_INTERRUPTS;
            }
            wrmtmp = intrp_1dctable(outpc.clt, NO_TEMPS, (int *)flash4.temp_table, 0,
                    (unsigned char *)flash4.warmen_table);    // %
            outpc.cold_adv_deg = CW_table(outpc.clt,(int *)flash4.cold_adv_table, (int *)flash4.temp_table); // deg x 10

            if(wrmtmp == 100)  {     // done warmup
                outpc.engine &= ~ENGINE_WUE;        // clear start warmup bit (ase) & warmup bit
                *pPTMpin[5] &= ~0x20;         // clear warmup led
                if(outpc.seconds > tASTol + 5) {
                    if (flash4.userlevel > 191) {
                        PulseTol = flash4.PulseTol;
                    } else {
                        PulseTol = 50;
                    }
                }
            } else {
                *pPTMpin[5] |= 0x20;            // set warmup led
                outpc.engine |= ENGINE_WUE;           // set warmup bit
            }
            if(!(outpc.engine & ENGINE_ASE)) {     // if starting warmup bit clear
                goto END_WRM;
            }
            if((asecount > AWC) || (AWEV == 0))  {
                outpc.engine &= ~ENGINE_ASE;        // clear start warmup bit
                if(outpc.seconds > tASTol + 5)
                    PulseTol = flash4.PulseTol;
                goto END_WRM;
            }

            if (AWC > 0) {
        //        utmp1 = (unsigned long)(AWEV * (AWC - asecount)) / AWC;
                __asm__ __volatile__ (
                "tfr d,x\n"
                "subd %1\n"
                "ldy  %2\n"
                "emul\n"
                "ediv\n"
                : "=y" (utmp1)
                : "m" (asecount), "m" (AWEV), "d" (AWC)
                : "x"
                );

                wrmtmp += utmp1;
            }
END_WRM:
            outpc.warmcor = wrmtmp;

            realtime();

            /**************************************************************************
             **
             **  Throttle Position Acceleration Enrichment
             **
             **   Method is the following:
             **
             **
             **   ACCELERATION ENRICHMENT:
             **   If (tpsdot < 0) goto DEACCELERATION_ENRICHMENT
             **   If tpsdot > tpsthresh and TPSAEN bit = 0 then (acceleration enrichment):
             **   {
             **    1) Set acceleration mode
             **    2) Continuously determine rate-of-change of throttle, and perform
             **        interpolation of table values to determine acceleration
             **        enrichment amount to apply.
             **   }
             **   If (TPSACLK > TpsAsync) and TPSAEN is set then:
             **   {
             **    1) Clear TPSAEN bit in engine
             **    2) Set TPSACCEL to 0
             **    3) Go to EGO Delta Step Check Section
             **   }
             **   Enrichment tail-off pulsewidth:
             **
             **   ------------------ tpsaccel
             **   |            |\
             **   |            |   \
             **   |            |      \
             **   |            |         \          ____ TpsAccel2
             **   |            |            |
             **   |            |            |
             **   ---------------------------
             **   <--TpsAsync--><-TpsAsync2->
             **
             **
             **   DEACCELERATION ENRICHMENT:
             **   If (-tpsdot) > tpsthresh then (deceleration fuel cut)
             **   {
             **    If (TPSAEN = 1) then:
             **    {
             **      1) TPSACCEL = 0 (no acceleration)
             **      2) Clear TPSAEN bit in ENGINE
             **      3) Go to EGO Delta Step
             **    }
             **    If (RPM > 1500 then (fuel cut mode):
             **    {
             **      1) Set TPSACCEL value to TPSDQ
             **      2) Set TPSDEN bit in ENGINE
             **      3) Go to EGO Delta Step Check Section
             **    }
             **   }
             **   else
             **   {
             **    If (TPSDEN = 1) then
             **    {
             **     1) Clear TPSDEN bit in ENGINE
             **     2) TPSACCEL = 0
             **     3) Go to EGO Delta Step Check Section
             **    }
             **   }
             **
             **************************************************************************/
            tpsatmp = outpc.tpsaccel;
            DISABLE_INTERRUPTS;
            tpsdot_ltch = outpc.tpsdot;
            mapdot_ltch = outpc.mapdot;
            ENABLE_INTERRUPTS;
            if((tpsdot_ltch < 0) && (flash4.Tps_acc_wght != 0)) goto TDE; // decelerating
            if((mapdot_ltch < 0) && (flash4.Tps_acc_wght != 100)) goto TDE;
            if(outpc.engine & ENGINE_TPSACC)goto AE_COMP_SHOOT_AMT;   // if accel enrich bit set
            if(outpc.engine & ENGINE_MAPACC)goto AE_COMP_SHOOT_AMT;
            if(((flash4.Tps_acc_wght == 0) || (tpsdot_ltch < flash4.TpsThresh)) &&
                    ((flash4.Tps_acc_wght == 100) || (mapdot_ltch < flash4.MapThresh)))
                goto TAE_CHK_TIME;
            // start out using first element - determine actual next time around
            tpsatmp = (((short)flash4.tpsen_table[0] * flash4.Tps_acc_wght) +
                    ((short)flash4.mapen_table[0] * (100 - flash4.Tps_acc_wght))) / 100;
            tpsaccel_end = tpsatmp;               // latch last tpsaccel before tailoff
            tpsaclk = 0;                    // incremented in .1 sec timer
            if ((tpsdot_ltch > flash4.TpsThresh) && (flash4.Tps_acc_wght != 0)) {
                outpc.engine |= ENGINE_TPSACC;       // set tpsaen bit
            }
            if ((mapdot_ltch > flash4.MapThresh) && (flash4.Tps_acc_wght != 100)) {
                outpc.engine |= ENGINE_MAPACC;
            }
            outpc.engine &= ~ENGINE_TPSDEC;      // clear tpsden bit
            outpc.engine &= ~ENGINE_MAPDEC;
            *pPTMpin[4] |= 0x10;        // set accel led
            goto END_TPS;
            /* First, calculate Cold temperature add-on enrichment value from coolant value
               TPSACOLD at min temp & 0 at high temp.

               Then determine cold temperature multiplier value ACCELMULT (in percent).

               Next, Calculate Shoot amount (quantity) for acceleration enrichment from table.
               Find bins (between) for corresponding TPSDOT and MAPDOT, and linear interpolate
               to find enrichment amount from table. This is continuously
               checked every time thru main loop while in acceleration mode,
               and the highest value is latched and used.

               The final acceleration enrichment (in .1 ms units) applied is AE =
               (((Alookup(TPSDOT)*Tps_acc_wght + Alookup(MAPDOT)*(100 - Tps_acc_wght))
               /100) * ACCELMULT/100) + TPSACOLD.
             */

AE_COMP_SHOOT_AMT:

            if(tpsaclk <= flash4.TpsAsync)  {
                tmp1 = (short)flash4.Tpsacold  - (short)((flash4.Tpsacold *
                            (long)(outpc.clt - flash4.temp_table[0]) / (flash4.temp_table[NO_TEMPS-1]
                                - flash4.temp_table[0])));          // in .1 ms
                tmp2 = (short)flash4.AccMult + (short)(((100 - flash4.AccMult) *
                            (long)(outpc.clt - flash4.temp_table[0]) / (flash4.temp_table[NO_TEMPS-1]
                                - flash4.temp_table[0])));          // in %
                if(flash4.Tps_acc_wght > 0)  {
                    tmp3 = intrp_1dctable(tpsdot_ltch, NO_TPS_DOTS, (int *)flash4.tpsdot_table, 0,
                            (unsigned char *)flash4.tpsen_table);   // .1 ms units
                }
                else
                    tmp3 = 0;
                if(flash4.Tps_acc_wght < 100)  {
                    tmp4 = intrp_1dctable(mapdot_ltch, NO_MAP_DOTS, (int *)flash4.mapdot_table, 0,
                            (unsigned char *)flash4.mapen_table);   // .1 ms units
                }
                else
                    tmp4 = 0;
                tmp3 = ((tmp3 * flash4.Tps_acc_wght) + (tmp4 * (100 - flash4.Tps_acc_wght))) / 100;
                tmp3 = (tmp3 * tmp2) / 100;
                if(tmp3 > 200)
                    tmp3 = 200;  // rail at 20 ms
                tmp3 += tmp1;
                if(tmp3 > tpsatmp)
                    tpsatmp = tmp3; // make > tps/mapen_table entry for lowest tps/mapdot
                // plus latch and hold largest pw
                tpsaccel_end = tpsatmp;         // latch last tpsaccel before tailoff
            }
            else  {      // tailoff enrichment pulsewidth
TAILOFF:
                if(flash4.TpsAsync2 > 0)  {
                    tpsatmp = tpsaccel_end + (short)(((flash4.TpsAccel2 - tpsaccel_end) *
                                (long)(tpsaclk - flash4.TpsAsync)) / flash4.TpsAsync2);
                }
                else
                    tpsatmp = 0;
            }

TAE_CHK_TIME:
            // check if accel is done
            // if tps decel bit not set, accel bit is
            if((!(outpc.engine & ENGINE_TPSDEC) && (outpc.engine & ENGINE_TPSACC)) ||
                    (!(outpc.engine & ENGINE_MAPDEC) && (outpc.engine & ENGINE_MAPACC))) {
                if(tpsaclk < (flash4.TpsAsync + flash4.TpsAsync2))goto END_TPS;
            }
            goto KILL_ACCEL;

TDE:             // tpsdot < 0
            if((outpc.engine & ENGINE_TPSACC) || (outpc.engine & ENGINE_MAPACC)) {     // if tps accel bit set
                if((-tpsdot_ltch) > flash4.TpsThresh)
                    goto KILL_ACCEL;
                if((-mapdot_ltch) > flash4.MapThresh)
                    goto KILL_ACCEL;
                if(tpsaclk < flash4.TpsAsync)
                    tpsaclk = flash4.TpsAsync;  // just tail off AE
                goto TAILOFF;
            }
            // decel
            if(((-tpsdot_ltch) > flash4.TpsThresh) && (flash4.TPSDQ != 100)) {
                if(outpc.rpm < 1500)goto END_TPS;
                outpc.tpsfuelcut = flash4.TPSDQ;    // in %
                outpc.engine |= ENGINE_TPSDEC;             // set tps decel bit
                goto END_TPS;
            }
            if(((-mapdot_ltch) > flash4.MapThresh) && (flash4.TPSDQ != 100)) {
                if(outpc.rpm < 1500) goto END_TPS;
                outpc.tpsfuelcut = flash4.TPSDQ;
                outpc.engine |= ENGINE_MAPDEC;
                goto END_TPS;
            }
            //  ** Jedrik bug fix
            if(outpc.engine & (ENGINE_TPSACC | ENGINE_TPSDEC | ENGINE_MAPACC | ENGINE_MAPDEC))  {     // if decel or just finished accel
KILL_ACCEL:
                outpc.engine &= ~(ENGINE_TPSACC | ENGINE_TPSDEC | ENGINE_MAPACC | ENGINE_MAPDEC);       // clear tps decel, accel bits
                outpc.tpsfuelcut = 100;
                *pPTMpin[4] &= ~0x10;        // clear accel led
                tpsatmp = 0;
            }
END_TPS:
            // apply AE rpm-based scaler
            if(outpc.rpm <= flash4.ae_lorpm)
                ae_scaler =  100;
            else if(outpc.rpm >= flash4.ae_hirpm)
                ae_scaler = 0;
            else  {
                ae_scaler = (short)(((long)100 * (flash4.ae_hirpm - outpc.rpm)) /
                        (flash4.ae_hirpm - flash4.ae_lorpm));
            }
            outpc.tpsaccel = (tpsatmp * ae_scaler) / 100;

            realtime();
            /**************************************************************************
             **
             **  Exhaust Gas Oxygen Sensor Measurement Section
             **
             **************************************************************************/
            ego_get_targs_gl();
            ego_get_targs();
            ego_calc();  // this is on page 3d
            /**************************************************************************
             **  Look up volumetric efficiency as function of rpm and map (tps
             **   in alpha N mode)
             **************************************************************************/
            uctmp = 0; //uctmp is local tmp var
            // nitrous control will also use this var as pin behaviour will be different
            if ((flash4.userlevel > 127) && (flash5.feature5_0 & 2) && (!flash4.dual_tble_optn)) { // user advanced enough and table switching
                if ((flash5.feature5_0 & 0x0c) == 0) {
                    if (flash5.ts_remote & 0x01) {
                        // Remote switch
                        if (!(outpc.gpioport[2] & (0x01 << ((flash5.ts_remote & 0x0E)>>1)))) {
                            uctmp = 1;
                        }
                    } else {
                        // Local switch
                        if (!(PORTE & 0x2)) { // the bastard pin. Pullup always enabled.
                            uctmp = 1;
                        }
                    }
                } else if ((flash5.feature5_0 & 0x0c) == 4) {
                    if (outpc.rpm > flash5.tsf_rpm) {
                        uctmp = 1;
                    }
                } else if ((flash5.feature5_0 & 0x0c) == 8) {
                    if (outpc.map > flash5.tsf_kpa) {
                        uctmp = 1;
                    }
                } else if ((flash5.feature5_0 & 0x0c) == 0xc) {
                    if (outpc.tps > flash5.tsf_tps) {
                        uctmp = 1;
                    }
                }
            }

            if (uctmp) {
                outpc.status1 |= status1_ftblsw;
            } else {
                outpc.status1 &= ~status1_ftblsw;
            }

            if (flash4.feature4_0 & 0x04) { // 12x12 tables
                if ((uctmp == 1) || (((flash8.seq_inj & 0x03) == 3) && (seq_inj_ctrl & SEQ_HYBRID))) {
                    if ((flash4.FuelAlgorithm & 0xF) != 5) {
                        // using table switching will disable secondary load table
                        // grab VE from table 3
                        outpc.vecurr1 = intrp_2dctable(outpc.rpm, outpc.fuelload, NO_FRPMS, NO_FMAPS,
                                &pg9_ptr->frpm_tables.frpm_tablevS[2][0], &pg9_ptr->fmap_tables.fmap_tablevS[2][0], 
                                (unsigned char *)&pg9_ptr->ve_tables.ve_tableS[2][0][0], 1); // in .1 %
                    } else {
                        outpc.vecurr1 = 1000;
                    }
                } else {
                    if ((flash4.FuelAlgorithm & 0xF) != 5) {
                        tmp1 = intrp_2dctable(outpc.rpm, outpc.fuelload, NO_FRPMS, NO_FMAPS,
                                &pg9_ptr->frpm_tables.frpm_tablevS[0][0], &pg9_ptr->fmap_tables.fmap_tablevS[0][0], 
                                (unsigned char *)&pg9_ptr->ve_tables.ve_tableS[0][0][0], 1); // in .1%
                    } else {
                        tmp1 = 1000;
                    }

                    if ((flash4.FuelAlgorithm & 0xF0) && ((flash4.FuelAlgorithm & 0xF0) != 0x50)) {
                        utmp1 = intrp_2dctable(outpc.rpm, outpc.fuelload2, NO_FRPMS, NO_FMAPS,
                                &pg9_ptr->frpm_tables.frpm_tablevS[1][0], &pg9_ptr->fmap_tables.fmap_tablevS[1][0],
                                (unsigned char *)&pg9_ptr->ve_tables.ve_tableS[1][0][0], 1);
                        if (flash4.loadopts & 0x1) {
                            outpc.vecurr1 = ((long)tmp1 * utmp1) / 1000;
                        } else {
                            outpc.vecurr1 = tmp1 + utmp1;
                        }
                    } else {
                        outpc.vecurr1 = tmp1;
                    }
                }
                // cannot have DT and secondary load tables - check in tuning SW
                if(flash4.dual_tble_optn) {
                    outpc.vecurr2 = intrp_2dctable(outpc.rpm, outpc.fuelload, NO_FRPMS, NO_FMAPS,   // should we use outpc.fuelload2 ?
                            &pg9_ptr->frpm_tables.frpm_tablevS[1][0], &pg9_ptr->fmap_tables.fmap_tablevS[1][0], 
                            (unsigned char *)&pg9_ptr->ve_tables.ve_tableS[1][0][0], 1); // in %
                } else {
                    outpc.vecurr2 = outpc.vecurr1;
                }

                if (((flash8.seq_inj & 0x03) == 3) && (seq_inj_ctrl & SEQ_HYBRID)) {
                    outpc.vecurr2 = 0;
                }
                if ((flash8.seq_inj & 0x03) && (pg8_ptr->seq_inj & 0x10)) {
                    outpc.vetrim[0] = intrp_2dctable_signed_3a(outpc.rpm, outpc.fuelload, NO_FRPMS, NO_FMAPS,
                            &pg8_ptr->frpm_tables.frpm_trimvS[0], &pg8_ptr->fmap_tables.fmap_trimvS[0], 
                            (unsigned char *)&pg8_ptr->ve_tables.ve_trim1S[0][0]); // in .1 %
                    for (ix = 0; ix < no_inj -1; ix++) {
                        outpc.vetrim[ix+1] = intrp_2dctable_signed_3a(outpc.rpm, outpc.fuelload, NO_FRPMS, NO_FMAPS,
                                &pg11_ptr->frpm_tables.frpm_trimvS[ix][0], &pg11_ptr->fmap_tables.fmap_trimvS[ix][0], 
                                (unsigned char *)&pg11_ptr->ve_tables.ve_trimS[ix][0][0]); // in .1 %
                    }
                    if (flash10.staged & 0x7) {
                        if (no_inj == 1) {
                            outpc.vetrim[1] = outpc.vetrim[0];
                        } else {
                            outpc.vetrim[2] = outpc.vetrim[0];
                            outpc.vetrim[3] = outpc.vetrim[1];
                        }
                    }
                }
            } else {  // 16x16 tables
                if ((uctmp == 1) || (((flash8.seq_inj & 0x03) == 3) && (seq_inj_ctrl & SEQ_HYBRID))) {
                    // using table switching will disable secondary load table
                    // grab VE from table 3
                    if ((flash4.FuelAlgorithm & 0xF) != 5) {
                        outpc.vecurr1 = intrp_2dctable(outpc.rpm, outpc.fuelload, NO_EXFRPMS, NO_EXFMAPS,
                                &pg9_ptr->frpm_tables.frpm_tablevL[2][0], &pg9_ptr->fmap_tables.fmap_tablevL[2][0], 
                                (unsigned char *)&pg9_ptr->ve_tables.ve_tableL[2][0][0], 1); // in .1 %
                    } else {
                        outpc.vecurr1 = 1000;
                    }
                } else {
                    if ((flash4.FuelAlgorithm & 0xF) != 5) {
                        tmp1 = intrp_2dctable(outpc.rpm, outpc.fuelload, NO_EXFRPMS, NO_EXFMAPS,
                                &pg9_ptr->frpm_tables.frpm_tablevL[0][0], &pg9_ptr->fmap_tables.fmap_tablevL[0][0], 
                                (unsigned char *)&pg9_ptr->ve_tables.ve_tableL[0][0][0], 1); // in .1%
                    } else {
                        tmp1 = 1000;
                    }

                    if ((flash4.FuelAlgorithm & 0xF0) && ((flash4.FuelAlgorithm & 0xF0) != 0x50)) {
                        utmp1 = intrp_2dctable(outpc.rpm, outpc.fuelload2, NO_EXFRPMS, NO_EXFMAPS,
                                &pg9_ptr->frpm_tables.frpm_tablevL[1][0], &pg9_ptr->fmap_tables.fmap_tablevL[1][0],
                                (unsigned char *)&pg9_ptr->ve_tables.ve_tableL[1][0][0], 1);
                        if (flash4.loadopts & 0x1) {
                            outpc.vecurr1 = ((long)tmp1 * utmp1) / 1000;
                        } else {
                            outpc.vecurr1 = tmp1 + utmp1;
                        }
                    } else {
                        outpc.vecurr1 = tmp1;
                    }
                }
                // cannot have DT and secondary load tables - check in tuning SW
                if(flash4.dual_tble_optn) {
                    outpc.vecurr2 = intrp_2dctable(outpc.rpm, outpc.fuelload, NO_EXFRPMS, NO_EXFMAPS,
                            &pg9_ptr->frpm_tables.frpm_tablevL[1][0], &pg9_ptr->fmap_tables.fmap_tablevL[1][0], 
                            (unsigned char *)&pg9_ptr->ve_tables.ve_tableL[1][0][0], 1); // in %
                } else {
                    outpc.vecurr2 = outpc.vecurr1;
                }
                if (((flash8.seq_inj & 0x03) == 3) && (seq_inj_ctrl & SEQ_HYBRID)) {
                    outpc.vecurr2 = 0;
                }
                if ((flash8.seq_inj & 0x03) && (pg8_ptr->seq_inj & 0x10)) {
                    outpc.vetrim[0] = intrp_2dctable_signed_3a(outpc.rpm, outpc.fuelload, NO_EXFRPMS, NO_EXFMAPS,
                            &pg8_ptr->frpm_tables.frpm_trimvL[0], &pg8_ptr->fmap_tables.fmap_trimvL[0], 
                            (unsigned char *)&pg8_ptr->ve_tables.ve_trim1L[0][0]); // in .1 %
                    for (ix = 0; ix < no_inj -1; ix++) {
                        outpc.vetrim[ix+1] = intrp_2dctable_signed_3a(outpc.rpm, outpc.fuelload, NO_EXFRPMS, NO_EXFMAPS,
                                &pg11_ptr->frpm_tables.frpm_trimvL[ix][0], &pg11_ptr->fmap_tables.fmap_trimvL[ix][0], 
                                (unsigned char *)&pg11_ptr->ve_tables.ve_trimL[ix][0][0]); // in .1 %
                    }
                }
            }


            realtime();
            /**************************************************************************
             **
             ** Computation of Fuel Parameters
             ** Note that GAMMAE only includes Warm, Tpsfuelcut, Barocor, and Aircor
             ** (EGO no longer included)
             **
             **************************************************************************/
            lsum = ((outpc.warmcor * (long)outpc.tpsfuelcut) / 100);
            lsum = (lsum * ((outpc.barocor * (long)outpc.aircor) / 100)/100);
            outpc.gammae = (int)lsum;
            if (flagbyte6 & FLAGBYTE6_USE_MAF) {
                lsum2 = outpc.mafmap;
                local_div = 1000;
            } else {
                if(flash4.loadopts & 0x4) {
                    lsum2 = (long)outpc.map;
                } else {
                    lsum2 = 1000;                // normalizes to ~1 when divide by baro
                }
                local_div = outpc.baro;
            }

            lsum1 = (lsum * ((outpc.egocor1 * lsum2) / local_div)/100);
            lsum1 = lsum1 * ((outpc.vecurr1 * (long)flash4.ReqFuel)/ 10000); // .01 usec
                    if (((flash8.seq_inj & 0x03) == 3) && (seq_inj_ctrl & SEQ_HYBRID)) {
                            lsum1 *= 2; // double the reqfuel do to the single pulse
                    }
            lsum2 = (lsum * ((outpc.egocor2 * lsum2) / local_div)/100);
            lsum2 = lsum2 * ((outpc.vecurr2 * (long)flash4.ReqFuel)/ 10000); // .01 usec

            if (flash4.loadopts & 0x8) { /* factor in afr target */
                lsum1 = (lsum1 * (long)flash4.stoich) / (long)gl_afrtgt1;
                if (flash4.dual_tble_optn) {
                    lsum2 = (lsum2 * (long)flash4.stoich) / (long)gl_afrtgt2;
                } else {
                    lsum2 = (lsum2 * (long)flash4.stoich) / (long)gl_afrtgt1;
                }
            }

            calc_opentime();

            /**************************************************************************
             **
             ** Calc. of Flex Fuel Sensor %alcohol and PW,spk correction (fuelcor,ffspkdel)
             **
             **************************************************************************/
            if(flash4.FlexFuel)  {
                                calc_flexfuel();
                lsum1 = (lsum1 * outpc.fuelcor)/ 100;           // usec
                lsum2 = (lsum2 * outpc.fuelcor)/ 100;           // usec
            }
            else  {            // no flex fuel or fuel sensor not yet ready/ broken
                outpc.fuelcor = 100; // %
                ffspkdel = 0;                        // degx10
            }

            realtime();
            /**************************************************************************
             **
             ** Calculation of Fuel Pulse Width
             **
             **************************************************************************/
            lsum = (long)outpc.tpsaccel * 10000;     // .01 usec
            if (lsum1 > 0) {
                lsum1 += lsum;      // usec
            }
            tmp_pw1 = lsum1;
            if (lsum2 > 0) {
                lsum2 += lsum;      // usec
            }
            tmp_pw2 = lsum2;
            if(outpc.status3 & status3_cut_fuel)  {
                tmp_pw1 = 0;
                tmp_pw2 = 0;
            }

            /**************************************************************************
             **
             ** Over Run Fuel Cut
             **
             **************************************************************************/
            if (flash5.feature5_0 & 0x1) {
                if ((outpc.rpm > flash5.fc_rpm) && (outpc.map < flash5.fc_kpa)
                        && (outpc.tps < flash5.fc_tps) && (outpc.clt > flash5.fc_clt) ) {
                    if (fc_counter == 0) {
                        tmp_pw1 = 0; // fuel cut to zero
                        tmp_pw2 = 0;
                        fc_off_time = 0xff;
                    } else if (fc_counter > flash5.fc_delay) {
                        fc_counter = flash5.fc_delay;
                    }
                } else if ((outpc.rpm < flash5.fc_rpm_lower) || (outpc.map >= flash5.fc_kpa) ||
                           (outpc.tps >= flash5.fc_tps) || (outpc.clt <= flash5.fc_clt)) {
                    fc_counter = 0xff;
                    if (fc_off_time == 0xff) {
                        fc_off_time = 0;
                    }
                } else {
                    /* if we're here, we're in hysteresis, so if the counter is < 0
                     * and none of the other conditions are above the threshold
                     * yet, continue cutting fuel
                     */
                    if (fc_counter == 0) {
                        tmp_pw1 = 0;
                        tmp_pw2 = 0;
                        fc_off_time = 0xff;
                    }
                }
            } else {
                fc_counter = 0xff;
                fc_off_time = 0xff;
            }

            /**************************************************************************
             ** Additional fuel from nitrous. Zero if unused.
             **************************************************************************/
            if (flash4.dual_tble_optn) {
                if (flash10.N2Oopt & 1) {
                    tmp_pw1 += (unsigned long)n2o_addfuel * 100;
                    goto DONE_ADD_N2O;
                } else if (flash10.N2Oopt & 2) {
                    tmp_pw2 += (unsigned long)n2o_addfuel * 100;
                    goto DONE_ADD_N2O;
                }
            }
            tmp_pw1 += (unsigned long)n2o_addfuel * 100;
            tmp_pw2 += (unsigned long)n2o_addfuel * 100;

DONE_ADD_N2O:

CHECK_STAGED:
            if (flash10.staged & 0x7) {
                            if (seq_inj_ctrl & SEQ_STD_INJ) {
                                    calc_staged_pw(tmp_pw1, 0);

                        tmp_pw1 = pw_staged1;
                        tmp_pw2 = pw_staged2;
                            } else {
                                    pw_staged3 = pw_staged4 = 0;  // Needed to reset them if tmp_pw2 changes to 0

                                    calc_staged_pw(tmp_pw1, tmp_pw2);

                        tmp_pw1 = pw_staged1;
                        tmp_pw2 = pw_staged3;
                                    tmp_pw3 = pw_staged2;
                                    tmp_pw4 = pw_staged4;
                            }
            }

            run_EAE_calcs();
            if ((flash10.staged & 0x7) && !(seq_inj_ctrl & SEQ_STD_INJ)) {
                unsigned long ttmppw1, ttmppw2;
                ttmppw1 = tmp_pw1;
                ttmppw2 = tmp_pw2;
                tmp_pw1 = tmp_pw3;
                tmp_pw2 = tmp_pw4;
                run_EAE_calcs();
                tmp_pw3 = tmp_pw1;
                tmp_pw4 = tmp_pw2;
                tmp_pw1 = ttmppw1;
                tmp_pw2 = ttmppw2;
            }

            /**************************************************************************
             ** Set pulse widths 3 and 4 and Add VE trim
             **************************************************************************/
            if (flash8.seq_inj & 0x03) {
                if (no_inj > 2) {
                    tmp_pw3 = tmp_pw1;
                    tmp_pw4 = tmp_pw2;
                }
                if (pg8_ptr->seq_inj & 0x10)
                add_vetrim();
            }
            localflags &= ~LOCALFLAGS_RUNFUEL;
        }

        realtime();
        /**************************************************************************
         **
         ** Calculation of Knock retard, Distributor Advance & coil charge time correction
         **
         **************************************************************************/
KNK:
        if (flash4.knk_option & 0x03) {
            // read from digi ports and set outpc var (only using 1 bit of a uint)
            // Want to display this on the dash even if outside window
                        if (flash4.knk_option & 0x08) {
                                // Remote knock input
                                unsigned char tmp_knk;
                                tmp_knk = outpc.gpioport[2] & (1<<flash4.knkport_remote);
                                if ( ((flash4.knk_option & 0x10) && (tmp_knk)) // high input
                                        || ((!(flash4.knk_option & 0x10)) && (!(tmp_knk))) ) {
                                        outpc.knock = 1;
                                } else {
                                        outpc.knock = 0;
                                }
                        } else {
                                // Local knock input pin
                    if (flash4.knk_option & 0x04) { // option AD6/JS5
                        if ( ((flash4.knk_option & 0x10) && (PTAD & 0x40)) // high input
                            || ((!(flash4.knk_option & 0x10)) && (!(PTAD & 0x40))) ) {
                            outpc.knock = 1;
                        } else {
                            outpc.knock = 0;
                        }
                    } else { // default AD7/JS4
                        if ( ((flash4.knk_option & 0x10) && (PTAD & 0x80)) // high input
                            || ((!(flash4.knk_option & 0x10)) && (!(PTAD & 0x80))) ) {
                            outpc.knock = 1;
                        } else {
                            outpc.knock = 0;
                        }
                                }
            }
        }

        if(!(flash4.knk_option & 0x03) ||
                (outpc.map > flash4.knk_maxmap) || (outpc.rpm < flash4.knk_lorpm) ||
                (outpc.rpm > flash4.knk_hirpm))  {  // no knock correction
            outpc.knk_rtd = 0;
        } else {   // latch any knocks that occur during the knk_clk_test interval
            // knock input active?
            if (outpc.knock) {
                // signal(Vx100) indicates knock occurred
                if(knk_count < 255)              // don't want to overflow to 0
                    knk_count++;
                if((knk_stat == 0) && (knk_count > flash4.knk_ndet))
                    knk_clk = knk_clk_test;             // just caught knock - force 1st retard
                // immediately (as fast as main loop allows)
            }
            if(knk_clk >= knk_clk_test)  {       // time to check for retard/ adv spark
                if(knk_count > flash4.knk_ndet)  {        // got valid knock. req ndet consec
                    // knocks to be sure
                    knk_clk_test = flash4.knk_trtd;
                    if(knk_stat == 4)   // thought had enough retard, but need more
                        knk_stat = 2;
                    if(knk_stat < 2)
                        uctmp = flash4.knk_step1;               // haven't stopped knock yet
                    else
                        uctmp = flash4.knk_step2;               // stopped once - use smaller step
                    uctmp = outpc.knk_rtd + uctmp;
                    if(uctmp < flash4.knk_maxrtd)
                        outpc.knk_rtd = uctmp;
                    else
                        outpc.knk_rtd = flash4.knk_maxrtd;
                    if(knk_stat == 0)                                   // 1st knock
                        knk_stat = 1;
                    else if(knk_stat == 2)      {  // this is knk returning due to too much adv
                        if((flash4.knk_option & 0x03) == 1)      // operate one step below knock
                            knk_stat = 3;
                    }
                } else {                                       // did not get unambiguous knock
                    knk_clk_test = flash4.knk_tadv;             // change time interval
                    //switch causes gcc complaints about banked memory
                    //                    switch (knk_stat)  {
                    //                        case 0:
                    if ((knk_stat == 1) || (knk_stat == 2)) {
                        //                            break;
                        //                        case 1:
                        //                        case 2:
                        if((knk_stat == 2) && (outpc.knk_rtd == 0))
                            knk_stat = 0;  // back to table value & no knock- restart process
                        else  {
                            if(outpc.knk_rtd >= flash4.knk_step2)
                                outpc.knk_rtd -= flash4.knk_step2;   // remove some retard
                            else
                                outpc.knk_rtd = 0;
                            knk_stat = 2;                       // had knock, eliminated it, now try get closer
                            //  to threshhold
                        }
                    } else if (knk_stat == 3) {
                        //                            break;
                        //                        case 3:    // had knock, eliminated it, couldn't get closer to thresh
                        // This is as good as can get; save tps, rpm
                        knk_tble_adv = outpc.adv_deg;
                        knk_stat = 4;
                    } else if (knk_stat == 4) {
                        //                            break;
                        //                        case 4:               // maintain status until knock or change in tps or map
                        tmp1 = outpc.adv_deg - knk_tble_adv;
                        if(tmp1 < 0)tmp1 = -tmp1;
                        if(tmp1 > flash4.knk_dtble_adv)  {
                            outpc.knk_rtd = 0;    // conditions changed- restart process
                            knk_stat = 0;
                        }
                        //                            break;
                    }    // end status switch
                }
                knk_count = 0;
                knk_clk = 0;
                }
            }

//DIST_ADV:
            // Table switching
            uctmp = 0; //uctmp is local tmp var
            // nitrous control will also use this var as pin behaviour will be different
            //note: doesn't block DT as not believed to have any effect
            if ((flash4.userlevel > 127) && (flash5.feature5_0 & 0x10) ) { // user advanced enough and table switching
                if ((flash5.feature5_0 & 0x60) == 0) {
                                        if (flash5.ts_remote & 0x10) {
                                                // Remote switch
                                if (!(outpc.gpioport[2] & (0x01 << (flash5.ts_remote>>5)))) {
                                    uctmp = 1;
                                }
                                        } else {
                                                // Local switch
                            if (!(PORTE & 0x2)) { // the bastard pin. Pullup always enabled.
                                uctmp = 1;
                            }
                                        }
                } else if ((flash5.feature5_0 & 0x60) == 0x20) {
                    if (outpc.rpm > flash5.tss_rpm) {
                        uctmp = 1;
                    }
                } else if ((flash5.feature5_0 & 0x60) == 0x40) {
                    if (outpc.map > flash5.tss_kpa) {
                        uctmp = 1;
                    }
                } else if ((flash5.feature5_0 & 0x60) == 0x60) {
                    if (outpc.tps > flash5.tss_tps) {
                        uctmp = 1;
                    }
                }
            }

            if (uctmp) {
                outpc.status1 |= status1_stblsw;
            } else {
                outpc.status1 &= ~status1_stblsw;
            }

            realtime();
            // Calculate ignition advance
            if (outpc.engine & ENGINE_CRANK) {
                if ( ((spkmode == 2) || (spkmode == 3) || (spkmode == 14) )&& (flash4.adv_offset <= 200) ) {  //2,3
                    lsum = flash4.adv_offset; // next-cyl fire at trigger on in dizzy modes
                } else {
                    lsum = flash4.crank_timing;
                }
            } else if (pg4_ptr->timing_flags & TIMING_FIXED) {
                lsum = pg4_ptr->fixed_timing;
            } else {
                

                if (uctmp) { // table switching
                    lsum = intrp_2ditable(outpc.rpm, outpc.ignload, NO_SRPMS, NO_SMAPS,
                            &pg8_ptr->srpm_table3[0], &pg8_ptr->smap_table3[0], (int *)&pg8_ptr->adv_table3[0][0]);
                } else {
                    lsum = intrp_2ditable(outpc.rpm, outpc.ignload, NO_SRPMS, NO_SMAPS,
                            &pg10_ptr->srpm_table[0][0], &pg10_ptr->smap_table[0][0], (int *)&pg10_ptr->adv_table[0][0][0]);
                }

                if (flash8.idle_special_ops & IDLE_SPECIAL_OPS_IDLEADVANCE) {
                    if ((outpc.tps < flash8.idleadvance_tps) &&
                    (outpc.rpm < flash8.idleadvance_rpm) &&
                    (outpc.fuelload > flash8.idleadvance_load) &&
                    (outpc.clt > flash8.idleadvance_clt)) {
                        if((idle_advance_timer >= flash8.idleadvance_delay) &&
                           (flagbyte4 & flagbyte4_idleadvreset)) {
                            /* deg x 10 */
                            lsum = intrp_1ditable(outpc.fuelload, 4, (int *)pg8_ptr->idleadvance_loads, 1,
                                                 (int *)pg8_ptr->idleadvance_curve);
                        } else {
                            if (!(flagbyte4 &flagbyte4_idleadvreset)) {
                                DISABLE_INTERRUPTS;
                                idle_advance_timer = 0;
                                ENABLE_INTERRUPTS;
                                flagbyte4 |= flagbyte4_idleadvreset;
                            }
                        }
                    } else {
                        flagbyte4 &= ~flagbyte4_idleadvreset;
                    }
                }

                lsum += outpc.cold_adv_deg - outpc.knk_rtd; // degx 10
                // Subtract retard vs manifold air temp
                lsum -= intrp_1dctable(outpc.mat, NO_MAT_TEMPS, (int *)flash5.MatTemps, 0, (unsigned char *)flash5.MatSpkRtd);    // %
                // correct for flex fuel;
                lsum += ffspkdel;    // degx10
                /* If the second table is enabled, use it */
                if (flash4.IgnAlgorithm & 0xF0) {
                    lsum2 = intrp_2ditable(outpc.rpm, outpc.ignload2, NO_SRPMS, NO_SMAPS,
                            &pg10_ptr->srpm_table[1][0], &pg10_ptr->smap_table[1][0], (int *)&pg10_ptr->adv_table[1][0][0]);
                    /* Ign only additive */
                    lsum += lsum2;
                }
                // rev limit
                if(flash4.RevLimOption & 1)  {
                    if(outpc.rpm > RevLimRpm2)
                        lsum -= flash4.RevLimMaxRtd;                  // deg x 10
                    else if(outpc.rpm > RevLimRpm1)  {
                        lsum -= (((long)flash4.RevLimMaxRtd*(outpc.rpm- RevLimRpm1))/
                                (RevLimRpm2 - RevLimRpm1));             // deg x 10
                    }
                }
            }


            // check for spark cut rev limiting
            outpc.status2 &= ~status2_spkcut; //global var but only used here
            // do launch in here too
            // not quite right yet, launch/flat shift transition doesn't appear to work right

            if ((flash4.userlevel > 127) && (flash10.launch_opt & 0x40)
                    && (outpc.tps > flash10.launch_tps)) {
                unsigned char lcmode; // saves gcc suboptimal code
                //check if the chosen pin is low
                lcmode = flash10.launch_opt & 0x3f;
                if (lcmode == 0) {
                    if (!(PORTE & 0x01)) goto DO_LAUNCH;
                } else if (lcmode == 1) {
                    if (!(PORTE & 0x02)) goto DO_LAUNCH;
                } else if (lcmode == 2) {
                    if (!(PORTT & 0x20)) goto DO_LAUNCH;
                } else if (lcmode == 3) {
                    if (!(PORTA & 0x01)) goto DO_LAUNCH;
                } else if (lcmode == 4) {
                    if (!(PTAD & 0x40)) goto DO_LAUNCH;
                } else if (lcmode == 5) {
                    if (!(PTAD & 0x80)) goto DO_LAUNCH;
                } else {
                                        // Remote port
                                        if (!(outpc.gpioport[2] & (0x01<<(lcmode-6)))) goto DO_LAUNCH;
                                }
                // nothing active
                if (outpc.status2 & status2_launch) { // if we were on, then set nitrous delay timer
                    if (flash10.launch_opt & 0x80) {
                        n2o_act_timer = flash10.N2Odel_flat;  //flat shift timer
                    } else {
                        n2o_act_timer = flash10.N2Odel_launch;  //launch timer
                    }
                }

                outpc.status2 &= ~(status2_launch | status2_flatshift); // turn off both
                goto NO_LAUNCH;

DO_LAUNCH:
                if (!(outpc.status2 & status2_launch)) {
                    outpc.status2 |= status2_launch; // turn it on (code below shuts down nitrous immediately)
                    if ((flash10.launch_opt & 0x80) && (outpc.rpm > flash10.flats_arm)) {
                        outpc.status2 |= status2_flatshift; // turn it on
                    }
                }
                if (outpc.status2 & status2_flatshift) {
                    // use flat shift limits
                    if (outpc.rpm > flash10.flats_sft) {
                        lsum = (long)flash10.flats_deg;
                    }
                    if (outpc.rpm > flash10.flats_hrd) {
                        if(flash10.launchlimopt & 1)  {
                            spk_cutx = flash10.launchcutx;
                            spk_cuty = flash10.launchcuty;
                            outpc.status2 |= status2_spkcut;
                        }
                        if(flash10.launchlimopt & 2)  {
                            tmp_pw1=0;
                            tmp_pw2=0;
                            if (!(seq_inj_ctrl & SEQ_STD_INJ)) {
                                    tmp_pw3 = 0;
                                    tmp_pw4 = 0;
                            }
                        }
                    }
                } else {
                    // use launch limits

                    if (outpc.rpm > flash10.launch_sft_lim) {
                        lsum = (long)flash10.launch_sft_deg;
                    }
                    if (outpc.rpm > flash10.launch_hrd_lim) {
                        if(flash10.launchlimopt & 1)  {
                            spk_cutx = flash10.launchcutx;
                            spk_cuty = flash10.launchcuty;
                            outpc.status2 |= status2_spkcut;
                        }
                        if(flash10.launchlimopt & 2)  {
                            tmp_pw1=0;
                            tmp_pw2=0;
                                                        if (!(seq_inj_ctrl & SEQ_STD_INJ)) {
                                                                tmp_pw3 = 0;
                                                                tmp_pw4 = 0;
                                                        }
                        }
                    }
                }
            }
NO_LAUNCH:
//            realtime();

            /**************************************************************************
             **
             ** Nitrous
             **
             **************************************************************************/
            if (flash10.N2Oopt & 0x04) {  // are we using nitrous at all
                if (outpc.status2 & status2_launch) {
                    outpc.status2 &= ~status2_nitrous1;
                    outpc.status2 &= ~status2_nitrous2;
                    goto NITROUS_OUTPUTS;
                }
                // is enable input on
                unsigned char nmode; // saves gcc suboptimal code
                //check if the chosen pin is low
                                if (flash10.N2Oremote & 0x01) {
                                        // Remote port
                        nmode = 0x01 << ((flash10.N2Oremote & 0x1C)>>2);
                    if (!(outpc.gpioport[2] & nmode)) goto DO_NITROUS;
                                } else {
                        nmode = flash10.N2Oopt & 0x70;
                        if (nmode == 0x00) {
                            if (!(PORTE & 0x01)) goto DO_NITROUS;
                        } else if (nmode == 0x10) {
                            if (!(PORTE & 0x02)) goto DO_NITROUS;
                        } else if (nmode == 0x20) {
                            if (!(PORTT & 0x20)) goto DO_NITROUS;
                        } else if (nmode == 0x30) {
                            if (!(PORTA & 0x01)) goto DO_NITROUS;
                        } else if (nmode == 0x40) {
                            if (!(PTAD & 0x40)) goto DO_NITROUS;
                        } else if (nmode == 0x50) {
                            if (!(PTAD & 0x80)) goto DO_NITROUS;
                        }
                                }
                // no valid input so turn it off
                outpc.status2 &= ~status2_nitrous1;
                outpc.status2 &= ~status2_nitrous2;
                n2o_addfuel = 0;
                goto NITROUS_OUTPUTS;
DO_NITROUS:
                // selection logic
                if ( (outpc.rpm > flash10.N2ORpm) && (outpc.rpm < flash10.N2ORpmMax) 
                        && (outpc.tps > flash10.N2OTps) && (outpc.clt > flash10.N2OClt) && (n2o_act_timer == 0) ) {
                    if (!(outpc.status2 & status2_nitrous1)) {
                        n2o2_act_timer = flash10.N2O2delay; // if first change then set delay to stage 2
                    }
                    outpc.status2 |= status2_nitrous1;
                    n2o_addfuel = twoptlookup(outpc.rpm, flash10.N2ORpm, flash10.N2ORpmMax, flash10.N2OPWLo, flash10.N2OPWHi);
                    lsum -= flash10.N2OAngle; // retard timing

                    // if stage 1 on, then check for stage 2
                    if ( (flash10.N2Oopt & 0x08) && (outpc.rpm > flash10.N2O2Rpm) && (outpc.rpm < flash10.N2O2RpmMax) 
                            && (n2o2_act_timer == 0)) {
                        outpc.status2 |= status2_nitrous2;
                        n2o_addfuel += twoptlookup(outpc.rpm, flash10.N2O2Rpm, flash10.N2O2RpmMax, flash10.N2O2PWLo, flash10.N2O2PWHi);
                        lsum -= flash10.N2O2Angle; // retard timing
                    } else {
                        outpc.status2 &= ~status2_nitrous2; // if stage1 is off then so is stage2
                    }

                } else {
                    outpc.status2 &= ~status2_nitrous1;
                    outpc.status2 &= ~status2_nitrous2; // if stage1 is off then so is stage2
                    n2o_addfuel = 0;
                }


NITROUS_OUTPUTS:
                // here we flip the bits for chosen output pins
                                if (flash10.N2Oremote & 0x02) {
                                        // Remote port
                                        nmode = 0x01 << (flash10.N2Oremote>>5);
                                        // stage 1
                                        if (outpc.status2 & status2_nitrous1) {
                                                outpc.gpioport[0] |= nmode; // turn on
                                        } else {
                                                outpc.gpioport[0] &= ~nmode; // turn off
                                        }

                                        if (flash10.N2Oopt & 0x08) {
                                                // stage 2
                                                nmode++;
                                                if (outpc.status2 & status2_nitrous2) {
                                                        outpc.gpioport[0] |= nmode; // turn on
                                                } else {
                                                        outpc.gpioport[0] &= ~nmode; // turn off
                                                }
                                        }
                                } else {
                        if (flash10.N2Oopt & 0x80) { // FIDLE + D15
                            // stage 1
                            if (outpc.status2 & status2_nitrous1) {
                                PORTM |= 0x04; // turn on FIDLE
                            } else {
                                PORTM &= ~0x04; // turn off
                            }

                            if (flash10.N2Oopt & 0x08) {
                                // stage 2
                                if (outpc.status2 & status2_nitrous2) {
                                    PORTM |= 0x20; // turn on D15
                                } else {
                                    PORTM &= ~0x20; // turn off
                                }
                            }
                        } else { // IAC 1+2
                            // stage 1
                            if (outpc.status2 & status2_nitrous1) {
                                PORTT |= 0x80; // turn on IAC1
                            } else {
                                PORTT &= ~0x80; // turn off
                            }

                            if (flash10.N2Oopt & 0x08) {
                                // stage 2
                                if (outpc.status2 & status2_nitrous2) {
                                    PORTT |= 0x40; // turn on IAC2
                                } else {
                                    PORTT &= ~0x40; // turn off
                                }
                            }
                        }
                                }
            }

            /**************************************************************************/
            if ((spkmode == 2) || (spkmode == 3) || (spkmode == 14)) { // 2,3,14 dizzy or twin trigger
                if (pg4_ptr->adv_offset < 200) { // next cyl
                    // allow at least 1 deg ahead of trigger
                    if (lsum < (pg4_ptr->adv_offset + 10)) {
                        lsum = pg4_ptr->adv_offset + 10;
                    }
                } else { // this cyl
                    // allow at least 5 deg after trigger
                    if (lsum > (pg4_ptr->adv_offset - 50)) {
                        lsum = pg4_ptr->adv_offset - 50;
                    }
                }
            }

          	lsum += datax1.SpkAdj;     // degx10 - adjustment from remote CAN device (dangerous)

            outpc.adv_deg = (int)lsum;  // Report advance before we fudge it

            /* check for difference between flash and ram trigger angles (trigger wizard?) for on-the-fly adjustment */
            if (pg4_ptr->adv_offset != flash4.adv_offset) {
                lsum += flash4.adv_offset - pg4_ptr->adv_offset;
            }

            /* ONLY FOR TRIGGER WHEEL - check for difference between flash and ram tooth #1 angles for on-the-fly adjustment */
            if ((spkmode == 4) && (pg4_ptr->Miss_ang != flash4.Miss_ang)) {
                lsum += flash4.Miss_ang - pg4_ptr->Miss_ang;
            }

            if (lsum < -100) {
                lsum = -100;
            }
            /* ROTARY */
            if (flash10.RotarySplitMode & 0x20) {
                if (outpc.engine & ENGINE_CRANK) {
                    lsum1 = flash4.crank_timing;
                } else if (pg4_ptr->timing_flags & TIMING_FIXED) {
                    lsum1 = pg4_ptr->fixed_timing;
                } else {
                    lsum1 = intrp_2ditable(outpc.rpm, outpc.fuelload, 8, 8, &pg10_ptr->RotarySplitRPM[0],
                            &pg10_ptr->RotarySplitMAP[0], (int *)&pg10_ptr->RotarySplitTable[0][0]);
                    if (!(pg10_ptr->RotarySplitMode & ROTARY_SPLIT_ALLOW_NEG_SPLIT)) {
                        if (lsum1 < 0) {
                            lsum1 = 0;
                        }
                    }

                    /* now since split is with reference to the leading timing, add split to leading timing */
                    lsum1 = lsum - lsum1;
                }
            }

            /* Fuel injection timing */ 
                if ((flash8.seq_inj & 0x03) != 0) {     
                    if (outpc.engine & ENGINE_CRANK) {  // cranking
                    lsum2 = flash8.inj_adv_crank[0];
                    } else if (pg8_ptr->seq_inj & 0x20) {  // use table
                                        if (((flash8.seq_inj & 0x03) == 3) && (seq_inj_ctrl & SEQ_HYBRID)) {
                                                lsum2 = intrp_2ditable(outpc.rpm, outpc.fuelload, 6, 6,
                                                        &pg5_ptr->srpm_inj_adv3[0], &pg5_ptr->smap_inj_adv3[0], (int *)&pg5_ptr->inj_adv_table3[0][0]);
                                        } else {
                                                lsum2 = intrp_2ditable(outpc.rpm, outpc.fuelload, 6, 6,
                                                        &pg8_ptr->srpm_inj_adv[0][0], &pg8_ptr->smap_inj_adv[0][0], (int *)&pg8_ptr->inj_adv_table[0][0][0]);
                                        }
                    } else {  // fixed timing
                                        if ((flash10.staged & 0x7) && (flagbyte4 & flagbyte4_staging_on)) {
                                                if (((flash8.seq_inj & 0x03) == 3) && (seq_inj_ctrl & SEQ_HYBRID)) {
                                                        lsum2 = pg8_ptr->inj_adv_fixed[5];  // staging on
                                                } else {
                                                        lsum2 = pg8_ptr->inj_adv_fixed[3];  // staging on
                                                }
                                        } else {
                                                if (((flash8.seq_inj & 0x03) == 3) && (seq_inj_ctrl & SEQ_HYBRID)) {
                                                        lsum2 = pg8_ptr->inj_adv_fixed[2];  // staging off or not enabled
                                                } else {
                                                        lsum2 = pg8_ptr->inj_adv_fixed[0];  // staging off or not enabled
                                                }
                                        }
                                }

                        outpc.inj_adv1 = (int)lsum2;    

                                /* check for difference between flash and ram trigger angles (trigger wizard?) for on-the-fly adjustment */
                    if (pg4_ptr->adv_offset != flash4.adv_offset) {
                        lsum2 += flash4.adv_offset - pg4_ptr->adv_offset;
                    }
                    if (lsum2 < 0) {
                        lsum2 += cycle_deg;
                    }

                                if ((flash8.seq_inj & 0x03) == 3) {     
                                        if (seq_inj_ctrl & SEQ_HYBRID) {
                                                lsum3 = lsum2 + 3600;
                                        } else if (flash8.seq_inj & 0x08) {     
                                                // Dual timing values
                                    if (outpc.engine & ENGINE_CRANK) {  // cranking
                                    lsum3 = flash8.inj_adv_crank[1];
                                    } else if (pg8_ptr->seq_inj & 0x20) {  // use table
                                                        lsum3 = intrp_2ditable(outpc.rpm, outpc.fuelload, 6, 6,
                                                                        &pg8_ptr->srpm_inj_adv[1][0], &pg8_ptr->smap_inj_adv[1][0], (int *)&pg8_ptr->inj_adv_table[1][0][0]);
                                    } else {  // fixed timing
                                                        if ((flash10.staged & 0x7) && (flagbyte4 & flagbyte4_staging_on)) {
                                                                lsum3 = pg8_ptr->inj_adv_fixed[4];  // staging on
                                                        } else {
                                                                lsum3 = pg8_ptr->inj_adv_fixed[1];  // staging off or not enabled
                                                        }
                                                }
                                                outpc.inj_adv2 = (int)lsum3;    

                                                /* check for difference between flash and ram trigger angles (trigger wizard?) for on-the-fly adjustment */
                                    if (pg4_ptr->adv_offset != flash4.adv_offset) {
                                        lsum3 += flash4.adv_offset - pg4_ptr->adv_offset;
                                    }
                                    if (lsum3 < 0) {
                                        lsum3 += 7200;
                                    }
                                        } else {
                                                lsum3 = lsum2;
                                        }
                                }
                }       

            /* --------------------------------------------------------------------------------------- */
            /* EVERY TOOTH WHEEL DECODER */
            /* --------------------------------------------------------------------------------------- */
EVERY_TOOTH:
//            realtime();
            if (tmp_pw1 > 3200000) {
                tmp_pw1 = 3200000;
            }

            if (tmp_pw2 > 3200000) {
                tmp_pw2 = 3200000;
            }

            if (tmp_pw3 > 3200000) {
                tmp_pw3 = 3200000;
            }

            if (tmp_pw4 > 3200000) {
                tmp_pw4 = 3200000;
            }

            pwcalc1 = tmp_pw1 / 100;
            pwcalc2 = tmp_pw2 / 100;
            if (!(seq_inj_ctrl & SEQ_STD_INJ)) {
                pwcalc3 = tmp_pw3 / 100;
                pwcalc4 = tmp_pw4 / 100;
            }

            if (spkmode > 1) {
                unsigned int rpm;
                signed int inttmp, latency_ang, last_tooth_ang, 
                           last_tooth_ang_prev, spk_req_ang, dwl_req_ang;
                unsigned long max_dwl_time, longtmp;
                unsigned long dtpred_local, dtpred_last_local, dtpred_last_local2, dtpred_last_local3;
                ign_event *dwell_events_fill, *spark_events_fill;
                fuel_event *fuel1_events_fill=NULL, *fuel2_events_fill=NULL, *fuel3_events_fill=NULL, *fuel4_events_fill=NULL;
                ign_time last_tooth_time, spk_time, dwl_time;
                ign_time last_tooth_time_prev;
                unsigned char last_tooth_no, last_tooth_no_prev;
                long longtmp2;

                DISABLE_INTERRUPTS;
                last_tooth_time = tooth_diff_rpm;
                last_tooth_time_prev = tooth_diff_rpm_last;
                dtpred_local = dtpred;
                dtpred_last_local = dtpred_last;
                dtpred_last_local2 = dtpred_last2;
                dtpred_last_local3 = dtpred_last3;
                last_tooth_no = tooth_no_rpm;
                ENABLE_INTERRUPTS;

                // sometimes when reconfiguring spark modes, might get here with last_tooth == 0, which is meaningless
                if (last_tooth == 0) {
                    goto END_WHEEL_DECODER;
                }

                // figure out angle between this tooth and previous one
                // array holds angle _ahead_ of the tooth, so step back a tooth
                last_tooth_no--;
                if ((char)last_tooth_no <=0) {
                    last_tooth_no = last_tooth;
                }
                // make sure we don't land on a zero one
                while ((last_tooth_ang = deg_per_tooth[last_tooth_no-1]) == 0) {
                    last_tooth_no--;
                    if ((char)last_tooth_no <=0) {
                        last_tooth_no = last_tooth;
                    }
                }

                // see if we have new data to look at
                if (tooth_counter_main != tooth_counter) {
                    // Now do this calc
                    // ticks per degree = last_tooth_time / last_tooth_ang
                    // @ 50    rpm   5000    ticks per deg
                    // @ 15000 rpm     16.66 ticks per deg
                    // Would need to say *100 and use a ulong to retain precision
                    // Use ultmp as ticks/deg * 1000 (degs is in 0.1deg)
                    ultmp = (last_tooth_time.time_32_bits * 1000) / (unsigned long)last_tooth_ang;

                    if (outpc.rpm == 1) {
                        // calc better rpm from the ticks/deg
                        outpc.rpm = 25000000L / ultmp;
                    }

                    // figure out how accurately we predicted ticks per deg  -12.7% to +12.7%   
                    // - means current period is shorter, + means current period is longer
                    // Can't easily compute as degree error like in MS2 because we are handling uneven
                    // wheels and the degree error will depend on which tooth we are predicing over
                    // %age should be more meaningful
                    longtmp2 = (long)ultmp - (long)ticks_per_deg;
                    //                  outpc.gpioadc[2] = (signed int)longtmp2; // feedback of actual error
                    longtmp2 = (longtmp2 * 1000) / (long)ultmp;
                    if (longtmp2 < -127) {
                        longtmp2 = -127;
                    } else if (longtmp2 > 127) {
                        longtmp2 = 127;
                    }
                    outpc.timing_err = (char)longtmp2;

                    if (flash4.timing_flags & USE_PREDICTION) {
                        // figure out angle between previous tooth and previous-previous one
                        // array holds angle _ahead_ of the tooth, so step back a tooth
                        last_tooth_no_prev = last_tooth_no - 1;
                        if ((char)last_tooth_no_prev <=0) {
                            last_tooth_no_prev = last_tooth;
                        }
                        // make sure we don't land on a zero one
                        while ((last_tooth_ang_prev = deg_per_tooth[last_tooth_no_prev-1]) == 0) {
                            last_tooth_no_prev--;
                            if (last_tooth_no_prev == 0) {
                                last_tooth_no_prev = last_tooth;
                            }
                        }

                        ultmp2 = (last_tooth_time_prev.time_32_bits * 1000) / (unsigned long)last_tooth_ang_prev;
                        // do first deriv prediction
                        ultmp = (ultmp<<1) - ultmp2;
                    }

                    //DEBUG

                    //              outpc.istatus5 = (unsigned int)ultmp;
                    //              outpc.status4 = (unsigned int) (ultmp >> 16);
                    //              outpc.status3 = (unsigned char) (last_tooth_ang / 10);

                    //          outpc.gpioadc[1] = (unsigned int)ultmp2;
                    //          outpc.gpioadc[0] = (unsigned int) (ultmp2 >> 16);
                    //          outpc.gpioadc[3] = (unsigned int)ticks_per_deg; // store value before we update it

                    //          act_tooth_ang[last_tooth_no-1] = outpc.istatus5; // remember we decremented the last_tooth_no above
                    //          act_tooth_time[last_tooth_no-1] = last_tooth_time;

                    ticks_per_deg = ultmp;
                    // fudge it to say we've done
                    // in next implementation of code will use ring buffer
                    tooth_counter_main = tooth_counter;
                }

                /* want to use alpha-beta-gamma like MS2

                   However MS2 is only doing even wheels so a regular angle between input pulses
                   we are capable of uneven wheels with irregular angles.
                   our base calcs are (scaled)ticks/degree which is similar to the time factor.

                // Predict next tach delta_t 
                errt = dt3[ICint] - dtpred;
                outpc.spare[0] = (int)((outpc.rpm * errt) / 16667); // degx10
                if(!inpram.PredOpt)  {
                // last interval pred.
                dtpred = dt3[ICint];
                }
                else  {
                // alpha-beta-gamma filter prediction
                dts = dtpred + ((inpram.alpha * errt) / 100);
                tddts = tddtpred + ((inpram.beta * errt) / 100);
                t2dddts = t2dddts + ((inpram.gamma * errt) / 100);
                dtpred = dts + tddts + (t2dddts >> 1);
                tddtpred = tddts + t2dddts;
                }
                if(inpram.No_Teeth)  {
                // calculate predicted time per tooth for comparison with measured  
                //  delta_t between teeth to correct OC register 
                dtprdt = dtpred / inpram.No_Skip_Teeth;
                sdtprdt = (unsigned short)dtprdt;
                }

                 */

                if (synch & SYNC_SYNCED) {
                    if (synch & SYNC_RPMCALC) {
                        if ((flash4.ICIgnOption & 0x8) &&
                                ((spkmode == 2) ||
                                 (spkmode == 14) ||
                                 (spkmode == 31)) ) { // oddfire dizzy + twin trigger + fuel only
                            unsigned long tdt,tdl;
                            DISABLE_INTERRUPTS;
                            tdt = tooth_diff_this;
                            tdl = tooth_diff_last;
                            ENABLE_INTERRUPTS;
                            rpm = Rpm_Coeff / ((tdt + tdl)>>1);
                        } else {
                            if (dtpred_local < 2) { // avoid risk of divide by zero
                                rpm = 2;
                            } else {
                                if (flash4.ICIgnOption & 0x8) {
/* always do it the VMAX way as other oddfire engines need it too */
//                                    if (flash4.spk_conf2 & 0x10) {
                                        rpm = Rpm_Coeff / ((dtpred_local + dtpred_last_local + dtpred_last_local2 + dtpred_last_local3) >> 2);
//                                    } else {
//                                        rpm = Rpm_Coeff / ((dtpred_local + dtpred_last_local) >> 1);
//                                    }
                                } else {
                                    rpm = Rpm_Coeff / dtpred_local;
                                }
                            }
                        }
                        if ((flagbyte0 & flagbyte0_firstrpm) == 0) {
                            flagbyte0 |= flagbyte0_firstrpm;
                            outpc.rpm = 1;
                        } else if ((outpc.engine & ENGINE_CRANK) || (outpc.rpm < 3) ) { // skip calc if cranking
                            outpc.rpm = rpm;
                        } else {
                            outpc.rpm += (int)((flash4.rpmLF * ((long)rpm - outpc.rpm)) / 100);
                        }
                        calc_rpmdot();
                        synch &= ~SYNC_RPMCALC;
                    }
                } else {
                    if (!(synch & SYNC_SEMI2)) {
                        outpc.rpm = 0;
                    }
                }

                                if ((flash8.seq_inj & 0x03) == 3) {
                                        if (seq_inj_ctrl & SEQ_HYBRID) {
                                                if (outpc.rpm < hybrid_rpm - hybrid_hyst) {
                                                        seq_inj_ctrl &= ~SEQ_HYBRID;    // Hybrid mode deactivated
                                                }
                                        } else {
                                                if (outpc.rpm > hybrid_rpm) {
                                                        seq_inj_ctrl |= SEQ_HYBRID;             // Hybrid mode activated
                                                }
                                        }
                                }

                /* if we're synced and/or we're supposed to calc */
                if (last_tooth_time.time_32_bits != 0) {
                    if (dwell_events == dwell_events_a) {
                        spark_events_fill = spark_events_b;
                        dwell_events_fill = dwell_events_b;
                    } else {
                        spark_events_fill = spark_events_a;
                        dwell_events_fill = dwell_events_a;
                    }

                    spk_time.time_32_bits = 0;
                    dwl_time.time_32_bits = 0;

                                        if ((flash8.seq_inj & 0x03) != 0) {     
                            if (fuel1_events == fuel1_events_a) {
                                fuel1_events_fill = fuel1_events_b;
                            } else {
                                fuel1_events_fill = fuel1_events_a;
                            }
                            if (fuel2_events == fuel2_events_a) {
                                fuel2_events_fill = fuel2_events_b;
                            } else {
                                fuel2_events_fill = fuel2_events_a;
                            }
                            if (fuel3_events == fuel3_events_a) {
                                fuel3_events_fill = fuel3_events_b;
                            } else {
                                fuel3_events_fill = fuel3_events_a;
                            }
                            if (fuel4_events == fuel4_events_a) {
                                fuel4_events_fill = fuel4_events_b;
                            } else {
                                fuel4_events_fill = fuel4_events_a;
                            }

                            //fuel_time.time_32_bits = 0;
                                        }

                    /* figure out based on period time and num_spk how much time we actually
                     * have for dwell.
                     */

                    if ((flash10.RotarySplitMode & 0x20) || (flagbyte11 & (FLAGBYTE11_DLI4 | FLAGBYTE11_DLI4))) {
                        /* rotary or DLI force 1 */
                        max_dwl_time = dtpred_local;
                    } else if (flash4.ICIgnOption & 0x8) {
                        if (spkmode == 2) {
                         // in odd fire set max dwell for shorter period
                            if (dtpred_last_local < dtpred_local) {
                                max_dwl_time = dtpred_last_local;
                            } else {
                                max_dwl_time = dtpred_local;
                            }
                        } else {
                            // use average time.. might work or not
                            max_dwl_time = ((dtpred_local + dtpred_last_local) >> 1) * num_spk;
                        }
                    } else {
                        max_dwl_time = dtpred_local * num_spk;
                    }

                    // allow for known latency in bit-bash outputs
                    latency_ang = (unsigned int)((unsigned long)(((unsigned long)(OUTPUT_LATENCY + flash4.hw_latency) * 1000) / ticks_per_deg));
                    inttmp = latency_ang + lsum;

                    if ((flash4.dwellmode & 3) == 0) {
                        //normal dwell
                        max_dwl_time -= (flash4.max_spk_dur * 100);
                        if (outpc.engine & ENGINE_CRANK) {
                            utmp2 = flash4.crank_dwell;
                        } else {
                            utmp2 = flash4.max_coil_dur;
                        }
                        utmp1 = utmp2 * coil_dur_table(outpc.batt);
                        // utmp1 /= 50; // this generates silly ASM
                        __asm__ __volatile__ ( "ldx #50\n"
                                "idiv\n"
                                : "=x" (utmp1)
                                : "d" (utmp1) // already in D from previous calc
                                );

                        // prevent under or overflow
                        if (utmp2 == 0) {
                            utmp1 = utmp2;
                        } else if (utmp2 > 255) {
                            utmp1 = 255;
                        }
                    } else if ((flash4.dwellmode & 3) == 1) {
                        //dwell duty
                        if (dtpred > 1500000) {
                            utmp1 = 10000; // top limit, prevents overflow
                        } else {
                            // had to work to avoid overflows in here
                            longtmp = (num_spk * dtpred) / 100; // convert to 0.0667ms units
                            longtmp = longtmp * flash4.dwellduty; // /256 and convert ticks to 0.1ms
                            utmp1 = longtmp / 256;
                        }
                    } else if ((flash4.dwellmode & 3) == 2) {
                        // time after spark (Saab trionic)
                        utmp1 = flash4.dwelltime;
                    } else {
                        utmp1 = 0; // unknown if dwell at trigger
                    }

                    longtmp = (unsigned long)utmp1 * 100;
                    if (longtmp > max_dwl_time) {
                        longtmp = max_dwl_time;
                    }

                    if ((flash4.dwellmode & 3) != 2) {
                        dwell_long = longtmp;
                    }
                    outpc.coil_dur = longtmp / 100; // shows dwell reduction due to spark duration

                    /* END OF DWELL STUFF. NOW DO TIME CALCS */

                    if ( (spkmode == 2) || (spkmode == 3) || (spkmode == 14) ){ // dizzy mode or twin trig
                        // check for out of range advance
                        if (flash4.adv_offset > 200) { // this cyl
                            if (inttmp > (flash4.adv_offset - 10)) {
                                inttmp = flash4.adv_offset - 10; // set to 1 deg less than trigger angle
                            }
                        } else { // next cyl
                            if (inttmp < (flash4.adv_offset + 10)) {
                                inttmp = flash4.adv_offset + 10; // set to 1 deg more than trigger angle
                            }
                        }
                    }

                    spk_req_ang = inttmp; // deg*10

                    // only need spark time to get to dwell time
                    spk_time.time_32_bits = (((unsigned long)inttmp *  ticks_per_deg) / (unsigned long)1000);

                    if (flash4.dwellmode != 2) {
                        // have now calc target dwell. Figure out min/max limits use 10% tolerance
                        if (pg4_ptr->feature4_0 & 0x40) { // underdwell protection
                            mindwl = (unsigned char) (longtmp/240); // 80% convert timer ticks to 0.128ms units
                        } else {
                            mindwl = 0;
                        }
                        nomdwl = (unsigned char) (longtmp/192); // 100% convert timer ticks to 0.128ms units
                        if (pg4_ptr->feature4_0 & 0x8) { // overdwell protection
                            maxdwl = (unsigned char) (longtmp/160); // 120% convert timer ticks to 0.128ms units
                        } else {
                            maxdwl = 255;
                        }
                        dwl_time.time_32_bits = spk_time.time_32_bits + longtmp;
                    } else {
                        mindwl = 0;
                        nomdwl = 0;
                        maxdwl = 255; // maximum
                        dwl_time.time_32_bits = spk_time.time_32_bits - longtmp;
                    }

#if 0
                    if (((spkmode == 2) || (spkmode == 19) || (spkmode == 20) || (spkmode == 4)) && (!(outpc.engine & ENGINE_CRANK))) {

                        /* Set slow dwell timer for dwell on dizzy */
                        if ((spkmode != 4) && (flash4.ICIgnOption & 0x8)) { // oddfire (but not oddfire-even-wheel)
                            dtpred_local = dtpred_local + dtpred_last_local; // combined period
                            dwell_time_slow  = ((((long)dtpred_local * (long)deg_per_tooth[0] / (long)(deg_per_tooth[0] + deg_per_tooth[1])) - longtmp)/192) + 2; // .128ms units (2 counts late so hires gets there first)
                            dwell_time_slowb = ((((long)dtpred_local * (long)deg_per_tooth[1] / (long)(deg_per_tooth[0] + deg_per_tooth[1])) - longtmp)/192) + 2; // .128ms units (2 counts late so hires gets there first)
                            flagbyte4 |= flagbyte4_oddspk; // set flag
                            // try disabling it altogether
                            //                  dwell_time_slow = 0;
                            //                  dwell_time_slowb = 0;
                        } else {
                            dtpred_local = (dtpred_local << 1) - dtpred_last_local;
                            dtpred_local = dtpred_local * num_spk;
                            dwell_time_slow = ((dtpred_local - longtmp)/192) + 2; // .128ms units (2 counts late so hires gets there first)
                            dwell_time_slowb = dwell_time_slow;
                        }
                    } else {
                        dwell_time_slow = 0;
                        dwell_time_slowb = 0;
                    }
#endif

                    // now convert dwell time to an angle using last tooth time
                    dwl_req_ang = (dwl_time.time_32_bits * 1000) / ticks_per_deg;
                    wheel_fill_event_array(spark_events_fill, dwell_events_fill, spk_req_ang,
                            dwl_req_ang, last_tooth_time, last_tooth_ang, 0);


                    if ((spkmode == 2) || (spkmode == 3)) { // 2,3 basic trigger i.e. distributor
                        unsigned int delay_tmp;
                        unsigned int ix;
                        for (ix = 0 ; ix < no_triggers ; ix++) {
                            if (pg4_ptr->adv_offset < 200) { // next cyl
                                if (flash4.ICIgnOption & 0x08) { // oddfire next-cyl
                                    unsigned int iy;
                                    iy = ix;
                                    iy = ix + 1;
                                    if (iy >= no_triggers) {
                                        iy = 0;
                                    }
                                    if (spk_req_ang < pg4_ptr->adv_offset) {
                                        delay_tmp = 0; // can't go later than trigger
                                    } else {
                                        delay_tmp = deg_per_tooth[iy] + pg4_ptr->adv_offset - spk_req_ang;
                                        // for oddfire the calc is divided by two tooth periods so that when use do the calc we can
                                        // still use the last period but the 65536 scaling calc does not overflow
                                        // e.g. if last was 90 deg, but we want to delay 140 deg forwards -> overflow
                                        // now  (140/(90+150) * 65536) = 38229 
                                        dizzy_scaler[ix] = (unsigned int)(((unsigned long)delay_tmp << 16) / (deg_per_tooth[0] + deg_per_tooth[1]));
                                    }
                                } else { // even fire next-cyl
                                    if (spk_req_ang < pg4_ptr->adv_offset) {
                                        delay_tmp = 0; // can't go later than trigger
                                    } else {
                                        delay_tmp = deg_per_tooth[ix] + pg4_ptr->adv_offset - spk_req_ang;
                                        dizzy_scaler[ix] = (unsigned int)(((unsigned long)delay_tmp << 16) / deg_per_tooth[ix]);
                                    }
                                }
                            }  else { // this cyl
                                if (spk_req_ang > (pg4_ptr->adv_offset - 20)) {
                                    delay_tmp = 20; // minimum 2deg delay
                                } else {
                                    delay_tmp = pg4_ptr->adv_offset - spk_req_ang;
                                }
                                if (flash4.ICIgnOption & 0x08) { // oddfire this-cyl
                                    dizzy_scaler[ix] = (unsigned int)(((unsigned long)delay_tmp << 16) / (deg_per_tooth[0] + deg_per_tooth[1]));
                                } else { // evenfire this-cyl
                                    dizzy_scaler[ix] = (unsigned int)(((unsigned long)delay_tmp << 16) / deg_per_tooth[ix]);
                                }
                                if (spkmode == 3) {
                                    // for trigger return set spark timer to fire very late, should only happen if trigger return missed
                                    // and possibly for one spark during crank/run transition
                                    trigret_scaler = (unsigned int)(((unsigned long)pg4_ptr->adv_offset << 16) / deg_per_tooth[ix]);
                                }
                            } 
                        }

                    }  else if (spkmode == 14) { // twin trigger
                        unsigned int delay_tmp;
                        unsigned int ix;
                        for (ix = 0 ; ix < no_triggers ; ix++) {
                            if (pg4_ptr->adv_offset < 200) { // next cyl
                                if (spk_req_ang < pg4_ptr->adv_offset) {
                                    delay_tmp = 0; // can't go later than trigger
                                } else {
                                    delay_tmp = (deg_per_tooth[0] + deg_per_tooth[1]) + pg4_ptr->adv_offset - spk_req_ang;
                                    // for oddfire the calc is divided by two tooth periods so that when use do the calc we can
                                    // still use the last period but the 65536 scaling calc does not overflow
                                    // e.g. if last was 90 deg, but we want to delay 140 deg forwards -> overflow
                                    // now  (140/(90+150) * 65536) = 38229 
                                    dizzy_scaler[ix] = (unsigned int)(((unsigned long)delay_tmp << 16) / (deg_per_tooth[0] + deg_per_tooth[1]));
                                }
                            } else { // this cyl
                                if (spk_req_ang > (pg4_ptr->adv_offset - 20)) {
                                    delay_tmp = 20; // minimum 2deg delay
                                } else {
                                    delay_tmp = pg4_ptr->adv_offset - spk_req_ang;
                                }
                                dizzy_scaler[ix] = (unsigned int)(((unsigned long)delay_tmp << 16) / (deg_per_tooth[0] + deg_per_tooth[1]));
                            }
                        }
                    }

                    wheel_fill_map_event_array(map_start_event, flash4.mapsample_angle, last_tooth_time,
                                               last_tooth_ang); 

                    if ((flash8.seq_inj & 0x03) != 0) {     
                        long fuel_req_ang;

                        fuel_req_ang = calc_fuel_req_ang (lsum2, tmp_pw1, pw_open1);
                        if ((flash8.seq_inj & 0x03) == 1) {     
                            wheel_fill_fuel_event_array(fuel1_events_fill, fuel_req_ang, last_tooth_time, last_tooth_ang, 10);
                        } else if ((flash8.seq_inj & 0x03) == 2) {      
                            wheel_fill_fuel_event_array(fuel1_events_fill, fuel_req_ang, last_tooth_time, last_tooth_ang, 4);
                        } else if ((flash8.seq_inj & 0x03) == 3) {      
                            wheel_fill_fuel_event_array(fuel1_events_fill, fuel_req_ang, last_tooth_time, last_tooth_ang, 2);
                        }

                        if ((flash8.seq_inj & 0x03) == 1) {     
                            if (no_inj > 1) {
                                fuel_req_ang = calc_fuel_req_ang (lsum2, tmp_pw2, pw_open2);
                                wheel_fill_fuel_event_array(fuel2_events_fill, fuel_req_ang, last_tooth_time, last_tooth_ang, 11);
                            } else if ((no_inj == 1) && (flash10.staged & 0x07)) {
                                fuel_req_ang = calc_fuel_req_ang (lsum2, tmp_pw3, pw_open2);
                                wheel_fill_fuel_event_array(fuel2_events_fill, fuel_req_ang, last_tooth_time, last_tooth_ang, 10);
                            }
                        } else if ((flash8.seq_inj & 0x03) == 2) {      
                            fuel_req_ang = calc_fuel_req_ang (lsum2, tmp_pw2, pw_open2);
                            wheel_fill_fuel_event_array(fuel2_events_fill, fuel_req_ang, last_tooth_time, last_tooth_ang, 4);
                        } else if ((flash8.seq_inj & 0x03) == 3) {      
                            fuel_req_ang = calc_fuel_req_ang (lsum3, tmp_pw2, pw_open2);
                            wheel_fill_fuel_event_array(fuel2_events_fill, fuel_req_ang, last_tooth_time, last_tooth_ang, 3);
                        }

                        if ((flash8.seq_inj & 0x03) == 3) {     
                            fuel_req_ang = calc_fuel_req_ang (lsum2, tmp_pw1, pw_open2);
                            wheel_fill_fuel_event_array(fuel2_events_fill, fuel_req_ang, last_tooth_time, last_tooth_ang, 0);
                            fuel_req_ang = calc_fuel_req_ang (lsum3, tmp_pw2, pw_open1);
                            wheel_fill_fuel_event_array(fuel1_events_fill, fuel_req_ang, last_tooth_time, last_tooth_ang, 1);
                        }

                        if (!(seq_inj_ctrl & SEQ_STD_INJ)) {
                            if ((flash8.seq_inj & 0x03) == 1) {     
                                if (no_inj > 2) {
                                    fuel_req_ang = calc_fuel_req_ang (lsum2, tmp_pw3, pw_open3);
                                    wheel_fill_fuel_event_array(fuel3_events_fill, fuel_req_ang, last_tooth_time, last_tooth_ang, 12);
                                    if (no_inj == 4) {
                                        fuel_req_ang = calc_fuel_req_ang (lsum2, tmp_pw4, pw_open4);
                                        wheel_fill_fuel_event_array(fuel4_events_fill, fuel_req_ang, last_tooth_time, last_tooth_ang, 13);
                                    }
                                } else if ((no_inj == 2) && (flash10.staged & 0x07)) {
                                    fuel_req_ang = calc_fuel_req_ang (lsum2, tmp_pw3, pw_open3);
                                    wheel_fill_fuel_event_array(fuel3_events_fill, fuel_req_ang, last_tooth_time, last_tooth_ang, 10);
                                    fuel_req_ang = calc_fuel_req_ang (lsum2, tmp_pw4, pw_open4);
                                    wheel_fill_fuel_event_array(fuel4_events_fill, fuel_req_ang, last_tooth_time, last_tooth_ang, 11);
                                }
                            } else if ((flash8.seq_inj & 0x03) == 3) {      
                                //if (tmp_pw3 > 0) {
                                fuel_req_ang = calc_fuel_req_ang (lsum2, tmp_pw3, pw_open4);
                                wheel_fill_fuel_event_array(fuel4_events_fill, fuel_req_ang, last_tooth_time, last_tooth_ang, 0);
                                fuel_req_ang = calc_fuel_req_ang (lsum2, tmp_pw3, pw_open3);
                                wheel_fill_fuel_event_array(fuel3_events_fill, fuel_req_ang, last_tooth_time, last_tooth_ang, 2);
                                //}
                                //if (tmp_pw4 > 0) {
                                fuel_req_ang = calc_fuel_req_ang (lsum3, tmp_pw4, pw_open3);
                                wheel_fill_fuel_event_array(fuel3_events_fill, fuel_req_ang, last_tooth_time, last_tooth_ang, 1);
                                fuel_req_ang = calc_fuel_req_ang (lsum3, tmp_pw4, pw_open4);
                                wheel_fill_fuel_event_array(fuel4_events_fill, fuel_req_ang, last_tooth_time, last_tooth_ang, 3);
                                //}
                            }
                        }
                    }

                    if (flash10.RotarySplitMode & 0x20) {
                        long spk_time_tmp, dwl_time_tmp;
                        // rotary
                        inttmp = latency_ang + lsum1;
                        spk_req_ang = inttmp; // deg*10

                        // only need spark time to get to dwell time
                        spk_time_tmp = (inttmp * (long)ticks_per_deg) / 1000L;

                        dwl_time_tmp = spk_time_tmp + longtmp;

                        // now convert dwell time to an angle using last tooth time
                        dwl_req_ang = (dwl_time_tmp * 1000L) / (long)ticks_per_deg;

                        wheel_fill_event_array(spark_events_fill, dwell_events_fill, spk_req_ang,
                                dwl_req_ang, last_tooth_time, last_tooth_ang, 1);
                    }

                    DISABLE_INTERRUPTS;
                    dwell_events = dwell_events_fill;
                    spark_events = spark_events_fill;
                    ENABLE_INTERRUPTS;
                                        if ((flash8.seq_inj & 0x03) != 0) {     
                            DISABLE_INTERRUPTS;
                            fuel1_events = fuel1_events_fill;
                            fuel2_events = fuel2_events_fill;
                            fuel3_events = fuel3_events_fill;
                            fuel4_events = fuel4_events_fill;
                            ENABLE_INTERRUPTS;
                                        }
                }
            } else { // EDIS mode
                unsigned long ltmp3;
                lsum -= flash4.adv_offset;
                ltmp3 = 2304 - ((983 * lsum) /  256); //1536 - (adv*25.6) us //takes 9, still crappy asm
                coil_dur = (unsigned int)ltmp3;

                if (synch & SYNC_RPMCALC) {
                    unsigned int rpm;
                    unsigned long dtpred_local;

                    DISABLE_INTERRUPTS;
                    dtpred_local = dtpred;
                    ENABLE_INTERRUPTS;
                    rpm = Rpm_Coeff / dtpred; // for EDIS only

                    if ((outpc.engine & ENGINE_CRANK) || (outpc.rpm < 3) ) { // skip calc if cranking
                        outpc.rpm = rpm;
                    } else {
                        outpc.rpm += (int)((flash4.rpmLF * ((long)rpm - outpc.rpm)) / 100);
                    }
                    synch &= ~SYNC_RPMCALC;
                    calc_rpmdot();
                }
            }
END_WHEEL_DECODER:

            // EDIS false tach masking
            if (spkmode < 2) { // EDIS only)
                if (flash4.feature4_0 & 0x20) {  // is false trig on at all ?
                    if ((flash4.userlevel > 191) && (flash4.feature4_0 & 0x10)) {
                        unsigned long ltmp1;
                        ltmp1 = ((flash4.ICISR_pmask * dtpred) / 100) +
                            ((unsigned long)flash4.ICISR_tmask * 100);
                        false_mask_crk = ltmp1 /192;
                    } else { // simple mode
                        false_mask_crk = (dtpred /400); // simple 48% false trig protection
                    }
                } else {
                    false_mask_crk = 0;
                    false_mask_cam = 0;
                    false_period_crk_tix = 0;
                    false_period_cam_tix = 0;
                }

            // Everything else more advanced options
            // calculate false trigger hold off times for primary and secondary triggers
            // we know smallest_tooth_crk and smallest_tooth_cam
            // want to calculate false_mask_crk and false_mask_cam

            } else { // everything that isn't EDIS
                unsigned long ltmp1;
                unsigned long tmp_ticks;

                if ((flash4.NoiseFilterOpts & 0x06) || (flash4.secondtrigopts & 0x06)) { // any of the filters/masks enabled?

                    if (ticks_per_deg > 25000) { // seems to be less than 1000rpm
                        tmp_ticks = 25000; // rail at equiv of 1000, in case we reset/key off etc and need to regain sync
                    } else {
                        tmp_ticks = ticks_per_deg;
                    }
                    
                    // a wheel or pseudo wheel. Use smallest tooth angle to determine mask time
                    // This percentage (equiv) in here could be made variable like MS2 base's various next pulse tolerance settings

                    ltmp1 = tmp_ticks * smallest_tooth_crk;
//                    ltmp1 = ltmp1 / 2864; // (equiv to * 35%)
                    ltmp1 *= (unsigned long)flash4.ICISR_pmask;
                    ltmp1 /= 100000L;
                    ltmp1 += (unsigned long)flash4.ICISR_tmask * 150; 
        
                    if ((flash4.NoiseFilterOpts & 0x02) && (ltmp1 < 65535)) {
                        false_period_crk_tix = (unsigned int)ltmp1;
                    } else {
                        false_period_crk_tix = 0;
                    }

                    if ((ltmp1 < 576) || (flash4.NoiseFilterOpts & 0x01) || ((flash4.NoiseFilterOpts & 0x04)==0)) { // too short OR crank noise filter OR disabled
                        false_mask_crk = 0;
                    } else {
                        ltmp1 = ltmp1 / 192;
                        false_mask_crk = (unsigned int)ltmp1;
                    }

                    ltmp1 = tmp_ticks * smallest_tooth_cam;
//                    ltmp1 = ltmp1 / 2864; // (equiv to * 35% )
                    ltmp1 *= (unsigned long)flash4.IC2ISR_pmask;
                    ltmp1 /= 100000L;
                    ltmp1 += (unsigned long)flash4.IC2ISR_tmask * 150; 

                    if ((flash4.secondtrigopts & 0x02) && (ltmp1 < 65535)) {
                        false_period_cam_tix = (unsigned int)ltmp1;
                    } else {
                        false_period_cam_tix = 0;
                    }

                    if ((ltmp1 < 576) || (flash4.secondtrigopts & 0x01) || ((flash4.secondtrigopts & 0x04)==0)) { // too short OR cam noise filter OR disabled
                        false_mask_cam = 0;
                    } else {
                        ltmp1 = ltmp1 / 192;
                        false_mask_cam = (unsigned int)ltmp1;
                    }

                } else {
                    false_mask_crk = 0;
                    false_mask_cam = 0;
                    false_period_crk_tix = 0;
                    false_period_cam_tix = 0;
                }            
            }

            // that's most of the spark calcs done

            if(flash4.RevLimOption & 0x7) {
                if (flash4.RevLimOption & 0x8) {
                    int limit;
                    if (outpc.tps < flash4.TpsBypassCLTRevlim) {
                        limit = intrp_1ditable(outpc.clt,8,(int *)pg8_ptr->RevLimLookup, 0,
                                (unsigned int *)pg8_ptr->RevLimRpm1);
                    } else {
                        limit = flash4.RevLimTPSbypassRPM;
                    }
                    DISABLE_INTERRUPTS;
                    RevLimRpm1 = limit;
                    RevLimRpm2 = limit + flash4.RevLimRpm2;
                    ENABLE_INTERRUPTS;
                } else {
                    RevLimRpm1 = flash4.RevLimNormal1;
                    RevLimRpm2 = flash4.RevLimNormal2;
                }

                // This is the same method as MS1/Extra. Would be nice to do adaptive spark cut
                // and/or vary cylinders cut. Should ensure that spk_cuty is not a multiple of num_cyl

                if(flash4.RevLimOption & 4)  {
                    if(outpc.rpm > RevLimRpm2) {
                        spk_cutx = flash4.revlimcutx;
                        spk_cuty = flash4.revlimcuty;
                        outpc.status2 |= status2_spkcut;
                    }
                }
            }

            realtime();

            if (flash4.OverBoostOption & 0x02) {
                if (outpc.status2 & status2_overboost_active) {
                    spk_cutx = flash4.overboostcutx;
                    spk_cuty = flash4.overboostcuty;
                    outpc.status2 |= status2_spkcut;
                }
            }
            if (flash4.EAEOption == 3) {
                int source;

                utmp1 = tmp_pw1 / EAEdivider;

                if (utmp1) {
                    utmp1 += pw_open1;
                }
                utmp1 = ((unsigned long)utmp1 * 3)>>1;

                DISABLE_INTERRUPTS;
                pwcalc_eae1 = utmp1;
                ENABLE_INTERRUPTS;

                utmp1 = tmp_pw2 / EAEdivider;

                if (utmp1) {
                    utmp1 += pw_open2;
                }
                utmp1 = ((unsigned long)utmp1 * 3)>>1;

                DISABLE_INTERRUPTS;
                pwcalc_eae2 = utmp1;
                ENABLE_INTERRUPTS;

                if (flash5.EAElagsource) {
                    /* use mapdot, otherwise, tpsdot */
                    source = outpc.mapdot;
                } else {
                    source = outpc.tpsdot / 10;
                }

                if ((source > flash5.EAElagthresh) &&
                        ((outpc.EAEfcor1 > 100) || (outpc.EAEfcor2 > 100)) &&
                        (outpc.rpm < flash5.EAElagRPMmax)) {
                    DISABLE_INTERRUPTS;
                    flagbyte2 |= flagbyte2_EAElag;
                    ENABLE_INTERRUPTS;
                } else {
                    DISABLE_INTERRUPTS;
                    flagbyte2 &= ~flagbyte2_EAElag;
                    ENABLE_INTERRUPTS;
                }

                DISABLE_INTERRUPTS;
                injtime_EAElagcomp = injtime / flash4.Divider;
                ENABLE_INTERRUPTS;
            }

            //utmp1 = tmp_pw1 / 100;
            /*if (utmp1) {
                utmp1 += pw_open1;
            }
            utmp1 = ((unsigned long)utmp1 * 3)>>1;*/

            //DISABLE_INTERRUPTS;
            //pwcalc1 = utmp1;
            //ENABLE_INTERRUPTS;

            //utmp1 = tmp_pw2 / 100;
            /*if (utmp1) {
                utmp1 += pw_open2;
            }
            utmp1 = ((unsigned long)utmp1 * 3)>>1;*/

            //DISABLE_INTERRUPTS;
            //pwcalc2 = utmp1;
            //ENABLE_INTERRUPTS;

            if (!(outpc.status2 & status2_spkcut)) {
                spk_cutx = 0;
                spk_cuty = 0;
            }

            handle_ovflo();

            /***************************************************************************
             **
             ** Check whether to burn flash
             ** (do this in SCI now)
             **************************************************************************/
            realtime();
            ckstall(); // also calc PWM duties
            //Removed re-init command

            handle_spareports();

            realtime();

            chk_srl();

            /***************************************************************************
             **
             **  CAN polling from I/O slave device
             **
             **************************************************************************/
            /* CAN message set up as follows
             * cx_msg_type = type of message being sent. MSG_REQ is a request for data
             * cx_dest = remote CANid that we are sending message to
             * cx_destvarblk = which variable block (page) to get data from. page 6 = realtime data, outpc
             * cx_destvaroff = offset within that datablock
             * cx_datbuf = a buffer for the data we are sending, none for a request, eight maximum.
             * cx_varbyt = number of bytes sent or requested
             * cx_myvarblk = the variable block to put the reply in (the other end sends a message back with this block no)
             * cx_myvaroff = the variable offset to put the reply in (the other end sends a message back with this block no)
             *
             * With MSG_REQ we send all of that info off and then the other end replies with a MSG_RSP including the variable block and offset
             * to tell us where to deposit the data, kind of like a "push" of the data. We then (blindly) store it where the MSG_RSP asked us to.
             * In the code below we are asking the GPIO board for the raw ADC data and then store it in outpc.gpioadc[] which are then available for
             * use in the code and are also sent to Megatune as part of the realtime data pack.
             */

            // CAN polling code.
            // If enabled it sends a request to a GPIO type board which then sends data back to us.
            // This gets ADC values from a GPIO with user defined CAN_ID= flash4.can_poll_id
            DISABLE_INTERRUPTS;
            ultmp = lmms;
            ENABLE_INTERRUPTS;
            if ( (ultmp > cansendclk) && (flash4.can_poll) && !(flash4.can_poll_id & 0x80))  { // only if enabled and not slave
                cansendclk = ultmp + 78;      // 10ms ( 1s = 7812 x .128 ms) clk
                                        can_poll_remote();
            }


            /* Calcs for fuel injection time mask */
            ltmp1 = dtpred * flash4.Divider;
            ltmp1 = (ltmp1 * flash10.inj_time_mask) / 100;
            /* convert to .128ms units */
            ltmp1 /= 192;

            if ((ltmp1 == 0) || (outpc.engine & ENGINE_CRANK)) {
                ltmp1 = 1;
            }

            DISABLE_INTERRUPTS;
            injtime = ltmp1;
            ENABLE_INTERRUPTS;

/* 'user defined' */

    user_defined(); // call the user defined function - put your code in there

/* end user defined section */

SKIP_THE_LOT:
            __asm__ __volatile__  ( "nop\n" );  // keep compiler happy
    }     //  END Main while(1) Loop
}
