/* $Id: ms2_extra_misc.c,v 1.79 2011-11-20 18:34:38 jsmcortina Exp $ */
#include "ms2_extra.h"

long boost_ctl_last_error;
long boost_ctl_last_pv[2];
char boost_PID_enabled;
int boost_ctl_duty_100;

void calc_rpmdot()
{
    // rpmdot calc - sliding window squares - variable dataset and max sample rate
    rpmdot_data[0][0] = (unsigned int)lmms; // store actual 16 bit time to first pt in array
    rpmdot_data[0][1] = outpc.rpm/10; // store rpm

    if ((rpmdot_data[0][0] - rpmdot_data[1][0]) > 39) { // minimum 5ms between samples to prevent high rpm jitter and cycletime cost
        int rpmi;
        long rpmdot_sumx, rpmdot_sumx2, rpmdot_sumy, rpmdot_sumxy;
        long toprow, btmrow;
        unsigned long rpmdot_x; // was uint

        rpmdot_sumx = 0;
        rpmdot_sumx2 = 0;
        rpmdot_sumy = 0;
        rpmdot_sumxy = 0;

        rpmi = 0;
        // only use ten datapoints for this. Array defined as larger
        while ((rpmi < 10) && (rpmdot_sumxy < 10000000)) {
            rpmdot_x = rpmdot_data[0][0] - rpmdot_data[rpmi][0]; // relative time to keep numbers smaller
            rpmdot_sumx += rpmdot_x;
            rpmdot_sumy += rpmdot_data[rpmi][1];
            rpmdot_sumx2 += (rpmdot_x * rpmdot_x); // overflow if rpmdot_x > 65535
            rpmdot_sumxy += (rpmdot_x * rpmdot_data[rpmi][1]);
            rpmi++;
        }

        toprow = rpmdot_sumxy - (rpmdot_sumx * (rpmdot_sumy / rpmi)); // divide sumy to help overflow
        btmrow = rpmdot_sumx2 - (rpmdot_sumx * rpmdot_sumx / rpmi);

        btmrow = btmrow / 10; // allows top row to be 10x less to reduce overflow.
        toprow = (-toprow * 781) / btmrow;
        if (toprow > 32767) {
            toprow = 32767;
        } else if (toprow < -32767) {
            toprow = -32767;
        }

        // very low rpmdot
        if ((toprow > -150) && (toprow < 150)) {
            long tmp_top, tmp_btm;
            // see how it compares to 20 positions
            tmp_btm = rpmdot_data[0][0] - rpmdot_data[RPMDOT_N-1][0];
            tmp_top = (int)rpmdot_data[0][1] - (int)rpmdot_data[RPMDOT_N-1][1];
            tmp_btm = tmp_btm / 10; // allows top row to be 10x less to reduce overflow.
            tmp_top = (tmp_top * 781) / tmp_btm;
            if (tmp_top > 32767) {
                tmp_top = 32767;
            } else if (tmp_top < -32767) {
                tmp_top = -32767;
            }
            // use lesser magnitude of two
            if (long_abs(tmp_top) < long_abs(toprow)) {
                toprow = tmp_top;
            }
        }

        toprow = 50L * (toprow - outpc.rpmdot); // now 50% lag
        if ((toprow > 0) && (toprow < 100)) {
            toprow = 100;
        } else if ((toprow < 0) && (toprow > -100)) {
            toprow = -100;
        }
        outpc.rpmdot += (int)(toprow / 100);

        //shuffle data forwards by one
        for (rpmi = RPMDOT_N - 1; rpmi > 0 ; rpmi--) {
            rpmdot_data[rpmi][0] = rpmdot_data[rpmi - 1][0];
            rpmdot_data[rpmi][1] = rpmdot_data[rpmi - 1][1];
        }
    }
}

void boost_ctl_init(void)
{
    boost_ctl_last_pv[0] = boost_ctl_last_pv[1] = 0;
    boost_ctl_last_error = 0;
    boost_ctl_timer = 0;
    boost_ctl_duty = 100;
    boost_ctl_duty_100 = 10000;
    outpc.boostduty = boost_ctl_duty;
    boost_PID_enabled = 0;
}

void boost_ctl(void)
{
    int tmp1 = 0, tmp2;

    if (flagbyte3 & flagbyte3_runboost) {
        DISABLE_INTERRUPTS;
        flagbyte3 &= ~flagbyte3_runboost;
        ENABLE_INTERRUPTS;
        if (flash5.boost_ctl_settings & BOOST_CTL_CLOSED_LOOP) {
            /* CLOSED LOOP BOOST */
            int targ_load, boost_deriv;
            int boost_ctl_error;
            long Kp, Ki, Kd, PV, SP;

            /* do not try to control boost below 100% load */
            if (outpc.fuelload < 1000) {
                boost_ctl_duty = flash5.boost_ctl_closeduty;
                outpc.boostduty = boost_ctl_duty;
                boost_ctl_last_pv[0] = boost_ctl_last_pv[1] = boost_ctl_last_error = 0;
                boost_PID_enabled = 0;
                return;
            }

            targ_load = intrp_2ditable(outpc.rpm, outpc.tps, 8, 8,
                    &pg5_ptr->boost_ctl_loadtarg_rpm_bins[0],
                    &pg5_ptr->boost_ctl_loadtarg_tps_bins[0],
                    &pg5_ptr->boost_ctl_load_targets[0][0]);

            PV = ((long)(outpc.fuelload - 1000) * 10000) /
                 (flash4.OverBoostKpa - 1000);
            SP = ((long)(targ_load - 1000) * 10000) /
                 (flash4.OverBoostKpa - 1000);

            boost_ctl_error = SP - PV;

            if (!boost_PID_enabled) {
                boost_ctl_last_error = boost_ctl_error;
                boost_ctl_duty_100 = (int)boost_ctl_duty * 100;
                boost_PID_enabled = 1;
            }

            boost_deriv = PV - (2*boost_ctl_last_pv[0]) + boost_ctl_last_pv[1];

            Kp = ((long)(boost_ctl_error - boost_ctl_last_error) * flash5.boost_ctl_Kp);
            Ki = ((((long)boost_ctl_error * flash5.boost_ctl_ms) / 1000) * flash5.boost_ctl_Ki);
            Kd = ((long)boost_deriv * ((long)flash5.boost_ctl_Kd*10) / flash5.boost_ctl_ms);

            boost_ctl_last_pv[1] = boost_ctl_last_pv[0];
            boost_ctl_last_pv[0] = PV;

            boost_ctl_last_error = boost_ctl_error;

            tmp1 =  boost_ctl_duty_100 - (((long)(Kp + Ki - Kd) * 
                                     (flash5.boost_ctl_openduty - flash5.boost_ctl_closeduty)) /
                                      1000);

            tmp2 = tmp1 / 100;

            if (tmp2 < flash5.boost_ctl_closeduty) {
                tmp2 = flash5.boost_ctl_closeduty;
                tmp1 = flash5.boost_ctl_closeduty * 100;
            } else if (tmp2 > flash5.boost_ctl_openduty) {
                tmp2 = flash5.boost_ctl_openduty;
                tmp1 = flash5.boost_ctl_openduty * 100;
            }

            boost_ctl_duty_100 = tmp1;

            boost_ctl_duty = tmp2;
        } else {
            /* OPEN LOOP BOOST
             * lookup duty based on TPS,RPM
             */
            boost_ctl_duty = intrp_2dctable(outpc.rpm, outpc.tps, 8, 8,
                    &pg5_ptr->boost_ctl_pwmtarg_rpm_bins[0],
                    &pg5_ptr->boost_ctl_pwmtarg_tps_bins[0],
                    &pg5_ptr->boost_ctl_pwm_targets[0][0], 0);

        }
        outpc.boostduty = boost_ctl_duty;
    }
}

//get_adc should be placed in 0x3c page along with the clt, mat, ego, maf data tables
void get_adc(char chan1, char chan2)
{
    char chan;
    //long adcval;
    int adcvalv,tmp1,tmp2,tmp3;
    unsigned int tmpadc;

    for (chan = chan1; chan <= chan2; chan++)  {
        //    switch(chan)  {
        // when using switch, gcc puts lookup table around 0x5000 and then linker
        // gets all upset because we are in page 0x3c and jump table isn't. Replace
        // with ifs instead. No functional difference. This is known bug in gcc
        if (chan == 0) {
            //removed lag code and first_adc comparison as only called here from init
            __asm__ __volatile__ (
                    "ldd    %1\n"
                    "subd   %2\n"
                    "ldy    %3\n"
                    "emul\n"
                    "ldx    #1023\n"
                    "ediv\n"
                    "tfr    y,d\n"
                    "addd   %2\n"
                    : "=d"(outpc.map)
                    : "m"(flash4.mapmax),
                    "m"(flash4.map0),
                    "m"(ATD0DR0)
                    : "y", "x");

        } else if (chan == 1) {
            //        adcval = (long)flash4.mat0 +
            //          ((long)flash4.matmult * matfactor_table[ATD0DR1]) / 100; // deg F or C x 10
            __asm__ __volatile__ (
                    //                "ldd    %1\n"
                    "asld\n"
                    "tfr    d,x\n"
                    "ldy    %2,x\n"
                    "ldd    %3\n"
                    "emul\n"
                    "ldx    #100\n"
                    "ediv\n"
                    "tfr    y,d\n"
                    "addd   %4\n"
                    : "=d"(tmp1)
                    : "d"(ATD0DR1),
                    "m"(matfactor_table[0]),
                    "m"(flash4.matmult),
                    "m"(flash4.mat0)
                    : "x", "y" );

            if(first_adc)
                outpc.mat = tmp1;
            else {
                //          outpc.mat += (short)((flash4.adcLF * (adcval - outpc.mat)) / 100);
                __asm__ __volatile__ (
                        //                "ldd    %1\n"
                        "subd   %3\n"
                        "tfr    d,y\n"
                        "clra\n"
                        "ldab    %2\n"      // it is a uchar
                        "emuls\n"
                        "ldx     #100\n"
                        "edivs\n"
                        "tfr     y,d\n"
                        "addd    %3\n"
                        : "=d"(outpc.mat)
                        : "d"(tmp1),
                        "m"(flash4.adcLF),
                        "m"(outpc.mat)
                        : "x", "y" );
            }
        } else if (chan == 2) {
            //        adcval = (long)flash4.clt0 +
            //          ((long)flash4.cltmult * cltfactor_table[ATD0DR2]) / 100; // deg F or C x 10
            __asm__ __volatile__ (
                    //                "ldd    %1\n"
                    "asld\n"
                    "tfr    d,x\n"
                    "ldy    %2,x\n"
                    "ldd    %3\n"
                    "emul\n"
                    "ldx    #100\n"
                    "ediv\n"
                    "tfr    y,d\n"
                    "addd   %4\n"
                    : "=d"(tmp1)
                    : "d"(ATD0DR2),
                    "m"(cltfactor_table[0]),
                    "m"(flash4.cltmult),
                    "m"(flash4.clt0)
                    : "x", "y" );
            if(first_adc)
                outpc.clt = tmp1;
            else {
                //          outpc.clt += (short)((flash4.adcLF * (adcval - outpc.clt)) / 100);
                __asm__ __volatile__ (
                        "ldd    %1\n"
                        "subd   %3\n"
                        "tfr    d,y\n"
                        "clra\n"
                        "ldab    %2\n"      // it is a uchar
                        "emuls\n"
                        "ldx     #100\n"
                        "edivs\n"
                        "tfr     y,d\n"
                        "addd    %3\n"
                        : "=d"(outpc.clt)
                        : "m"(tmp1),
                        "m"(flash4.adcLF),
                        "m"(outpc.clt)
                        : "x", "y" );
            }
        } else if (chan == 3) {
            outpc.tpsadc = ATD0DR3;
            //          adcval = (ATD0DR3 - (long)flash4.tps0) * 1000 /
            //          (flash4.tpsmax - flash4.tps0);                           // % x 10
            //          outpc.tps = (short)adcval;
            __asm__ __volatile__ (
                    "ldd    %1\n"
                    "subd   %2\n"
                    "tfr    d,x\n"

                    "ldd    %3\n"
                    "subd   %2\n"
                    "ldy    #1000\n"
                    "emul\n"
                    "ediv\n"
                    : "=y"(tmp1)
                    : "m"(flash4.tpsmax),
                    "m"(flash4.tps0),
                    "m"(ATD0DR3)
                    : "d", "x");

        } else if (chan == 4) {
            //        adcval = (long)flash4.batt0 +
            //          ((long)(flash4.battmax - flash4.batt0) * ATD0DR4) / 1023; // V x 10
            __asm__ __volatile__ (
                    "ldd    %1\n"
                    "subd   %2\n"
                    "ldy    %3\n"
                    "emul\n"
                    "ldx    #1023\n"
                    "ediv\n"
                    "tfr    y,d\n"
                    "addd   %2\n"
                    : "=d"(tmp1)
                    : "m"(flash4.battmax),
                    "m"(flash4.batt0),
                    "m"(ATD0DR4)
                    : "y", "x");
            if(first_adc)
                outpc.batt = tmp1;
            else {
                //        outpc.batt += (short)((flash4.adcLF * (adcval - outpc.batt)) / 100);
                __asm__ __volatile__ (
                        "ldd    %1\n"
                        "subd   %3\n"
                        "tfr    d,y\n"
                        "clra\n"
                        "ldab    %2\n"      // it is a uchar
                        "emuls\n"
                        "ldx     #100\n"
                        "edivs\n"
                        "tfr     y,d\n"
                        "addd    %3\n"
                        : "=d"(outpc.batt)
                        : "m"(tmp1),
                        "m"(flash4.adcLF),
                        "m"(outpc.batt)
                        : "x", "y" );
            }
        } else if (chan == 5) {
            if (flash4.egoport == 0) {
                tmpadc = ATD0DR5;
            } else {
                tmpadc = outpc.gpioadc[flash4.egoport - 1];
            }

            // check if sensor bad (near limits)
            if((tmpadc < 3) || (tmpadc > 1020)) {
                bad_ego_flag |= 0x01;
            } else {
                bad_ego_flag &= ~0x01;
            }
            //          adcval = (long)flash4.ego0 +
            //            ((long)flash4.egomult * egofactor_table[tmpadc]) / 100; // afr x 10
            __asm__ __volatile__ (
                    //                "ldx    %1\n"
                    "ldab   %2,x\n"
                    "clra\n"
                    "ldy    %3\n"
                    "emul\n"
                    "ldx    #100\n"
                    "ediv\n"
                    "tfr    y,d\n"
                    "addd   %4\n"
                    : "=d"(tmp3)
                    : "x"(tmpadc),
                    "m"(egofactor_table[0]),
                    "m"(flash4.egomult),
                    "m"(flash4.ego0)
                    : "y" );

            // next line doesn't compile right because gcc doesn't notice that X got clobbered above
            //          tmp1 = (int)tmpadc;
            __asm__ __volatile__ ("ldd #500\n"
                    "emuls\n"
                    "ldx #1023\n"
                    "edivs\n":
                    "=y" (adcvalv):
                    "y" (tmpadc):    // was tmp1
                    "d","x");

            if (first_adc) {
                outpc.ego1 = tmp3;
                outpc.egoV1 = adcvalv;                          // Vx100
            } else {
                //            outpc.ego1 += (short)((flash4.egoLF * (adcval - outpc.ego1)) / 100);
                __asm__ __volatile__ (
                        "ldd    %1\n"
                        "subd   %3\n"
                        "tfr    d,y\n"
                        "clra\n"
                        "ldab    %2\n"      // it is a uchar
                        "emuls\n"
                        "ldx     #100\n"
                        "edivs\n"
                        "tfr     y,d\n"
                        "addd    %3\n"
                        : "=d"(outpc.ego1)
                        : "m"(tmp3),
                        "m"(flash4.egoLF),
                        "m"(outpc.ego1)
                        : "x", "y" );

                tmp1 = (int)flash4.egoLF;
                tmp2 = adcvalv - outpc.egoV1;
                __asm__ __volatile__ ("emuls\n"
                        "ldx #100\n"
                        "edivs\n":
                        "=y" (adcvalv):
                        "d" (tmp1),
                        "y" (tmp2):
                        "x");
                outpc.egoV1 += adcvalv;      // Vx100
            }
        } else if (chan == 6) {
            outpc.adc6 = ATD0DR6;
        } else if (chan == 7) {
            outpc.adc7 = ATD0DR7;

        }                        // end of switch
    }                            // end of for loop

    // if GPIO slave copy these raw ADCs to a convenient place so master can grab them
    if (flash4.mycan_id) {
        outpc.gpioadc[0] = ATD0DR0;
        outpc.gpioadc[1] = ATD0DR1;
        outpc.gpioadc[2] = ATD0DR2;
        outpc.gpioadc[3] = ATD0DR3;
        outpc.gpioadc[4] = ATD0DR4;
        outpc.gpioadc[5] = ATD0DR5;
        outpc.gpioadc[6] = ATD0DR6;
        outpc.gpioadc[7] = ATD0DR7;
    }

    // now calculate other stuff that uses optional ADC inputs
    if (flash4.BaroOption == 2)  {

        if (flash4.rtbaroport == 6) {
            tmpadc = outpc.adc6;
        } else if (flash4.rtbaroport == 7) {
            tmpadc = outpc.adc7;
        } else if (flash4.rtbaroport > 7) {
            //read for GPIO port copy
            tmpadc = outpc.gpioadc[flash4.rtbaroport & 0x7];
        } else {
            tmpadc = 0;
        }

        //          adcval = (long)flash4.baro0 +
        //            ((long)(flash4.baromax - flash4.baro0) * tmpadc) / 1023; // kPa x 10
        __asm__ __volatile__ (
                "ldd    %1\n"
                "subd   %2\n"
                "ldy    %3\n"
                "emul\n"
                "ldx    #1023\n"
                "ediv\n"
                "tfr    y,d\n"
                "addd   %2\n"
                : "=d"(tmp1)
                : "m"(flash4.baromax),
                "m"(flash4.baro0),
                "m"(tmpadc)
                : "y", "x");

        if(first_adc)
            outpc.baro = tmp1;
        else {
            //            outpc.baro += (short)((flash4.adcLF * (adcval - outpc.baro)) / 100);
            __asm__ __volatile__ (
                    "ldd    %1\n"
                    "subd   %3\n"
                    "tfr    d,y\n"
                    "clra\n"
                    "ldab    %2\n"      // it is a uchar
                    "emuls\n"
                    "ldx     #100\n"
                    "edivs\n"
                    "tfr     y,d\n"
                    "addd    %3\n"
                    : "=d"(outpc.baro)
                    : "m"(tmp1),
                    "m"(flash4.adcLF),
                    "m"(outpc.baro)
                    : "x", "y" );
        }
        if (outpc.baro < flash4.baro_lower) {
            outpc.baro = flash4.baro_lower;
        } else if (outpc.baro > flash4.baro_upper) {
            outpc.baro = flash4.baro_upper;
        }
    }

    if((flash4.EgoOption == 2) || (flash4.EgoOption == 4))  {

        if (flash4.ego2port == 6) {
            tmpadc = outpc.adc6;
        } else if (flash4.ego2port == 7) {
            tmpadc = outpc.adc7;
        } else if (flash4.ego2port > 7) {
            //read for GPIO port copy
            tmpadc = outpc.gpioadc[flash4.ego2port & 0x7];
        } else {
            tmpadc = 0;
        }

        // check if sensor bad (near limits)
        if((tmpadc < 3) || (tmpadc > 1020)) {
            bad_ego_flag |= 0x02;
        } else {
            bad_ego_flag &= ~0x02;
        }
        //          adcval = (long)flash4.ego0 +
        //            ((long)flash4.egomult * egofactor_table[tmpadc]) / 100; // afr x 10
        __asm__ __volatile__ (
                //                "ldx    %1\n"
                "ldab   %2,x\n"
                "clra\n"
                "ldy    %3\n"
                "emul\n"
                "ldx    #100\n"
                "ediv\n"
                "tfr    y,d\n"
                "addd   %4\n"
                : "=d"(tmp3)
                : "x"(tmpadc),
                "m"(egofactor_table[0]),
                "m"(flash4.egomult),
                "m"(flash4.ego0)
                : "y" );

        // next line doesn't compile right because gcc doesn't notice that X got clobbered above
        //          tmp1 = (int)tmpadc;
        __asm__ __volatile__ ("ldd #500\n"
                "emuls\n"
                "ldx #1023\n"
                "edivs\n":
                "=y" (adcvalv):
                "y" (tmpadc):    // was tmp1
                "d","x");
        if (first_adc) { // skip the LF for
            outpc.ego2 = tmp3;
            outpc.egoV2 = adcvalv;                              // Vx100
        } else {
            //            outpc.ego2 += (short)((flash4.egoLF * (adcval - outpc.ego2)) / 100);
            __asm__ __volatile__ (
                    "ldd    %1\n"
                    "subd   %3\n"
                    "tfr    d,y\n"
                    "clra\n"
                    "ldab    %2\n"      // it is a uchar
                    "emuls\n"
                    "ldx     #100\n"
                    "edivs\n"
                    "tfr     y,d\n"
                    "addd    %3\n"
                    : "=d"(outpc.ego2)
                    : "m"(tmp3),
                    "m"(flash4.egoLF),
                    "m"(outpc.ego2)
                    : "x", "y" );

            tmp1 = (int)flash4.egoLF;
            tmp2 = adcvalv - outpc.egoV2;
            __asm__ __volatile__ ("emuls\n"
                    "ldx #100\n"
                    "edivs\n":
                    "=y" (adcvalv):
                    "d" (tmp1),
                    "y" (tmp2):
                    "x");
            outpc.egoV2 += adcvalv;      // Vx100
        }
    } else {
        outpc.ego2 = outpc.ego1;
        outpc.egoV2 = outpc.egoV1;
    }


    //was knock. Now use the ADC pin as a digi input if requested

    return;
}

int barocor_eq(int baro)
{
    // returns baro correction in % (100 is no correction)
    // baro in kPa x 10
    return((int)(flash4.bcor0 + (((long)flash4.bcormult * baro) / 1000)));
}

int aircor_eq(int mat)
{
    signed int cor;
    signed char ccor;
    // returns air density correction from equation in % (100 is no correction)
    //   mat in deg F x10 or deg Cx10
    /* Following equations used:

       For Farenheit, air density (pounds/cubic feet) = .0391568 x map (kPa x 10)
       -------------------------
       ((mat(degFx10)/10) + 459.7)
       If we take 70 degF as standard temperature (no density correction) and ignore
       map, which is already accounted for elsewhere,then
       air density correction(%) = (70 + 459.7) x 100
       ------------------
       ((mat/10) + 459.7)
       For Celsius, with a 20 deg C reference and mat in deg C x 10
       air density correction(%) = (20 + 273.2) x 100
       ------------------
       ((mat/10) + 273.2)

       This function could actually be unsigned char. Doesn't need to be signed int.
     */
//    if(flash4.Temp_Units == 0)  {    // deg F
        cor = 529700 / (mat + 4597);
// Changed for 3.0.3w to ignore this (unused) setting always use degF internally.
//    }
//    else  {                          // deg C
//        cor = 293200 / (mat + 2732);
//    }
    if (flash5.airden_scaling) { // only if non-zero
        ccor = (unsigned char)cor - 100;
        cor = ((signed int)(ccor * flash5.airden_scaling)) / 100;
        cor = cor + 100;
    }
    return (int)cor;
}

int CW_table(int clt, int *table, int *temp_table)
{
    int ix;
    long interp, interp3;
    // returns values for various cold warmup table interpolations
    // bound input arguments
    if(clt > temp_table[NO_TEMPS-1])  {
        return(table[NO_TEMPS -1]);
    }
    if(clt < temp_table[0])  {
        return(table[0]);
    }
    for(ix = NO_TEMPS - 2; ix > -1; ix--)  {
        if(clt > temp_table[ix])  {
            break;
        }
    }
    if(ix < 0)ix = 0;

    interp = temp_table[ix + 1] - temp_table[ix];
    if(interp != 0)  {
        interp3 = (clt - temp_table[ix]);
        interp3 = (100 * interp3);
        interp = interp3 / interp;
    }
    return((int)(table[ix] + interp * (table[ix+1] - table[ix])/ 100));
}

void set_spr_port(char port, char val)
{
    unsigned char pval;

    if (val) {
        outpc.port_status |= (0x01 << port);
    } else {
        outpc.port_status &= ~(0x01 << port);    // JL fix
    }

        // Use the MS ports
        if(port < 4)  {
                pval = (0x01 << (port + 2));
                if(val)
                        PTM |= pval;
                else
                        PTM &= ~pval;
        } else if(port < 6)  {
#ifndef MICROSQUIRT
                /* Workaround for MT bug, reverse IAC1 and IAC2 */
                /* But only on MS2. Microsquirt module is correct */
                if (port == 4) {
                        port = 5;
                } else if (port == 5) {
                        port = 4;
                }
#endif
                pval = (0x01 << (port + 2));
                if(val)  {
                        DISABLE_INTERRUPTS
                                PTT |= pval;
                        ENABLE_INTERRUPTS
                } else  {
                        DISABLE_INTERRUPTS
                                PTT &= ~pval;
                        ENABLE_INTERRUPTS
                }
        } else  {
                if(val)
                        PORTA |= 0x01;
                else
                        PORTA &= ~0x01;
        }
}

/***************************************************************************
 **
 ** Determine remote port settings
 **
 **************************************************************************/

void remote_spr_ports(void)
{
unsigned char ix;
int tmp1=0,tmp2=0;
char ctmp1=0,ctmp2=0;

        for(ix = 0;ix < 8; ix++)  {
                if(flash5.rmt_spr_port[ix])  {
                        // Evaluate first condition
                        if(flash5.rmt_out_byte1[ix] == 1)
                                tmp1 = *((char *)(&outpc) + flash5.rmt_out_offset1[ix]);
                        else
                                tmp1 = *( int *)((char *)(&outpc) + flash5.rmt_out_offset1[ix]);
                        tmp1 = tmp1 - flash5.rmt_thresh1[ix];
                        if(flash5.rmt_condition1[ix] == '<')
                                tmp1 = -tmp1;              //  convert < condition to same as > condition
                        if(flash5.rmt_condition1[ix] == '=')  {
                                if((tmp1 >= -flash5.rmt_hyst1[ix]) && (tmp1 <= flash5.rmt_hyst1[ix]))
                                        ctmp1 = 1;               // 1st condition true
                        }
                        else if(tmp1 > 0)
                                ctmp1 = 1;                 // 1st condition true
                        else
                                ctmp1 = 0;                 // 1st condition false
                        // Evaluate second condition if there is one
                        if(flash5.rmt_cond12[ix] != ' ')  {
                                if(flash5.rmt_out_byte2[ix] == 1)
                                        tmp2 = *((char *)(&outpc) + flash5.rmt_out_offset2[ix]);
                                else
                                        tmp2 = *( int *)((char *)(&outpc) + flash5.rmt_out_offset2[ix]);
                                tmp2 = tmp2 - flash5.rmt_thresh2[ix];
                                if(flash5.rmt_condition2[ix] == '<')
                                        tmp2 = -tmp2;            //  convert < condition to same as > condition
                                if(flash5.rmt_condition2[ix] == '=')  {
                                        if((tmp2 >= -flash5.rmt_hyst2[ix]) && (tmp2 <= flash5.rmt_hyst2[ix]))
                                                ctmp2 = 1;             // 2nd condition true
                                }
                                else if(tmp2 > 0)
                                        ctmp2 = 1;               // 2nd condition true
                                else
                                        ctmp2 = 0;               // 2nd condition false
                        }
                        // Evaluate final condition
                        if(((flash5.rmt_cond12[ix] == '&') && (ctmp1 && ctmp2)) ||
                                        ((flash5.rmt_cond12[ix] == '|') && (ctmp1 || ctmp2)) ||
                                        ((flash5.rmt_cond12[ix] == ' ') && ctmp1))  {
                                if(lst_pval[ix] != flash5.rmt_port_val[ix])  {
                                    if (flash5.rmt_port_val[ix]) {
                                        outpc.gpioport[flash4.port_generic - 1] |= (0x01 << ix);
                                    } else {
                                        outpc.gpioport[flash4.port_generic - 1] &= ~(0x01 << ix);    // JL fix
                                    }
                                        lst_pval[ix] = flash5.rmt_port_val[ix];
                                }
                        }
                        else  {
                                // Evaluate hysteresis conditions
                                if((flash5.rmt_condition1[ix] == '>') || (flash5.rmt_condition1[ix] == '<'))
                                        tmp1 = -tmp1 - flash5.rmt_hyst1[ix];
                                if(flash5.rmt_condition1[ix] == '=')  {
                                        ctmp1 = 1 - ctmp1;         // 1st hyst. condition opposite of set cond
                                }
                                else if(tmp1 > 0)
                                        ctmp1 = 1;                 // 1st hysteresis condition true
                                else
                                        ctmp1 = 0;                 // 1st hysteresis condition false
                                if(flash5.rmt_cond12[ix] != ' ')  {
                                        if((flash5.rmt_condition2[ix] == '>') || (flash5.rmt_condition2[ix] == '<'))
                                                tmp2 = -tmp2 - flash5.rmt_hyst2[ix];
                                        if(flash5.rmt_condition2[ix] == '=')  {
                                                ctmp2 = 1 - ctmp2;         // 2nd hyst. condition opposite of set cond
                                        }
                                        else if(tmp2 > 0)
                                                ctmp2 = 1;                 // 2nd hysteresis condition true
                                        else
                                                ctmp2 = 0;                 // 2nd hysteresis condition false
                                }
                                // Evaluate final hysteresis condition
                                if(((flash5.rmt_cond12[ix] == '&') && (ctmp1 || ctmp2)) ||
                                                ((flash5.rmt_cond12[ix] == '|') && (ctmp1 && ctmp2)) ||
                                                ((flash5.rmt_cond12[ix] == ' ') && ctmp1))  {
                                        if(lst_pval[ix] != 1 - flash5.rmt_port_val[ix])  {
                                            if (1 - flash5.rmt_port_val[ix]) {
                                                outpc.gpioport[flash4.port_generic - 1] |= (0x01 << ix);
                                            } else {
                                                outpc.gpioport[flash4.port_generic - 1] &= ~(0x01 << ix);    // JL fix
                                            }
                                                lst_pval[ix] = 1 - flash5.rmt_port_val[ix];
                                        }
                                }
                        }           // end eval of hysteresis conditions
                }                // end if spr_port
        }                    // end for ix loop
}

//*****************************************************************************
//* Function Name: Flash_Init
//* Description : Initialize Flash NVM for HCS12 by programming
//* FCLKDIV based on passed oscillator frequency, then
//* uprotect the array, and finally ensure PVIOL and
//* ACCERR are cleared by writing to them.
//*
//*****************************************************************************
void Flash_Init()
{
    /* Next, initialize FCLKDIV register to ensure we can program/erase */
    FCLKDIV = 39;
    //  FPROT = 0xFF; /* Disable all protection (only in special modes)*/
    // commented as it will likely spew out error normally
    FSTAT = PVIOL|ACCERR;/* Clear any errors */
    return;
}

void realtime(void)
{

    ck_log_clr();
    chk_crc();
    cp_page();

    if (rtsci == 0) {
        goto skip_rt;
    }
    if (rtsci == 1) {
        // copy outpc to txbuf one by one to allow interrupts
        txbuf.seconds = outpc.seconds;
        if (flagbyte2 & flagbyte2_MV2) {
            // send back in microsecond units
            txbuf.pw1 = (outpc.pw1 << 1) / 3;
            txbuf.pw2 = (outpc.pw2 << 1) / 3;
        } else {
            txbuf.pw1 = outpc.pw1;
            txbuf.pw2 = outpc.pw2;
        }
        txbuf.rpm = outpc.rpm;
        txbuf.adv_deg = outpc.adv_deg;
        txbuf.squirt = outpc.squirt;
        txbuf.engine = outpc.engine;
        txbuf.afrtgt1 = outpc.afrtgt1;
        txbuf.afrtgt2 = outpc.afrtgt2;
        txbuf.wbo2_en1 = outpc.wbo2_en1;
        txbuf.wbo2_en2 = outpc.wbo2_en2;
        txbuf.baro = outpc.baro;
        txbuf.map = outpc.map;
        if ((flagbyte2 & flagbyte2_MV2) && (flash4.Temp_Units & 1)) {
            txbuf.mat = ((outpc.mat - 320) * 5) / 9;
            txbuf.clt = ((outpc.clt - 320) * 5) / 9;
        } else {
            txbuf.mat = outpc.mat;
            txbuf.clt = outpc.clt;
        }
        txbuf.tps = outpc.tps;
        txbuf.batt = outpc.batt;
        txbuf.ego1 = outpc.ego1;
        txbuf.ego2 = outpc.ego2;
        txbuf.knock = outpc.knock;
        txbuf.egocor1 = outpc.egocor1;
        txbuf.egocor2 = outpc.egocor2;
        txbuf.aircor = outpc.aircor;
        txbuf.warmcor = outpc.warmcor;
        txbuf.tpsaccel = outpc.tpsaccel;
        txbuf.tpsfuelcut = outpc.tpsfuelcut;
        txbuf.barocor = outpc.barocor;
        txbuf.gammae = outpc.gammae;
        txbuf.vecurr1 = outpc.vecurr1;
        txbuf.vecurr2 = outpc.vecurr2;
        txbuf.iacstep = outpc.iacstep;
        txbuf.cold_adv_deg = outpc.cold_adv_deg;
        txbuf.tpsdot = outpc.tpsdot;
        txbuf.mapdot = outpc.mapdot;
        txbuf.coil_dur = outpc.coil_dur;
        txbuf.maf = outpc.maf;
        txbuf.fuelload = outpc.fuelload;
        txbuf.fuelcor = outpc.fuelcor;
        txbuf.port_status = outpc.port_status;
        txbuf.knk_rtd = outpc.knk_rtd;
        txbuf.EAEfcor1 = outpc.EAEfcor1;
        txbuf.EAEfcor2 = outpc.EAEfcor2;
        txbuf.egoV1 = outpc.egoV1;
        txbuf.egoV2 = outpc.egoV2;

        // the following only apply to MS2/Extra but should not hurt MV2
        txbuf.status1 = outpc.status1;
        if (outpc.status1 & status1_syncok) { // actually synced
            if ((outpc.status1 & status1_synclatch) == 0) { // latched not synced
                txbuf.status1 &= ~status1_syncok; // claim still not synced to user
                outpc.status1 |= status1_synclatch; // reset latch
            }
        }
        txbuf.status2 = outpc.status2;
        txbuf.status3 = outpc.status3;
        txbuf.status4 = outpc.status4;
        txbuf.looptime = outpc.looptime;
        txbuf.istatus5 = outpc.istatus5;
        txbuf.tpsadc = outpc.tpsadc;
        txbuf.fuelload2 = outpc.fuelload2;
        txbuf.ignload = outpc.ignload;
        txbuf.ignload2 = outpc.ignload2;
        //txbuf. spare[5]; - deleted
        txbuf.inj_adv1 = outpc.inj_adv1;
        txbuf.inj_adv2 = outpc.inj_adv2;
        txbuf.pw3 = outpc.pw3;
        txbuf.pw4 = outpc.pw4;
                txbuf.vetrim[0] = outpc.vetrim[0];
                txbuf.vetrim[1] = outpc.vetrim[1];
                txbuf.vetrim[2] = outpc.vetrim[2];
                txbuf.vetrim[3] = outpc.vetrim[3];
        txbuf.synccnt = outpc.synccnt;
        txbuf.timing_err = outpc.timing_err;
        DISABLE_INTERRUPTS;
        txbuf.dt3 = outpc.dt3; // these two are long, some ensure coherency with sei/cli
        ENABLE_INTERRUPTS;
        DISABLE_INTERRUPTS;
        txbuf.wallfuel1 = outpc.wallfuel1;
        txbuf.wallfuel2 = outpc.wallfuel2;
        ENABLE_INTERRUPTS;
        txbuf.gpioadc[0] = outpc.gpioadc[0];
        txbuf.gpioadc[1] = outpc.gpioadc[1];
        txbuf.gpioadc[2] = outpc.gpioadc[2];
        txbuf.gpioadc[3] = outpc.gpioadc[3];
        txbuf.gpioadc[4] = outpc.gpioadc[4];
        txbuf.gpioadc[5] = outpc.gpioadc[5];
        txbuf.gpioadc[6] = outpc.gpioadc[6];
        txbuf.gpioadc[7] = outpc.gpioadc[7];

        txbuf.gpiopwmin[0] = outpc.gpiopwmin[0];
        txbuf.gpiopwmin[1] = outpc.gpiopwmin[1];
        txbuf.gpiopwmin[2] = outpc.gpiopwmin[2];
        txbuf.gpiopwmin[3] = outpc.gpiopwmin[3];

        txbuf.gpioport[0] = outpc.gpioport[0];
        txbuf.gpioport[1] = outpc.gpioport[1];
        txbuf.gpioport[2] = outpc.gpioport[2];

        txbuf.adc6 = outpc.adc6;
        txbuf.adc7 = outpc.adc7;
        txbuf.boostduty = outpc.boostduty;
        txbuf.syncreason = outpc.syncreason;
        txbuf.mafmap = outpc.mafmap;
        txbuf.eaeload = outpc.eaeload;
        txbuf.afrload = outpc.afrload;
        txbuf.rpmdot = outpc.rpmdot;
        if (outpc.syncreason) {
            outpc.syncreason = 0; // send the sync loss reason code once then reset it
        }
        txbuf.user0 = outpc.user0;


        DISABLE_INTERRUPTS;
        rcv_timeout = lmms + 3906;
        ENABLE_INTERRUPTS;
            rtsci = 0;
        txmode = 128;
        if ((flagbyte2 & flagbyte2_MV2) == 0) {
            txgoal = SIZEOFTXBUF;
        } else {
            txgoal = 112;
        }

        txcnt = 0;
        SCI0DRL = *(unsigned char *)&txbuf.seconds;
        SCI0CR2 |= 0x88;
    }
skip_rt: ;
}


/**************************************************************************
 **
 ** Calculation of Battery Voltage Correction for Injector Opening Time
 **
 ** Injector open time is implemented as a linear function of
 **  battery voltage, from 7.2 volts to 19.2 volts,
 **  with 13.2 volts being the nominal operating voltage
 **
 ** INJOPEN = injector open time at 13.2 volts in ms x 10
 ** BATTFAC = injector open adjustment factor 6 volts from 13.2V in ms x 10
 **
 **
 ** + (INJOPEN + BATTFAC)
 ** +   *
 ** +                     (INJOPEN)
 ** +                         *
 ** +                                       (INJOPEN - BATTFAC)
 ** +                                               *
 ** +
 ** ++++++++++++++++++++++++++++++++++++++++++++++++++++++
 **    7.2V                 13.2V                19.2
 **
 **************************************************************************
 **
 ** The linear function has been replaced by a non-linear function
 ** which is a more realistic representation of the physics involved.
 **
 ** The correction to the injector open time at 13.2V is multiplied by
 ** (13.2/battery voltage)
 **
 **************************************************************************/
void calc_opentime()
{
    int tmp1,tmp2,tmp3;

    tmp3 = 60 * outpc.batt;
	tmp2 = 132 * (132 - outpc.batt);
	tmp1 = -(((long)pg4_ptr->BatFac * tmp2) / tmp3);

    if ((((int)pg4_ptr->InjOpen) - tmp1) > 0) {
        //positive which is reasonable
        pw_open1 = (unsigned int)(pg4_ptr->InjOpen - tmp1);
    } else {
		// if it was negative then don't set so use default value
        pw_open1 = pg4_ptr->InjOpen;
    }

    if (pw_open1 > 5000) {
        pw_open1 = 5000; // hardcoded 5ms max
    }

    // if channel 2 has different parameters, then apply them here
    if (pg4_ptr->ICIgnOption & 0x20) {
        tmp1 = -(((long)pg4_ptr->BatFac2 * tmp2) / tmp3);

        if ((((int)pg4_ptr->InjOpen2) - tmp1) > 0) {
            //positive which is reasonable
			pw_open2 = (unsigned int)(pg4_ptr->InjOpen2 - tmp1);
        } else {
			// if it was negative then don't set so use default value
            pw_open2 = pg4_ptr->InjOpen2;
        }

        if (pw_open2 > 5000) {
            pw_open2 = 5000; // hardcoded 5ms max
        }
    } else {
        pw_open2 = pw_open1;
    }

        if (!(seq_inj_ctrl & SEQ_STD_INJ)) {
                // Additional drivers used for staged injection
            // if channel 3 and 4 have different parameters, then apply them here
            if (((flash8.seq_inj & 0x03) == 1) && (pg4_ptr->ICIgnOption & 0x20)) {
                tmp1 = -(((long)pg8_ptr->BatFac3 * tmp2) / tmp3);

                if ((((int)pg8_ptr->InjOpen3) - tmp1) > 0) {
                    //positive which is reasonable
                    pw_open3 = (unsigned int)(pg8_ptr->InjOpen3 - tmp1);
                } else {
                    // if it was negative then don't set so use last value
                    pw_open3 = pg8_ptr->InjOpen3;
                }

                if (pw_open3 > 5000) {
                    pw_open3 = 5000; // hardcoded 5ms max
                }

                tmp1 = -(((long)pg8_ptr->BatFac4 * tmp2) / tmp3);

                if ((((int)pg8_ptr->InjOpen4) - tmp1) > 0) {
                    //positive which is reasonable
                    pw_open4 = (unsigned int)(pg8_ptr->InjOpen4 - tmp1);
                } else {
                    // if it was negative then don't set so use last value
                    pw_open4 = pg8_ptr->InjOpen4;
                }

                if (pw_open4 > 5000) {
                    pw_open4 = 5000; // hardcoded 5ms max
                }
            } else {
                        pw_open3 = pw_open4 = pw_open2;
                        pw_open2 = pw_open1;
            }
        }

}

unsigned int twoptlookup(unsigned int x, unsigned int x0, unsigned int x1, unsigned int y0, unsigned int y1 )
{
    long interp, interp3;
    unsigned int result;

    // bound input arguments
    if(x >= x1)  {
        return(y1);
    }

    if(x <= x0)  {
        return(y0);
    }

    interp = (long)x1 - (long)x0;
    interp3 = ((long)x - (long)x0);
    interp3 = (100 * interp3);
    interp = interp3 / interp;

    interp = interp * ((long)y1 - (long)y0)/100;
    result = (unsigned int)( (long)y0 + interp );

    return(result);
}

long calc_fuel_req_ang (long ang, unsigned long pw, unsigned int pw_open)
{
    long fuel_req_ang;

    // Adjust timing for mid-pulse and end-of-pulse modes
    if (pw == 0) {
        fuel_req_ang = ang;
    } else {
        if (flash8.seq_inj & 0x40) {
            // Mid-pulse
            fuel_req_ang = ang + (((pw * 15)>>1) + (long)(pw_open) * 1500L) / ticks_per_deg;
        } else if (flash8.seq_inj & 0x80) {
            // End-of-pulse
            fuel_req_ang = ang + (pw * 15 + (long)(pw_open) * 1500L) / ticks_per_deg;
        } else {
            fuel_req_ang = ang;
        }
        while (fuel_req_ang > cycle_deg) {
            fuel_req_ang -= cycle_deg;
        }

        while (fuel_req_ang < 0) {
            fuel_req_ang += cycle_deg;
        }
    }

    return(fuel_req_ang);
}

//Without this next code segment in page3a, the config error code doesn't get included in the s19
//Seems like buggy behaviour in binutils
void bs_text3a (void) {
    return;
}

void wheel_fill_map_event_array (map_event * map_events_fill, int map_ang,
                                 ign_time last_tooth_time,
                                 unsigned int last_tooth_ang)
{
    char iterate, tth, wfe_err;
    int tth_ang, tmp_ang, i;
    unsigned int map_time, map_window_time;

    map_window_time = (unsigned int)((((flash4.mapsample_window *10) * last_tooth_time.time_32_bits) / last_tooth_ang)
                      / 192L);
    if (map_window_time < 1) {
        map_window_time = 1;
    }

    for (i = 0; i < no_triggers; i++) {
        wfe_err = 0;
        iterate = 0;
        tth_ang = trig_angs[i];
        tth = trigger_teeth[i];
        while (!iterate) {
            if (tth_ang > map_ang) {
                iterate = 1;
            } else {
                //how far do we step back in deg
                tth--;
                if (tth < 1) {
                    tth = last_tooth;
                    wfe_err++;
                    if (wfe_err > 1) {
                        iterate = 2;
                    }
                }
                tth_ang += deg_per_tooth[tth - 1];
            }
        }
        if (iterate == 2) {
            DISABLE_INTERRUPTS;
            asm ("nop\n");      // something screwed up, place for breakpoint
            ENABLE_INTERRUPTS;
            // can't continue as didn't find a valid tooth
            return;
        }

        tmp_ang = tth_ang - map_ang;

        map_time = (unsigned int)(((tmp_ang * last_tooth_time.time_32_bits) /
                                   last_tooth_ang) / 192L);
        wfe_err = 0;

        while ((wfe_err < 2) && (map_time < 1)) {
            // too soon after tooth, need to step back
            tth--;
            if (tth < 1) {
                tth = last_tooth;
                wfe_err++;
            }
            tth_ang += deg_per_tooth[tth - 1];
            // recalc
            tmp_ang = tth_ang - map_ang;
            map_time =
                (unsigned int)(((tmp_ang * last_tooth_time.time_32_bits) / last_tooth_ang) / 192L);
        }

        if (wfe_err > 1) {
            DISABLE_INTERRUPTS;
            asm ("nop\n");      // something screwed up, place for breakpoint
            ENABLE_INTERRUPTS;
            // can't continue as didn't find a valid tooth
            return;
        }

        map_events_fill[i].tooth = tth;
        map_events_fill[i].time = map_time;
        map_events_fill[i].map_window_set = map_window_time;
        map_events_fill[i].evnum = i;
    }
}

int calc_ITB_load(int percentbaro)
{
    int tmp3, tmp4, tmp5; 

    tmp3 = intrp_1ditable(outpc.rpm, 10,
            (unsigned int *) flash11.ITB_load_rpms, 1,
            (int *) flash11.ITB_load_loadvals);

    tmp4 = intrp_1ditable(outpc.rpm, 10,
            (unsigned int *) flash11.ITB_load_rpms, 1,
            (int *) flash11.ITB_load_switchpoints); 

    if (percentbaro < 900) {
        /* Make MAP fit in to 0-tmp3 % load... so if user selects 60%,
         * 0-90kPa would be 0-60% load, and the throttle position above
         * that point to 100% throttle will be 60% load to 100% load
         */
        tmp3 = (((long) percentbaro * tmp3) / 900);
    } else {
        /* Make TPS fit in tmp3 - 100% */
        if (outpc.tps >= tmp4) {
            /* This is the amt of load TPS has to fit into */
            tmp5 = 1000 - tmp3;

            /* This is the actual percent above the
             * switchpoint TPS is at */
            tmp4 = ((long)(outpc.tps - tmp4) * 1000) / (1000 - tmp4);


            /* Now scale that into what's left above the 90 % baro 
             * point
             */
            tmp3 = (((long) tmp4 * tmp5) / 1000) + tmp3;

        }
        /* IF TPS hasn't gone above the setpoint, load should
         * stay at the user-set setpoint */
    }

    /* Make 10 the lowest possible load */

    if (tmp3 < 100) {
        tmp3 = 100;
    }

    return tmp3;
}

            /***************************************************************************
             **
             ** Determine spare port settings
             **
             **************************************************************************/
void handle_spareports(void)
{
    int ix, tmp1=0,tmp2=0;
    char ctmp1=0,ctmp2=0;
    for(ix = 0;ix < NPORT; ix++) {
        if (flash4.spr_port[ix]) {
            // Evaluate first condition
            if (flash4.out_byte1[ix] == 1) {
                tmp1 = *((char *)(&outpc) + flash4.out_offset1[ix]);
            } else {
                tmp1 = *( int *)((char *)(&outpc) + flash4.out_offset1[ix]);
            }
            tmp1 = tmp1 - flash4.thresh1[ix];
            if (flash4.condition1[ix] == '<') {
                tmp1 = -tmp1;              //  convert < condition to same as > condition
            }
            if (flash4.condition1[ix] == '=')  {
                if((tmp1 >= -flash4.hyst1[ix]) && (tmp1 <= flash4.hyst1[ix])) {
                    ctmp1 = 1;               // 1st condition true
                }
            } else if(tmp1 > 0) {
                ctmp1 = 1;                 // 1st condition true
            } else {
                ctmp1 = 0;                 // 1st condition false
            }
            // Evaluate second condition if there is one
            if(flash4.cond12[ix] != ' ')  {
                if(flash4.out_byte2[ix] == 1) {
                    tmp2 = *((char *)(&outpc) + flash4.out_offset2[ix]);
                } else {
                    tmp2 = *( int *)((char *)(&outpc) + flash4.out_offset2[ix]);
                }
                tmp2 = tmp2 - flash4.thresh2[ix];
                if (flash4.condition2[ix] == '<') {
                    tmp2 = -tmp2;            //  convert < condition to same as > condition
                }
                if (flash4.condition2[ix] == '=') {
                    if((tmp2 >= -flash4.hyst2[ix]) && (tmp2 <= flash4.hyst2[ix])) {
                        ctmp2 = 1;             // 2nd condition true
                    }
                } else if(tmp2 > 0) {
                    ctmp2 = 1;               // 2nd condition true
                } else {
                    ctmp2 = 0;               // 2nd condition false
                }
            }
            // Evaluate final condition
            if (((flash4.cond12[ix] == '&') && (ctmp1 && ctmp2)) ||
                    ((flash4.cond12[ix] == '|') && (ctmp1 || ctmp2)) ||
                    ((flash4.cond12[ix] == ' ') && ctmp1))  {

                if (lst_pval[ix] != flash4.port_val[ix])  {
                    set_spr_port((char)ix, flash4.port_val[ix]);
                    lst_pval[ix] = flash4.port_val[ix];
                }
            } else {
                // Evaluate hysteresis conditions
                if ((flash4.condition1[ix] == '>') || (flash4.condition1[ix] == '<')) {
                    tmp1 = -tmp1 - flash4.hyst1[ix];
                }

                if(flash4.condition1[ix] == '=')  {
                    ctmp1 = 1 - ctmp1;         // 1st hyst. condition opposite of set cond
                } else if(tmp1 > 0) {
                    ctmp1 = 1;                 // 1st hysteresis condition true
                } else {
                    ctmp1 = 0;                 // 1st hysteresis condition false
                }
                if (flash4.cond12[ix] != ' ')  {
                    if((flash4.condition2[ix] == '>') || (flash4.condition2[ix] == '<')) {
                        tmp2 = -tmp2 - flash4.hyst2[ix];
                    }
                    if (flash4.condition2[ix] == '=')  {
                        ctmp2 = 1 - ctmp2;         // 2nd hyst. condition opposite of set cond
                    } else if(tmp2 > 0) {
                        ctmp2 = 1;                 // 2nd hysteresis condition true
                    } else {
                        ctmp2 = 0;                 // 2nd hysteresis condition false
                    }
                }
                // Evaluate final hysteresis condition
                if (((flash4.cond12[ix] == '&') && (ctmp1 || ctmp2)) ||
                        ((flash4.cond12[ix] == '|') && (ctmp1 && ctmp2)) ||
                        ((flash4.cond12[ix] == ' ') && ctmp1))  {

                    if (lst_pval[ix] != 1 - flash4.port_val[ix]) {
                        set_spr_port((char)ix, 1 - flash4.port_val[ix]);
                        lst_pval[ix] = 1 - flash4.port_val[ix];
                    }
                }
            }           // end eval of hysteresis conditions
        }                // end if spr_port
    }                    // end for ix loop
    if ((flash4.port_generic != 0) && (flash4.can_poll) && (flash4.enable_poll & 0x04) && flash4.ports_dir) {
        // Remote port settings is enabled
        remote_spr_ports();
    }
}

void handle_ovflo(void)
{
    // check for long timers
    if (wheeldec_ovflo) {
        unsigned long wotmp;

        while ((TCNT > 0xfff8) || (TCNT < 6)) { ; } // make sure not right at rollover

        wotmp = ((unsigned long)swtimer<<16) | TCNT;

        if (wheeldec_ovflo & OVFLO_SPK) {
            if ((spk_time_ovflo.time_32_bits - wotmp) < 0x10000) {
                // within 30000 ticks (20ms) must ensure mainloop never slower than this.
                TC_ign = spk_time_ovflo.time_16_bits[1];
                TFLG1 = TFLG_ign;        // clear ign OC interrupt flag
                TIE |= TFLG_ign;
                wheeldec_ovflo &= ~OVFLO_SPK; // done overflow
            }
        }

        if (wheeldec_ovflo & OVFLO_DWL) {

            if ((dwl_time_ovflo.time_32_bits - wotmp) < 0x10000) {
                TC_dwl = dwl_time_ovflo.time_16_bits[1];
                TFLG1 = TFLG_dwl;    // clear ign OC interrupt flag
                TIE |= TFLG_dwl;
                wheeldec_ovflo &= ~OVFLO_DWL; // done overflow
            }
        }
            if (wheeldec_ovflo & OVFLO_ROT_DWL) {
                if ((dwl_time_ovflo_trl.time_32_bits - wotmp) < 0x10000) {
                    TC_rotINJ3 = dwl_time_ovflo_trl.time_16_bits[1];
                    TFLG1 = TFLG_rotINJ3;
                    TIE |= TFLG_rotINJ3;
                    wheeldec_ovflo &= ~OVFLO_ROT_DWL;   // done overflow
                }
            }

            if (wheeldec_ovflo & OVFLO_ROT_SPK) {
                if ((spk_time_ovflo_trl.time_32_bits - wotmp) < 0x10000) {
                    TC_rotINJ4 = spk_time_ovflo_trl.time_16_bits[1];
                    TFLG1 = TFLG_rotINJ4;
                    TIE |= TFLG_rotINJ4;
                    wheeldec_ovflo &= ~OVFLO_ROT_SPK;
                }
            }
    }
}

void ck_log_clr(void)
{
/* Check for clearing trigger/tooth logger buffer */
    if (flagbyte5 & FLAGBYTE5_LOG_CLR) {
        if ((page >= 0xf0) && (page <= 0xf3)) { // double check
            __asm__ __volatile__ (
            "ldd   #512\n"
            "tthclr:\n"
            "movw   #0, 2,y+\n"
            "dbne   d, tthclr\n"
            : 
            : "y"(ram_data)
            : "d");
        }
        if (page == 0xf0) {
            flagbyte0 |= flagbyte0_tthlog;
        } else if (page == 0xf1) {
            flagbyte0 |= flagbyte0_trglog;
        } else if ((page == 0xf2) || (page == 0xf3)) {
            flagbyte0 |= flagbyte0_complog;
        }
        flagbyte5 &= ~FLAGBYTE5_LOG_CLR;
    }
}

void chk_crc(void)
{
    /* if required, calc crc of ram page */
    if (flagbyte6 & FLAGBYTE6_CRC) {
        flagbyte6 &= ~FLAGBYTE6_CRC;
// only check ram copy, irrespective of page number
        *(unsigned long*)&txbuf = crc32buf(0, (unsigned int)&ram_data, 0x400);    // incrc, buf, size
        SCI0DRL = *(unsigned char*)&txbuf;
        txmode = 133;
        SCI0CR2 |= 0x88;
    } else if (flagbyte6 & FLAGBYTE6_CRC_CAN) {
        int i;

        flagbyte6 &= ~FLAGBYTE6_CRC_CAN;
// only check ram copy, irrespective of page number
        i = can[1].cxno_in;
        *(unsigned long*)&can[1].cx_datbuf[i][0] = crc32buf(0, (unsigned int)&ram_data, 0x400);    // incrc, buf, size
        // tell the CAN system to send it somewhere
		can[1].cx_msg_type[i] = MSG_RSP; 
		can[1].cx_dest[i] = *((char *)&txbuf + 5);   // send to device stored in ISR

		can[1].cx_destvarblk[i] = *((char *)&txbuf + 4);  // table stored in ISR
		can[1].cx_destvaroff[i] = 0;  // assume offset is zero
		can[1].cx_varbyt[i] = 4;    // 4 bytes

		// This is where (in xmt ring buffer) to put next message
		if(can[1].cxno_in < (NO_CANMSG - 1)) {
			can[1].cxno_in++;
		} else {
			can[1].cxno_in = 0;
		}
		// increment counter
		if(can[1].cxno < NO_CANMSG) {
			can[1].cxno++;
		} else {
			can[1].cxno = NO_CANMSG;
		}
        if(!(CANTIER & 0x07))  {
            CANTBSEL = CANTFLG;
            CANTIER = CANTBSEL;
        }
    }
}

void cp_page(void)
{
    if (flagbyte6 & FLAGBYTE6_PAGECOPY) {
        flagbyte6 &= ~FLAGBYTE6_PAGECOPY;
        page = 0;
        rd_wr = 0;
        if ((tble_idx > 11) || ((tble_idx < 8) && (tble_idx != 4) && (tble_idx != 5))) {
            // this should not happen
            return;
        }
        memcpy(ram_data, tables[tble_idx].addrFlash, 1024);
        page = tble_idx;
        if (tble_idx == 4) {
            pg4_ptr = (page4_data *)&ram_data;
        } else if (tble_idx == 5) {
            pg5_ptr = (page5_data *)&ram_data;
        } else if (tble_idx == 8) {
            pg8_ptr = (page8_data *)&ram_data;
        } else if (tble_idx == 9) {
            pg9_ptr = (page9_data *)&ram_data;
        } else if (tble_idx == 10) {
            pg10_ptr = (page10_data *)&ram_data;
        } else if (tble_idx == 11) {
            pg11_ptr = (page11_data *)&ram_data;
        }
    }
}

long long_abs(long in)
{
    if (in < 0) {
        return -in;
    } else {
        return in;
    }
}

void calc_flexfuel()
{
	if(flash4.FlexFuel & 0x2)  {
		// Remote port
		unsigned int tmppwm = outpc.gpiopwmin[flash4.flexport>>1];
		if(tmppwm > 0)  {
			tmppwm >>= remotePWMscale;
			FSensFreq = (int)(remotePWMfreq / tmppwm);   // Hz
		} else
			FSensFreq = 0;
	} else if(FSens_Pd > 0)  {
		// Local port
		FSensFreq = (int)(7812 / FSens_Pd);   // Hz, (FSens_Pd in .128 tics)
	} else
		FSensFreq = 0;
	if((FSensFreq >= 10)  && (FSensFreq <= 300))  {
		outpc.fuelcor = flash4.fuelCorr[0] +
			(((short)(FSensFreq - flash4.fuelFreq[0]) *
			  (flash4.fuelCorr[1] - flash4.fuelCorr[0])) /
			 (flash4.fuelFreq[1] - flash4.fuelFreq[0])); // %
		ffspkdel = flash4.ffSpkDel[0] +
			(((char)(FSensFreq - flash4.fuelFreq[0]) *
			  (flash4.ffSpkDel[1] - flash4.ffSpkDel[0])) /
			 (flash4.fuelFreq[1] - flash4.fuelFreq[0])); // degx10
	}
	else  {          // sensor reading bad - use default
		outpc.fuelcor = 100;     // %
		ffspkdel = 0;                          // degx10
	}
}

unsigned int maflookup(unsigned int adcval)
{
    return maffactor_table[adcval];
}

void chk_srl(void)
{
    /***************************************************************************
     **
     **  Check for serial, CAN receiver timeout
     **
     **************************************************************************/
    unsigned long ultmp, ultmp2;

    DISABLE_INTERRUPTS;
    ultmp = lmms;
    ultmp2 = rcv_timeout;
    ENABLE_INTERRUPTS;
    if (ultmp > ultmp2)  {
        txmode = 0;    // break out of current receive sequence
        rcv_timeout = 0xFFFFFFFF;
    }
    DISABLE_INTERRUPTS
    ultmp2 = ltch_CAN;
    ENABLE_INTERRUPTS
    if(ultmp > ultmp2)  {
        flagbyte3 &= ~flagbyte3_getcandat;    // break out of current receive sequence
        flagbyte3 &= ~flagbyte3_sndcandat;    // break out of current send sequence
        ltch_CAN = 0xFFFFFFFF;
        CanInit(); // start over again
    }

    if (flagbyte3 & flagbyte3_kill_srl) {
        if (((unsigned int)lmms - srl_timeout) > 39000) { // about 5 seconds of timeout
            flagbyte3 &= ~flagbyte3_kill_srl;
            if (next_txmode == 1) {
                conf_err = 203;
            } else if (next_txmode == 2) {
                conf_err = 204;
            } else if (next_txmode == 3) {
                conf_err = 205;
            } else if (next_txmode == 4) {
                conf_err = 206;
            } else if (next_txmode == 5) {
                conf_err = 207;
            } else if (next_txmode == 6) {
                conf_err = 208;
            } else if (next_txmode == 7) {
                conf_err = 209;
            } else if (next_txmode == 8) {
                conf_err = 210;
            } else if (next_txmode == 9) {
                conf_err = 211;
            } else if (next_txmode == 10) {
                conf_err = 212;
            } else if (next_txmode == 11) {
                conf_err = 213;
            } else if (next_txmode == 12) {
                conf_err = 214;
            } else if (next_txmode == 13) { // not used
                conf_err = 215;
            } else if (next_txmode == 14) {
                conf_err = 217;
            } else {
                conf_err = 216;
            }
            unsigned char dummy;
            dummy = SCI0SR1; // step 1, clear any pending interrupts
            dummy = SCI0DRL; // step 2
            SCI0CR2 |= 0x24;        // rcv, rcvint re-enable
            rcv_timeout = 0xFFFFFFFF;
        }
    }
}
