/* Written by James Murray 2008                                                 *
 * Test code to query every CANid and report on format and full version strings *
 * Serial code needs some work as it isn't 100% reliable. Megasquirt end is     *
 * is working fine from Megatune, so problem is here.                           *
 * Appears to be a port initialisation issue, once I'd run the lin_ms2dl was ok *
 * Included code from lin_ms2dl and works "from cold" now                       *
 * Don't scan target 0xf as that is a promiscuous CANid                         *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <termios.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>
#include <unistd.h>
        
#define BAUDRATE B115200
#define _POSIX_SOURCE 1 /* POSIX compliant source */

#ifdef CREPRINT
#define REPRINT CREPRINT
#else
#define REPRINT CRPRNT
#endif

cc_t    ttydefchars[NCCS] = {
        CEOF,   CEOL,   CEOL,   CERASE, CWERASE, CKILL, REPRINT,
        _POSIX_VDISABLE, CINTR, CQUIT,  CSUSP,  CDSUSP, CSTART, CSTOP,  CLNEXT,
        CFLUSH, 1, 0,  0, _POSIX_VDISABLE
};


      
int main(int argc, char **argv) {
        int fd, res;
        unsigned char c,canid;
        struct termios oldtio,newtio;
        char buf[255];
        
        if (argc != 2) {
            fprintf(stderr, "You must specify a serial device - aborting\n");
            exit(1);
        }
        fd = open(argv[1], O_RDWR | O_NOCTTY ); 
        if (fd <0) {
            perror(argv[1]);
            exit(-1);
        }
        
        fcntl(fd, F_SETFL, 0);

        tcgetattr(fd,&oldtio); /* save current port settings */
     
        memcpy(newtio.c_cc, ttydefchars, NCCS);

        bzero(&newtio, sizeof(newtio));
        newtio.c_cflag &= ~PARENB;
        newtio.c_cflag &= ~CSTOPB;
        newtio.c_cflag &= ~CSIZE;
        newtio.c_cflag = BAUDRATE | CS8 | CLOCAL | CREAD;
        newtio.c_iflag = IGNPAR;
        newtio.c_oflag = 0;
        /* set input mode (non-canonical, no echo,...) */
        newtio.c_lflag = 0;
        newtio.c_cc[VTIME]    = 5;   /* timeout on reads 0.5 sec*/
        newtio.c_cc[VMIN]     = 0;   /* no minimum characters */

        tcsetattr(fd,TCSANOW,&newtio);
        tcflush(fd, TCIOFLUSH);

        tcflush(fd, TCIFLUSH);

        printf("Scanning CAN bus..\n");

        for (canid = 0 ; canid < 15 ; canid++) { // don't probe 15

// query the data format
            buf[0] = 'r';
            buf[1] = canid;
            buf[2] = 0x0f;
            buf[3] = 0x00;
            buf[4] = 0x00;
            buf[5] = 0x00;
            buf[6] = 0x14;
            write(fd,buf,7); // send a request for id string
            tcdrain(fd);
        
            usleep(100);
            printf("0x%x: ", canid);
            res = 1;
            c = 0;
            while (res) {
                res = read(fd,&buf[c],1);   /* returns after 1 chars have been input */
                if (res) {
                    if (c == 0) {
                        printf("Format: ");
                    }
                    if (buf[c] > 31) {
                        printf("%c", buf[c]);
                    } else {
                        printf(".");
                    }
                    c++;
                }
                fflush(stdout);
            }

// query the title
            if (c) {
                buf[0] = 'r';
                buf[1] = canid;
                buf[2] = 0x0e;
                buf[3] = 0x00;
                buf[4] = 0x00;
                buf[5] = 0x00;
                buf[6] = 0x3c;
                write(fd,buf,7); // send a request for id string
                tcdrain(fd);
        
                printf(" : Title: ");
                res = 1;
                c = 0;
                while (res) {
                    res = read(fd,&buf[c],1);   /* returns after 1 chars have been input */
                    if (res) {
                        if (buf[c] > 31) {
                            printf("%c", buf[c]);
                        } else {
                            printf(".");
                        }
                        c++;
                    }

                    fflush(stdout);
                }
            } else {
                printf(" -- no device -- ");
            }
            printf("\n");
            tcflush(fd, TCIOFLUSH);
        }
        tcdrain(fd);
        tcsetattr(fd,TCSANOW,&oldtio);

        return(0);
      }
    
