/*
decode a Megatune comm.log to produce csv files of tooth/trigger logs
that can then be read into a spreadsheet

Written by James Murray 2006
Free software, use as you wish.

Usage:
commlog-parser <page> <file>

Will search the commlog for reads of 'page' and produce
 file.0.csv
 file.1.csv
etc.           

2006 dec 22. rev 2. Ignore segment if first data is zero.
******************
2009 Jan 16: JSM
Minor new variant - this is for the composite log on page 0xf2.
2009 Feb 15: JSM
Make it one executable and specify the page (f0, f1, f2, f3) on the command line
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

int main(int argc, char **argv) {
FILE *f1, *f2;
int filecount=-1, i;
unsigned int ptr, ptr2;
char buf[256], *inname, *outname, *match;
unsigned char flg, flg2, by, by2, opened, out_bits, page;
unsigned long out, count;

  if (argc != 3) {
    fprintf(stderr, "You must specify the page and one file must be specified - aborting\n\ne.g. %s <page> <filename>\n", argv[0]);
    exit(1);
  }

  page = (unsigned char)strtol(argv[1], NULL, 16);
  if (page == 0xf0) {
    match = "SND r  00 f0";
  } else if (page == 0xf1) {
    match = "SND r  00 f1";
  } else if (page == 0xf2) {
    match = "SND r  00 f2";
  } else if (page == 0xf3) {
    match = "SND r  00 f3";
  } else {
    fprintf(stderr, "Page value %x out of allowed range f0 to f3\n", page);
    exit(1);
  }

  inname = argv[2];
  f1 = fopen(inname,"r");
  if (!f1) {
    fprintf(stderr, "Could not open %s for reading - aborting!\n", inname);
    exit(1);
  }
  printf("Opened %s for reading\n", inname);

  if (!(outname = malloc(strlen(inname)+10))) {
     fprintf(stderr, "Malloc failed\n");
     exit(1);
  }

//read in file looking for signature data
  while (!feof(f1)) {
    if (fgets(&buf[0], 256, f1) == NULL) {
      fprintf(stderr, "read error\n");
      exit(1);
    }
    
//    printf("Read in string ***%s***\n", &buf[0]);
    
    //check for sig
    if (strstr(&buf[0], match) != NULL) {
      if (fgets(&buf[0], 256, f1) == NULL) {
        fprintf(stderr, "read error\n");
        exit(1);
      }
      opened=0;
      count=0;

      flg=1;
      by2=0;
      flg2=0;

      if (fgets(&buf[0], 256, f1) == NULL) {
        fprintf(stderr, "read error\n");
        exit(1);
      }

      while (flg) {
        ptr2=strlen(&buf[0]);
        for (i=0 ; i< ptr2 ; i++) {
          if (!flg2) {
//            printf("searching for RCV\n");
            if ((buf[i]=='R') && (buf[i+1]=='C') && (buf[i+2]=='V')) {
              i+= 3;
              flg2=1;
            }
          } else {
            if (buf[i]>32) {
//              printf("Number %c%c ", buf[i], buf[i+1]);
              if (buf[i]>96) {
                by = (buf[i]-87)*16;
              } else {
                by = (buf[i]-48)*16;
              }
              if (buf[i+1]>96) {
                by += buf[i+1]-87;
              } else {
                by += buf[i+1]-48;
              }
              i++;
            
            
//convert to 24bit number
//              printf(" by2=%d, by=%d\n", by2, by);
              if (by2 == 0 ) {
                out = (by & 0xf) * 65536;
                out_bits = (by & 0xf0)>>4;
                by2++;
              } else if (by2 == 1) {
                out += by * 256;
                by2++;
              } else if (by2 == 2) {
                out += by;
                if (opened==0) {
                  if (out == 0) {
                    opened = 2;  // blank data set, so don't write anything
                  } else {
                    filecount++;
                    sprintf(outname, "%s.%d.csv", inname, filecount);
                    if (!(f2 = fopen(outname, "w"))) {
                      fprintf(stderr, "Failed to open %s - aborting\n", outname);
                      exit(1);
                    }
                    opened = 1;
                    printf("Writing to file %s\n", outname);
                    if (page == 0xf0) {
                        fprintf(f2, "semi2, semi, 2nd trig, sync, tooth time\n");
                    } else if (page == 0xf1) {
                        fprintf(f2, "-, -, -, -, tooth time\n");
                    } else if (page >= 0xf2) {
                        fprintf(f2, "sec, pri, trig, sync, tooth time\n");
                    }
                  }
                }
                if (opened == 1) {
                  if ((page == 0xf3) && (count == 340)) {
                    fprintf(f2, "0,0,0,0,0,Last row is %d\n", (out/3)+2);
                  } else {
                    fprintf(f2, "%d,", (out_bits & 0x8)>>3);
                    fprintf(f2, "%d,", (out_bits & 0x4)>>2);
                    fprintf(f2, "%d,", (out_bits & 0x2)>>1);
                    fprintf(f2, "%d,", (out_bits & 0x1));

                    fprintf(f2, "%d\n", out);
                    count++;
                  }
                }

                by2 =0;
              }
            }
          }
        }
        if (feof(f1)) {
          fclose(f2);
          flg=0;
          break;
        }
        if (fgets(&buf[0], 256, f1) == NULL) {
          fprintf(stderr, "read error\n");
          exit(1);
        }

        // check if we got to the end
        if (strstr(&buf[0], "bytes") != NULL) {
//           printf("Got to end\n");
           if (opened == 1) {
             fclose(f2);
           }
           flg=0;
           break;
        }
      } 
    }
  }
}
