/* This program is a VERY quick and dirty hack which will be cleaned up later
 * I wrote it very quickly in order to be able to reflash the MS2 from linux, so
 * things like comport speed, etc... are hardcoded
 * and I'm using blocking I/O when non-blocking would be better, and
 * I can get into situations that require the boot jumper on occasion
 * This program is based on efahl's ms2dl C++ program, but ported to Linux.
 *
 * $Id: lin_ms2dl.c,v 1.8 2009-10-31 16:58:52 culverk Exp $
 */

#ifndef _POSIX_VDISABLE
#define _POSIX_VDISABLE 0
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <termios.h>
#include <unistd.h>

#ifdef CREPRINT
#define REPRINT CREPRINT
#else
#define REPRINT CRPRNT
#endif

cc_t    ttydefchars[NCCS] = {
        CEOF,   CEOL,   CEOL,   CERASE, CWERASE, CKILL, REPRINT,
        _POSIX_VDISABLE, CINTR, CQUIT,  CSUSP,  CDSUSP, CSTART, CSTOP,  CLNEXT,
        CFLUSH, 1, 0,  0, _POSIX_VDISABLE
};


#define BAUDRATE B115200

#define C_WAKE_UP        0x0D
#define C_READ_BYTE      0xA1
#define C_WRITE_BYTE     0xA2
#define C_READ_WORD      0xA3
#define C_WRITE_WORD     0xA4
#define C_READ_NEXT      0xA5
#define C_WRITE_NEXT     0xA6
#define C_READ_BLOCK     0xA7
#define C_WRITE_BLOCK    0xA8
#define MAX_BLOCK        256 // For both writes and reads.
#define C_READ_REGS      0xA9
#define C_WRITE_SP       0xAA
#define C_WRITE_PC       0xAB
#define C_WRITE_IY       0xAC
#define C_WRITE_IX       0xAD
#define C_WRITE_D        0xAE
#define C_WRITE_CCR      0xAF

#define C_GO             0xB1
#define C_TRACE1         0xB2
#define C_HALT           0xB3
#define C_RESET          0xB4
#define C_ERASE_ALL      0xB6
#define C_DEVICE_INFO    0xB7
#define C_ERASE_PAGE     0xB8
#define C_ERASE_EEPROM   0xB9

//--  Error codes  -------------------------------------------------------------

#define E_NONE           0xE0
#define E_COMMAND        0xE1
#define E_NOT_RUN        0xE2
#define E_SP_RANGE       0xE3
#define E_SP_INVALID     0xE4
#define E_READ_ONLY      0xE5
#define E_FACCERR        0xE6
#define E_ACCERR         0xE9

//--  Status codes  ------------------------------------------------------------

#define S_ACTIVE         0x00
#define S_RUNNING        0x01
#define S_HALTED         0x02
#define S_TRACE1         0x04
#define S_COLD_RESET     0x08
#define S_WARM_RESET     0x0C

#define LONG_DELAY 250000  /* 250 ms */

struct termios tio;
int commsfd;
unsigned int total_bytes;

char **fileBuf;
unsigned int count;
int debug = 1;
/* debug levels
0 = Quiet
1 = Some progress
2 = Full progress
3 = + serial comms
4 = + the s19 file as parsed
5 = + comments
*/

void ms2_chomp(char *inBuf)
{
    char *s;

    s = strrchr(inBuf, '\n');
    if (s)
        *s = 0;
    s = strrchr(inBuf, '\r');
    if (s)
        *s = 0;
}

void read_s19 (char *filename)
{
    unsigned int lines = 0;
    char inBuf[256];
    FILE *inFile;

    count = 0;
    if(!(inFile = fopen(filename, "r"))) {
        fprintf (stderr, "Could not open s19 file: %s, exiting...\n", filename);
        exit(1);
    }

    while(fgets(inBuf, sizeof(inBuf), inFile)) {
        lines++;
    }

    fclose(inFile);

    fileBuf = (char **)malloc(lines * sizeof(char *));

    inFile = fopen(filename, "r");

    while(fgets(inBuf, sizeof(inBuf), inFile)) {
        if (debug > 4) {
            fprintf(stderr, "%s", inBuf);
        }
        ms2_chomp(inBuf);
        fileBuf[count] = strdup(inBuf);
        count++;
    }

    fclose(inFile);

    return;
}

void free_s19(void)
{
    unsigned int i;

    for (i = 0; i < count; i++) {
        free(fileBuf[i]);
    }

    free(fileBuf);
}

unsigned int extract_number(char *data, unsigned int nBytes)
{
    char number[128];

    strncpy(number, data, nBytes);
    number[nBytes] = 0;

    return strtol(number, NULL, 16);
}

unsigned char cs(unsigned int l)
{
    return ((l >> 24) & 0xff) + ((l >> 16) & 0xff) + ((l >> 8) & 0xff) + ((l >> 0) & 0xff);
}

unsigned char extract_data(char *data, unsigned int nBytes, unsigned char checksum, unsigned char *binary)
{
    unsigned int i;

    for (i = 0; i < nBytes; i++) {
        unsigned int n = extract_number(data +i*2, 2);
        binary[i] = (char)n;
        checksum += n;
    }

    return checksum;
}

void wakeup_S12(void)
{
    unsigned char errorCode, statusCode, prompt;
    unsigned char c;
    unsigned char c2;
    int i;

    c = C_WAKE_UP;

    fcntl(commsfd, F_SETFL, O_NDELAY);

    for (i = 0; i < 10; i++) {
        prompt = 0;
        fprintf(stderr, "Attempting Wakeup...\n");
        write(commsfd, &c, 1);
        if (debug >= 4) {
            fprintf(stderr, "TX: %02x\n", c);
        }
        usleep(25000);

        read(commsfd, &c2, 1);
        errorCode = c2;
        if (debug >= 4) {
            fprintf(stderr, "RX: %02x", c2);
        }
        read(commsfd, &c2, 1);
        statusCode = c2;
        if (debug >= 4) {
            fprintf(stderr, " %02x", c2);
        }
        read(commsfd, &c2, 1);
        prompt = c2;
        if (debug >= 4) {
            fprintf(stderr, " %02x\n", c2);
        }

        switch(errorCode) {
            case E_NONE:
                break;
            default:
                fprintf(stderr, "Error code 0x%02x\n", errorCode);
        }

        switch(statusCode) {
            case S_ACTIVE:
                break;
            default:
                fprintf(stderr, "Status code 0x%02x\n", statusCode);
        }

        if (prompt != '>') {
            fprintf(stderr, "Prompt was %c\n", prompt);
        } else {
            fprintf(stderr, "Got Prompt, continuing...\n");
            break;
        }

        usleep(LONG_DELAY);
    }

    fcntl(commsfd, F_SETFL, 0);

    if (i == 10) {
        fprintf (stderr, "Could not wake up processor, exiting...\n");
        exit(1);
    }
}
   
void check_status(void)
{
    unsigned char errorCode, statusCode, prompt;
    unsigned char c2;

    read(commsfd, &c2, 1);
    errorCode = c2;
    if (debug >= 4) {
        fprintf(stderr, "RX: %02x", c2);
    }
    read(commsfd, &c2, 1);
    statusCode = c2;
    if (debug >= 4) {
        fprintf(stderr, " %02x", c2);
    }
    read(commsfd, &c2, 1);
    prompt = c2;
    if (debug >= 4) {
        fprintf(stderr, " %02x\n", c2);
    }

    switch(errorCode) {
        case E_NONE:
            break;
        default:
            fprintf(stderr, "Error code 0x%x\n", errorCode);
    }

    switch(statusCode) {
        case S_ACTIVE:
            break;
        default:
            fprintf(stderr, "Status code 0x%x\n", statusCode);
    }

    if (prompt != '>') {
        fprintf(stderr, "Prompt was %c\n", prompt);
    } 
}

void sendPPAGE(unsigned int a, unsigned char erasing)
{
    unsigned char c;
    static unsigned char page = 0;
    unsigned char command [4];

    a = 0xFFFF & (a >> 16);

    if (a != page) {
        page = a & 0xFF;
        fprintf(stderr, "Setting page to 0x%02x:\n", page);
        command[0] = C_WRITE_BYTE;
        command[1] = 0x00;
        command[2] = 0x30;
        command[3] = page;
        write(commsfd, command, 4);
        if (debug >= 4) {
            fprintf(stderr, "TX: %02x %02x %02x %02x\n", command[0], command[1], command[2], command[3] );
        }
        usleep(LONG_DELAY);
        check_status();

        c = C_ERASE_PAGE;
        if (erasing) {
            fprintf(stderr, "erasing page 0x%02x:\n", page);
            write(commsfd, &c, 1);
            if (debug >= 4) {
                fprintf(stderr, "TX: %02x\n", c);
            }
            usleep(LONG_DELAY);
            check_status();
            fprintf(stderr, "Erased.\n");
        }

    }
}

void send_block(unsigned int a, unsigned char *b, unsigned int n)
{
    unsigned char command[4];
    unsigned char i;

    if (a < 0x400) {
        if (debug) {
            fprintf(stderr, "Skipping block %04x\n", a);
        }
        return;
    }

    command[0] = C_WRITE_BLOCK;
    command[1] = 0;
    command[2] = 0;
    command[3] = 0;

    sendPPAGE(a, 1);

    command[1] = 0xFF & (a >> 8);
    command[2] = 0xFF & a;
    command[3] = n - 1;

    if (debug >= 4) {
        fprintf(stderr, "TX: %02x %02x %02x %02x\n", command[0], command[1], command[2], command[3] );
    }

    write(commsfd, command, 4);
    if (debug >= 4) {
        fprintf(stderr, "TX:");
        for (i = 0 ; i < n ; i++) {
            fprintf(stderr, " %02x", b[i] );
        }
        fprintf(stderr, "\n");
    }
    write(commsfd, b, n);
    total_bytes += n;
    check_status();
}

void erase_S12(void)
{
    unsigned char c;

    if (debug) {
        fprintf(stderr, "Erasing main flash!\n");
    }
    c = C_ERASE_ALL;
    usleep(LONG_DELAY);
    write(commsfd, &c, 1);
    if (debug >= 4) {
        fprintf(stderr, "TX: %02x\n", c );
    }
    usleep(LONG_DELAY);
    check_status();
    if (debug) {
        fprintf(stderr, "Erased.\n");
    }
}

void send_S12(void)
{
    unsigned int i, j;
    unsigned char checksum, *thisRec, recsum, difsum;
    unsigned int size, dataSize, addr, addrSize;
    int nBlocks;

    for (i = 0; i < count; i++) {
        switch (fileBuf[i][1]) {
            case '0':
                addrSize = 4;
                break;
            case '1':
                addrSize = 4;
                break;
            case '2':
                addrSize = 6;
                break;
            case '3':
                addrSize = 8;
                break;
            case '7':
                addrSize   = 8;
                break;
            case '8':
                addrSize   = 6;
                break;
            case '9':
                addrSize   = 4;
                break;
        }
        size = extract_number(fileBuf[i]+2, 2);
        dataSize = size - addrSize/2 -1;
        addr = extract_number(fileBuf[i]+4, addrSize);
        checksum = cs(addr) + size;

        thisRec = (unsigned char *)malloc(dataSize + 1);
        checksum = extract_data(fileBuf[i]+4+addrSize, dataSize, checksum, thisRec);

        recsum = extract_number(fileBuf[i]+4+addrSize+dataSize*2, 2);
        difsum = ~(recsum + checksum);

        if (difsum != 0) {
            fprintf(stderr, "Invalid checksum, found 0x%02x, expected %#04x\n", recsum,
                    (unsigned char)~checksum);
        }

        if (debug >= 3) {
            fprintf(stderr, "Sending record %d:%6x\n", i, addr);
        }
        if (addr >= 0x8000 && addr <= 0xBFFF) addr -= 0x4000;

        nBlocks = (dataSize - 1) / MAX_BLOCK + 1;
        for (j = 0; dataSize > 0; j++) {
            int nn = dataSize > MAX_BLOCK ? MAX_BLOCK : dataSize;
            unsigned char *thisRecPtr = thisRec;
            if (addr < 0x8000 && addr+nn > 0x8000) {
                nn = 0x8000 - addr;
            }

            send_block(addr, thisRecPtr, nn);
            dataSize -= nn;
            thisRecPtr += nn;
            addr += nn;
            if (addr >= 0x8000 && addr <= 0xBFFF) addr += 0x4000;
        }

        free(thisRec);
    }
}

void open_comm_port(char *port)
{
    commsfd = open(port, O_RDWR | O_NOCTTY | O_NDELAY);

    if (commsfd < 0) {
        fprintf(stderr, "Could not open serial port: %s... exiting", port);
        exit(1);
    }

    fcntl(commsfd, F_SETFL, 0);

    tcgetattr(commsfd, &tio);

    memcpy(tio.c_cc, ttydefchars, NCCS);

    cfsetispeed(&tio, B115200);
    cfsetospeed(&tio, B115200);

    tio.c_cflag &= ~PARENB;
    tio.c_cflag &= ~CSTOPB;
    tio.c_cflag &= ~CSIZE;

    tio.c_cflag |=  CS8 | CLOCAL | CREAD;
    tio.c_lflag &= ~(ICANON | ECHO | ECHOE | ISIG);
    tio.c_oflag = 0;
    tio.c_iflag = 0;

    tcsetattr(commsfd, TCSANOW, &tio);
}

void close_comm_port(void)
{
    close(commsfd);
}

void enter_boot_mode(void)
{
    printf("Sending jumperless flash command\n");
    write(commsfd, "!", 1);
    if (debug>4) {
        fprintf(stderr, "!");
    }
    usleep(LONG_DELAY);
    tcflush(commsfd, TCIOFLUSH);
    //    sleep(6);

    write(commsfd, "!", 1);
    if (debug>4) {
        fprintf(stderr, "!");
    }
    usleep(LONG_DELAY);
    tcflush(commsfd, TCIOFLUSH);
    //    sleep(3);

    write(commsfd, "!", 1);
    if (debug>4) {
        fprintf(stderr, "!");
    }
    usleep(LONG_DELAY);
    tcflush(commsfd, TCIOFLUSH);

    write(commsfd, "SafetyFirst", 11);
    if (debug>4) {
        fprintf(stderr, "SafetyFirst\n");
    }
    usleep(LONG_DELAY);
    tcflush(commsfd, TCIOFLUSH);

}

void reset_proc(void)
{
    char command = C_RESET;

    write(commsfd, &command, 1);
}

void usage (char **argv)
{
    fprintf (stderr, "Usage:\n");
    fprintf (stderr, "%s [-j] [-f <s19file>] [-c <serial dev>] [-d <debug level>] [-h]\n", argv[0]);
    fprintf (stderr, "-j: Specify if using jumperless flash\n");
    fprintf (stderr, "-f: Specify file to upload\n");
    fprintf (stderr, "-c: Specify the serial device\n");
    fprintf (stderr, "-d: Specify debug level (0-5)\n");
    fprintf (stderr, "-h: Display this help\n");
}

int main(int argc, char **argv)
{
    char *s19file = NULL, *commport = NULL;
    char option;
    int bootmode = 0;

    while((option = getopt(argc, argv, "jf:c:d:h")) != -1) {
        switch(option) {
            case 'j':
                bootmode = 1;
                break;
            case 'f':
                s19file = strdup(optarg);
                break;
            case 'c':
                commport = strdup(optarg);
                break;
            case 'd':
                debug = strtol(optarg, NULL, 10);
                fprintf(stderr,"Enabled debug level %d\n", debug);
                break;
            case 'h':
                usage(argv);
                exit(0);
            default:
                fprintf(stderr, "Unrecognized commandline flag -%c\n", option);
                usage(argv);
                exit(1);
        }
    }

    if (!s19file) {
        s19file = strdup("ms2_extra.s19");
    }

    if (!commport) {
        commport = strdup("/dev/ttyS0");
    }

    total_bytes = 0;

    open_comm_port(commport);
    free(commport);
    read_s19(s19file);
    free(s19file);
    if (bootmode) {
        enter_boot_mode();
    }
    wakeup_S12();
    erase_S12();
    send_S12();
    free_s19();
    reset_proc();
    close_comm_port();
    fprintf(stderr, "Wrote %d bytes\n", total_bytes);

    return 0;
}

