;*********************************************************************
; ISR_SCI_COMM
;*********************************************************************
; $Id: isr_sci.s,v 1.2 2007-05-03 23:16:20 jsmcortina Exp $

.sect .text
.globl ISR_SCI_Comm
.globl ISR_Inj2_TimerOut
.equ getCANid,             40
.equ getTableId,           41
.equ setBurningParameters, 99


             nolist               ;turn off listing
             include "s12asmdefs.inc"
             include "ms2extrah.inc"
             include "ms2extra_structs.inc"
             list                 ;turn listing back on

;**************************************************************************
; **
; ** SCI Communications
; **
; ** Communications is established when the PC communications program sends
; ** a command character - the particular character sets the mode:
; **
; was "a"+<canid>+<table id> = send all of the realtime display variables (outpc structure) via txport.
; now "A" send all realtime vars
; ** "w"+<canid>+<table id>+<offset lsb>+<offset msb>+<nobytes>+<newbytes> =
; **    receive updated data parameter(s) and write into offset location
; **    relative to start of data block
; ** "e" = same as "w" above, followed by "r" below to echo back value
; ** "r"+<canid>+<table id>+<offset lsb>+<offset msb>+<nobytes>+<newbytes> = read and
; **    send back value of a data parameter or block in offset location
; **   offset means data table. FIXME. No specific page change command.
; not implemented: "y" = verify inpram data block = inpflash data block, return no. bytes different.
; ** "b"+<canid>+<table id> = jump to flash burner routine and burn a ram data block into a flash
; **    data block.
; ** "c" = Test communications - echo back Seconds
; ** "Q" = Send over Embedded Code Revision Number
; ** "S" = Send program title.
; ** "P" = forcibly switch page and copy flash to ram if required
; not really needed- trying to force Megatune to work on page 7, but it doesn't
; **
; **************************************************************************
ISR_SCI_Comm:
    ; if RDRF register not set, => transmit interrupt
    ldab	SCI0SR1
    andb	#32
    bne         is1
    jmp         XMT_INT

is1:
    ; Receive Interrupt
    ; Clear the RDRF bit by reading SCISR1 register (done above), then read data
    ;  (in SCIDRL reg).
    ; Check if we are receiving new input parameter update
    ldab   SCI0DRL   ; always read the data first

;log it into ring buffer for debug
; uncomment scidiag in .h and main if needed
;    ldx    scidiag
;    stab   scidiag+2,X
;    inx
;    stx    scidiag   ; store 16bit result
;    clr    scidiag   ; clear top byte as only 8 bits used of 16
; end ring buffer

;fast track for 'A'
    ldaa   txmode
    bne    is1ckmode
    cmpb   #'A'   ; removed 'a' for the moment and use simple A again
    bne    is1ckmode
;sending back realtime vars - 'a' command
    movb   #1,rtsci    ; enable mainloop send mode
    jmp    is1_rti

is1ckmode:
    clr    txgoal
    clr	   txgoal+0x1

    movw   #0xffff, rcv_timeout+0x2
    movw   #0xffff, rcv_timeout

    ldaa   txmode
    beq    is1case0
    cmpa   #5
    beq    is1case5
    cmpa   #6
    beq    is1case6
    cmpa   #7
    beq    is1case7
    cmpa   #8
    beq    is1case8
    cmpa   #9
    beq    is1case9
    cmpa   #30
    beq    is1case30
    cmpa   #31
    beq    is1case31
    cmpa   #32
    beq    is1case32
    cmpa   #33
    beq    is1case33
    cmpa   #34
    beq    is1case34
    cmpa   #35
    beq    is1case35
    cmpa   #36
    beq    is1case36
    cmpa   #37
    beq    is1case37
    cmpa   #38
    beq    is1case38
    cmpa   #39
    beq    is1case39
    cmpa   #40
    beq    is1case40
    cmpa   #41
    beq    is1case41
    cmpa   #42
    beq    is1case42

    cmpa   #getCANid
    beq    is1cgc
    cmpa   #getTableId
    beq    is1cgt
;default
    jmp    isL4

is1case0:
;already read SCI0DRL into B
   cmpb     #'w'
   beq      is1c0w
   cmpb     #'e'
   beq      is1c0e
   cmpb     #'r'
   beq      is1c0r
   cmpb     #'!'
   beq      is1c0exc
   cmpb     #'c'
   beq      is1c0c
   cmpb     #'P'
   beq      is1c0P
   cmpb     #'Q'
   beq      is1c0Q
   cmpb     #'S'
   beq      is1c0S
;default
   jmp      isL4

is1c0w:
;		case 'w':		  // receive new ram input data and write into offset location
   movb     #5, next_txmode
   movb	   #getCANid, txmode ; getCANid
   movb	   #1, rd_wr
   jmp	   isL4

is1c0e:
;		case 'e':		  // same as 'w', but verify by echoing back value
   movb	   #5, next_txmode
   movb	   #getCANid, txmode
   movb	   #2, rd_wr
   jmp	isL4

is1c0r:
;		case 'r':		  // read and send back ram input data from offset location
   movb	   #5, next_txmode
;   movb	   #getCANid, txmode
;   movw	   #0, rd_wr
   bra	   isLM34    ; from gcc

is1c0exc:
;		case '!':        // start receiving reinit/reboot command
   movb	   #30, txmode
   jmp     isL4

is1c0c:
;		case 'c':        // send back seconds to test comms
   clr	    txcnt
   clr	    txcnt+0x1
   movb	   #1, txmode
   movb	   #2, txgoal

   movb    outpc.seconds, SCI0DRL
   inc     outpc.seconds   ; fake it, increment seconds
   jmp	   is1L103

is1c0P:
;		case 'P':		  // change page
   movb	   #10, next_txmode

isLM34:
   movb    #getCANid, txmode
   clr	   rd_wr
   jmp     isL4

is1c0Q:
;		case 'Q':         // send code rev no.
   clr	    txcnt
   clr	    txcnt+0x1
   movb	    #4, txmode
   movw     #20, txgoal
   movb	    RevNum, SCI0DRL  ; put first byte in xmit buffer
   jmp	    is1L103

is1c0S:
;		case 'S':         // send program title
   clr	    txcnt
   clr	    txcnt+0x1
   movb	    #5, txmode
   movw	    #32, txgoal
   movb	    Signature, SCI0DRL   ; put first byte in xmit buffer
   jmp	    is1L103

;-------------- end of case 0
;case getCANid
is1cgc:
;   ldab   SCI0DRL  already done
   stab   CANid
   cmpb   #NO_CANBOARDS
   lbhs   is1LM165  ; out of range
   clra
   tfr    d,x
   ldab   #1  ; force no.1
   lbeq   is1LM165  ; out of range (0 = not in use)
;ok
   movb   #getTableId, txmode
   jmp    isL4
;-------------- end of case getCANid
;	case getTableId: // Get table id for current command.
is1cgt:
;   ldab   SCI0DRL  already done
   stab   tble_idx
   ldaa   CANid
   cmpa   #CANID_THIS_BOARD
   bne    is1LM52   ; out of range
;   cmpb   #NO_TBLES
;   bls    is1LM53   ; ok
   bra    is1LM53   ; ok

is1LM52:
   clr    txmode
   jmp	   is1L27

is1LM53:
   ldab   next_txmode
   cmpb   #10
   beq	   is1LM55
   movb   next_txmode, txmode
   bra	   is1LM56

is1LM55:
   clr	   txmode

is1LM56:
;		// only check flash data pages
;		// as page metaphor also used for realtime data
   ldab    tble_idx
   cmpb    #4
   beq     is1LM57

   clr     txmode   ; illegal table no.
   bra     is1L27   ; anything else then skip

is1LM57:
;		    //see if we changed page
   ldab    #4     ;// force to page 4 to prevent segfault type errors
   cmpb	   page
   beq	   is1L27

   bclr    flagbyte0,flagbyte0_tthlog ; ensure tooth logger off
   bclr    flagbyte0,flagbyte0_trglog ; ensure trigger logger off

   ldab	   tble_idx
   stab    page
   movb    #4,page             ; force it

is1LM69:
   ldab   outpc.status1  ; check if "need burn" bit was set
   bitb   #1
   beq    is1L27
   bset   outpc.status1,#2  ; flag that we lost some data

is1L27:
   clr	   next_txmode

   ldab    txmode

is1LM87:
   jmp     isL4   ; 'y' not supported for now


is1case5:
   stab    rxoffset  ; byte offset(msb) from start of inpram
   jmp     is1L102

is1case6:
   stab    rxoffset+1 ; byte offset(lsb) from start of inpram
   jmp     is1L102

is1case7:
   stab    rxnbytes      ; no. bytes (msb)
   jmp     is1L102

is1case8:
   stab    rxnbytes+1    ; no. bytes (lsb)
   clr	   rxcnt
   clr     rxcnt+0x1

   ldaa	   rd_wr   ; read & send back input data
   bne	   is1LM110

;send ram data back down serial line
   clr	   txcnt
   clr	   txcnt+0x1
   movb    #3, txmode
   movw    rxnbytes,txgoal

; was this and 33 bytes of assembler, but as ramdata is fixed addr, life is easier
;		SCI0DRL = *tableByteRam(tble_idx, rxoffset);
   clra     ; return only zeros
   staa    SCI0DRL
   jmp	   is1L103 ;  xmit enable & xmit interrupt enable

is1LM110:
 ; if short chunk of data, did write data to input data block
 ; JSM removed this feature on the assumptions that
 ; - data errors such as overrun most likely when sending big chunks of data
 ; - we'll add a superior checksum routine
 ; - can always re-copy data from flash if get into trouble
    inc    txmode
    clr	   ibuf
    jmp    isL4

is1case9:
;data phase of 'w' command
;	    // Check for data overrun.  Note: this
;	    // still not bullet proof because could write half the bytes
;	    // then have overrun; need to store and write all at once if
;	    // all is valid.
  ; ldaa    SCI0SR1    ; cross fingers for now
  ; bita    #8
  ; beq     is1LM119

;		//check if we changed anything
   xgdx
   ldd     rxoffset
   addd    rxcnt
   xgdx

; don't write at all
is1LM119:
   ldy     rxcnt
   iny
   sty     rxcnt

   cpy	   rxnbytes
   lbcs    isL4

   ldaa	   rd_wr
   cmpa    #1
   lbeq    is1LM165

   clr	   txcnt
   clr	   txcnt+0x1
   movb	   #3,txmode  ; for verification

   movw	   rxnbytes,  txgoal

   clra
   staa    SCI0DRL

is1L103:
    bset   SCI0CR2, #0x88   ; xmit enable & xmit interrupt enable
    jmp    isL4

is1case30:
   cmpb    #'!'       ; receive 2nd ! for reboot signal.
   bne     is1LM165   ; any other character terminates sequence
   ldaa    bl_timer   ; safety feature. 2nd ! only allowed in 4-9 second window. Otherwise terminate sequence
   cmpa    #5
;   blo     is1LM165
   cmpa    #10
;   bhi     is1LM165
   movb    #1,bl_timer

is1L102:   ; common piece of code
   inc     txmode
   bra     isL4

is1case31:
   cmpb    #'x' ; !!x for reboot (engine will continue running)
   bne     is1LM163
   call    ResetCmd
is1LM163:
   cmpb    #'!' ; received enter monitor mode signal(!!!)
   bne     is1LM165 ; other character terminates sequence
   ldaa    bl_timer ;window as above, this time 2-5 seconds
   ;now check abother 10 bytes of data sent within a few seconds
   bra     is1L102

is1case32:
   cmpb    #'S'
   bne     is1LM165
   bra     is1L102

is1case33:
   cmpb    #'a'
   bne     is1LM165
   bra     is1L102

is1case34:
   cmpb    #'f'
   bne     is1LM165
   bra     is1L102

is1case35:
   cmpb    #'e'
   bne     is1LM165
   bra     is1L102

is1case36:
   cmpb    #'t'
   bne     is1LM165
   bra     is1L102

is1case37:
   cmpb    #'y'
   bne     is1LM165
   bra     is1L102

is1case38:
   cmpb    #'F'
   bne     is1LM165
   bra     is1L102

is1case39:
   cmpb    #'i'
   bne     is1LM165
   bra     is1L102

is1case40:
   cmpb    #'r'
   bne     is1LM165
   bra     is1L102

is1case41:
   cmpb    #'s'
   bne     is1LM165
   bra     is1L102

is1case42:
   cmpb    #'t'
   bne     is1LM165

do_jumperless:
; turn off fuel pump. User is instructed to have coils wired via the relay
   bclr	   PORTE, #0x10

;// go to copy/execute ram serial monitor code
   call    monitor

is1LM165:
   clr     txmode
   bra     is1_rti

;    End of case switch for received data

isL4:

;    if((txgoal == 0) && (txmode > 0))
   ldx     txgoal
   lbne    is1_rti
   tst     txmode
   lbeq    is1_rti
;	rcv_timeout = lmms + 3906;   // 0.5 sec timeout
   ldd     lmms+0x2
   ldx     lmms
   addd    #3906
   bcc     isL4a
   inx
isL4a:
   std     rcv_timeout+0x2
   stx     rcv_timeout
   jmp     is1_rti

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;    // Transmit Interrupt
XMT_INT:
;    // Clear the TDRE bit by reading SCISR1 register (done), then write data
   ldx     txcnt
   inx
   stx     txcnt

   cpx     txgoal
   lbcc    is1LM188

;;;start of switch txmode

   ldab    txmode
   cmpb    #3
   bne     is1LM175
;r command xmit phase
;   ldx     txcnt - done above
   ldd     rxoffset
   leax    d,x
   clra          ; return zero
   staa    SCI0DRL
   jmp     is1_rti

is1LM175:
   cmpb    #4
   bne     is1LM177
;	    SCI0DRL = RevNum[txcnt];
;   ldx     txcnt - done above
   ldaa	   RevNum,X
   staa    SCI0DRL
   jmp     is1_rti

is1LM177:
   cmpb    #5
   bne     is1LM179
;   ldx     txcnt - done above
   ldaa	   Signature,X
   staa    SCI0DRL

is1LM179:
;removed "A" command phase
   bra     is1_rti

is1LM188:
   clr     txcnt
   clr     txcnt+0x1
   clr     txgoal
   clr     txgoal+0x1
   bclr    SCI0CR2, #0x88 ; xmit disable & xmit interrupt disable
   clr     txmode

is1_rti:
   rti

;*********************************************************************

