;*********************************************************************
; ISR_Timer_Clock
;*********************************************************************
; $Id: isr_rtc.s,v 1.60 2011-12-08 15:04:05 jsmcortina Exp $

.sect .text
.globl ISR_Timer_Clock
             nolist               ;turn off listing
             include "s12asmdefs.inc"
             include "ms2extrah.inc"
             include "ms2extra_structs.inc"
             list                 ;turn listing back on

;**************************************************************************
; "0.1ms" section periodic interrupt
; maintains clocks amongst other functions
; **************************************************************************

ISR_Timer_Clock:
;    // .128 ms clock interrupt - clear flag immediately to resume count
   movb    #128, CRGFLG ; clear RTI interrupt flag

;    // also generate 1.024 ms, .10035 sec and 1.0035 sec clocks
   ldd	    lmms+0x2 ; free running clock(.128 ms tics) good for ~ 110 hrs
   ldx	    lmms
   addd     #1
   bcc      lm3a
   inx
lm3a:
   std      lmms+0x2
   stx      lmms

;    mms++;    // in .128 ms tics - reset every 8 tics = 1.0024 ms
   inc      mms

; sequential injection injector channel 1
   ldd      inj1_count
   beq      injector_2
   subd     #1
   std      inj1_count
   bne      injector_2
   ; start injection for channel 1
   STACK_SOFT
   call    INJ1
   UNSTACK_SOFT

injector_2:
; sequential injection injector channel 2
   ldd      inj2_count
   beq      injector_3
   subd     #1
   std      inj2_count
   bne      injector_3
   ; start injection for channel 2
   STACK_SOFT
   call    INJ2
   UNSTACK_SOFT

injector_3:
; sequential injection injector channel 3
   ldd      inj3_count
   beq      injector_4
   subd     #1
   std      inj3_count
   bne      injector_4
   ; start injection for channel 3
   STACK_SOFT
   call    INJ3
   UNSTACK_SOFT

injector_4:
; sequential injection injector channel 4
   ldd      inj4_count
   beq      map_sampling
   subd     #1
   std      inj4_count
   bne      map_sampling
   ; start injection for channel 4
   STACK_SOFT
   call    INJ4
   UNSTACK_SOFT

map_sampling:
   brclr    flagbyte6, #FLAGBYTE6_DONEINIT, no_new_adc
   brclr    ATD0STAT0, #0x80, no_new_adc
   movb     #0xB0, ATD0CTL5

no_new_adc:
    ldab    map_deadman
    cmpb    #4
    bhs     deadmap
   brset    outpc.engine,#0x1,norm_map_sample
map_nonwindow:
   ldx      ATD0DR0
   stx      map_temp
   bset     flagbyte3,#flagbyte3_samplemap
   clr      map_deadman ; acknowledge that we have taken a sample
   bra      done_mapsample 

deadmap:
   ; something went wrong with MAP sampling and samples not happening
   bset     outpc.status3, #4 ; STATUS3_MAPERROR
   bra      map_nonwindow

norm_map_sample:
   ldd      map_start_countdown
   beq      cont_map_check

   ; MAP sampling time?
   subd     #1
   std      map_start_countdown
;   bne      done_mapsample
   bne      cont_map_check  ; allow window to be running while MAP start is counting down
   movw     map_window_set,map_window_countdown
   movw     #0xFFFF,map_temp
cont_map_check:
   ldd      map_window_countdown
   beq      done_mapsample
   subd     #1
   std      map_window_countdown
   ldx      ATD0DR0
   cmpx     map_temp
   bhi      cont_map_check2
   stx      map_temp
cont_map_check2:
   cpd      #0
   bne      done_mapsample
   bset     flagbyte3,#flagbyte3_samplemap
   clr      map_deadman ; acknowledge that we have taken a sample

    brclr   flash4.mapsample_opt, #3, done_min ; bypass

; 4 element ring buffer
    clra
    ldab    map_temps_cnt
    aslb
    tfr     d,y
    stx     map_temps, y
    brclr   flash4.mapsample_opt, #2, scmp1

    cmpb    #6
    blo     cmc2a
    clr     map_temps_cnt
    bra     cmc2b
scmp1:
    cmpb    #2
    blo     cmc2a
    clr     map_temps_cnt
    bra     cmc2b

cmc2a:
    inc     map_temps_cnt
cmc2b:

;pick smallest value
    ldy     #map_temps
    ldd     2,y+
    emind   2,y+
    brclr   flash4.mapsample_opt, #2, str_min
    emind   2,y+
    emind   0,y
str_min:
    std     map_temp

done_min:
   brclr    flagbyte6,#0x2,done_mapsample
   brset    flash4.MAFOption,#0x10,sample_ATD0DR7
   movw     ATD0DR6,maf_temp
   bra      done_mapsample
sample_ATD0DR7:
   movw     ATD0DR7,maf_temp


done_mapsample:
   brset    flagbyte1,#2,do_testmode
   jmp      ir_notest

; --------- test mode in here, normally skipped  --------
do_testmode:
; test mode
   brset    ramdata.testop,#0x10,tstfpon
   bclr     PORTE, #0x10
   bclr     outpc.engine, #1
   bra      tstfp_done
tstfpon:
   bset     PORTE, #0x10
   bset     outpc.engine, #1 ; say running to keep FP on

tstfp_done:
   ldx      testcnt
   beq      tst_choose
   dex
   stx      testcnt
   bra      tst_inj_pwm
tst_choose:
   movw     ramdata.testint,testcnt

   bclr     TCTL2, #0x44  ; set outputs low
   bset     CFORC, #0x0a  ; force inj off. Ensures they turn off if mode changed

   ldaa     ramdata.testmode
   bita     #1
   bne      tst_coils
   bita     #2
   bne      tst_inj
   bra      ir_notest

tst_coils:
   clr      mindwl
   movb     #0xff, maxdwl  
   ldaa     ramdata.testop
   anda     #0x0f
   cmpa     #1
   beq      tds2
   cmpa     #2
   beq      tds4
   cmpa     #3
   beq      tds8
   cmpa     #4
   beq      tds10
   cmpa     #5
   beq      tds20
   movb     #1,dwellsel
   movb     #1,coilsel
   bra      tdsdone
tds2:
   movb     #2,dwellsel
   movb     #2,coilsel
   bra      tdsdone
tds4:
   movb     #4,dwellsel
   movb     #4,coilsel
   bra      tdsdone
tds8:
   movb     #8,dwellsel
   movb     #8,coilsel
   bra      tdsdone
tds10:
   movb     #0x10,dwellsel
   movb     #0x10,coilsel
   bra      tdsdone
tds20:
   movb     #0x20,dwellsel
   movb     #0x20,coilsel
tdsdone:
   ldd      TCNT
   addd     #48 ; slight delay
   std      TC_dwl ; set up dwell O/C
   bset     TIE,#TFLG_dwl
   movb     #TFLG_dwl, TFLG1

   ldaa     ramdata.testdwell
   ldab     #170
   mul
   addd     #48
   addd     TCNT
   std      TC_ign  ; set up spark O/C
   bset     TIE,#TFLG_ign
   movb     #TFLG_ign, TFLG1
   bra      ir_notest

jLM25:
    jmp     LM25

tst_inj:
   bclr     outpc.squirt, #0x03

; injection counter
   ldx      ramdata.testinjcnt  
   stx      outpc.istatus5
   beq      LM25
   brclr    flagbyte1, #0x40, jLM25 ; skip if latch not yet set
   dex
   stx      ramdata.testinjcnt
   bne      ti2
   bclr    flagbyte1, #0x40    ; reached zero, unlatch

ti2:
   brclr    ramdata.testop,0x20,tst_inj2
;tst_inj1
.ifndef MICROSQUIRT
   brclr    seq_inj_ctrl,#1,nopwm1 ; skip if using additional injectors   
   brset    ramdata.testop,0x80,tipw1
   movb     flash4.InjPWMTim,pwm1_on
   movb     flash4.InjPWMPd, PWMPER2
   bra      tid1
tipw1:
   movb     ramdata.testInjPWMTim,pwm1_on
   movb     ramdata.testInjPWMPd, PWMPER2

tid1:
   movb     PWMPER2, PWMDTY2
   clr      PWMCNT2
   bset     PWME, #0x04 ; enable PWM2
.endif
nopwm1:
   ldx      ramdata.testpw
   beq      tst_inj2   ; bail out if zero

   bset     TCTL2, #0x04
   bset     CFORC, #0x02  ; turn inj on

   ldd      TCNT
   addd     ramdata.testpw
   std      TC1       ; set up injector off event
   bclr     TCTL2, #0x04 ; next mode is off
   bset     TIE, #0x02
   movb     #2, TFLG1
   bset     outpc.squirt, #0x01


tst_inj2:
   brclr    ramdata.testop,0x40,tst_inj3
tst_inj2a:
.ifndef MICROSQUIRT
   brclr    seq_inj_ctrl,#1,nopwm2 ; skip if using additional injectors   
   brset    ramdata.testop,0x80,tipw2
   movb     flash4.InjPWMTim,pwm2_on
   movb     flash4.InjPWMPd, PWMPER4
   bra      tid2
tipw2:
   movb     ramdata.testInjPWMTim,pwm2_on
   movb     ramdata.testInjPWMPd, PWMPER4
tid2:
   movb     PWMPER4, PWMDTY4  ; PWM enabled but inactive

   clr      PWMCNT4
   bset     PWME, #0x10 ; enable PWM4
.endif
nopwm2:
   ldx      ramdata.testpw
   beq      tst_inj_done    ; bail out if zero

   bset     TCTL2, #0x40
   bset     CFORC, #0x08  ; turn inj on

   ldd      TCNT
   addd     ramdata.testpw
   std      TC3       ; set up injector off event
   bclr     TCTL2, #0x40 ; next mode is off
   bset     TIE, #0x08
   movb     #0x08, TFLG1
   bset     outpc.squirt, #0x02

tst_inj3:
   brclr    ramdata.testmode,0x10,tst_inj4
   ldx      ramdata.testpw
   beq      tst_inj_done    ; bail out if zero

.ifndef MICROSQUIRT
   bset     TCTL2, #0x10
.else
   bset     TCTL1, #0x10
.endif
   bset     CFORC, TFLG_rotINJ3  ; turn inj on

   ldd      TCNT
   addd     ramdata.testpw
   std      TC_rotINJ3       ; set up injector off event
.ifndef MICROSQUIRT
   bclr     TCTL2, #0x10 ; next mode is off
.else
   bclr     TCTL1, #0x10 ; next mode is off
.endif
   bset     TIE, TFLG_rotINJ3
   movb     TFLG_rotINJ3, TFLG1
   bset     outpc.squirt, #0x04

tst_inj4:
   brset    ramdata.testmode,0x20,tst_inj4a
   jmp      tst_inj_done
tst_inj4a:
   ldx      ramdata.testpw
   beq      tst_inj_done    ; bail out if zero

.ifndef MICROSQUIRT
   bset     TCTL1, #0x01
.else
   bset     TCTL1, #0x40
.endif
   bset     CFORC, TFLG_rotINJ4  ; turn inj on

   ldd      TCNT
   addd     ramdata.testpw
   std      TC_rotINJ4       ; set up injector off event
.ifndef MICROSQUIRT
   bclr     TCTL1, #0x01 ; next mode is off
.else
   bclr     TCTL1, #0x40 ; next mode is off
.endif
   bset     TIE, TFLG_rotINJ4
   movb     TFLG_rotINJ4, TFLG1
   bset     outpc.squirt, #0x08

tst_inj_pwm:
.ifndef MICROSQUIRT
; test mode   check for turning on pwm duty cycle
   brclr   seq_inj_ctrl,#1,tst_inj_done ; skip if using additional injectors   
   tst     pwm1_on ; skip if zero
   beq     tsti2

   dec     pwm1_on
   ldaa    pwm1_on
   bne     tsti2

   brset    ramdata.testop,0x80,tsti1a
   movb    flash4.InjPWMPd,PWMPER2 ; set PWM period (us)
   ldab    flash4.InjPWMPd
   ldaa    flash4.InjPWMDty
   bra     tsti1b
tsti1a:
   movb    ramdata.testInjPWMPd,PWMPER2 ; set PWM period (us)
   ldab    ramdata.testInjPWMPd
   ldaa    ramdata.testInjPWMDty
tsti1b:
   mul
   ldx     #100
   idivs
   xgdx
   stab    PWMDTY2

tsti2:
   tst     pwm2_on ; skip if zero
   beq     tst_inj_done

   dec     pwm2_on
   ldaa    pwm2_on
   bne     tst_inj_done

   brset    ramdata.testop,0x80,tsti2a
   movb    flash4.InjPWMPd,PWMPER4 ; set PWM period (us)
   ldab    flash4.InjPWMPd
   ldaa    flash4.InjPWMDty
   bra     tsti2b
tsti2a:
   movb    ramdata.testInjPWMPd,PWMPER4 ; set PWM period (us)
   ldab    ramdata.testInjPWMPd
   ldaa    ramdata.testInjPWMDty
tsti2b:
   mul
   ldx     #100
   idivs
   xgdx
   stab    PWMDTY4
.endif

tst_inj_done:
   nop ; space for next mode
   bra      LM25 ; skip over normal inj PWM code

; --------- normal code continues --------

ir_notest:
;    check for turning on pwm duty cycle
.ifndef MICROSQUIRT
   brset   outpc.engine,#2,LM25 ; skip if engine is cranking
   brclr   seq_inj_ctrl,#1,LM25 ; skip if using additional injectors   
   tst     pwm1_on ; skip if zero
   beq     LM20

   dec     pwm1_on
   ldaa    pwm1_on
   bne     LM20

LM17:
   ldy     pg4_ptr
   ldab    flash4.InjPWMPd-0x4000,Y ; HARDCODING
   stab    PWMPER2 ; set PWM period (us)
   movb    pwmd1,PWMDTY2

LM20:
   tst     pwm2_on ; skip if zero
   beq     LM25

   dec     pwm2_on
   ldaa    pwm2_on
   bne     LM25

LM22:
   ldy     pg4_ptr
   brset   flash4.ICIgnOption,#0x20,LM22a
   ldab    flash4.InjPWMPd-0x4000,Y ; HARDCODING
   bra     LM22b
LM22a:
   ldab    flash4.InjPWMPd2-0x4000,Y ; HARDCODING
LM22b:
   stab    PWMPER4 ; set PWM period (us)
   movb    pwmd2,PWMDTY4
.endif
LM25:
;    // check for re-enabling IC interrupt
;    if(lmms > t_enable_IC)  {
   ldd     lmms
   cpd     t_enable_IC
   bcs     LM7
   bhi     LM6
   ldd     lmms+0x2
   cpd     t_enable_IC+0x2
   bls     LM7

LM6:
   movb    #1, TFLG1   ; clear Ignition IC interrupt flag
   bset    TIE, #1     ; enable Ignition IC interrupt

   movw    #0xffff, t_enable_IC+0x2
   movw    #0xffff, t_enable_IC

LM7:
;    // check for re-enabling IC2 interrupt
;    if(lmms > t_enable_IC2)  {
   ldd     lmms
   cpd     t_enable_IC2
   bcs     LM9
   bhi     LM8
   ldd     lmms+0x2
   cpd     t_enable_IC2+0x2
   bls     LM9

LM8:
   movb    TFLG_trig2, TFLG1   ; clear 2nd trig IC interrupt flag
   bset    TIE, #TFLG_trig2     ; enable 2nd trig IC interrupt

   movw    #0xffff, t_enable_IC2+0x2
   movw    #0xffff, t_enable_IC2

LM9:
;    // check for IAC step pulses
   ldab    IdleCtl
   cmpb    #4
   beq	   pwmidle
   cmpb    #6
   beq     pwmidle
   bra     LM40 ; skip

pwmidle:
;        // pwm idle
   ldaa    flash5.pwmidle_port
   bne     pwmidledone          ; check if remote PWM idle port and skip if so (but update outpc)
   clra
   ldab    flash5.pwmidle_freq
   addd    iacpwmctr
LM25a:
   std     iacpwmctr

   cpd     #255                         ; counter runs 0-255... gives 30.5 Hz at .4% duty res
   bls     LM32
   clr     iacpwmctr
   clr     iacpwmctr+0x1

LM32:
   ldd     iacpwmctr ; at duty% ?
   cpd     IACmotor_pos
   bhi     pwmidleon

pwmidleoff:
   brclr   flash5.pwmidleset,#2,pwmidle1  ; check for inverted
   bra     pwmidle0

pwmidleon:
   brset   flash5.pwmidleset,#2,pwmidle1  ; check for inverted

pwmidle0:
;           *pPTMpin[2] &= ~0x04; make output 0
   ldx     pPTMpin+0x4
   bclr    0,X,#0x04
   bra     pwmidledone

pwmidle1:
;           *pPTMpin[2] |= 0x04;  make output 1
   ldx     pPTMpin+0x4
   bset    0,X,#0x04

pwmidledone:

;        outpc.iacstep = IACmotor_pos;    // Dual purpose as idle DC - E.Fahlgren fix
   movw    IACmotor_pos, outpc+0x36
   jmp     L31

LM40:
   ldab    IAC_moving
   cmpb    #1
   lble    LM60

   ldd	   lmms          ; if(lmms > motor_time)  {
   cpd	   motor_time
   lbcs    L31
   bhi     LM42
   ldd	   lmms+0x2
   cpd	   motor_time+0x2
   lbls	   L31

LM42:
;changed from 0.1ms to 0.128ms units to eliminate *8/10 conversion
; was             motor_time = lmms + ((flash4.IACtstep*8)/10);  // .128 ms
; now             motor_time = lmms + flash4.IACtstep;  // .128 ms
   ldx     lmms
   clra
   ldab    flash4.IACtstep
   addd    lmms+0x2
   std     motor_time+0x2
   bcc     LM42a     ; if carry then increment top word
   inx
LM42a:
   stx     motor_time

LM45:
   ldx     pPTTpin+0xc  ;  *pPTTpin[6]

   ldd     IACmotor_pos
   cpd     outpc.iacstep
   bgt     step_anticlockwise
   blt     step_clockwise
   bra     LM50

step_clockwise:
   dec     motor_step
   ldab    motor_step
   clra
   andb    #0x7
   stab    motor_step
   ldy     outpc.iacstep
   dey
   sty     outpc.iacstep

   tfr     D,Y

   ldab    IACCoilA,Y
   tstb
   beq     LM47a
   bset    0,X,#64
   bra     LM47b
LM47a:
   bclr    0,X,#64
LM47b:
   ldab    IACCoilB,Y
   tstb
   beq     LM47c
   bset    0,X,#128
   bra     LM50
LM47c:
   bclr    0,X,#128
   bra     LM50

step_anticlockwise:
   inc     motor_step
   ldab    motor_step
   clra
   andb    #0x7
   stab    motor_step
   ldy     outpc.iacstep
   iny
   sty     outpc.iacstep

   tfr     D,Y

   ldab    IACCoilA,Y
   tstb
   beq     LM49a
   bset    0,X,#64
   bra     LM49b
LM49a:
   bclr    0,X,#64
LM49b:
   ldab    IACCoilB,Y
   tstb
   beq     LM49c
   bset    0,X,#128
   bra     LM50
LM49c:
   bclr    0,X,#128

LM50:
   ldd     outpc.iacstep
   cpd     IACmotor_pos
   bne     L31 ; skip if not equal

   ldab    IACmotor_reset
   bne     LM56 ; skip if non-zero

   movb    #1, IACmotor_reset
   movw    #0xf380, last_iacclt ; -3200
    ; this will cause to go to temperature based position after initial reset
   clr     IAC_moving
   bra     LM58

LM56:
   clra
   ldab    IdleCtl
   cpd     #7
   beq	   LM57
   cpd     #8
   beq     LM57
   ldd     flash4.IACcrankxt
   addd    tcrank_done
;   std     outpc.istatus5
   cpd     outpc.seconds
   bhi     LM57
;                        motor_time += 32000; // delay next move for ~4 secs
   ldd     motor_time+0x2
   addd    #0x7d00
   std     motor_time+0x2
   bcc     LM57
   inc     motor_time+0x1
   bne     LM57
   inc     motor_time

LM57:
   movb	#1, IAC_moving

LM58:
   ldab    IdleCtl
   cmpb    #2
   beq     turn_off_IAC
   cmpb    #7
   bne	   L31
turn_off_IAC:
   bset    PORTB, #0x10 ; disable current to stepper motor(bit=1)
   bra     L31

LM60:
   tst     IAC_moving
   beq     L31  ; zero so skip

   ldd     lmms
   cpd     motor_time
   bcs     L31
   bhi     LM62
   ldd     lmms+0x2
   cpd     motor_time+0x2
   bls     L31
LM62:
   clr     IAC_moving
L31:
   ldaa     conf_err                 ; check for code config error
   beq     LM68  ; skip if no error
   cmpa     #190
   bhs     LM68  ; or >=190  (soft error)

   STACK_SOFT
   call    ign_reset
   UNSTACK_SOFT

   movw    outpc.seconds, outpc.clt ; flag up something weird
   ldd     #60                      ;
   subd    outpc.seconds            ; to catch user's attention
   std     outpc.mat                ;
;   movw    #0xffff, outpc.rpm         ;
   jmp     L47

LM68:

L47:
;    // read fuel sensor data, determine freq(proportional to %alcohol)
   brclr   flash4.FlexFuel,#1,LM95  ; skip if not set
   brset   flash4.FlexFuel,#2,LM95  ; skip if remote

;        if (flash4.flexport == 0) {
   brset   flash4.flexport,#1,ff_pa  ; port a  if 1

;          fsensdat = PORTE & 0x01;   // default  PE0
   ldab    PORTE
   bra     LM79a

ff_pa:
   ldab    PORTA
LM79a:
   andb    #1

;        // other option may be to get GPIO to read frequency of it
   brset   FSensStat,#1,FS1
   brset   FSensStat,#2,FS2

FS0:             ; first time - save pin value (below)
   clr     FPdcounter
   clr     FPdcounter+0x1
   clr     FSens_Pd
   clr     FSens_Pd+0x1
   movb    #1, FSensStat
   bra     LM94

FS1:
;                // wait for pin hi -> lo transition to start period(freq) count
   tst     last_fsensdat ;
   beq     LM94          ;
   tstb                  ;
   bne     LM94          ;

   ldx     FPdcounter    ; .128 ms tics
   inx
   stx     FPdcounter
   movb    #2, FSensStat
   bra     LM94

FS2:
;                // continue period count
   tst     last_fsensdat  ; transition hi -> lo
   beq     LM93           ;
   tstb                   ;
   bne     LM93           ;

   movw    FPdcounter, FSens_Pd      ; save present count = period
   clr     FPdcounter                ; start new period count
   clr     FPdcounter+0x1

LM93:
   ldx    FPdcounter
   inx
   stx    FPdcounter

LM94:
   stab    last_fsensdat    ;  last_fsensdat = fsensdat

;end of FF

LM95:
;2nd trigger polling removed as now input capture

   brset    flagbyte1,#2,skip_dwells
   brset    flash4.feature4_0, #0x40, dwell_timers ; under dwell is on
   brset    flash4.feature4_0, #0x08, dwell_timers ; over dwell is on

skip_dwells:
   jmp      LM112i   ; don't do dwell timers if in test mode

;dwell "actual" timers
;if zero then counter is skipped
;if>0 and <ff then increments
;code can then determine how long a coil has actually charged for
; compared to how long it thought it was being charged for
;In here also see if maxdwl exceeded
dwell_timers:
   ldaa    dwl
   beq     LM112b
   cmpa    #0xff
   beq     LM112b
   inc     dwl
   cmpa    maxdwl
   blo     LM112b
   ldab    coilsel
   pshb
   movb    #COILABIT,coilsel
   jsr     fire_coil
   pulb
   stab    coilsel
LM112b:
   ldaa    dwl+1
   beq     LM112c
   cmpa    #0xff
   beq     LM112c
   inc     dwl+1
   cmpa    maxdwl
   blo     LM112c
   ldab    coilsel
   pshb
   movb    #COILBBIT,coilsel
   jsr     fire_coil  
   pulb
   stab    coilsel
LM112c:
   ldaa    dwl+2
   beq     LM112d
   cmpa    #0xff
   beq     LM112d
   inc     dwl+2
   cmpa    maxdwl
   blo     LM112d
   ldab    coilsel
   pshb
   movb    #COILCBIT,coilsel
   jsr     fire_coil  
   pulb
   stab    coilsel
LM112d:
   ldaa    dwl+3
   beq     LM112e
   cmpa    #0xff
   beq     LM112e
   inc     dwl+3
   cmpa    maxdwl
   blo     LM112e
   ldab    coilsel
   pshb
   movb    #COILDBIT,coilsel
   jsr     fire_coil  
   pulb
   stab    coilsel   
LM112e:
   ldaa    dwl+4
   beq     LM112f
   cmpa    #0xff
   beq     LM112f
   inc     dwl+4
   cmpa    maxdwl
   blo     LM112f
   ldab    coilsel
   pshb
   movb    #COILEBIT,coilsel
   jsr     fire_coil  
   pulb
   stab    coilsel
LM112f:
   ldaa    dwl+5
   beq     LM112g
   cmpa    #0xff
   beq     LM112g
   inc     dwl+5
   cmpa    maxdwl
   blo     LM112g
   ldab    coilsel
   pshb
   movb    #COILFBIT,coilsel
   jsr     fire_coil  
   pulb
   stab    coilsel
LM112g:
   ldaa    dwl+6
   beq     LM112h
   cmpa    #0xff
   beq     LM112h
   inc     dwl+6
   cmpa    maxdwl
   blo     LM112h
   ldab    coilsel
   pshb
   movb    #COILGBIT,coilsel
   jsr     fire_coil  
   pulb
   stab    coilsel
LM112h:
   ldaa    dwl+7
   beq     LM112i
   cmpa    #0xff
   beq     LM112i
   inc     dwl+7
   cmpa    maxdwl
   blo     LM112i
   ldab    coilsel
   pshb
   movb    #COILHBIT,coilsel
   jsr     fire_coil  
   pulb
   stab    coilsel

LM112i:
   ldd     mapsample_time
   addd    #1
   std     mapsample_time
   ldd     tpssample_time
   addd    #1
   std     tpssample_time

;;;; boost
check_boost:
   brclr    flash5.boost_ctl_settings,#0x8,check_countdownmode
   brset    flash5.boost_ctl_settings,#0x40,check_countdownmode  ; Remote boost control
   ldaa	    mmsDiv
   inca 
   staa	    mmsDiv
   ldaa	    flash5.boost_ctl_settings  ; bits 0-2... 78 Hz = 1, 39 Hz = 2, 26 = 3, 19.5 = 4, 15.6 = 5, etc...
   anda	    #0x7
   cmpa	    mmsDiv	
   bhi      check_countdownmode
   movb	    #0,mmsDiv
   ldaa	    boost_ctl_clock
   inca
   cmpa     #100
   blo      cont_boost_clk
   clra
cont_boost_clk:
   staa     boost_ctl_clock

   ldaa     boost_ctl_duty
   beq	    boostOff
   cmpa	    boost_ctl_clock
   blo      boostOff

boostOn:
   brset    flash5.boost_ctl_settings,#0x20,bcClrout
   bra      bcSetout

boostOff:
   brset    flash5.boost_ctl_settings,#0x20,bcSetout
   bra	    bcClrout

bcSetout:
   ldx	    boostport
   ldaa     0,X
   oraa     boostpin
   staa     0,X
   bra      check_countdownmode

bcClrout:
   ldx      boostport
   ldab     boostpin 
   comb
   andb     0,X 
   stab     0,X 

check_countdownmode:
; removed and replaced by dwell queue

dwell_queue:
; array is of ints
; dwellq[0].sel = dwellq
; dwellq[0].time_us  = dwellq+2
; dwellq[0].time_mms = dwellq+4
; dwellq[1].sel = dwellq+6
; dwellq[1].time_us  = dwellq+8
; dwellq[1].time_mms = dwellq+10

dq1:
    ldx     dwellq
    beq     dq2
    ldy     dwellq+4
    dey
    sty     dwellq+4
    bne     dq2
    clr     dwellq
    clr     dwellq+1
    ldd     dwellq+2
    bsr     dq_fire

dq2:
    ldx     dwellq+6
    beq     dq_done
    ldy     dwellq+10
    dey
    sty     dwellq+10
    bne     dq_done
    clr     dwellq+6
    clr     dwellq+7
    ldd     dwellq+8
    bsr     dq_fire

    bra     dq_done

dq_fire:
    xgdx
    stab    dwellsel
    stx     TC_dwl
    movb    #TFLG_dwl, TFLG1
    bset    TIE, #TFLG_dwl
    rts

dq_done:

spark_queue:
; array is of ints
; spkq[0].sel = spkq
; spkq[0].time_us  = spkq+2
; spkq[0].time_mms = spkq+4
; spkq[1].sel = spkq+6
; spkq[1].time_us  = spkq+8
; spkq[1].time_mms = spkq+10

sq1:
    ldx     spkq
    beq     sq2
    ldy     spkq+4
    dey
    sty     spkq+4
    bne     sq2
    clr     spkq
    clr     spkq+1
    ldd     spkq+2
    bsr     sq_fire

sq2:
    ldx     spkq+6
    beq     sq_done
    ldy     spkq+10
    dey
    sty     spkq+10
    bne     sq_done
    clr     spkq+6
    clr     spkq+7
    ldd     spkq+8
    bsr     sq_fire

    bra     sq_done

sq_fire:
    xgdx
    stab    coilsel
    stx     TC_ign
    movb    #TFLG_ign, TFLG1
    bset    TIE, #TFLG_ign
    rts

sq_done:


;;;; start of clocks section

rtc_clocks:
; are we within 2 rtc ticks of the overflow? if so, let IC know
   ldd TCNT
   cpd #0xFE7F
   blo  really_rtc_clocks
   bset flagbyte1,#flagbyte1_ovfclose


really_rtc_clocks:
;create 0.128ms period timer like MS1 did. Used for tacho out
   ldx     lowres_ctr
   cpx     #0xffff
   beq     no_low
   inx
   stx     lowres_ctr
no_low:

;tacho out
   brclr   flash5.tacho_opt,#128,no_tachoff
   ldaa    flash4.userlevel
   cmpa    #128
   blo     no_tachoff
   cpx     tacho_targ
   bne     no_tachoff
; turn off tacho output
   ldaa    flash5.tacho_opt
   anda    #0x3f
   beq     toff_pt5
   cmpa    #1
   beq     toff_pt7
   cmpa    #2
   beq     toff_pt6
   cmpa    #3
   beq     toff_pa0
   cmpa    #4
   beq     toff_pm2
   cmpa    #5
   beq     toff_pm3
   cmpa    #6
   beq     toff_pm4
   cmpa    #7
   beq     toff_pm5
   cmpa    #8
   beq     toff_ptad40
   cmpa    #9
   beq     toff_ptad80
   bra     no_tachoff ; illegal
toff_pt5:
   bclr    PORTT,#0x20
   bra     no_tachoff
toff_pt6:
   bclr    PORTT,#0x40
   bra     no_tachoff
toff_pt7:
   bclr    PORTT,#0x80
   bra     no_tachoff
toff_pa0:
   bclr    PORTA,#0x01
   bra     no_tachoff
toff_pm2:
   bclr    PORTM,#0x04
   bra     no_tachoff
toff_pm3:
   bclr    PORTM,#0x08
   bra     no_tachoff
toff_pm4:
   bclr    PORTM,#0x10
   bra     no_tachoff
toff_pm5:
   bclr    PORTM,#0x20
   bra     no_tachoff
toff_ptad40:
   bclr    PTAD,#0x40
   bra     no_tachoff
toff_ptad80:
   bclr    PTAD,#0x80
;  bra     no_tachoff

no_tachoff:

; semi-seq time mask

    ldd       inj1cntdown
    beq	      checkinj2
    subd      #1
    std	      inj1cntdown
    beq	      SEMI_SCHED1

checkinj2:
    ldd	      inj2cntdown
    beq	      done_semi
    subd      #1
    std       inj2cntdown
    beq	      SEMI_SCHED2
    bra	      done_semi

SEMI_SCHED1:
    STACK_SOFT
    call      INJ1
    UNSTACK_SOFT
    bra       checkinj2

SEMI_SCHED2:
    STACK_SOFT
    call      INJ2
    UNSTACK_SOFT

done_semi:
;    // check mms to generate other clocks
   ldaa	   mms
   cmpa    #7   ; reset every 8 ticks
   bls     CLK_DONE
   clr     mms

   ldaa    millisec
   adda    #1    ; // actually 1.024 ms
   staa    millisec

   brclr   flash5.boost_ctl_settings,#0x8,idle_ctl_timer
   ldd     boost_ctl_timer
   addd    #1
   cmpd    flash5.boost_ctl_ms
   blo     continue_boost
   bset    flagbyte3,#flagbyte3_runboost
   ldd     #0

continue_boost:
   std     boost_ctl_timer

idle_ctl_timer:
   ldab    IdleCtl
   cmpb    #6
   beq     continue_idle_ctl_timer
   cmpb    #7
   beq     continue_idle_ctl_timer
   cmpb    #8
   beq     continue_idle_ctl_timer
   bra     continue_millisec

continue_idle_ctl_timer:
   ldd     pwmidle_timer
   addd    #1
   cmpd    flash5.pwmidle_ms
   blo     store_pwmidle_timer
   bset    flagbyte2,#flagbyte2_runidle
   ldd	   #0

store_pwmidle_timer:
   std     pwmidle_timer
   
continue_millisec:
   ldab    adc_ctr
   addb    #1
   cmpb    #10   ; every 10.24ms

;50ms now made into 10ms as we were 6x slower than MS1 (8ms sampling period on MAP)
   bne     milli_cont
   clrb
   bset    flagbyte0,#flagbyte0_50ms  ; set flag so mainloop can do lag factors

;run nitrous down timer here at 1/100s
   ldaa    n2o_act_timer
   beq     n2chk2
   dec     n2o_act_timer

n2chk2:
   ldaa    n2o2_act_timer
   beq     milli_cont
   dec     n2o2_act_timer

milli_cont:
   stab    adc_ctr
   ldaa    millisec
   cmpa    #98
   bls     CLK_DONE

LM116:
   cmpa    #99
   bls     CLK_DONE
   clr     millisec

;(1/10) tenth of second section
   inc     tpsaclk  ; .10035 sec clocks
   inc     knk_clk
   ldaa    fc_counter
   beq     no_fc
   dec     fc_counter
no_fc:

; reset holdoff timer in 0.1 second units
   tst     resetholdoff
   beq     hod
   dec     resetholdoff
hod:

CLK_DONE:

   ldx    TC_ovflow  ;    // Get display seconds from continuously running TCNT
   inx
   stx    TC_ovflow
   cpx    #7813
   blo    DONE1s
   clr    TC_ovflow
   clr    TC_ovflow+1
   ldx    outpc.seconds ;        // update seconds to send back to PC
   inx
   stx    outpc.seconds
   ldaa   bl_timer
   beq    pwmidle_wait_timer
   cmpa   #255
   beq    pwmidle_wait_timer
   inca
   staa   bl_timer

pwmidle_wait_timer:
   ldaa   idle_wait_timer
   cmpa   #255
   beq    idle_advance_tmer 
   inca
   staa   idle_wait_timer

idle_advance_tmer:
   ldaa   idle_advance_timer
   cmpa   #255
   beq    idle_shift_timer 
   inca
   staa   idle_advance_timer

idle_shift_timer:
   ldaa   pwmidle_shift_timer
   cmpa   #255
   beq    running_timer
   inca
   staa   pwmidle_shift_timer

running_timer:
   ldd    outpc.rpm  ; if rpm is 0, don't increment this counter
   beq	  fc_ego_timer 
   ldaa   running_seconds
   cmpa   #255
   beq    fc_ego_timer
   inca
   staa   running_seconds

fc_ego_timer:
   ldaa   fc_off_time
   cmpa   flash5.fc_ego_delay
   bhs    DONE1s
   inca
   staa   fc_off_time

DONE1s:

   rti

