;*********************************************************************
; ISR_SCI_COMM
;*********************************************************************
; $Id: isr_sci.s,v 1.46 2011-08-17 23:52:50 jsmcortina Exp $

.sect .text
.globl ISR_SCI_Comm
.globl ISR_Inj2_TimerOut
.globl chknewpage
.equ getCANid,             40
.equ getTableId,           41
.equ setBurningParameters, 99


             nolist               ;turn off listing
             include "s12asmdefs.inc"
             include "ms2extrah.inc"
             include "ms2extra_structs.inc"
             list                 ;turn listing back on

;**************************************************************************
; **
; ** SCI Communications
; **
; ** Communications is established when the PC communications program sends
; ** a command character - the particular character sets the mode:
; **
; was "a"+<canid>+<table id> = send all of the realtime display variables (outpc structure) via txport.
; now "A" send all realtime vars
; ** "w"+<canid>+<table id>+<offset lsb>+<offset msb>+<nobytes>+<newbytes> =
; **    receive updated data parameter(s) and write into offset location
; **    relative to start of data block
; ** "e" = same as "w" above, followed by "r" below to echo back value
; ** "r"+<canid>+<table id>+<offset lsb>+<offset msb>+<nobytes>+<newbytes> = read and
; **    send back value of a data parameter or block in offset location
; **   offset means data table. FIXME. No specific page change command.
; not implemented: "y" = verify inpram data block = inpflash data block, return no. bytes different.
; ** "b"+<canid>+<table id> = jump to flash burner routine and burn a ram data block into a flash
; **    data block.
; ** "c" = Test communications - echo back Seconds
; ** "t" = receive new table data for local sensor data
; ** "T" = receive new table data for CAN re-transmission to GPIO
; ** "Q" = Send over Embedded Code Revision Number
; ** "S" = Send program title.
; **
; **************************************************************************
ISR_SCI_Comm:
    ; if RDRF register not set, => transmit interrupt
    ldab	SCI0SR1
    bitb        #7
    bne         rx_err
    bitb        #32
    bne         is1
    bitb        #128
    lbne        XMT_INT

    jmp         is1_rti


rx_err:
    bitb    #1
    bne     rx_err_pf
    bitb    #2
    bne     rx_err_fe
    bitb    #4
    bne     rx_err_nf
    bitb    #8
    bne     rx_err_or
    clr     next_txmode ; shouldn't happen..
    bra     srl_abort

rx_err_pf:
    movb    #1, next_txmode
    bra     srl_abort
rx_err_fe:
    movb    #2, next_txmode
    bra     srl_abort
rx_err_nf:
    movb    #3, next_txmode
    bra     srl_abort
rx_err_or:
    movb    #4, next_txmode
    bra     srl_abort
tx_err_notcomplete:
    movb    #14, next_txmode
    bra     srl_abort

rx_re_en:
    ldab    txmode
    cmpb    #255
    bne     tx_err_notcomplete
    clr     txmode
    bra     is1_rti

is1:
    ; Receive Interrupt
    ; Clear the RDRF bit by reading SCISR1 register (done above), then read data
    ;  (in SCIDRL reg).
    ; Check if we are receiving new input parameter update
    ldab   SCI0DRL   ; always read the data first

;log it into ring buffer for debug
; uncomment scidiag in .h and main if needed
;    ldx    scidiag
;    stab   scidiag+2,X
;    inx
;    stx    scidiag   ; store 16bit result
;    clr    scidiag   ; clear top byte as only 8 bits used of 16
; end ring buffer

;fast track for 'A'
    ldaa   txmode
    bmi    rxerrtxmode
    bne    is1ckmode
    cmpb   #'A'   ; removed 'a' for the moment and use simple A again
    bne    is1ckmode
;sending back realtime vars - 'a' command
    bclr   flagbyte2,#flagbyte2_MV2      ; disable MV2 mode
    movb   #1,rtsci    ; enable mainloop send mode
    jmp    is1_rti

rxerrtxmode:
    movb   #5, next_txmode

; had serial overrun
srl_abort:
    clr    txmode
    bclr   SCI0CR2,#0xAC;   // rcv, xmt disable, interrupt disable
    bset   flagbyte3,#flagbyte3_kill_srl
    movw   lmms+2, srl_timeout
    jmp    isL4           ; bail out

is1ckmode:
    clr    txgoal
    clr    txgoal+0x1

    movw   #0xffff, rcv_timeout+0x2
    movw   #0xffff, rcv_timeout

is1ckm1:
    ldaa   txmode   ; already in a
    beq    is1case0
    cmpa   #5
    beq    is1case5
    cmpa   #6
    beq    is1case6
    cmpa   #7
    beq    is1case7
    cmpa   #8
    beq    is1case8
    cmpa   #9
    beq    is1case9
    cmpa   #20
    beq    is1case20
    cmpa   #21
    beq    is1case21
    cmpa   #22
    beq    is1case22

    cmpa   #getCANid
    beq    is1cgc
    cmpa   #getTableId
    beq    is1cgt

    cmpa   #24
    beq    is1case24
    cmpa   #25
    beq    is1case25
    cmpa   #26
    beq    is1case26

    cmpa   #50
    beq    is1case50
    cmpa   #51
    beq    is1case51
    cmpa   #52
    beq    is1case52
    cmpa   #53
    beq    is1case53
    cmpa   #54
    beq    is1case54
    cmpa   #55
    beq    is1case55
    cmpa   #56
    beq    is1case56
    cmpa   #57
    beq    is1case57
    cmpa   #58
    beq    is1case58
    cmpa   #59
    beq    is1case59
    cmpa   #60
    beq    is1case60
    cmpa   #61
    beq    is1case61
    cmpa   #62
    beq    is1case62

;default
    jmp    isL4

is1case0:
;already read SCI0DRL into B
   cmpb     #'w'
   beq      is1c0w
   cmpb     #'r'
   beq      is1c0r
;   cmpb     #'y'   ; don't like 'y' command, checksum would be easier and more robust
;   beq      is1c0y
   cmpb     #'b'
   beq      is1c0b
   cmpb     #'t'
   beq      is1c0t
   cmpb     #'!'
   beq      is1c0exc
   cmpb     #'c'
   beq      is1c0c
   cmpb     #'Q'
   beq      is1c0Q
   cmpb     #'S'
   beq      is1c0S
   cmpb     #'a'  ; for MV2
   beq      is1c0a
   cmpb     #'T'  ; sensor data table to go to GPIO via CAN
   beq      is1c0tt
   cmpb     #'k'  ; return crc32 of table
   beq      is1c0k
   cmpb     #'p'
   beq      is1c0p

;default
   jmp      isL4

is1c0a:
   bset     flagbyte2,#flagbyte2_MV2      ; enabled MV2 mode
   movb    #129, next_txmode
   bra     txgc

is1c0w:
;		case 'w':		  // receive new ram input data and write into offset location
   movb	   #1, rd_wr
   bra     ntxm5

is1c0r:
;		case 'r':		  // read and send back ram input data from offset location
   clr	   rd_wr
   bra     ntxm5

is1c0k:	  ; crc32 of table
   movb	   #2, rd_wr
   bra	   ntxm5

is1c0p:	  ; change page
   movb	   #3, rd_wr
   bra	   ntxm5

is1c0b:
;		case 'b':        // burn a block of ram input values into flash
   movb	   #setBurningParameters, next_txmode

isLM22:
   bra     txgc

is1c0t:
;		case 't':        // update a flash table with following serial data
   movb	   #20, txmode
   jmp     isL4

is1c0exc:
;		case '!':        // start receiving reinit/reboot command
   movb	   #50, txmode
   movb    #1,bl_timer           ; set bootload safety timer
   jmp     isL4

is1c0c:
;		case 'c':        // send back seconds to test comms
   clr	    txcnt
   clr	    txcnt+0x1
   movb    #128, txmode
   movw	   #2, txgoal

   ldd     outpc.seconds  ; to maintain coherency
   staa    SCI0DRL
   std     txbuf
   jmp	   is1L103

is1c0Q:
;		case 'Q':         // send code rev no.
   clr	    txcnt
   clr	    txcnt+0x1
   movb     #131, txmode
   movw     #20, txgoal
   movb	    RevNum, SCI0DRL  ; put first byte in xmit buffer
   jmp	    is1L103

is1c0S:
;		case 'S':         // send program title
   clr	    txcnt
   clr	    txcnt+0x1
   movb     #132, txmode
   movw	    #60, txgoal
   movb	    Signature, SCI0DRL   ; put first byte in xmit buffer
   jmp	    is1L103

is1c0tt:
   movb     #24,next_txmode
   movb     getCANid,txmode
   clr      Tcksum
   jmp	    is1L103

;-------------- end of case 0
;case getCANid
is1cgc:
   stab   CANid
   cmpb   #MAX_CANBOARDS
   bhs   err_canid
   movb   #getTableId, txmode
   jmp    isL4

err_canid:
   movb   #7, next_txmode
   jmp    srl_abort

;-------------- end of case getCANid
;	case getTableId: // Get table id for current command.
; it is imperative that tuning software inserts a small delay after this byte to allow MS2 to swap tables if required
; otherwise the next bytes may over-run and get lost.
is1cgt:
   stab   tble_idx
   movb   next_txmode, txmode

is1LM56:
   ldaa   CANid
   cmpa   flash4.mycan_id
   beq    cgt_local

;;; handle feed through CAN burns ;;;
; We allow a single command to go through without altering local pages and such
   ldab    txmode
   cmpb    #setBurningParameters
   beq     rem_burn
; for CAN pass-through read/write nothing to do yet, wait for next command
   clr     next_txmode
   jmp     isL4

rem_burn:
   STACK_SOFT
   call    can_sendburn
   UNSTACK_SOFT
   clr     txmode
   jmp     isL4

err_table:
    movb    #8, next_txmode
    jmp     srl_abort

cgt_local:
   bclr   flagbyte4,#flagbyte4_cantuning
   ldab   tble_idx
   bsr    chknewpage
   tsta
   beq    cgtloc_noerr
   ldaa   rd_wr
   cmpa   #3
   bne    err_table  ; if A non zero then there was an error - abort
   clr    rd_wr
   jmp    txmcl

cgtloc_noerr:
;check for MV2 mode
   ldab   next_txmode
   cmpb   #129
   lbne   isL4
   movb   #1,rtsci    ; enable mainloop send mode (MV2)
   clr    txmode
   jmp    is1_rti

; subrouting shared with CAN code. Checks to see if page is in RAM and copies if not
; Having a sub in the middle of here is a bit odd, but this is where the code was, now
; shared by CAN code for same function.

chknewpage:
; all this ONLY applies to local data
;		// only check flash data pages
;		// as page metaphor also used for realtime data
   cmpb    #4
   beq     is1LM57
   cmpb    #5
   beq     is1LM57
   cmpb    #6
   beq     end_chknewpage  ; ok, but don't do anything yet
   cmpb    #7
   beq     end_chknewpage  ; ok, but don't do anything yet
   cmpb    #8
   beq     is1LM57
   cmpb	   #9
   beq	   is1LM57
   cmpb    #10
   beq     is1LM57
   cmpb    #11
   beq     is1LM57
; add other tables in here if required
   cmpb    #14
   beq     is1L27 ; no need to copy data and such
   cmpb    #15
   beq     is1L27 ; no need to copy data and such

   cmpb    #0xf0    ; tooth logger
   beq     log_com
   cmpb    #0xf1    ; trigger logger
   beq     log_com
   cmpb    #0xf2    ; composite tooth logger
   beq     log_com
   cmpb    #0xf3    ; composite tooth logger loop
   beq     log_com

   clr     txmode    ; illegal table no.
   bra     end_chknewpage_error ; abort

log_com:
;ensure logger is OFF during sending data
   bclr    flagbyte0, #flagbyte0_tthlog ; ensure tooth logger off
   bclr    flagbyte0, #flagbyte0_trglog ; ensure trigger logger off
   bclr    flagbyte0, #flagbyte0_complog ; ensure composite tooth logger off
   cmpb    page
   beq     log_com_ok
   stab    page ; just selected a new log page

   bclr    outpc.status3, #status3_donelog
; clear page data
;   ldd   #512
;   ldy    #ram_data

; caution! memcpy equivalent below
;tthclr2:
;   movw   #0, 2,y+
;   dbne   d, tthclr2
   movw   #0, ram_data ; just nullify first word

log_com_ok:
   movw    #flash4, pg4_ptr
   movw    #flash5, pg5_ptr
   movw    #flash10, pg10_ptr
   movw    #flash8, pg8_ptr
   movw	   #flash9, pg9_ptr
   movw	   #flash11, pg11_ptr
   bra     is1LM69

is1LM57:
;		    //see if we changed page
   cmpb	   page
   beq	   is1L27

   bclr    flagbyte0, #flagbyte0_tthlog ; ensure tooth logger off
   bclr    flagbyte0, #flagbyte0_trglog ; ensure trigger logger off
   bclr    flagbyte0, #flagbyte0_complog ; ensure composite tooth logger off
   bclr    outpc.status3, #status3_donelog

; clear pointers
   movw    #flash4, pg4_ptr
   movw    #flash5, pg5_ptr
   movw    #flash10, pg10_ptr
   movw    #flash8, pg8_ptr
   movw	   #flash9, pg9_ptr
   movw	   #flash11, pg11_ptr

; temporary code that didn't work too well
;    ldaa    rd_wr
;    cmpa    #3  ; page change
;    bne     is1LM57cp
;    bset    flagbyte6, #FLAGBYTE6_PAGECOPY
;    bra     end_chknewpage_error

is1LM57cp:

;do a lookup in tables. (int) ram addr, (int) flash addr, (int) size
   ldaa   #6
   mul
   tfr    d,x
   ldy    tables,X   ; dest
   ldd    tables+4,X ; size (1024)
   lsrd              ; no. words
   ldx    tables+2,X ; source

;copy flash to ram  (memcpy)
is1cplp:
   movw   2,X+, 2,Y+  ; 2 looks odd but works
   dbne   D, is1cplp

   ldab	   tble_idx
   stab    page
;                        // set ram / flash pointers
   cmpb    #4
   bne	   is1LM65
   movw	   #ram_data, pg4_ptr
   bra	   is1LM69

is1LM65:
   cmpb    #5
   bne	   is1LM67
   movw	   #ram_data, pg5_ptr
   bra	   is1LM69

is1LM67:
   cmpb    #10
   bne     is1LM68
   movw	   #ram_data, pg10_ptr
   bra	   is1LM69

is1LM68:
   cmpb    #8
   bne     is1PG9
   movw	   #ram_data, pg8_ptr
   bra	   is1LM69

is1PG9:
   cmpb    #9
;   bne     is1LM69
   bne     is1PG11
   movw    #ram_data, pg9_ptr
   bra	   is1LM69

is1PG11:
   cmpb    #11
   bne     is1LM69
   movw    #ram_data, pg11_ptr
;   bra	   is1LM69

is1LM69:
   ldab   outpc.status1  ; check if "need burn" bit was set
   bitb   #status1_needburn
   beq    is1L27
   bset   outpc.status1,#status1_lostdata  ; flag that we lost some data

is1L27:
   brclr   flagbyte4,#flagbyte4_cantuning, is1L27Xa
   jmp     end_chknewpage
is1L27Xa:
   clr	   next_txmode

   ldab    txmode
   cmpb    #setBurningParameters
   bne     end_chknewpage
;;; This is the burn routine for local data ;;;

   ldab    page
   cmpb    #8
   bne     is1L27aa
   ldx     ramdata.testmodelock
   cpx     #12345
   beq     is1L27ac
   bclr    flagbyte1,#2  ; disable test mode
   bra     is1L27ab
is1L27ac:
   bset    flagbyte1,#2  ; enable test mode
   bclr    outpc.status1, #status1_needburn ; turn out Burn indicator
   call    ign_reset     ; kill off anything if engine running
   clr     outpc.rpm
   clr     outpc.rpm+1
is1L27ab:
   clr     ramdata.testmodelock      ; clear testmode in ram,
   clr     ramdata.testmodelock+1    ;  so we never burn this ON
   clr     ramdata.iactest          ; ensure this is never burned on
   clr     ramdata.testinjcnt
   clr     ramdata.testinjcnt+1

; all pages carry on here
is1L27aa:
   ldab	   flocker
   bne     is1LM27b    ; shouldn't be set. Clear it

   clr     txmode
   brset   flagbyte1, #2, end_chknewpage
;OK to burn page
   movb    #15,resetholdoff   ; allow 1.5s for resync (over two revs @ 120 rpm)

   call	   Flash_Init ; check FDIV written to (should be at reset) likely safe?
   movb	   #0xCC, flocker ; // set semaphore to prevent burning flash thru runaway code
   bclr    outpc.status1, #status1_needburn+status1_lostdata  ; clear NeedBurn,LostData


;		// Changed from Al's code. Do all burning right here so tables don't get screwed up.
;		// Likely to cause a stumble though. FIXME
   ldab    page
   cmpb    #NO_TBLES
   bhi     is1LM27b   ; skip if illegal page (MT insists on trying to burn regardless)
   cmpb    #4
   bne     is1LM27ad

   ldx     flash4.adv_offset ; has trigger angle/offset been changed?
   cpx     ramdata.adv_offset
   bne     b_change

   ldx     flash4.Miss_ang ; has tooth#1 angle been changed?
   cpx     ramdata.Miss_ang
   bne     b_change

   bra     is1LM27ad
  
b_change:
   ; if the trigger angle/offset or #1 angle changed then we need to do ign_reset
   jsr     burntbl
   STACK_SOFT
   call    ign_wheel_init ; re-initialise wheels
   call    ign_reset      ; reset ignition
   UNSTACK_SOFT
   bra     is1LM27b

is1LM27ad:
   jsr     burntbl  ; safe

is1LM27b:
   clr     flocker
   brclr   flash10.feature3,#0x08,end_chknewpage
   bclr    flagbyte3,#flagbyte3_toothinit
end_chknewpage:
   clra
   rts

end_chknewpage_error:
   ldaa    #1
   clr     flocker
   rts
;************************************
  
is1case5:
   stab    rxoffset  ; byte offset(msb) from start of inpram
   jmp     is1L102

is1case6:
   stab    rxoffset+1 ; byte offset(lsb) from start of inpram
   jmp     is1L102

is1case7:
   stab    rxnbytes      ; no. bytes (msb)
   jmp     is1L102

is1case8:
   stab    rxnbytes+1    ; no. bytes (lsb)
   clr	   rxcnt
   clr     rxcnt+0x1

   ldab    CANid
   cmpb    flash4.mycan_id
   beq     is1c8local

;check if can get or snd
   ldaa     rd_wr
   beq      is1c8gc
   cmpa     #1
   beq      is1c8sc
   cmpa     #2
   beq      is1c8kc
   bra      err_table ; not exact, but close enough

is1c8gc:  ;get from can
   clr     txmode
   STACK_SOFT
   call    can_reqdata
   UNSTACK_SOFT
   jmp     isL4

is1c8kc:  ;crc32 checksum via can
   clr     txmode
   STACK_SOFT
   call    can_crc32
   UNSTACK_SOFT
   jmp     isL4

is1c8sc:
;get ready to send to can
   bclr    flagbyte3,#flagbyte3_getcandat
   bset    flagbyte3,#flagbyte3_sndcandat
;  	    ltch_CAN = lmms + 3906;    0.5 sec timeout to get CAN data
   ldd     lmms+0x2
   ldx     lmms
   addd    #3906
   bcc     is1c8t
   inx
is1c8t:
   std     ltch_CAN+0x2
   stx     ltch_CAN
   ; actually send CAN commands in next serial phase (case9)
   jmp     is1L102

loc67:
    bra is1c8com
;The following code is 'nice' in that the fast-track mainloop code is used
;instead but leads to inconsistencies between pass-through and local data
;In the future realtime() could be updated to handle the CAN sends as well
;for speed and consistency.
;RC2 - took out checksum, so this code no longer causes an inconsistency
   ldd     rxoffset
   bne     is1c8com  ; not starting at zero
   ldd     rxnbytes
   cpd     #SIZEOFTXBUF
   bne     is1c8com  ; not full size
; starts at zero and full size, so use mainloop code
   clr    txmode
   movb   #1,rtsci    ; enable mainloop send mode
   jmp    is1_rti

is1c8local:
   bclr    flagbyte3,#flagbyte3_getcandat+flagbyte3_sndcandat  ; neither get,snd

; see if RT data, if so then use mainloop send (could possibly do all TX in mainloop)
   ldab    tble_idx
   cmpb    #6
   beq     loc67
   cmpb    #7
   beq     loc67
;wasn't outpc or txbuf complete

is1c8com:
   ldd     rxoffset
   addd    rxnbytes
   cmpd    #1024      ; all tables in MS2/Extra are 1k
   lbhi    srl_abort  ; something went wrong

   ldaa    rd_wr
   beq     is1LM109
   cmpa    #1
   beq	   is1LM110
   cmpa    #2
   beq     c8cksum
   bra     err_table ; similar error

c8cksum:
;checksum
   clr	   txcnt
   clr	   txcnt+0x1
   clr     txmode
   movw    rxnbytes,txgoal
   bset    flagbyte6, #FLAGBYTE6_CRC  ; get mainloop to do calcs
   jmp     is1_rti

is1LM109:
;send ram data back down serial line
   clr	   txcnt
   clr	   txcnt+0x1
   movb    #130, txmode
   movw    rxnbytes,txgoal

; was this and 33 bytes of assembler, but as ramdata is fixed addr, life is easier
;		SCI0DRL = *tableByteRam(tble_idx, rxoffset);
;   ldx     rxoffset
;   ldaa    ram_data,X
; the above two lines do not support reading from other tables, put back to how it was

;hard code for tooth/trigger logger pages
   ldab    tble_idx
   cmpb    #0xf0
   blo     regpgs

   ldd      #ram_data ; always read from ramdata
   bra      readpg

regpgs:
   ldaa    #6
   mul
   tfr     d,x
   ldd     tables,x

readpg:
   addd    rxoffset
   tfr     d,x
   ldaa    0,x

   staa    SCI0DRL
   jmp	   is1L103 ;  xmit enable & xmit interrupt enable

is1LM110:
 ; if short chunk of data, did write data to input data block
 ; JSM removed this feature on the assumptions that
 ; - data errors such as overrun most likely when sending big chunks of data
 ; - we'll add a superior checksum routine
 ; - can always re-copy data from flash if get into trouble
    inc    txmode
    jmp    isL4

is1case9:
;data phase of 'w' command
;	    // Check for data overrun.  Note: this
;	    // still not bullet proof because could write half the bytes
;	    // then have overrun; need to store and write all at once if
;	    // all is valid.
  ; ldaa    SCI0SR1    ; cross fingers for now
  ; bita    #8
  ; beq     is1LM119

   ldaa   CANid
   cmpa   flash4.mycan_id
   beq    c9_local
;; buffered for CAN ;;
;; Store small chunks in txbuf then send on via CAN ;;
   ldx     rxcnt
   stab    txbuf,x  ; store it directly to ram
   inx
   stx     rxcnt

   cpx	   rxnbytes
   beq     i9sbc   ; send it
   tfr     x,d
   clra
   andb    #0x07
   beq     i9sbc    ; send the 8 byte block

   jmp     isL4  ; not done with whole transfer yet

; with the speed of CAN, we are _probably_ able to receive in 8 byte chunks and deliver by
; can as fast as serial comes in - perhaps?
; Present code splits received data into 8 byte blocks automatically
i9sbc:
   brclr   flagbyte3,#flagbyte3_sndcandat,c9_rem_end  ;we must be in a send phase, but double check
   STACK_SOFT
   call    can_snddata   ; send the chunk via CAN
   UNSTACK_SOFT

   ldx     rxcnt
   cpx	   rxnbytes
   lbne    isL4       ; not finished yet
c9_rem_end:
   clr     txgoal
   clr     txmode
   jmp     isL4


c9_local:
;		//check if we changed anything
   xgdx
   ldd     rxoffset
   addd    rxcnt
   xgdx
   ldaa    ram_data,x
   cba
   beq     is1LM119
   bset    outpc.status1, #status1_needburn  ; flag burn needed

   stab    ram_data,x  ; store it directly to ram
is1LM119:
   ldy     rxcnt
   iny
   sty     rxcnt

   cpy	   rxnbytes
   lbcs    isL4

   ldaa	   rd_wr
   cmpa    #1
    beq is1LM120

   clr	   txcnt
   clr	   txcnt+0x1
   movb	   #3,txmode  ; for verification

   movw	   rxnbytes,  txgoal

   ldx     rxoffset
   ldaa    ram_data,x   ; this is sending the data back. Doesn't appear to ever be used by Megatune
   staa    SCI0DRL

is1L103:
    bset   SCI0CR2, #0x88   ; xmit enable & xmit interrupt enable
    jmp    isL4

is1LM120:
    ; check if test mode data was written and double-buffer injector counter
    brclr    flagbyte1,#2, is1LM122
    ldab    page
    cmpb    #8
    bne     is1LM122
    ldx     ramdata.testinjcnt
    beq     is1LM121
    bset    flagbyte1, #0x40    ; a count is set and end of write transaction, enable inj test. Ensures coherency
    bra     is1LM122

is1LM121:
    bclr    flagbyte1, #0x40 ; ensure off if 0 inj is written

is1LM122:
    jmp     is1LM165

is1case20:
;		 // d/load & burn tables - *** Do while engine NOT turning ***
;	    // Note: this type table has no ram copy - its not intended for tuning
;            dummy = SCI0DRL;  // getting garbage data???
   clr	   ntword
   clr	   ntword+0x1
   stab    tble_idx
   cmpb    #3
   lbhi    srl_abort

   call    Flash_Init ; check FDIV written to (should be at reset)
   movb    #0xcc,flocker ; set semaphore to prevent burning flash thru runaway code
   call	   erasefactor ; erase table
   clr     flocker
   bra     is1L102

is1case21:
    stab   tble_word ; high byte
    bra    is1L102

is1case22:
    stab   tble_word+1 ; low byte
    movb   #0xCC, flocker ; set semaphore to prevent burning flash thru runaway code

    ldab   tble_idx
    cmpb   #3
    bhi    is1LM146
    call   progfactor   ; asm, safe
is1LM146:
    clr    flocker
    ldx	   ntword
    inx
    stx	   ntword

;figure out no. words in table
    ldaa   #6
    mul
    tfr    d,x
    ldd    tables+4,x
    addd   #1
    lsrd

    cpd    ntword
    bls    is1LM153

    movb   #21, txmode
    bra    isL4

is1LM153:
    clr    txmode
    STACK_SOFT
    call    ign_reset
    UNSTACK_SOFT
    bra    isL4


is1case24:
; nbytes must be <= 8 for CAN interaction (unless code buffers it)
    stab    rxnbytes
    bra     is1L102

is1case25:
    stab    rxnbytes+1
    clr     rxcnt
    clr     rxcnt+1
    clr     Tcntr
    bra     is1L102

is1case26:
; get 4 table words (8 bytes). Receive msb,then lsb for each word 
    ldaa    Tcksum
    aba
    staa    Tcksum
    tfr     d,x
    clra
    ldab    Tcntr
    xgdx
    stab    txbuf,x   ; stores serial data into txbuf
  	inc     Tcntr
    ldx     rxcnt
    inx
  	stx     rxcnt
    ldaa    Tcntr
    cmpa    #8
    blo     is1c26no
    cpx     rxnbytes
    blo     is1c26no
    STACK_SOFT
    call    can_t    ; send CAN message to GPIO with this data
    UNSTACK_SOFT
    clr     Tcntr
    ldx     rxcnt
    cpx     rxnbytes
    blo     is1c26no
    jmp     txmcl

is1c26no: ; continue with receiving bytes, 
    bra     isL4

is1case50:
   cmpb    #'!'       ; receive 2nd ! for reboot signal.
   bne     is1LM165   ; any other character terminates sequence
   ldaa    bl_timer   ; safety feature. 2nd ! only allowed in 4-9 second window. Otherwise terminate sequence
   cmpa    #5
;   blo     is1LM165
   cmpa    #10
;   bhi     is1LM165
   movb    #1,bl_timer

is1L102:   ; common piece of code
   inc     txmode
   bra     isL4

is1case51:
   cmpb    #'x' ; !!x for reboot (engine will continue running)
   bne     is1LM163
   call    ResetCmd ; safe
is1LM163:
   cmpb    #'!' ; received enter monitor mode signal(!!!)
   bne     is1LM165 ; other character terminates sequence
   ldaa    bl_timer ;window as above, this time 2-5 seconds
   cmpa    #3
;   blo     is1LM165
   cmpa    #6
;   bhi     is1LM165
   clr     bl_timer
   ;now check abother 10 bytes of data sent within a few seconds
   bra     is1L102

is1case52:
   cmpb    #'S'
   bne     is1LM165
   bra     is1L102

is1case53:
   cmpb    #'a'
   bne     is1LM165
   bra     is1L102

is1case54:
   cmpb    #'f'
   bne     is1LM165
   bra     is1L102

is1case55:
   cmpb    #'e'
   bne     is1LM165
   bra     is1L102

is1case56:
   cmpb    #'t'
   bne     is1LM165
   bra     is1L102

is1case57:
   cmpb    #'y'
   bne     is1LM165
   bra     is1L102

is1case58:
   cmpb    #'F'
   bne     is1LM165
   bra     is1L102

is1case59:
   cmpb    #'i'
   bne     is1LM165
   bra     is1L102

is1case60:
   cmpb    #'r'
   bne     is1LM165
   bra     is1L102

is1case61:
   cmpb    #'s'
   bne     is1LM165
   bra     is1L102

is1case62:
   cmpb    #'t'
   bne     is1LM165
   ldaa    bl_timer    ; check sequence came in fast enough (2 seconds)
   cmpa    #3
   bhi     is1LM165

do_jumperless:
; turn off fuel pump. User is instructed to have coils wired via the relay
   bclr	   PORTE, #0x10

;// go to copy/execute ram serial monitor code
   call    monitor  ; safe

is1LM165:
   clr     txmode
   bra     is1_rti

;    End of case switch for received data
ntxm5:
   movb	   #5, next_txmode
txgc:
   movb	   #getCANid, txmode ; getCANid
isL4:

;    if((txgoal == 0) && (txmode > 0))
   ldx     txgoal
   lbne    is1_rti
   tst     txmode
   lbeq    is1_rti
;	rcv_timeout = lmms + 3906;   // 0.5 sec timeout
   ldd     lmms+0x2
   ldx     lmms
   addd    #3906
   bcc     isL4a
   inx
isL4a:
   std     rcv_timeout+0x2
   stx     rcv_timeout
   jmp     is1_rti

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;    // Transmit Interrupt
XMT_INT:
;    // Clear the TDRE bit by reading SCISR1 register (done), then write data
   ldx     txcnt
   inx
   stx     txcnt

   cpx     txgoal
   lbcc    is1LM188

;;;start of switch txmode

   ldab    txmode

   ldab    txmode
   lbeq    err_txmode0 ; txmode = 0,   shouldn't be here
   lbpl    err_txmode12 ; txmode < 128, shouldn't be here
   cmpb    #128
   bne     is1LM170
;this is txmode = 1 , realtime data - read from txbuf
   ldaa    txbuf,X
   staa    SCI0DRL

   bra     is1_rti

err_txmode0:
   bra     is1_rti
;    movb    #6, next_txmode
;    jmp     srl_abort

err_txmode12:
    movb    #12, next_txmode
    jmp     srl_abort

is1LM170:

is1LM171:
   cmpb    #130
   bne     is1LM175
;r command xmit phase
;hard code for tooth/trigger logger pages

   ldab    tble_idx
   cmpb    #0xf0
   blo     regpgs2

   ldd      #ram_data ; always read from ramdata
   bra      readpg2

regpgs2:
   ldaa    #6
   mul
   tfr     d,x
   ldd     tables,x

readpg2:
   addd    rxoffset
   addd    txcnt
   tfr     d,x
   ldaa    0,x

   staa    SCI0DRL
   jmp     is1_rti

is1LM175:
   cmpb    #131
   bne     is1LM177
;	    SCI0DRL = RevNum[txcnt];
;   ldx     txcnt - done above
   ldaa	   RevNum,X
   staa    SCI0DRL
   jmp     is1_rti

is1LM177:
   cmpb    #132
   bne     is1LM179
;   ldx     txcnt - done above
   ldaa	   Signature,X
   staa    SCI0DRL
   jmp     is1_rti

is1LM179:
   cmpb    #133
   bne     is1LM180   ; send back buffered CAN data
   ldaa	   txbuf,X
   staa    SCI0DRL

   jmp     is1_rti

is1LM180:
;removed "A" command phase - now in mainloop
   bra     is1_rti

is1LM188:
   clr     txcnt
   clr     txcnt+0x1

   ldab    txmode
   cmpb    #133
   bne     is1LM189
; see if more CAN chunks to fetch
   ldx     rxnbytes
   cpx     #8
   bls     is1LM189  ; we are done
   tfr     x,d
   subd    #8
   std     rxnbytes
   ldd     rxoffset
   addd    #8
   std     rxoffset
   STACK_SOFT
   call    can_reqdata  ; request another chunk of data by CAN
   UNSTACK_SOFT
   bra     is1LM190
is1LM189:
   bset    SCI0CR2, #0x24;   // re-enable received interrupt and receiver
is1LM190:
   clr     txgoal
   clr     txgoal+0x1
   bclr    SCI0CR2, #0x88 ; xmit disable & xmit interrupt disable
   ldab    txmode
   cmpb    #130
   bne     txmcl

;trigger logger init. Check in f0-f3 range
   ldab    tble_idx
   cmpb    #0xf0
   blo     txmcl
   cmpb    #0xf3
   bhi     txmcl

log_com3:
   bclr    outpc.status3, #status3_donelog
   bset    flagbyte5, #FLAGBYTE5_LOG_CLR ; set flag to clear buffer in mainloop
   clr     log_offset
   clr     log_offset+1
txmcl:
   clr     txmode

is1_rti:
   rti

;*********************************************************************


