/* This header should be included by all other source files in the
 * ms2-extra project.
 */

/* $Id: ms2_extra.h,v 1.205 2011-12-08 15:04:05 jsmcortina Exp $ */
#ifndef _MS2_EXTRA_H
#define _MS2_EXTRA_H

#include "hcs12def.h"      /* common defines and macros */
#include "flash.h"         /* flashburner defines, structures */
#include <string.h>

#include "us_opt_c.h"

extern void _start(void);       /* Startup routine */

//#define CAN_TEST

#define FAR_TEXT1_ATTR __attribute__ ((far)) __attribute__ ((section (".text3c")))
#define FAR_TEXT3d_ATTR __attribute__ ((far)) __attribute__ ((section (".text3d")))
#define FAR_TEXT38_ATTR __attribute__ ((far)) __attribute__ ((section (".text38")))
#define FAR_TEXT39_ATTR __attribute__ ((far)) __attribute__ ((section (".text39")))
#define FAR_TEXT3a_ATTR __attribute__ ((far)) __attribute__ ((section (".text3a")))
#define FAR_TEXT3b_ATTR __attribute__ ((far)) __attribute__ ((section (".text3b")))
#define LOOKUP_ATTR __attribute__ ((section (".lookup")))
#define EEPROM_ATTR __attribute__ ((section (".eeprom")))
#define TEXT3a_ATTR __attribute__ ((section (".text3a")))
#define TEXT3c_ATTR __attribute__ ((section (".text3c")))
#define TEXT3_ATTR __attribute__ ((section (".text3")))
#define INTERRUPT
#define POST_INTERRUPT __attribute__((interrupt))
#define POST_INTERRUPT_TEXT3 __attribute__ ((section (".text3"))) __attribute__((interrupt))
#define POST_INTERRUPT_TEXT3d __attribute__ ((section (".text3d"))) __attribute__((interrupt))
#define ENABLE_INTERRUPTS __asm__ __volatile__ ("cli");
#define DISABLE_INTERRUPTS __asm__ __volatile__ ("sei");
#define NEAR
#define VECT_ATTR __attribute__ ((section (".vectors")))

extern const int cltfactor_table[1024] LOOKUP_ATTR; // caution ms2_extra_can.c forces a pageswap to this page
extern const int matfactor_table[1024] LOOKUP_ATTR;
extern const unsigned char egofactor_table[1024] LOOKUP_ATTR;
extern const unsigned int maffactor_table[1024] LOOKUP_ATTR;

INTERRUPT void UnimplementedISR(void) POST_INTERRUPT;
INTERRUPT void ISR_Ign_TimerIn(void) POST_INTERRUPT_TEXT3;
INTERRUPT void ISR_Ign_TimerIn_paged(void) FAR_TEXT38_ATTR;
INTERRUPT void ISR_Ign_TimerOut(void) POST_INTERRUPT;
INTERRUPT void ISR_TC5(void) POST_INTERRUPT;
INTERRUPT void ISR_Dwl_TimerOut(void) POST_INTERRUPT;
INTERRUPT void ISR_Rot_TimerOut(void) POST_INTERRUPT;
INTERRUPT void ISR_Rot_SpkTimerOut(void) POST_INTERRUPT;
INTERRUPT void ISR_Inj1_TimerOut(void) POST_INTERRUPT_TEXT3;
INTERRUPT void ISR_Inj2_TimerOut(void) POST_INTERRUPT_TEXT3;
void ISR_Inj3_TimerOut(void) POST_INTERRUPT_TEXT3;
void ISR_Inj4_TimerOut(void) POST_INTERRUPT_TEXT3;
INTERRUPT void ISR_TimerOverflow(void) POST_INTERRUPT;
INTERRUPT void ISR_Timer_Clock(void) POST_INTERRUPT;
INTERRUPT void ISR_SCI_Comm(void) POST_INTERRUPT;
INTERRUPT void CanTxIsr(void) POST_INTERRUPT;
INTERRUPT void CanRxIsr(void) POST_INTERRUPT;

typedef void (* NEAR tIsrFunc)(void);

int intrp_1dctable(int x, unsigned char n, int * x_table, char sgn,
		unsigned char * z_table);
int intrp_1ditable(int x, unsigned char n, int *x_table, char sgn,
		unsigned int *z_table);
int intrp_2dctable(unsigned int x, int y, unsigned char nx, unsigned char ny,
		unsigned int * x_table, int * y_table, unsigned char * z_table,
		unsigned char hires);
int intrp_2dctable_signed(unsigned int x, int y, unsigned char nx,
		unsigned char ny, unsigned int * x_table, int * y_table,
		char * z_table);
int intrp_2ditable(unsigned int x, int y, unsigned char nx, unsigned char ny,
		unsigned int * x_table, int * y_table, int * z_table);

int intrp_1ditable_3a(int x, unsigned char n, int *x_table, char sgn,
		unsigned int *z_table) FAR_TEXT3a_ATTR;
int intrp_2dctable_signed_3a(unsigned int x, int y, unsigned char nx,
		unsigned char ny, unsigned int * x_table, int * y_table,
		char * z_table) FAR_TEXT3a_ATTR;

unsigned int twoptlookup(unsigned int x, unsigned int x0, unsigned int x1, unsigned int y0, unsigned int y1 ) FAR_TEXT1_ATTR;

#define NO_TBLES        16
#define NO_EXFMAPS      16
#define NO_EXFRPMS      16
#define NO_FMAPS        12
#define NO_SMAPS        12
#define NO_FRPMS        12
#define NO_SRPMS        12
#define NO_ARPMS  6
#define NO_ATPSS  6
#define NO_INJ          2
#define NO_TEMPS        10
#define NO_MAT_TEMPS    6
#define NO_BARS         6
#define NO_MATS         6
#define NO_TPS_DOTS   4
#define NO_MAP_DOTS   4
#define NO_KNKRPMS  6
#define NPORT    7
#define NO_COILCHG_PTS  6
#define EGODT  78        /* 78 .128 ms tics = 10 ms */
#define END_SYNCH  3
#define MAXNUMTEETH 120
#define SIZEOFTXBUF 169 // be sure to update ms2extrah.inc as well

#define SER_TOUT  5

#define MSG_CMD 0
#define MSG_REQ 1
#define MSG_RSP 2
#define MSG_XSUB        3
#define MSG_BURN        4
#define OUTMSG_REQ  5
#define OUTMSG_RSP  6
#define MSG_XTND    7
// define xtended msgs from 8 on
#define MSG_FWD     8
#define MSG_CRC     9
#define NO_CANMSG 8 // was 10
#define MAX_CANBOARDS 16
// Error status words:
//    -bits 0-7 are current errors
//    -bits 8-15 are corresponding latched errors
#define XMT_ERR                 0x0101
#define CLR_XMT_ERR             0xFFFE
#define XMT_TOUT                0x0202
#define CLR_XMT_TOUT    0xFFFD
#define RCV_ERR                 0x0404
#define CLR_RCV_ERR             0xFFFB
#define SYS_ERR         0x0808

typedef struct {
   unsigned int *addrRam;
   unsigned int *addrFlash;
   unsigned int  n_bytes;
} tableDescriptor;

extern const tableDescriptor tables[NO_TBLES];

// User inputs - 1 set in flash, 1 in ram
typedef struct {
    unsigned char no_cyl,no_skip_pulses,      // skip >= n pulses at startup
                  ICIgnOption,     // Bit 0: Input capture: 0 = falling edge, 1 rising
                  // bit 3: 0 = evenfire, 1 = oddfire
                  // bit 4 = spk out hi/lo 0 = spk low (gnd)
                  // bit 5 = inj2 uses own parameters

                  XXspkout_hi_lo,    // Ign Output compare: 0 = spark low (gnd)
                  max_coil_dur,max_spk_dur,DurAcc;        // ms x 15 (10* 3/2)
    unsigned char deltV_table[NO_COILCHG_PTS],deltDur_table[NO_COILCHG_PTS], // Vx10,%age/2
     PredOpt;          // Option for prediction algorithm for next tach plse
    //  0=use last time interval
    //  1=use 1st deriv prediction; 2=use 1st deriv at hi
    //   rpm, 2nd deriv prediction at lo rpm;
    //  3=use 2nd deriv prediction always.
    int crank_rpm;        // rpm at which cranking is through (~300 - 400 rpm)
    int cold_adv_table[NO_TEMPS],
        adv_offset,        // all in deg x 10
        //     adv_offset is no deg(x10) between trigger (Input Capture) and TDC.
        //     It may be +btdc (IC1 to TDC) or -atdc (TDC to IC2).
        //
        //    |               |     |
        //    |               |     |
        //   -|---------------|-----|-
        //   IC1             TDC    IC2
        TpsBypassCLTRevlim,RevLimRpm2;  // Optn 1:Retard spk by 0 deg at Rpm1 and increase
    //    to RevLimMaxRtd at Rpm2
    // Optn 2:Cut fuel above Rpm2, restore below Rpm1
    unsigned char afr_table[NO_INJ][NO_FMAPS][NO_FRPMS],            // afr x 10
                  warmen_table[NO_TEMPS], // % enrichment vs temp
                  tpsen_table[NO_TPS_DOTS], // accel enrichment pw in .1 ms units vs tpsdot
                  mapen_table[NO_MAP_DOTS]; // accel enrichment pw in .1 ms units vs mapdot
    int iacstep_table[NO_TEMPS]; // iac steps vs temp
    unsigned int frpm_tablea[NO_INJ][NO_FRPMS];  // fuel, spk rpm tables
    int fmap_tablea[NO_INJ][NO_FMAPS],      // kpa x 10,
        temp_table[NO_TEMPS],             // deg x 10 (C or F)
        tpsdot_table[NO_TPS_DOTS],        // change in % x 10 per .1 sec
        mapdot_table[NO_MAP_DOTS];        // change in kPa x 10 per .1 sec
    int map0,mapmax,clt0,cltmult,mat0,matmult,tps0,tpsmax,batt0,battmax,
        // kPa x 10, deg F or C x 10, adc counts, volts x 10
        ego0,egomult,baro0,baromax,bcor0,bcormult,knock0,knockmax;
    // afr x 10, kpa x 10, volts x 100
    int Dtpred_Gain;  // %
    unsigned char CrnkTol,ASTol,PulseTol,   // % tolerance for next input pulse
                  // timing during cranking, after start/warmup and normal running
                  IdleCtl,         // idle: 0 = none, 1= solenoid, 2= iac stepper motor
                  //  - enabled only when moving, 3 = iac motor - always enabled.
                  // 4 = Ford pwm, 5 = 3 for 15 min, then = 2.
                  IACtstep,        // iac stepper motor nominal time between steps (.1 ms units)
                  IAC_tinitial_step, // Moving only initial step delay after valve powerup. 
                  IACminstep,     // iac stepper motor no. of accel/decel steps - future use
                  dwellduty;       // dwell duty%
    int IACStart,     // no. of steps to send at startup to put stepper
        //    motor at reference (wide open) position
        IdleHyst,        // amount clt temp must move before Idle position is changed
        IACcrankpos,     // IAC pos must be open(<) at least this much(steps) in cranking
        IACcrankxt,      // no. seconds from end of cranking for IAC pos to blend into
        // coolant dependent pos.
        IACcoldtmp,IACcoldpos,IACcoldxt;
    unsigned int InjOpen,BatFac;
    unsigned char OverBoostOption;
    int OverBoostKpa;
    int OverBoostHyst;
    unsigned char overboostcutx;
    unsigned char overboostcuty;
    unsigned char secondtrigopts;
#define NOISE_FILTER_ONLY 0x1
    int TpsThresh, MapThresh;
    unsigned char  Tpsacold,     // cold (-40F) accel amount in .1 ms units
                   AccMult;         // cold (-40F) accel multiply factor (%)
    int mapsample_angle;
    unsigned char  TpsAsync,        // clock duration (in .1 sec tics) for accel enrichment
                   TPSDQ;           // deceleration fuel cut option (%)
    int TPSWOT,       // TPS value at WOT (for flood clear) in %x10
        TPSOXLimit;      // Max tps value (%x10) where O2 closed loop active
    unsigned char Tps_acc_wght,    // weight (0-100) to be given to tpsdot for accel enrichment.
                  //  100 - Tps_acc_wght will then be given to mapdot.
                  BaroOption,      // 0=no baro, 1=baro is 1st reading of map (before cranking), (baroCorr)
                  // 2=independent barometer (=> EgoOption not 2 or 4)
                  EgoOption,       // 0 = no ego;1= nb o2;2=2 nb o2;3=single wbo2;4=dual wbo2. NOTE:
                  //  BaroOption MUST be < 2 if EgoOption = 2 or 4.
                  EgoCountCmp,     // Ign Pulse counts between when EGO corrections are made
                  EgoStep,         // % step change for EGO corrections
                  oldEgoLimit,        // Upper/Lower rail limit (egocorr inside 100 +/- limit)
                  AFRTarget,       // NBO2 AFR determining rich/ lean
                  Temp_Units,      // 0= coolant & mat in deg F; 1= deg C
                  MAFOption,cpad2; // MAF options
    int FastIdle,     // fast idle Off temperature (idle_ctl = 1 only)
        EgoTemp,         // min clt temp where ego active
        RPMOXLimit;      // Min rpm where O2 closed loop is active
    unsigned int ReqFuel;     // fuel pulsewidth (usec) at wide open throttle
    unsigned char Divider,    // divide factor for input tach pulses
                  Alternate,       // option to alternate injector banks. bit 0 normal function, bit 1 means /2 during crank
                  dummy2,         // Injector open time (.1 ms units)
                  InjPWMTim,       // Time (.1 ms units) after Inj opening to start pwm
                  InjPWMPd,        // Inj PWM period (us) - keep between 10-25 KHz (100-40 us)
                  InjPWMDty,       // Inj PWM duty cycle (%)
                  dummy1,          // Battery fuel pw correction factor (msx10)
                  EngStroke,       // 0 = 4 stroke
                  // 1 = 2 stroke
                  InjType,         // 0 = port injection
                  // 1 = throttle body
                  NoInj;           // no. of injectors (1-12)
unsigned int      OddFireang;        //  smaller angle bet firings (deg*10)
unsigned char     rpmLF,mapLF,tpsLF,   // Lag filter coefficient for Rpm,Map,Tps. Acts like
                  egoLF,           // averager: xnew = xold + xLF * (xmeas - xold), so xLF=0
                  adcLF,knkLF,     // means value will never change, xLF=100 means no filtering.
                  // egoLF is coefficient for ego filter, adcLF is for clt,mat,batt,
                  // knkLF is for knock.
                  AMCOption,       // Automatic Mixture Control Option: 0 = none; 1= automatic updates
                  // to ram ve table(s); 2= also automatically updates flash ve tables.
                  dual_tble_optn,  // 1 = use dual table option - ve, afr tables for each inj
                  FuelAlgorithm,       // option for alpha-N mode: 0=none;1=use map,tps blend algorithm;
                  //   2=same as 1, but don't use kpa multiplier in plsewidth eq.
                  //   3=%Baro
                  IgnAlgorithm,        // option to use map,tps(alphaN) blend algorithm for ignition
                  AfrAlgorithm,        // option to use map,tps(alphaN) blend algorithm for WBO2 AFR
                  dwelltime;       // time in 0.1ms
    unsigned int trigret_ang; // angle between trigger and return
    char RevLimOption;     // 0=none, 1=spark retard, 2=fuel cut
    unsigned char RevLimMaxRtd;     // max amount of spark retard (degx10) (at Rpm2 below)
    unsigned char InjPWMTim2,       // Time (.1 ms units) after Inj opening to start pwm
                  InjPWMPd2,        // Inj PWM period (us) - keep between 10-25 KHz (100-40 us)
                  InjPWMDty2;       // Inj PWM duty cycle (%)
    unsigned int  InjOpen2, BatFac2;
    unsigned char padder;
    unsigned int baro_upper, baro_lower, baro_default;
    int RevLimTPSbypassRPM;
    int RevLimNormal1;
    int RevLimNormal2;
    unsigned int TC5_required_width;
    int EgoLimit;
    int stoich;
        
        // This goes with the CAN polling for a generic external board
    unsigned char enable_poll;  // bit 0: enable ADC
                                    // bit 1: enable PWM
                                                                // bit 2: enable digital I/O ports
    unsigned char poll_tables[3];  // Remote table numbers for ADC, PWM and ports data
    unsigned int poll_offset[3];   // Offset in the table (ADC, PWM, ports). This assumes that the data is contiguous for each of the 3 data types
    unsigned char ports_dir;            // Bits 0-2: Direction of the 3 remote ports: 0=input, 1=output
                                                                        // Bits 4-6: Set if digital I/Os or single 0-255 value
    unsigned char port_generic;         // Select which port will be used as generic spare port: 0: use MS ports; 1,2,3: Remote ports

    unsigned int CID;
	
	unsigned char remotePWMfreq,       // Remote PWM clock frequency  (in MHz)
	              remotePWMprescale;   // Remote PWM clock prescale

    int dummy[26];  // was 34

    unsigned char hw_latency;
    unsigned char loadopts; // bit 0: 1 mult for fuel, 0 add for fuel
                            // bit 2: 1 multiply "load" into final equation, 2 don't
                            // bit 3: Scale VE by "stoich" value
    unsigned long baud;         // baud rate
    int MAPOXLimit;   // Max map value (kPax10) where O2 closed loop active
    unsigned char board_type,   // board type (1-255) of this board(not used now);
                  // type=0, reserved.
                  // type=1, ECU (MS II)
                  // type=2. Router board
                  // type=3, Generic I/O board
                  // type=4, Transmission Controller, ......
 mycan_id;        // can_id (address) of this board (< MAX_CANBOARDS). Always 0 for ECU.
// CAUTION!!! These are in a different place from MS2 and the GPIO code may well clobber stuff
// over here.
   int
      FuelAdj,SpkAdj,        // Adjustments for fuel(% +/- to ve),spark(degx10),idle step,spare
      IdleAdj,SprAdj;                    // for GPIO boards.
// END CAUTION
    unsigned char mapsample_window, can_poll, can_poll_id;
        int MAPOXMin ;   // lower map value (kpax10) where 02 closed loop active -- KG  
    char morecrap[1];

    // Generic spare port parameters: spr_port = 0(don't use)/1(use),where
    // spr_port[0-7] = PM2 - PM5; PTT6,7; PORTA0; they are set as outs to main
    //  pcb; out_offset,out_byte= byte offset from start of outpc structure and
    // size in bytes of 1st, 2nd variables to be tested for setting port;
    // condition='<', '>', '=';cond12 = '&','|',' ' connects the conditions for
    // the two variables with ' ' meaning only the first variable condition is
    // desired; thresh = value for the condition(e.g., var1 > thresh1); init_val,
    // port_val=value (0/1) to which the pin will be set at startup and when the
    // condition(s) is met; hyst is a hysteresis delta and works as ff: if a
    // setpoint condition is > and it is met, set port to val and leave until
    // variable is < thresh - hyst, then set pin back to 1 - val. Similarly if
    // condition is <, wait til var > thresh + hyst. For dual conditions, the
    // hysteresis conditions are evaluated the same way, but use the opposite
    // of cond12 to connect them (if cnd12 is &, use | and vice versa).
    char
        spr_port   [NPORT], // NPORT == 7
                   condition1 [NPORT],
                   condition2 [NPORT],
                   cond12     [NPORT],
                   init_val   [NPORT],
                   port_val   [NPORT],
                   out_byte1  [NPORT],
                   out_byte2  [NPORT];
    int
        out_offset1[NPORT],
        out_offset2[NPORT],
        thresh1    [NPORT],
        thresh2    [NPORT],
        hyst1      [NPORT],
        hyst2      [NPORT];
    unsigned char
        TpsAsync2,  // accel tailoff duration (sec x 10)
        cpad4;
    int
        TpsAccel2;      // end pulsewidth of accel enrichment (ms x 10)
    unsigned char
        EgoAlg, // 0=simple prop error algorithm;
        // 1=same algorithm with variable transport delay;
        // 2=full PID with Smith Pred correction.
        egoKP,
        egoKI,
        egoKD;    // PID coefficients in %; egoKP also gain for
    // EgoAlg=0, with 100 = no gain; egoKD includes
    // 1/dt factor since fixed time step.
    unsigned int
        egoKdly1, // coefficients used to calculate ego transport
        egoKdly2;      // delay (ms) = Kdly1 + Kdly2*120000 / (map(kPax10)*rpm)
    unsigned char
        FlexFuel, // Flex fuel option - modifies pw and spk adv based on % alcohol.
        fuelFreq[2],      // Table of fuel sensor freq(Hz) vs %fuel corr;
        fuelCorr[2],
        dwellmode, // dwell mode
        AMCStep,                    // % of AMC correction to be applied when ramve updated.
        AMCdve;        // AMC correction must be > AMCdve to be applied in burn
    unsigned int
        AMCve_drpm,AMCve_dmap,  // current rpm, map(kPax10) must be within this
        AMCramve_dt,                    // tolerance of a ve table vertex for AMCramve_dt secs
        // before AMC ve correction is applied
        AMCT_thresh,     // Min time (secs) between flash burns of ram ve table
        AMCupdate_thresh;// Min number of AMC ram ve updates before burn table.
    unsigned char
        CWOption,        // Cold warmup option - 0 = linear, 1 = custom table.
        knk_option,      // Bits 0-1: 0=no knock detection;1=operate at table value or 1
        // step below knock; 2=operate at table value or edge of knock.
		// Bit 2: local port 0=AD7/JS4, 1=AD6/JS5
		// Bit 3: 0=local or 1=remote
        // Bits 4-7: 0/1 = knock signal < or > knk_thresh indicates knock occurred.
        knk_maxrtd,      // max total retard when knock occurs, (degx10),
        knk_step1,knk_step2, // ign retard/ adv steps when 1st knock or after stopped,
        // (degx10); step1 large to quickly retard/ stop knock
        knk_trtd,knk_tadv,   // time between knock retard, adv corrections, (secx10);
        // allows short time step to quickly retard, longer to try advancing.
        knk_dtble_adv, // change in table advance required to restart adv til knock or
        // reach table value (0 knock retard) process, deg x10.
        // This only applies with knk_option = 1.
        knk_ndet,    // number knock detects required for valid detection; pad byte.
        EAEOption;   // Bits 0-1: 1: on or off, 2: Use lag compensation
    unsigned int
        knk_maxmap,        // no knock retard above this map (kPax10).
        knk_lorpm,knk_hirpm,  // no knock retard below, above these rpms.
        knk_rpm[NO_KNKRPMS],  // tables of rpm vs knock threshhold(Vx100).
        knk_thresh[NO_KNKRPMS],
        No_Teeth;          // Nominal (include missing) teeth for wheel decoding
    unsigned char
        No_Miss_Teeth;     // Number of consecutive missing teeth.
    unsigned int
        Miss_ang;     // Position of missing tooth BTDC deg*10
    unsigned char
        ICISR_tmask,                            // Time (msx10) after tach input capture during which further
        // interrupts are inhibited to mask coil ring or VR noise.
        ICISR_pmask,                            // % of dtpred after tach input capture during which further
        // interrupts are inhibited to mask coil ring or VR noise.
        // This and prior mask not applicable with wheel decoding.
        knkport_remote;
    unsigned int
        ae_lorpm,ae_hirpm; // lorpm is rpm at which normal accel enrichment just starts
    // to scale down, and is reduced to 0 at ae_hirpm. To omit scaling, set _lorpm
    // = _hirpm= very large number.
    int
        ffSpkDel[2];      // Table of fuel sensor freq(Hz) vs spk corr (degx10);
    unsigned char IC2ISR_tmask;
    unsigned char IC2ISR_pmask;
    unsigned char NoiseFilterOpts;
    unsigned char extra_load_opts; /* bit 0-1: afrload: 0 = use fuelload, 1 = MAP, 2 = % baro, 3 = TPS */
                                   /* bit 2-3: eaeload: 0 = use fuelload, 1 = MAP, 2 = % baro, 3 = TPS */
    char pad41;

    unsigned char
        spk_conf2, // various see ini
        spk_config,    // config byte
        // bit0 sparkA 0=JS6 (MS2 default) 1= D14 (MS1/Extra default)
        // when num_spk_op > 3 always D14 as JS6 = sparkD
        // bit1 0=360deg 1=720
        // bit3,2 = 0 invalid, 1 = missing crank, 2 = 2nd trig, 3 = both
        // bit5,4 = 0 invalid, 1 rising, 2 falling, 3 rising&falling
        spk_mode,      // defines standard/EDIS/toothed wheel + num/type of coils
        userlevel,     // defines basic/intermediate/advanced and hides features
        rtbaroport,    // defines AD port used for RT baro 2nd sensor, MS2/GPIO
        //AD ports bottom three bits are AD0-7, upper bits
        // 0 = MS2, 1= GPIO1, 2=GPIO2
        ego2port,      // defines AD port used for 2nd EGO sensor MS2/GPIO
        egoport,       // defines port used for first EGO sensor: 0 means local port; > 0 means remote CAN port; was XXXknkport
        flexport,      // defines freq capture port used for flex fuel sensor MS2/GPIO
        revlimcutx,
        revlimcuty,
        feature4_0;      // various settings
    //bit 0 = simple/advanced false trigger protection when userlevel>191
    //bit 1 = enable middle LED as ignition trigger. Certain modes prevent this.
    //bit 7 = enable logging of VANOS position. Tooth no. -> status4, time diff -> istatus5 
    int pwmidle_table[NO_TEMPS];  // 10 pwm
    unsigned char timing_flags, crank_dwell;
    int crank_timing, fixed_timing;
#define TIMING_FIXED 0x1
#define USE_PREDICTION 0x2
} page4_data;

#define PWMIDLE_NUM_BINS 8

typedef struct {
    unsigned int pwmidle_target_rpms[PWMIDLE_NUM_BINS];
    int pwmidle_clt_temps[PWMIDLE_NUM_BINS];
    unsigned int  pwmidle_ms;
    unsigned char pwmidle_close_delay;
    unsigned char pwmidle_open_duty,
                  pwmidle_closed_duty, pwmidle_pid_wait_timer, pwmidle_min_duty;
    unsigned int pwmidle_engage_rpm_adder;
    int pwmidle_tps_thresh;
    unsigned char pwmidle_dp_adder;
    unsigned int pwmidle_rpmdot_threshold;
    unsigned int pwmidle_decelload_threshold;
    unsigned int pwmidle_Kp, pwmidle_Ki, pwmidle_Kd;
    unsigned char pwmidle_freq;   // 1 = 30.5 Hz, 2 = 61 Hz, etc...
    unsigned int pwmidle_min_rpm, pwmidle_max_rpm;
    unsigned char pwmidle_targ_ramptime;
    int pwmidle_rpmdot_disablepid;
    unsigned char pwmidle_port;  // 0: local; 1,2,3: remote port number
    unsigned char junk[4];  // was 7
    unsigned char boost_ctl_settings;  // bit 0-2: freq-divider
                                       // bit 3: on or off
                                       // bit 4: closed loop?
                                       // bit 5: invert?
                                       // bit 6: remote
#define BOOST_CTL_ON            0x8
#define BOOST_CTL_CLOSED_LOOP   0x10
#define BOOST_CTL_INVERT        0x20
#define BOOST_CTL_REMOTE        0x40
    unsigned char boost_ctl_pins;  // Bits 4-5: remote port number
#define BOOST_CTL_IACA 0x1
#define BOOST_CTL_IACB 0x2
#define BOOST_CTL_JS11 0x4
#define BOOST_CTL_IDLE 0x8
    unsigned char boost_ctl_Kp, boost_ctl_Ki, boost_ctl_Kd, boost_ctl_closeduty, boost_ctl_openduty;
    unsigned int boost_ctl_ms;
    int boost_ctl_load_targets[8][8];
    int boost_ctl_loadtarg_tps_bins[8];
    unsigned int boost_ctl_loadtarg_rpm_bins[8];
    unsigned char boost_ctl_pwm_targets[8][8];
    int boost_ctl_pwmtarg_tps_bins[8];
    unsigned int boost_ctl_pwmtarg_rpm_bins[8];
    unsigned int pwmidle_crank_dutyorsteps[4];
    int pwmidle_crank_clt_temps[4];
        int inj_adv_table3[6][6];       // injection advance table for single pulse in siamese sequential mode
    unsigned int srpm_inj_adv3[6];  // injection advance rpm tables     
    int smap_inj_adv3[6];           // kpa x 10,        
//    char junk1[134]; //was 230
    int               // this is primePWtable, CrankPctTable, asePctTable, aseCntTable
        CWPrime[NO_TEMPS],CrankPctTable[NO_TEMPS],CWAWEV[NO_TEMPS],CWAWC[NO_TEMPS];
    int
        MatTemps[NO_MAT_TEMPS];  // MAT temperatures for spark retard, degx10 F or C
    unsigned char
        MatSpkRtd[NO_MAT_TEMPS]; // degx10 of spark retard vs mfld air temp
    unsigned int
        EAEAWCRPMbins[NO_FRPMS],
        EAESOCRPMbins[NO_FRPMS],
        EAEAWCKPAbins[NO_FMAPS], /* MAP bins for EAE */
        EAESOCKPAbins[NO_FMAPS];
    unsigned char
        EAEBAWC[12], /* Added to the Wall coefficient */
        EAEBSOC[12], /* sucking off the wall coefficient */
        EAEAWN[12], /* added to the walls rpm scalar */
        EAESON[12], /* pulled from walls rpm scalar */
        EAEAWW[12], /* added to the walls CLT scalar */
        EAESOW[12]; /* pulled from the walls CLT scalar */
//        placeholder[20];
    int
        BaroVals[NO_BARS],   // Barometric pressures (kPa x 10) for baro correction table
        MatVals[NO_MATS];    // air temperatures (degx10) for air density correction table
    char
        BaroCorDel[NO_BARS],   // Barometric corrections (+/-%) - added to eq. value
        // to correct for varying exhaust size
        AirCorDel[NO_MATS];    // Air density corrections (+/-%) - added to eq. value
    // to correct for varying mat sensor location
    int temp_table_p5[NO_TEMPS];
    int tsf_rpm, tsf_kpa, tsf_tps, tss_rpm, tss_kpa, tss_tps;  // table switch
    int EAEAWWCLTbins[12], EAESOWCLTbins[12];
    unsigned char airden_scaling;
//    char junk3[18];
        unsigned char ts_remote;  // Bit 0: Remote fuel table switching; Bit 1-3: Port3 Bit selection; Bit 4: Remote spark table switching; Bit 5-7: Port3 Bit selection
    unsigned char
        feature5_0,  // on/off feature settings
        //bitval 1 = overrun fuel cut
        XXpwmidlecoldpc, // not used
        pwmidlecranking,
        pwmidlecranktaper,
        pwmidleset;   // settings bits 0 = 78Hz, 156Hz   1 = normal, inverse output
    unsigned int fc_rpm;
    int fc_kpa, fc_tps, fc_clt; // overrun fuel cut >rpm, <kpa, >tps, >clt
    unsigned char fc_delay;  // > time in 0.1s units
    unsigned char tacho_opt; // tacho output option
    unsigned char EAElagsource; // 0 = tpsdot, 1 = MAPdot
    int EAElagthresh;
    unsigned int EAElagRPMmax;
    unsigned char fc_ego_delay;
    unsigned int fc_rpm_lower;
    unsigned int pwmidle_shift_lower_rpm;
    unsigned char pwmidle_shift_open_time;
    unsigned char morepage5[10];
    char
        rmt_spr_port   [8],
        rmt_condition1 [8],
        rmt_condition2 [8],
        rmt_cond12     [8],
        rmt_init_val   [8],
        rmt_port_val   [8],
        rmt_out_byte1  [8],
        rmt_out_byte2  [8];
    int
        rmt_out_offset1[8],
        rmt_out_offset2[8],
        rmt_thresh1    [8],
        rmt_thresh2    [8],
        rmt_hyst1      [8],
        rmt_hyst2      [8];
} page5_data;

typedef struct {
    int
        adv_table[2][NO_SMAPS][NO_SRPMS]; // two spark tables
    unsigned int srpm_table[2][NO_SRPMS];  // fuel, spk rpm tables
    int smap_table[2][NO_SMAPS];            // kpa x 10,
    unsigned char feature3,  // feature settings (presently only ASM vs C ign_out ISR)
                    // 0x2 Use MAP lag lookup based on TPSdot
             launch_opt; //launch/flat shift options
    int      launch_sft_lim,
             launch_sft_deg,
             launch_hrd_lim,
             launch_tps;
    unsigned char launchlimopt, // launch limiter options
                  launchcutx,
                  launchcuty;
    int      flats_arm, // flat shift options
             flats_sft,
             flats_deg,
             flats_hrd;

    unsigned int staged_pri_size, staged_sec_size;
    unsigned char staged;  /* Bits 0-2: 000 = off, 001 = RPM, 010 = MAP, 011 = TPS, 100 = Duty, 101 = Table
                            * Bits 3-5: second param: 00 = off, 01 = rpm, 10 = MAP, 11 = TPS, 100 = Duty, 101 = Table
                            * Bit 6: transition on
                            * Bit 7: 2nd param: 0 = OR logic, 1 = AND logic
                            */
    unsigned char staged_transition_events;
    int staged_param_1, staged_param_2;
    int staged_hyst_1, staged_hyst_2;

// Nitrous System
    unsigned char N2Oopt;    // bit 0-1: DT bank usage
                             // bit 2: stage 1 enable
                             // bit 3: stage 2 enable
                             // bits 4-6: input pin
    unsigned int N2ORpm, N2ORpmMax;
    signed int  N2OTps, N2OClt, N2OAngle;
    unsigned int N2OPWLo, N2OPWHi;
    unsigned char N2Odel_launch, N2Odel_flat, N2Oholdon;
    unsigned int N2O2Rpm, N2O2RpmMax;
    unsigned char N2O2delay;
    signed int N2O2Angle;
    unsigned int N2O2PWLo, N2O2PWHi;

/* user defined */
    unsigned int user_value1;
    unsigned int user_value2;
    unsigned char user_conf;
/* end user defined */

    unsigned int staged_secondary_enrichment;
    unsigned char staged_percents[6][6];
    unsigned int staged_rpms[6];
    int staged_loads[6];
        unsigned char N2Oremote;  // Bit 0: remote input; Bit 1: remote outputs; Bits 2-4: remote input bit number on Port 3; Bits 5-7: remote ouputs bit number on Port 1
    unsigned char crap8[3];
    int RotarySplitTable[8][8];
    unsigned int RotarySplitMAP[8];
    unsigned int RotarySplitRPM[8];
    unsigned char RotarySplitMode;
#define ROTARY_SPLIT_FD_MODE 0x1
#define ROTARY_SPLIT_ALLOW_NEG_SPLIT 0x2
#define ROTARY_SPLIT_RX8_MODE 0x4
    unsigned int NoiseFilterRpm[4];
    unsigned int NoiseFilterLen[4];
    unsigned char padnfo;
    unsigned char staged_primary_delay;
    unsigned char VariableLagTPSBins[4];
    unsigned char VariableLagMapLags[4];
// test options for semi sequential
    unsigned char crap_ss[9];
    unsigned char trig_init;
    unsigned char inj_time_mask;
    char crap7[19]; // was 30
} page10_data;

typedef struct {
    unsigned int testmodelock; // special non-burnable word
    unsigned char testop,  // was testcoil; which coil, inj to fire + fp + pwm
                  testdwell; // dwell in 0.1ms
    unsigned int testint; // interval in 0.128ms units
    unsigned char testmode;
    unsigned int testpw, testinjcnt;

    int
        adv_table3[NO_SMAPS][NO_SRPMS]; // two spark tables
    unsigned int srpm_table3[NO_SRPMS];  // fuel, spk rpm tables
    int smap_table3[NO_SMAPS];      // kpa x 10,
    unsigned char     testInjPWMTim,       // Time (.1 ms units) after Inj opening to start pwm
                      testInjPWMPd,        // Inj PWM period (us) - keep between 10-25 KHz (100-40 us)
                      testInjPWMDty;       // Inj PWM duty cycle (%)
#define REVLIMRPMSIZE 8
    unsigned int RevLimLookup[REVLIMRPMSIZE],RevLimRpm1[REVLIMRPMSIZE];
    unsigned int iacpostest; // test word. Fix iac postion. 0 = off
    unsigned int iachometest; // test home position
    unsigned char iactest; // control byte
    unsigned char idle_special_ops; // right now, just idle advance, but possibly idle VE and other idle-only features later
    int idleadvance_tps;
    int idleadvance_rpm;
    int idleadvance_load;
    int idleadvance_clt;
    unsigned char idleadvance_delay;
#define IDLE_SPECIAL_OPS_IDLEADVANCE 0x1
    int idleadvance_curve[4];
    int idleadvance_loads[4];
    unsigned char feature413;

        unsigned char crapalign;
        // Siamese and sequential injection     
        unsigned char seq_inj;  // Bit 0: 1 = Sequential        
                                                        // Bit 1: 1 = Siamese   
                                                        // Bit 2: 1 = Extra injector drivers    
                                                        // Bit 3: 0 = Single timing value; 1 = Dual timing values       
                                                        // Bit 4: 0 = Don't use VE trim tables; 1 = Use VE trim tables  
                                                        // Bit 5: 0 = Fixed timing; 1 = Use table       
                                                        // Bit 6,7: 0 = Start-of-pulse; 1 = Mid-pulse; 2 = End-of-pulse 
        int inj_adv_fixed[6];   // Fixed injection advance: advance 1, advance 2, advance 3, staged advance 1, staged advance 2, staged advance 3       
        int inj_adv_table[2][6][6];     
    unsigned int srpm_inj_adv[2][6];  // injection advance rpm tables   
    int smap_inj_adv[2][6];         // kpa x 10,        
        int inj_adv_crank[2];   // Injection advance for cranking 1 and 2
        unsigned int hybrid_rpm, hybrid_hyst;   // Hybrid mode: RPM and hysteresis
    unsigned int InjOpen3,BatFac3,InjOpen4,BatFac4;
        
    union {
        char ve_trim1L[NO_EXFMAPS][NO_EXFRPMS];
        char ve_trim1S[NO_FMAPS][NO_FRPMS];
    } ve_tables;
    union {
        unsigned int frpm_trimvL[NO_EXFRPMS];
        unsigned int frpm_trimvS[NO_FRPMS];
    } frpm_tables;
    union {
        int fmap_trimvL[NO_EXFMAPS];            // kpa x 10,
        int fmap_trimvS[NO_FMAPS];
    } fmap_tables;
        char crap8[12];  // was 610,404,396, 76, 20
        char TS_sensor_data[56];  // some of previous repurposed for TS to store sensor data in
} page8_data;

typedef struct {
    union {
        unsigned char ve_tableL[3][NO_EXFMAPS][NO_EXFRPMS];
        unsigned char ve_tableS[3][NO_FMAPS][NO_FRPMS];
    } ve_tables;
    union {
        unsigned int frpm_tablevL[3][NO_EXFRPMS];  // 2x fuel rpm tables
        unsigned int frpm_tablevS[3][NO_FRPMS];
    } frpm_tables;
    union {
        int fmap_tablevL[3][NO_EXFMAPS];            // kpa x 10,
        int fmap_tablevS[3][NO_FMAPS];
    } fmap_tables;
    unsigned int MAFFlow[12];
    unsigned char MAFCor[12];
    char junk[28];
} page9_data;

typedef struct {
    union {
        char ve_trimL[3][NO_EXFMAPS][NO_EXFRPMS];
        char ve_trimS[3][NO_FMAPS][NO_FRPMS];
    } ve_tables;
    union {
        unsigned int frpm_trimvL[3][NO_EXFRPMS];
        unsigned int frpm_trimvS[3][NO_FRPMS];
    } frpm_tables;
    union {
        int fmap_trimvL[3][NO_EXFMAPS];            // kpa x 10,
        int fmap_trimvS[3][NO_FMAPS];
    } fmap_tables;
    int ITB_load_loadvals[10];
    int ITB_load_switchpoints[10];
    unsigned int ITB_load_rpms[10];
    char junk[4];
} page11_data;  

extern const page4_data flash4 EEPROM_ATTR;
extern const page5_data flash5 EEPROM_ATTR;
extern const page10_data flash10 EEPROM_ATTR;
extern const page8_data flash8 EEPROM_ATTR;
extern const page9_data flash9 EEPROM_ATTR;
extern const page11_data flash11 EEPROM_ATTR;
extern const unsigned char IACCoilA[8];
extern const unsigned char IACCoilB[8];
extern const char RevNum[];
extern const char Signature[];

extern char ram_data[1024];
extern page4_data *pg4_ptr;
extern page5_data *pg5_ptr;
extern page10_data *pg10_ptr;
extern page8_data *pg8_ptr;
extern page9_data *pg9_ptr;
extern page11_data *pg11_ptr;   

/* Coil bits for an ign event */

#define         TRIGA           0
#define         TRIGB           1
#define         TRIGC           2
#define         TRIGD           3
#define         TRIGE           4
#define         TRIGF           5
#define         TRIGG           6
#define         TRIGH           7

typedef union _ign_time {
    unsigned long time_32_bits;
    unsigned int time_16_bits[2];
} ign_time;

typedef struct _ign_event {
    ign_time            time;           // time after the tooth to fire
    char                tooth;          // the tooth to schedule an event from
    unsigned char       coil;
    char                ftooth;         // "force dwell" tooth
    unsigned char       fs;             // "force spark" flag (only really need a byte)
} ign_event;

typedef struct _fuel_event {
    unsigned int        time;           // time after the tooth to fire using software timer
    char                tooth;          // the tooth to schedule an event from
    unsigned char       inj;
} fuel_event;

typedef struct _map_event {
    unsigned int        time;
    unsigned int        map_window_set;
    char                tooth;
    unsigned char       evnum;
} map_event;

typedef struct _ign_queue {
    unsigned int sel;
    unsigned int time_us;
    unsigned int time_mms;
} ign_queue;

#define time32 time.time_32_bits
#define time16_high time.time_16_bits[0]
#define time16_low time.time_16_bits[1]

#define NUM_TRIGS 10
extern ign_event dwell_events_a[NUM_TRIGS];
extern ign_event spark_events_a[NUM_TRIGS];
extern fuel_event fuel1_events_a[5];    
extern fuel_event fuel2_events_a[5];    
extern fuel_event fuel3_events_a[3];    
extern fuel_event fuel4_events_a[3];    
extern ign_event dwell_events_b[NUM_TRIGS];
extern ign_event spark_events_b[NUM_TRIGS];
extern fuel_event fuel1_events_b[5];    
extern fuel_event fuel2_events_b[5];    
extern fuel_event fuel3_events_b[3];    
extern fuel_event fuel4_events_b[3];    
extern ign_event *dwell_events;
extern ign_event *spark_events;
extern fuel_event *fuel1_events;        
extern fuel_event *fuel2_events;        
extern fuel_event *fuel3_events;        
extern fuel_event *fuel4_events;        
extern ign_event next_spark;
extern ign_event next_dwell;
extern fuel_event next_fuel1_event;     
extern fuel_event next_fuel2_event;     
extern fuel_event next_fuel3_event;     
extern fuel_event next_fuel4_event;     
extern ign_event next_dwl_trl;
extern ign_event next_spk_trl;
extern ign_time dwl_time_ovflo;
extern ign_time spk_time_ovflo;
extern ign_time fuel1_time_ovflo;       
extern ign_time dwl_time_ovflo_trl;
extern ign_time spk_time_ovflo_trl;
extern ign_queue spkq[2], dwellq[2];
extern unsigned char wheeldec_ovflo;
#define OVFLO_SPK 0x1
#define OVFLO_DWL 0x2
#define OVFLO_ROT_SPK 0x4
#define OVFLO_ROT_DWL 0x8
#define OVFLO_FUEL 0x10
extern unsigned char next_fuel;
extern unsigned int inj1_count, inj2_count, inj3_count, inj4_count;
extern unsigned char trigger_teeth[NUM_TRIGS];
extern int trig_angs[NUM_TRIGS];
extern int trig_ang;
extern map_event next_map_start_event, map_start_event[NUM_TRIGS];
extern unsigned int map_start_countdown, map_window_countdown, map_window_set;
extern unsigned int map_temp, maf_temp, mafraw, map_temps[4];
extern unsigned char map_temps_cnt, map_deadman;
extern long MAFCoef;

/* ignition macros */



#define FIRE_ALL \
    if (flash4.ICIgnOption & 0x10) { \
        if ((flash4.spk_config & 0x01) || (num_spk > 3)) { \
            PTM &= ~0x08; \
        } else { \
            PTT &= ~0x20; \
        } \
        if (num_spk > 1) { \
            PTM &= ~0x10; \
        } \
        if (num_spk > 2) { \
            PTM &= ~0x20; \
        } \
        if (num_spk > 3) { \
            PORTA &= ~0x01; \
        } \
        if (num_spk > 4) { \
            PTAD &= ~0x40; \
        } \
        if (num_spk > 5) { \
            PTAD &= ~0x80; \
        } \
    } else { \
        if ((flash4.spk_config & 0x01) || (num_spk > 3)) { \
            PTM |= 0x08; \
        } else { \
            PTT |= 0x20; \
        } \
        if (num_spk > 1) { \
            PTM |= 0x10; \
        } \
        if (num_spk > 2) { \
            PTM |= 0x20; \
        } \
        if (num_spk > 3) { \
            PORTA |= 0x01; \
        } \
        if (num_spk > 4) { \
            PTAD |= 0x40; \
        } \
        if (num_spk > 5) { \
            PTAD |= 0x80; \
        } \
    }

#define FIRE_ALL_US \
    if (flash4.ICIgnOption & 0x10) { \
        PTT &= ~0x20; \
        if (num_spk > 1) { \
            PTT &= ~0x10; \
        } \
        if (num_spk > 2) { \
            PTM |= 0x20; \
        } \
        if (num_spk > 3) { \
            PTM |= 0x10; \
        } \
    } else { \
        PTT |= 0x20; \
        if (num_spk > 1) { \
            PTT |= 0x10; \
        } \
        if (num_spk > 2) { \
            PTM &= ~0x20; \
        } \
        if (num_spk > 3) { \
            PTM &= ~0x10; \
        } \
    }

void SET_COIL(unsigned char*, unsigned char*);

#define COILABIT 0x1
#define COILBBIT 0x2
#define COILCBIT 0x4
#define COILDBIT 0x8
#define COILEBIT 0x10
#define COILFBIT 0x20
#define COILGBIT 0x40
#define COILHBIT 0x80

#define OUTPUT_LATENCY 6  // known latency in code from outpc compare to bit flipping
#define SPK_TIME_MIN 150 // minimum time after tooth before stepping back

extern unsigned char coilsel;
extern unsigned char dwellsel;
extern unsigned char rotaryspksel;
extern unsigned char rotarydwlsel;

// rs232 Outputs to pc
typedef struct {
unsigned int seconds,pw1,pw2,rpm;           // pw in usec
int adv_deg;                                // adv in deg x 10
unsigned char squirt,engine,afrtgt1,afrtgt2;    // afrtgt in afr x 10
/*
; Squirt Event Scheduling Variables - bit fields for "squirt" variable above
inj1:    equ    0       ; 0 = no squirt; 1 = inj squirting
inj2:    equ    1

; Engine Operating/Status variables - bit fields for "engine" variable above
ready:  equ     0       ; 0 = engine not ready; 1 = ready to run
                                               (fuel pump on or ign plse)
crank:  equ     1       ; 0 = engine not cranking; 1 = engine cranking
startw: equ     2       ; 0 = not in startup warmup; 1 = in startw enrichment
warmup: equ     3       ; 0 = not in warmup; 1 = in warmup
tpsaen: equ     4       ; 0 = not in TPS acceleration mode; 1 = TPS acceleration mode
tpsden: equ     5       ; 0 = not in deacceleration mode; 1 = in deacceleration mode
mapaen: equ     6
mapden: equ     7
*/
#define ENGINE_READY  0x01
#define ENGINE_CRANK  0x02
#define ENGINE_ASE    0x04
#define ENGINE_WUE    0x08
#define ENGINE_TPSACC 0x10
#define ENGINE_TPSDEC 0x20
#define ENGINE_MAPACC 0x40
#define ENGINE_MAPDEC 0x80

unsigned char wbo2_en1,wbo2_en2; // from wbo2 - indicates whether wb afr valid
int baro,map,mat,clt,tps,batt,ego1,ego2,knock,   // baro - kpa x 10
                                                 // map - kpa x 10
                                                 // mat, clt deg(C/F)x 10
                                                 // tps - % x 10
                                                 // batt - vlts x 10
                                                 // ego1,2 - afr x 10
                                                 // knock - volts x 100
 egocor1,egocor2,aircor,warmcor,                 // all in %
 tpsaccel,tpsfuelcut,barocor,gammae,             // tpsaccel - acc enrich(.1 ms units)
                                                 // tpsfuelcut - %
                                                 // barocor,gammae - %
 vecurr1,vecurr2,iacstep,cold_adv_deg,           // vecurr - %
                                                 // iacstep - steps
                                                 // cold_adv_deg - deg x 10
tpsdot,mapdot;                                   // tps, map rate of change - %x10/.1 sec,
                                                 // kPax10 / .1 sec
unsigned int coil_dur;                           // msx10 coil chge set by ecu
int mafmap, fuelload,                                    // maf for future; kpa (=map or tps)
fuelcor;                                         // fuel composition correction - %
unsigned char port_status,                       // Bits indicating spare port status.
  knk_rtd;               // amount of ign retard (degx10) subtracted from normal advance.
unsigned int EAEfcor1;
int egoV1,egoV2;                                                         // ego sensor readbacks in Vx100
unsigned char status1, status2, status3, status4;   // added ms2extra
unsigned int looptime;
unsigned int istatus5;
unsigned int tpsadc; //lets do a real calibration
int fuelload2;
int ignload;
int ignload2;
//int spare[5]; - deleted (base.ini updated)
unsigned char synccnt;
char timing_err;
unsigned long dt3;                               // delta t bet. rpm pulses (us)
unsigned long wallfuel1;
unsigned int gpioadc[8]; // capture values of gpioadc ports
unsigned int gpiopwmin[4];

unsigned int adc6, adc7; // capture values of adc6,7
unsigned long wallfuel2;
unsigned int EAEfcor2;
unsigned char boostduty;
unsigned char syncreason;
/* this variable will hold reasons that trigger wheels lost sync
e.g.
0 = no problem
1 = init error
2 = missing tooth at wrong time
3 = too many teeth before missing tooth (last)
4 = too few teeth before missing tooth (last)
5 = 1st tooth failed test
6 = nonsense input (last)
7 = nonsense input (mid)
8 = too many teeth before missing tooth (mid)
9 = too few teeth before missing tooth (mid)
10 = too many teeth before end of sequence
11 = too few teeth before second trigger
12 = too many sync errors
13 = dizzy wrong edge
14 = trigger return vane size
15 = EDIS
16 = EDIS
17 = didn't received the second trigger when expected in wheel mode

space for more common reasons
plus other special reasons for the custom wheels
20 = subaru 6/7 tooth 6 error
21 = subaru 6/7 tooth 3 error
22 = Rover #2 missing tooth error
23 = 420A long tooth not found
24 = 420A cam phase wrong
25 = 420A 
26 = 420A
27 = 420A
28 = 36-1+1
29 = 36-2-2-2 semi sync failed
30 = 36-2-2-2 tooth 14 error
31 = Miata 99-00 - 2 cams not seen
32 = Miata 99-00 - 0 cams seen
33 = 6G72 - tooth 2 error
34 = 6G72 - tooth 4 error
35 = Weber-Marelli
36 = CAS 4/1
37 = 4G63
38 = 4G63
39 = 4G63
40 = Twin trigger
41 = Twin trigger
42 = Chrysler 2.2/2.5
43 = Renix
44 = Suzuki Swift
45 = Vitara
46 = Vitara
47 = Daihatsu 3
48 = Daihatsu 4
49 = VTR1000
50 = Rover #3
51 = GM 7X
52 = 36-2-2-2 tooth 30 error
53 = rc51 semi error
54 = rc51 re-sync error tooth 6
55 = rc51 re-sync error tooth 16
56 = rc51 re-sync error tooth 18
57: Nissan CAS: wrong pattern, e.g. slot length increases but should decrease
58: Nissan CAS: longest slot test failed
..
67 = LS1 semi failed
68 = LS1 resync failed
69 = YZF1000 resync failed
70 = 36-1+1 no cam
*/
unsigned int user0; // spare value for the 'user defined'

int inj_adv1, inj_adv2; // injection timing in deg x 10 
unsigned int pw3,pw4;           // pw in usec
int vetrim[4]; 
unsigned int maf;
int eaeload;
int afrload;
int rpmdot;

unsigned char gpioport[3]; // capture values from gpio digi ports (moved to preserve alignment for CAN passthrough)
} variables;

extern variables outpc;
extern variables txbuf;

typedef struct {
    int FuelAdj, SpkAdj, IdleAdj, SprAdj; // allow other devices to change our behaviour
} datax;
extern datax datax1;

#define status1_needburn    1   // need burn
#define status1_lostdata    2  // lost data
#define status1_conferr     4    // config error
#define status1_syncok      8
#define status1_synclatch   0x10
#define status1_ftblsw   0x20
#define status1_stblsw   0x40

#define status2_nitrous1  1    // nitrous stage1
#define status2_nitrous2  2    // nitrous stage2
#define status2_revlim  4   //hard limiter on
#define status2_launch  8   // launch active
#define status2_flatshift  0x10   // flatshift active
#define status2_spkcut 0x20 // doing spk cut
#define status2_overboost_active 0x40
#define status2_pwmidle_closed  0x80

#define status3_cut_fuel 1
#define status3_donelog 2 // set when trigger or tooth log is complete
#define STATUS3_MAPERROR 4

// outpc.status 4,5 are used for ease of getting data values into Megatune

// Prototypes - Note: ISRs prototyped above.
int main(void) FAR_TEXT3d_ATTR; // try 3d to give 16k to play with
void noisefilter_lookup(void) FAR_TEXT3b_ATTR;
void wheel_fill_event_array(ign_event *, ign_event *, int, int,
                             ign_time, unsigned int, unsigned char) FAR_TEXT3b_ATTR;
void wheel_fill_fuel_event_array(fuel_event *, int, ign_time, unsigned int, unsigned char siamese) FAR_TEXT1_ATTR;
void setup_staging(void) FAR_TEXT3b_ATTR;
void calc_staged_pw(unsigned long, unsigned long) FAR_TEXT38_ATTR;
unsigned char calc_duty(unsigned long) FAR_TEXT3b_ATTR;
void staged_on(unsigned long) FAR_TEXT3b_ATTR;
void set_prime_ASE(void) FAR_TEXT3b_ATTR;
void set_EAE_lagcomp(void) FAR_TEXT3b_ATTR;
void main_init(void) FAR_TEXT3b_ATTR; // was TEXT3
void ign_reset(void) FAR_TEXT1_ATTR;
void get_adc(char chan1, char chan2) FAR_TEXT1_ATTR;
unsigned int maflookup(unsigned int) FAR_TEXT1_ATTR;
void calc_rpmdot() FAR_TEXT39_ATTR;
#define ego_get_sample() get_adc(5, 6)
int move_IACmotor(void); // FAR_TEXT1_ATTR;
int barocor_eq(int baro) FAR_TEXT1_ATTR;
int aircor_eq(int mat) FAR_TEXT1_ATTR;
void set_spr_port(char port, char val) FAR_TEXT1_ATTR;
int coil_dur_table(int delta_volt) FAR_TEXT1_ATTR;
int CW_table(int clt, int *table, int *temp_table) FAR_TEXT1_ATTR;
void CanInit(void) FAR_TEXT1_ATTR; // test FAR_TEXT1_ATTR;
void can_xsub01(void) FAR_TEXT1_ATTR; // was FAR_TEXT1_ATTR
void can_sendburn(void) FAR_TEXT1_ATTR;
void can_reqdata(void) FAR_TEXT1_ATTR;
void can_snddata(void) FAR_TEXT39_ATTR;
void can_t(void) FAR_TEXT39_ATTR;
void can_crc32(void) FAR_TEXT39_ATTR;
void cp_page(void) FAR_TEXT39_ATTR;
void can_init_tbl(void) FAR_TEXT1_ATTR;  // same page as lookup tables
void Flash_Init(void) FAR_TEXT1_ATTR;
void ign_wheel_init(void) FAR_TEXT3a_ATTR; // was in 3b;
void boost_ctl_init(void) FAR_TEXT3b_ATTR;
void boost_ctl(void) FAR_TEXT3b_ATTR;
void idle_ctl_init(void) FAR_TEXT3b_ATTR;
void idle_firstrun(void) FAR_TEXT39_ATTR;
void idle_ctl(void) FAR_TEXT3b_ATTR;
void idle_test_mode(void) FAR_TEXT3b_ATTR;
void idle_on_off(void) FAR_TEXT3b_ATTR;
void idle_iac_warmup(void) FAR_TEXT3b_ATTR;
void idle_pwm_warmup(void) FAR_TEXT39_ATTR;
void idle_closed_loop(void) FAR_TEXT39_ATTR;
void idle_closed_loop_throttlepressed(int rpm_thresh) FAR_TEXT39_ATTR;
void idle_closed_loop_throttlelifted(int rpm_thresh) FAR_TEXT39_ATTR;
void idle_closed_loop_pid(int targ_rpm, int rpm_thresh, char savelast) FAR_TEXT39_ATTR;
int idle_closed_loop_newtarg(int targ_rpm) FAR_TEXT39_ATTR;
void wheel_fill_map_event_array(map_event * map_events_fill, int map_ang,
                                ign_time last_tooth_time,
                                unsigned int last_tooth_ang) FAR_TEXT3b_ATTR;
int calc_ITB_load(int percentbaro) FAR_TEXT39_ATTR;
void run_EAE_calcs(void) FAR_TEXT3b_ATTR;

void ego_init(void) FAR_TEXT1_ATTR;
void ego_get_targs(void) FAR_TEXT1_ATTR;
void ego_get_targs_gl(void) FAR_TEXT1_ATTR;
void ego_closed_loop_simple(long *ego1step, long *ego2step) FAR_TEXT1_ATTR;
void ego_closed_loop_pid(long *ego1step, long *ego2step, unsigned long looptime) FAR_TEXT1_ATTR;
void ego_closed_loop_pid_dopid(long *egostep, unsigned long looptime, unsigned int ego, unsigned int afrtarg, int ego1or2) FAR_TEXT1_ATTR;
void ego_calc(void) FAR_TEXT1_ATTR;
void realtime(void)  FAR_TEXT3b_ATTR;
void chk_srl(void)  FAR_TEXT39_ATTR;
void chk_crc(void) FAR_TEXT39_ATTR;
void INJ1(void) FAR_TEXT1_ATTR; //was TEXT3b
void INJ2(void) FAR_TEXT1_ATTR;
void INJ3(void) FAR_TEXT1_ATTR;
void INJ4(void) FAR_TEXT1_ATTR;
void schedule_fuel(unsigned int TCothis) FAR_TEXT3b_ATTR;
unsigned int add_open(unsigned int pwcalc, unsigned int pw_open) FAR_TEXT3b_ATTR;
void add_vetrim(void) FAR_TEXT1_ATTR;
long calc_fuel_req_ang (long ang, unsigned long pw, unsigned int pw_open) FAR_TEXT39_ATTR;
void calc_opentime(void) FAR_TEXT39_ATTR;
unsigned char afrLF_calc(long t) FAR_TEXT1_ATTR;
void user_defined(void) FAR_TEXT3a_ATTR;
void ck_log_clr(void) FAR_TEXT3a_ATTR;
void handle_spareports(void) FAR_TEXT39_ATTR;
void handle_ovflo(void) FAR_TEXT39_ATTR;
long long_abs(long) FAR_TEXT39_ATTR;

// for ASM routines the memory allocation is set in the source file
// *** BUT *** imperative to set the bank here as well or the C code jumps incorrectly.
unsigned long crc32buf(unsigned long, unsigned int, unsigned int) FAR_TEXT39_ATTR;
void ResetCmd(void) FAR_TEXT1_ATTR;
void monitor(void) FAR_TEXT1_ATTR;
void SpSub(void) FAR_TEXT1_ATTR;
void NoOp(void) FAR_TEXT1_ATTR;
void burntbl(void);
void erasefactor(void) FAR_TEXT1_ATTR;
void progfactor(void) FAR_TEXT1_ATTR;

void do_idle(void) FAR_TEXT39_ATTR;
void ckstall(void);

void fire_coil(void);
void dwell_coil_cut(void);

void fire_coil_rotary(void);
void dwell_coil_rotary(void);
void tt2d_sub(void);
void tt2s_sub(void);

void syncfirst(void);
void chknewpage(void);

void do_complog_pri(unsigned long);
void configerror(void) FAR_TEXT3a_ATTR; // real routine in assembly
void bs_text3a(void) FAR_TEXT3a_ATTR; // BS routine in C

void can_poll_remote(void) FAR_TEXT3a_ATTR;

void remote_spr_ports(void) FAR_TEXT3a_ATTR;

void tacho_out(void) FAR_TEXT3a_ATTR;
unsigned long muldiv(unsigned int, unsigned long);

void calc_flexfuel() FAR_TEXT39_ATTR;

// sensor variables
extern int last_tps,last_map,tpsdot_ltch,mapdot_ltch;
// fuel variables
extern unsigned int pwcalc1,pwcalc2,pwcalc3,pwcalc4,pw_open1,pw_open2,pw_open3,pw_open4,PrimeP,AWEV,AWC,pwcalc_eae1,pwcalc_eae2, req_pw1, req_pw2, req_pw3, req_pw4;
extern unsigned char pwm1_on,pwm2_on;
extern unsigned int RevLimRpm1, RevLimRpm2;
// ignition variables
extern unsigned char SPK,CHG, pulse_no,ign_state,ign_setpin,
  IgnOCpinstate,PulseTol;
extern long charge_time,coil_dur_set;
extern unsigned int coil_dur;
extern unsigned long IgnTimerComp,dtpred,dtpred_last,dtpred_last2,dtpred_last3,NoiseFilterMin;
// IAC variables
extern unsigned long motor_time;
extern int IACmotor_pos,IACmotor_pos_remainder,last_iacclt,tble_motor_pos;
extern unsigned char idle_wait_timer;
extern unsigned char pwmidle_reset;
extern unsigned int pwmidle_timer;
extern unsigned char boost_ctl_duty;
extern char IAC_moving,IACmotor_reset,IdleCtl,motor_step;
extern int IACmotor_last;
// General variables
extern unsigned int iacpwmctr, TC_ovflow;
extern unsigned long lmms,t_enable_IC,t_enable_IC2,Rpm_Coeff,ltch_lmms,ltch_lmms2,rcv_timeout,adc_lmms;
extern unsigned int asecount;
extern unsigned char flocker,tpsaclk,egocount,igncount,fuelcount,altcount,next_adc,first_adc,   
        txmode,tble_idx,burn_idx,synch,
        egopstat[2], FSensStat,knk_clk,knk_clk_test,knk_stat,knk_count,mms,millisec;
extern unsigned int boost_ctl_timer;
#define SYNC_SYNCED     0x1
#define SYNC_FIRST      0x2
#define SYNC_RPMCALC    0x4
#define SYNC_SEMI       0x8
#define SYNC_SEMI2      0x10

extern unsigned char seq_inj_ctrl;
extern unsigned int hybrid_rpm, hybrid_hyst;
#define SEQ_STD_INJ     0x01
#define SEQ_USE_TC2     0x02
#define SEQ_USE_TC4     0x04
#define SEQ_HYBRID      0x08
#define SEQ_MASK_INJ1   0x10
#define SEQ_MASK_INJ2   0x20
#define SEQ_MASK_INJ3   0x40
#define SEQ_MASK_INJ4   0x80

extern long ego1errm1[2],ego2errm1[2];
extern unsigned int  FSens_Pd,FSensFreq;
extern unsigned long tegoclk;
/* Clocks:
        - igncount: counts up each tach pulse, cleared when hit Divider pulses
               (and injection occurs).
        - asecount: counts up each time igncount = 0 (each Divider pulses).
        - egocount: counts up each tach pulse, cleared when hits EgoCountCmp
        - tpsaclk: counts every .1 sec
        - altcount: flips 0,1,0,1... on each injection, resulting in firing alternate
                injector banks if Alternate option.
*/
extern unsigned int txcnt,txgoal,rxoffset,rxnbytes,rxcnt,tble_word,ntword;
extern char ego_cloop,bad_ego_flag,bad_ego_ltch,first_clt;
extern int knk_tble_adv,warmup_Tclt,ffspkdel;
extern long sumegocor1,sumegocor2;
extern unsigned long WF1, WF2;
extern unsigned long AWA1, AWA2, SOA1, SOA2;
extern unsigned long tooth_diff_last_2, tooth_diff_last_1, tooth_diff_last, tooth_diff_this;
extern ign_time tooth_diff_rpm, tooth_diff_rpm_last;
extern unsigned char no_triggers;
extern unsigned char no_teeth;
extern unsigned char tooth_no, tooth_no_rpm;
extern unsigned char last_tooth;
extern unsigned char mid_last_tooth;

extern int cycle_deg;

//had to add these when main_init broken off
extern unsigned int tcrank_done,tcold_pos;
extern int start_clt;

// CAN variables
extern unsigned long cansendclk,ltch_CAN;
extern unsigned int can_status;
extern unsigned char can_clr_stat;
typedef struct {
  /* CAN Xmt mssge ring buffer:
      can[0] is to hold Rx,TxISR messages,
      can[1] for main loop messages (so don't get clobbered by ISR)
      cxno = no msgs in queue waiting to be sent out
      cxno_in = index for inserting a msg in queue (incr after insert)
      cxno_out = index for sending out a msg (incr after load CAN buf)
      msg_type = CMD,REQ,RESP,XSUB (= set value, request value, respond
          to a request for value, execute a subroutine)
      varblk,varoffset,varbyte = blk no of data structure, byte offset
          from start of structure, no. bytes of data
      datbuf = the actual data (max of 8 bytes)
      dest = id no. of device to which msg being sent.
  */
  unsigned char cxno,cxno_in,cxno_out;
  unsigned char cx_msg_type[NO_CANMSG], cx_myvarblk[NO_CANMSG],
          cx_destvarblk[NO_CANMSG], cx_dest[NO_CANMSG],cx_varbyt[NO_CANMSG];
  unsigned short cx_myvaroff[NO_CANMSG],cx_destvaroff[NO_CANMSG];
  unsigned char cx_datbuf[NO_CANMSG][8];  // max msg data = 8 bytes
} canmsg;
extern canmsg can[];

// pointers for spare port pins
extern volatile unsigned char *pPTMpin[8], *pPTTpin[8], *pPTApin0, *pPTEpin[2];
extern volatile unsigned char *boostport;
extern unsigned char boostpin;
extern unsigned char dummyReg,lst_pval[NPORT],lst_rpval[8];

// allocate space in ram for flash burner core
extern volatile unsigned char RamBurnPgm[36];

// vars added for MS2/Extra
extern unsigned char page;  // which flash data page is presently in ram
extern unsigned char num_spk; // calculated number of spark outputs
extern unsigned char conf_err; // set if configuration error
extern unsigned int mltimestamp; // time the mainloop
extern unsigned int EAEdivider;
extern unsigned char mmsDiv, boost_ctl_clock;

// these were static in sci isr, asm needs them as global (same thing)
//extern int vfy_fail,;
extern unsigned char CANid, next_txmode, rd_wr,Tcksum,Tcntr;

/* NOTE! When updating these defines, be sure to check ms2extrah.inc as well */

extern unsigned char flagbyte0;
#define flagbyte0_50ms    1   // use bits of this byte
#define flagbyte0_to      2   // tacho out divider
#define flagbyte0_pt5ip    4   // use PT5 as an input
#define flagbyte0_foundfirst 8
#define flagbyte0_firstrpm 0x10 // got the first rpm calc period
#define flagbyte0_complog  0x20 // logging crank + cam teeth (composite loger)
#define flagbyte0_tthlog  0x40 // logging teeth
#define flagbyte0_trglog  0x80 // logging triggers

extern unsigned char flagbyte1;
#define flagbyte1_trig2active 1
#define flagbyte1_tstmode  2   // test mode enable - set to 1 turns off normal functions
#define flagbyte1_ovfclose 4   // nearly going to overflow
#define flagbyte1_polarity 8 // polarity check on (reduces tests in ISR)
#define flagbyte1_noisefilter 0x10 // noise filter on (reduces tests in ISR)
#define flagbyte1_igntrig 0x20 // ignition trigger LED feature on
#define flagbyte1_tstmodelatch  0x40   // test mode latch
#define flagbyte1_trig2statl 0x80  // 2nd trigger state in previous ISR (used by 6g72)

extern unsigned char flagbyte2;
#define flagbyte2_twintrig 1   // for quick checking
#define flagbyte2_twintrignow 2   // event happened just now
#define flagbyte2_crank_ok 4   // ok to go to crank mode (rock crawler / hei bypass)
#define flagbyte2_tfi_ps 8   // Push Start TFI mode enabled
#define flagbyte2_tc0stat 0x10   // Status of crank tach input when 2nd trigger (CAS4/2)
#define flagbyte2_runidle 0x20
#define flagbyte2_EAElag 0x40
#define flagbyte2_MV2 0x80   // return MS2 base style data to keep MV2 happy

extern unsigned char flagbyte3;
#define flagbyte3_firstIAC  1    // from MS2 2.87
#define flagbyte3_kill_srl  2    // from MS2 2.87
#define flagbyte3_can_reset 4    // from MS2 2.87
#define flagbyte3_getcandat 8    // from MS2 2.87
#define flagbyte3_sndcandat 0x10 // from MS2 2.87
#define flagbyte3_runboost  0x20
#define flagbyte3_toothinit 0x40 // set to 1 once we've reached the tooth
#define flagbyte3_samplemap 0x80

extern unsigned char flagbyte4;
#define flagbyte4_first_edis 1 // have we sent the multi-spark SAW word
#define flagbyte4_transition_done 2
#define flagbyte4_staging_on 4
#define flagbyte4_tach2 8        // entered ISR on 2nd tach signal (used locally in timer ISR)
#define flagbyte4_found_miss 0x10
#define flagbyte4_cantuning  0x20  // CAN is being used to read/write/burn tuning data. Avoid fights with serial due to paging mechanism.
#define flagbyte4_oddspk     0x40  // tells code to "join" sparks A & B, but allowing them to have their own dwell timers
#define flagbyte4_idleadvreset 0x80

extern unsigned char flagbyte5;
#define FLAGBYTE5_CRK_DOUBLE 0x01 // crank - single or double edged
#define FLAGBYTE5_CRK_BOTH   0x02 // crank - triggering on both edges
#define FLAGBYTE5_CAM        0x04 // cam in use
#define FLAGBYTE5_CAM_DOUBLE 0x08 // cam - single or double edged
#define FLAGBYTE5_CAM_BOTH   0x10 // cam - triggering on both edges
#define FLAGBYTE5_CAM_NOISE  0x20 // cam - noise filter on
#define FLAGBYTE5_CAM_POLARITY 0x40 // cam - noise filter on
#define FLAGBYTE5_LOG_CLR    0x80 // tooth log buffer needs clearing

extern unsigned char flagbyte6;
#define FLAGBYTE6_DONEINIT      0x01 // DONE INIT
#define FLAGBYTE6_USE_MAF       0x02
#define FLAGBYTE6_USE_MAF_ONLY  0x04
#define FLAGBYTE6_CRC           0x08
#define FLAGBYTE6_CRC_CAN       0x10
#define FLAGBYTE6_PAGECOPY      0x20

extern unsigned char flagbyte11;
#define FLAGBYTE11_DLI4         0x01
#define FLAGBYTE11_DLI6         0x02
#define FLAGBYTE11_FC           0x04
#define FLAGBYTE11_FD           0x08
#define FLAGBYTE11_RX8          0x10
#define FLAGBYTE11_JS10         0x20

//extern unsigned char scidiag[];      // this is for debug only and should be removed in future

extern unsigned long stall_timeout; // save doing long div each 0.128ms
extern unsigned char last_fsensdat;
extern unsigned short FPdcounter;
extern unsigned char fc_counter, adc_ctr;
extern unsigned int lowres, lowres_ctr, tacho_targ; // 0.128ms period counters (like MS1) for tacho
//spark cut
extern unsigned char spk_cutx, spk_cuty, spk_cuti;
extern unsigned char staged_num_events; /* number of events into staging trasition */
extern unsigned long pw_staged1, pw_staged2, pw_staged3, pw_staged4; /* staged pulsewidths */
// not used extern unsigned int spk_mult; // save doing some long divs in ISR
//tooth / trigger logger
extern unsigned int log_offset;
//dwell exec software 0.128ms timers
extern unsigned char dwl[], mindwl, nomdwl, maxdwl, testcnt, rtsci, rtcksum;
extern unsigned int swtimer, swtimer_TC5_last;
extern unsigned int deg_per_tooth[]; // deg*10 AHEAD of tooth-1 i.e. runs 0->, teeth are 1->
extern ign_time act_tooth_time[];
extern unsigned int act_tooth_ang[];
extern unsigned char pwmd1, pwmd2, trig2cnt, bl_timer, resetholdoff, n2o_act_timer, n2o2_act_timer;
extern unsigned int inj1cntdown, inj2cntdown, injtime, injtime_EAElagcomp;
extern unsigned int n2o_addfuel;
extern unsigned int mapsample_time, tpssample_time; //.128 ms ticks
extern unsigned char running_seconds;
extern unsigned char fc_off_time;
extern unsigned long tmp_pw1,tmp_pw2,tmp_pw3,tmp_pw4, ticks_per_deg;
extern unsigned char tmpdwellsel, tmpcoilsel;
extern unsigned char tooth_init, tooth_counter, tooth_counter_main;
#define WHEEL_NUM_TEETH 20    // minimal to allow all teeth to be grabbed in mainloop exec time
extern ign_time act_tooth_time[];
extern unsigned char act_tooth_num[];

extern unsigned char fuel_cntr, firstsync_iter, set_count, EAElagcomp_squirts, EAElag_squirting;
extern unsigned char channel_squirted, squirtcount1, squirtcount2;
extern unsigned long dtpred_adder;
extern unsigned char syncerr;
extern unsigned int smallest_tooth_crk, smallest_tooth_cam, false_mask_crk, false_mask_cam, false_period_crk_tix, false_period_cam_tix;
extern unsigned char injbits;
extern unsigned int TC0_last, TC_trig2_last, TC_trig2_last2, TC5_last;
extern unsigned long TC5_32bits, TC5_trig_firstedge;
extern unsigned char idle_advance_timer;
extern unsigned long IC_last; // for triglog2
extern int gl_afrtgt1, gl_afrtgt2;
extern unsigned char num_cyl, divider;
extern unsigned int dwell_us, dwell_us2, dizzy_scaler[NUM_TRIGS], trigret_scaler;
extern unsigned long dwell_long;
extern unsigned char dwellsel_next;

extern unsigned char no_inj, no_squirts;
extern unsigned char spkmode;
extern unsigned char ls1_ls, ls1_sl;
extern unsigned char last_edge, last_edge2;
#define RPMDOT_N 15
extern unsigned int rpmdot_data[RPMDOT_N][2];
extern unsigned long sd_crc;

extern unsigned int remotePWMfreq;
extern unsigned char remotePWMscale;

extern unsigned int srl_timeout;

// ignition definitions to swap timer interrupts TC2/TC4/TC5/TC6/TC7 if MS2 vs. Microsquirt // added TC7 and TC4/TC6 (for uS module)
#ifndef MICROSQUIRT
#define TC_ign TC7    // was TC2
#define TFLG_ign 0x80 // was 0x04
#define TC_trig2 TC5
#define TFLG_trig2 0x20
#define TC_rotINJ3 TC2
#define TFLG_rotINJ3 0x04
#define TC_rotINJ4 TC4
#define TFLG_rotINJ4 0x10
#define TC_dwl TC6
#define TFLG_dwl 0x40
#else
#define TC_ign TC5
#define TFLG_ign 0x20
#define TC_trig2 TC2
#define TFLG_trig2 0x04
#define TC_rotINJ3 TC6
#define TFLG_rotINJ3 0x40
#define TC_rotINJ4 TC7
#define TFLG_rotINJ4 0x80
#define TC_dwl TC4
#define TFLG_dwl 0x10
#endif

/* 'user defined'                                                           *  
 * Here are some variables defined to help the new programmer get started   *
 * search for 'user defined' in ms2_extra_main.c for more notes             *
 *                                                                          */
extern unsigned long user_ulong;
extern unsigned int user_uint;
extern unsigned char user_uchar;
/* end user defined section                                                 */

#endif
