/* $Id: ms2_extra_can.c,v 1.15 2010-10-01 00:32:46 jsmcortina Exp $ */
#include "ms2_extra.h"

void CanInit(void)
{
    unsigned int ix;
    /* Set up CAN communications */
    /* Enable CAN, set Init mode so can change registers */
    CANCTL1 |= 0x80;
    CANCTL0 |= 0x01;

    /* clear ring buffers */
    for(ix = 0;ix < 2;ix++)  {
        can[ix].cxno = 0;
        can[ix].cxno_in = 0;
        can[ix].cxno_out = 0;
    }
    can_status = 0;

    while(!(CANCTL1 & 0x01));  // make sure in init mode

    /* Set Can enable, use IPBusclk (24 MHz),clear rest */
    CANCTL1 = 0xC0;  
    /* Set timing for .5Mbits/ sec */
    CANBTR0 = 0xC2;  /* SJW=4,BR Prescaler= 3(24MHz CAN clk) */
    CANBTR1 = 0x1C;  /* Set time quanta: tseg2 =2,tseg1=13 
                        (16 Tq total including sync seg (=1)) */
    CANIDAC = 0x00;   /* 2 32-bit acceptance filters */
    /* CAN message format:
     * Reg Bits: 7 <-------------------- 0
     * IDR0:    |---var_off(11 bits)----|  (Header bits 28 <-- 21)
     * IDR1:    |cont'd 1 1 --msg type--|  (Header bits 20 <-- 15)
     * IDR2:    |---From ID--|--To ID---|  (Header bits 14 <--  7)
     * IDR3:    |--var_blk-|--spare--rtr|  (Header bits  6 <-- 0,rtr)
     */  
    /* Set identifier acceptance and mask registers to accept 
       messages only for can_id or device #15 (=> all devices) */
    /* 1st 32-bit filter bank-to mask filtering, set bit=1 */
    CANIDMR0 = 0xFF;           // anything ok in IDR0(var offset)
    CANIDAR1 = 0x18;           // 0,0,0,SRR=IDE=1
    CANIDMR1 = 0xE7;		   // anything ok for var_off cont'd, msgtype
    CANIDAR2 = flash4.mycan_id;     // rcv msg must be to can_id, but
    CANIDMR2 = 0xF0;			 // can be from any other device
    CANIDMR3 = 0xFF;           // any var_blk, spare, rtr
    /* 2nd 32-bit filter bank */
    CANIDMR4 = 0xFF;           // anything ok in IDR0(var offset)
    CANIDAR5 = 0x18;           // 0,0,0,SRR=IDE=1
    CANIDMR5 = 0xE7;		   // anything ok for var_off cont'd, msgtype
    CANIDAR6 = 0x0F;			 // rcv msg can be to everyone (id=15), and
    CANIDMR6 = 0xF0;			 // can be from any other device
    CANIDMR7 = 0xFF;           // any var_blk, spare, rtr

    /* clear init mode */
    CANCTL0 &= 0xFE;  
    /* wait for synch to bus */
    while ((!(CANCTL0 & 0x10)) && (ix < 0xfffe)) {
        ix++;
        asm("nop");
        asm("nop");
        asm("nop");
        asm("nop");
    }
    if (ix == 0xfffe) { // Did not sync in time
        // CAN broken
        conf_err = 54;
    }

    /* no xmit yet */
    CANTIER = 0x00;
    /* clear RX flag to ready for CAN recv interrupt */
    CANRFLG = 0xC3;
    /* set CAN rcv full interrupt bit */
    CANRIER = 0x01;
    ltch_CAN = 0xffffffff;

	CANid = flash4.mycan_id;
    return;
}

void can_sendburn()
{
    int ix;
    // set up single CAN message for "burn" & forward to aux board
    // (called from SCI routine)
    ix = can[0].cxno_in;
    can[0].cx_msg_type[ix] = MSG_BURN; 
    can[0].cx_destvarblk[ix] = tble_idx;
    can[0].cx_destvaroff[ix] = 0;
    can[0].cx_dest[ix] = CANid;
    can[0].cx_varbyt[ix] = 0;		 // no data bytes
    // This is where (in xmt ring buffer) to put next message
    if(can[0].cxno_in < (NO_CANMSG - 1)) {
        can[0].cxno_in++;
    } else {
        can[0].cxno_in = 0;	 // overwrite oldest msg in queue
    }
    // increment counter
    if(can[0].cxno < NO_CANMSG) {
        can[0].cxno++;
    } else {
        can[0].cxno = NO_CANMSG;
    }
    if(!(CANTIER & 0x07))  {
        // Following will cause entry to TxIsr without sending msg
        // since when CANTIER = 0, CANTFLG left as buff empty(>0).
        // If CANTIER has at least 1 int buf enabled, will enter
        // TxIsr automatically.
        CANTBSEL = CANTFLG;
        CANTIER = CANTBSEL;
    }
}

void can_reqdata()
{
    int ix;
    // set up single CAN message & forward to aux board
    //   MT requesting data from aux board.
    //   Note: MT must only deal with 1 board at a time and wait til
    //   data back or timeout.
    ix = can[0].cxno_in;
    can[0].cx_msg_type[ix] = MSG_REQ; 
    can[0].cx_destvarblk[ix] = tble_idx;
    can[0].cx_myvarblk[ix] = 6;  // txbuf
    // varblks for the aux boards
    can[0].cx_destvaroff[ix] = rxoffset;
    can[0].cx_myvaroff[ix] = 0;
    can[0].cx_dest[ix] = CANid;
    if (rxnbytes > 8) {
        can[0].cx_varbyt[ix] = 8; // bring data back in 8 byte chunks
    } else {
        can[0].cx_varbyt[ix] = (unsigned char)rxnbytes;
    }
    // This is where (in xmt ring buffer) to put next message
    if(can[0].cxno_in < (NO_CANMSG - 1)) {
        can[0].cxno_in++;
    } else {
        can[0].cxno_in = 0;	 // overwrite oldest msg in queue
    }
    // increment counter
    if(can[0].cxno < NO_CANMSG) {
        can[0].cxno++;
    } else {
        can[0].cxno = NO_CANMSG;
    }
    if(!(CANTIER & 0x07))  {
        // Following will cause entry to TxIsr without sending msg
        // since when CANTIER = 0, CANTFLG left as buff empty(>0).
        // If CANTIER has at least 1 int buf enabled, will enter
        // TxIsr automatically.
        CANTBSEL = CANTFLG;
        CANTIER = CANTBSEL;
    }
    flagbyte3 |= flagbyte3_getcandat;
    flagbyte3 &= ~flagbyte3_sndcandat;

}

void can_snddata()
{
    int ix;
    unsigned char bk_cnt;
    bk_cnt = (rxnbytes-1) & 0x07; // allow splitting blocks
    // set up single CAN message & forward to aux board
    //   MT sending data to aux board
    for(ix = 0; ix <= bk_cnt; ix++)  {
        can[0].cx_datbuf[can[0].cxno_in][ix] = *((char *)&txbuf + ix + ((rxnbytes-1) & 0xfff8));
    }
    ix = can[0].cxno_in;
    can[0].cx_msg_type[ix] = MSG_CMD; 
    can[0].cx_destvarblk[ix] = tble_idx;
    can[0].cx_destvaroff[ix] = rxoffset + ((rxnbytes-1) & 0xfff8);
    can[0].cx_dest[ix] = CANid;
    can[0].cx_varbyt[ix] = bk_cnt+1;
    // This is where (in xmt ring buffer) to put next message
    if(can[0].cxno_in < (NO_CANMSG - 1)) {
        can[0].cxno_in++;
    } else {
        can[0].cxno_in = 0;	 // overwrite oldest msg in queue
    }
    // increment counter
    if(can[0].cxno < NO_CANMSG) {
        can[0].cxno++;
    } else {
        can[0].cxno = NO_CANMSG;
    }
    if(!(CANTIER & 0x07))  {
        // Following will cause entry to TxIsr without sending msg
        // since when CANTIER = 0, CANTFLG left as buff empty(>0).
        // If CANTIER has at least 1 int buf enabled, will enter
        // TxIsr automatically.
        CANTBSEL = CANTFLG;
        CANTIER = CANTBSEL;
    }  
} 

void can_t()
{
    unsigned int ix;
    // set up single CAN message & forward to aux board
    //   MT sending data to aux board
    //  'T' command for remote sensor data
    for(ix = 0; ix < Tcntr; ix++)  {
        can[0].cx_datbuf[can[0].cxno_in][ix] = *((char *)&txbuf + ix);
    }
    ix = can[0].cxno_in;
    can[0].cx_msg_type[ix] = MSG_CMD;
    can[0].cx_destvarblk[ix] = tble_idx;
    can[0].cx_destvaroff[ix] = 0;
    can[0].cx_dest[ix] = CANid;
    can[0].cx_varbyt[ix] = Tcntr;
    // This is where (in xmt ring buffer) to put next message
    if(can[0].cxno_in < (NO_CANMSG - 1)) {
        can[0].cxno_in++;
    } else {
        can[0].cxno_in = 0;	 // overwrite oldest msg in queue
    }
    // increment counter
    if(can[0].cxno < NO_CANMSG) {
        can[0].cxno++;
    } else {
        can[0].cxno = NO_CANMSG;
    }
    if(!(CANTIER & 0x07))  {
        // Following will cause entry to TxIsr without sending msg
        // since when CANTIER = 0, CANTFLG left as buff empty(>0).
        // If CANTIER has at least 1 int buf enabled, will enter
        // TxIsr automatically.
        CANTBSEL = CANTFLG;
        CANTIER = CANTBSEL;
    }
}

void can_xsub01(void)
{
    return;
}

void can_poll_remote(void)
{
	unsigned int ix;

	// load ring buffer - send request for data
	// can[1] is used for mainloop requests
	//CANRIER = 0x00;
	if ((flash4.can_poll < 3) || ((flash4.can_poll == 3) && (flash4.enable_poll & 0x01))) {
		// Get remote ADC data (GPIO, MS2/Extra slave, Generic board with ADC polling enabled)
		for (ix=0 ; ix<2 ; ix++) { // loop to make two 8 byte transfer for all 8 words
			can[1].cx_msg_type[can[1].cxno_in] = MSG_REQ; 
			can[1].cx_dest[can[1].cxno_in] = (flash4.can_poll_id & 0x0F);            // send to device 1

			if (flash4.can_poll == 1) {
				can[1].cx_destvarblk[can[1].cxno_in] = 2;   // fetch from block 2 - GPIO
				can[1].cx_destvaroff[can[1].cxno_in] = 2 + (ix*8);  // fetch from adcs start at byte 2 - GPIO
			} else if (flash4.can_poll == 2) {
				can[1].cx_destvarblk[can[1].cxno_in] = 7;   // fetch from block 7 - MS2 + MS2/Extra
				can[1].cx_destvaroff[can[1].cxno_in] = (unsigned short)(&outpc.gpioadc[0]) - (unsigned short)(&outpc) + (ix*8);  // fetch raw adc from outpc as MS2/Extra slave should have stored them here
			} else if (flash4.can_poll == 3) {
				can[1].cx_destvarblk[can[1].cxno_in] = flash4.poll_tables[0];   // fetch from user defined table
				can[1].cx_destvaroff[can[1].cxno_in] = flash4.poll_offset[0] + (ix*8);  // fetch raw adc from user defined offset
			}
			can[1].cx_varbyt[can[1].cxno_in] = 8;    // 8 bytes to be returned

			// where should the resulting data be stored
			can[1].cx_myvarblk[can[1].cxno_in] = 7;  // store returned data in outpc
			can[1].cx_myvaroff[can[1].cxno_in] = (unsigned short)(&outpc.gpioadc[0]) - (unsigned short)(&outpc) + (ix*8); // this is offset of where to store it

			// This is where (in xmt ring buffer) to put next message
			if(can[1].cxno_in < (NO_CANMSG - 1)) {
				can[1].cxno_in++;
			} else {
				can[1].cxno_in = 0;
			}
			// increment counter
			if(can[1].cxno < NO_CANMSG) {
				can[1].cxno++;
			} else {
				can[1].cxno = NO_CANMSG;
			}
		}
	}
	if ((flash4.can_poll == 3) && (flash4.enable_poll & 0x02)) {
		// Get remote PWM data from Generic board
		can[1].cx_msg_type[can[1].cxno_in] = MSG_REQ; 
		can[1].cx_dest[can[1].cxno_in] = (flash4.can_poll_id & 0x0F);            // send to device 1

		can[1].cx_destvarblk[can[1].cxno_in] = flash4.poll_tables[1];  // fetch from user defined table
		can[1].cx_destvaroff[can[1].cxno_in] = flash4.poll_offset[1];  // fetch raw pwm from user defined offset
		can[1].cx_varbyt[can[1].cxno_in] = 8;    // 8 bytes to be returned

		// where should the resulting data be stored
		can[1].cx_myvarblk[can[1].cxno_in] = 7;  // store returned data in outpc
		can[1].cx_myvaroff[can[1].cxno_in] = (unsigned short)(&outpc.gpiopwmin[0]) - (unsigned short)(&outpc); // this is offset of where to store it

		// This is where (in xmt ring buffer) to put next message
		if(can[1].cxno_in < (NO_CANMSG - 1)) {
			can[1].cxno_in++;
		} else {
			can[1].cxno_in = 0;
		}
		// increment counter
		if(can[1].cxno < NO_CANMSG) {
			can[1].cxno++;
		} else {
			can[1].cxno = NO_CANMSG;
		}
	}
	if ((flash4.can_poll == 3) && (flash4.enable_poll & 0x04) && ((flash4.ports_dir & 0x0F) < 7)) {
		// Get remote ports data from Generic board
		can[1].cx_msg_type[can[1].cxno_in] = MSG_REQ; 
		can[1].cx_dest[can[1].cxno_in] = (flash4.can_poll_id & 0x0F);            // send to device 1

		can[1].cx_destvarblk[can[1].cxno_in] = flash4.poll_tables[2];  // fetch from user defined table
		if ((flash4.ports_dir & 0x0F) == 0) {
			// 3 inputs
			can[1].cx_destvaroff[can[1].cxno_in] = flash4.poll_offset[2];  // fetch raw port from user defined offset
			can[1].cx_varbyt[can[1].cxno_in] = 3;    // 3 bytes to be returned
			ix = 0;
		} else if ((flash4.ports_dir & 0x0F) == 1) {
			// 2 inputs
			can[1].cx_destvaroff[can[1].cxno_in] = flash4.poll_offset[2] + 1;  // fetch raw port from user defined offset
			can[1].cx_varbyt[can[1].cxno_in] = 2;    // 2 bytes to be returned
			ix = 1;
		} else {
			// 1 input
			can[1].cx_destvaroff[can[1].cxno_in] = flash4.poll_offset[2] + 2;  // fetch raw port from user defined offset
			can[1].cx_varbyt[can[1].cxno_in] = 1;    // 1 bytes to be returned
			ix = 2;
		}

		// where should the resulting data be stored
		can[1].cx_myvarblk[can[1].cxno_in] = 7;  // store returned data in outpc
		can[1].cx_myvaroff[can[1].cxno_in] = (unsigned short)(&outpc.gpioport[ix]) - (unsigned short)(&outpc); // this is offset of where to store it

		// This is where (in xmt ring buffer) to put next message
		if(can[1].cxno_in < (NO_CANMSG - 1)) {
			can[1].cxno_in++;
		} else {
			can[1].cxno_in = 0;
		}
		// increment counter
		if(can[1].cxno < NO_CANMSG) {
			can[1].cxno++;
		} else {
			can[1].cxno = NO_CANMSG;
		}
	}
	if ((flash4.can_poll == 3) && (flash4.enable_poll & 0x04) && (flash4.ports_dir & 0x0F)) {
		// Update PWM idle if used
		if (flash5.pwmidle_port) {
			outpc.gpioport[flash5.pwmidle_port-1] = (unsigned char)outpc.iacstep;
		}
		// Set remote ports data on Generic board
		can[1].cx_msg_type[can[1].cxno_in] = MSG_CMD; 
		can[1].cx_dest[can[1].cxno_in] = (flash4.can_poll_id & 0x0F);            // send to device 1

		can[1].cx_destvarblk[can[1].cxno_in] = flash4.poll_tables[2];  // put to user defined table
		can[1].cx_destvaroff[can[1].cxno_in] = flash4.poll_offset[2];  // put raw port to user defined offset
		if ((flash4.ports_dir & 0x0F) == 1) {
			// 1 output
			can[1].cx_varbyt[can[1].cxno_in] = 1;    // 1 bytes to be returned
		} else if ((flash4.ports_dir & 0x0F) == 3) {
			// 2 outputs
			can[1].cx_varbyt[can[1].cxno_in] = 2;    // 2 bytes to be returned
		} else {
			// 3 outputs
			can[1].cx_varbyt[can[1].cxno_in] = 3;    // 3 bytes to be returned
		}

		for(ix = 0;ix < can[1].cx_varbyt[can[1].cxno_in];ix++)  {
			can[1].cx_datbuf[can[1].cxno_in][ix] = *((unsigned char *)outpc.gpioport + ix);
		}

				// This is where (in xmt ring buffer) to put next message
		if(can[1].cxno_in < (NO_CANMSG - 1)) {
			can[1].cxno_in++;
		} else {
			can[1].cxno_in = 0;
		}
		// increment counter
		if(can[1].cxno < NO_CANMSG) {
			can[1].cxno++;
		} else {
			can[1].cxno = NO_CANMSG;
		}
	}
	if(!(CANTIER & 0x07))  {
		// Following will cause entry to TxIsr without sending msg
		// since when CANTIER = 0, CANTFLG left as buff empty(>0).
		// If CANTIER has at least 1 int buf enabled, will enter
		// TxIsr automatically.
		CANTBSEL = CANTFLG;
		CANTIER = CANTBSEL;
	}
	//CANRIER = 0x01;
}

void can_crc32()
{
    int ix;
    // set up single CAN message & forward to aux board
    //   PC requesting CRC from aux board.
    ix = can[0].cxno_in;
    can[0].cx_msg_type[ix] = MSG_CRC; 
    can[0].cx_destvarblk[ix] = tble_idx;
    can[0].cx_myvarblk[ix] = 6;  // txbuf
    // varblks for the aux boards
    can[0].cx_destvaroff[ix] = 0;
    can[0].cx_myvaroff[ix] = 0;
    can[0].cx_dest[ix] = CANid;
    can[0].cx_varbyt[ix] = 4; // 4 bytes of CRC
    // This is where (in xmt ring buffer) to put next message
    if(can[0].cxno_in < (NO_CANMSG - 1)) {
        can[0].cxno_in++;
    } else {
        can[0].cxno_in = 0;	 // overwrite oldest msg in queue
    }
    // increment counter
    if(can[0].cxno < NO_CANMSG) {
        can[0].cxno++;
    } else {
        can[0].cxno = NO_CANMSG;
    }
    if(!(CANTIER & 0x07))  {
        // Following will cause entry to TxIsr without sending msg
        // since when CANTIER = 0, CANTFLG left as buff empty(>0).
        // If CANTIER has at least 1 int buf enabled, will enter
        // TxIsr automatically.
        CANTBSEL = CANTFLG;
        CANTIER = CANTBSEL;
    }
    flagbyte3 |= flagbyte3_getcandat;
    flagbyte3 &= ~flagbyte3_sndcandat;
}
