/* $Id: ms2_extra_ego.c,v 1.20 2011-07-10 04:30:46 culverk Exp $ */
#include "ms2_extra.h"

unsigned long ego_last_run;
long PID_scale_factor;

long egocor_100[2];

void ego_init(void)
{
    ego_last_run = 0;
    /* This is used for a similar function to the valve ranges for other
     * PID loops. It helps scale the PID output down for small engines with
     * large injectors for example
     */
    PID_scale_factor = 100000/(long)flash4.ReqFuel;
}


/* Main EGO routine */
void ego_calc(void)
{
    unsigned char uctmp;
    unsigned long looptime, lmms_ltch;
    int egotmpcor = 0;
    long ego1step, ego2step;

    ego1step = ego2step = 0;

    if (egocount < flash4.EgoCountCmp) {
        return;
    }

    DISABLE_INTERRUPTS;
    uctmp = running_seconds;
    egocount = 0;
    lmms_ltch = lmms;
    ENABLE_INTERRUPTS;

    looptime = lmms_ltch - ego_last_run; // .128 ms units
    ego_last_run = lmms_ltch;

    if (flash4.EgoOption == 0) {
        outpc.egocor1 = 1000;
        outpc.egocor2 = 1000;
        return;
    }

    if ((outpc.rpm < flash4.RPMOXLimit) ||
        (outpc.engine & (ENGINE_TPSACC | ENGINE_TPSDEC | ENGINE_MAPACC | ENGINE_MAPDEC)) ||
        (outpc.clt < flash4.EgoTemp) ||
        (outpc.tps > flash4.TPSOXLimit) ||
        (outpc.map > flash4.MAPOXLimit) ||
        (outpc.map < flash4.MAPOXMin) ||
        (uctmp < 30) ||
        ((pwcalc1 == 0) && (pwcalc2 == 0)) ||
         (flash5.fc_ego_delay && (fc_off_time < flash5.fc_ego_delay))) {
        outpc.egocor1 = 1000;
        outpc.egocor2 = 1000;
        egopstat[0] = egopstat[1] = 0; 
        return;
    }

//    ego_get_targs(); // now in main

    if (flash4.EgoAlg == 0) {
        /* Simple correction is just a simple up-and-down oscillate around
         * the target correction
         */
        ego_closed_loop_simple(&ego1step, &ego2step);

        egotmpcor = outpc.egocor1 + ego1step;

        if (ego1step < 0) {
            /* check lean limit */
            if (egotmpcor < (1000 - flash4.EgoLimit)) {
                outpc.egocor1 = 1000 - flash4.EgoLimit;
            } else {
                outpc.egocor1 = egotmpcor;
            }
        } else if (ego1step > 0) {
            if (egotmpcor > (1000 + flash4.EgoLimit)) {
                outpc.egocor1 = 1000 + flash4.EgoLimit;
            } else {
                outpc.egocor1 = egotmpcor;
            }
        }

        if (flash4.dual_tble_optn) {
            egotmpcor = outpc.egocor2 + ego2step;

            if (ego2step < 0) {
                if (egotmpcor < (1000 - flash4.EgoLimit)) {
                    outpc.egocor2 = 1000 - flash4.EgoLimit;
                } else {
                    outpc.egocor2 = egotmpcor;
                }
            } else if (ego2step > 0 ) {
                if (egotmpcor > (1000 + flash4.EgoLimit)) {
                    outpc.egocor2 = 1000 + flash4.EgoLimit;
                } else {
                    outpc.egocor2 = egotmpcor;
                }
            }
        } else {
            outpc.egocor2 = outpc.egocor1;
        }
    } else {
        long ltmp;

        ego_closed_loop_pid(&ego1step, &ego2step, looptime);

        egocor_100[0] += ego1step;
        ltmp = flash4.EgoLimit * 100;

        if (egocor_100[0] > (100000 + ltmp)) {
            egocor_100[0] = 100000 + ltmp;
        } else if (egocor_100[0] < (100000 - ltmp)) {
            egocor_100[0] = 100000 - ltmp;
        }

        outpc.egocor1 = egocor_100[0] / 100L;


        if (flash4.dual_tble_optn) {
            egocor_100[1] += ego2step;
            if (egocor_100[1] > (100000 + ltmp)) {
                egocor_100[1] = 100000 + ltmp;
            } else if (egocor_100[1] < (100000 - ltmp)) {
                egocor_100[1] = 100000 - ltmp;
            }

            outpc.egocor2 = egocor_100[1] / 100L;
        }
    }
}

/* Get AFR targets. Narrowband needs to be double-checked */
void ego_get_targs(void)
{
    if (flash4.EgoOption <= 2) {  /* narrowband */
        outpc.afrtgt1 = flash4.AFRTarget;
        outpc.afrtgt2 = flash4.AFRTarget;
    } else { /* wideband */
        outpc.afrtgt1 = gl_afrtgt1;
        outpc.afrtgt2 = gl_afrtgt2;
    }
}

void ego_get_targs_gl(void)
{
    gl_afrtgt1 = intrp_2dctable(outpc.rpm, outpc.afrload, NO_FRPMS,
            NO_FMAPS, &pg4_ptr->frpm_tablea[0][0], &pg4_ptr->fmap_tablea[0][0],
            (unsigned char *)&pg4_ptr->afr_table[0][0][0], 0);
    if (flash4.dual_tble_optn) {
        gl_afrtgt2 = intrp_2dctable(outpc.rpm, outpc.afrload, NO_FRPMS,
                NO_FMAPS, &pg4_ptr->frpm_tablea[1][0], &pg4_ptr->fmap_tablea[1][0],
                (unsigned char *)&pg4_ptr->afr_table[1][0][0], 0);
    } else {
        gl_afrtgt2 = gl_afrtgt1;
    }
}

/* Simple, oscillating EGO control */
void ego_closed_loop_simple(long *ego1step, long *ego2step)
{
    if (outpc.ego1 > outpc.afrtgt1) {
        *ego1step = ((long)flash4.EgoStep);
    } else if (outpc.ego1 < outpc.afrtgt1) {
        *ego1step = -((long)flash4.EgoStep);
    } else {
        *ego1step = 0;
    }

    if (flash4.dual_tble_optn) {
        if(outpc.ego2 > outpc.afrtgt2) {
            *ego2step = flash4.EgoStep;
        } else if (outpc.ego2 < outpc.afrtgt2) {
            *ego2step = -flash4.EgoStep;
        } else {
            *ego2step = 0;
        }
    } else {
        *ego2step = *ego1step;
    }
}

/* PID EGO. This routine calls the actual worker routine twice. Once for each
 * table (if dual table is selected)
 */
void ego_closed_loop_pid(long *ego1step, long *ego2step, unsigned long looptime)
{
    ego_closed_loop_pid_dopid(ego1step, looptime, outpc.ego1, outpc.afrtgt1, 0);

    if (flash4.dual_tble_optn) {
        ego_closed_loop_pid_dopid(ego2step, looptime, outpc.ego2, outpc.afrtgt2, 1);
    }
}

/* This is the actual PID algorithm. It incorporates looptime and scales using
 * the req_fuel based scale factor
 */
void ego_closed_loop_pid_dopid(long *egostep, unsigned long looptime,
                               unsigned int ego, unsigned int afrtarg,
                               int ego1or2)
{
    long PV, SP, egoerr, Kp, Ki, Kd, deriv = 0;
    long *PVarray;
    unsigned char uctmp;


    /* compiler didn't like when I just used
     * a pointer to do this. It would give
     * an internal compiler error. So
     * use a local temp var instead
     */
    if(!ego1or2) {
        PVarray = ego1errm1;
    } else {
        PVarray = ego2errm1;
    }

    /* calc PV, SP, and error. This is done in 
     * unitless percentages based on a range of 9.0 AFR to
     * 20.0 AFR. PV is the actual current afr, SP is the target
     */
    uctmp = (ego < 90) ? 90 : ego;
    PV = ((long)(uctmp - 90) * 10000L) / 110L;
    uctmp = (afrtarg < 90) ? 90 : afrtarg;
    SP = ((long)(uctmp - 90) * 10000L) / 110L;

    egoerr = SP - PV;

    if (egopstat[ego1or2] == 0) {
        egopstat[ego1or2] = 1;
        /* Set the whole PV array to PV to avoid large initial jumps in
         * correction that are not based on the actual target
         */
        PVarray[0] = PVarray[1] = PV;
        if (ego1or2 == 0) {
            egocor_100[ego1or2] = 100*(long)outpc.egocor1;
        } else {
            egocor_100[ego1or2] = 100*(long)outpc.egocor2;
        }
    }

    /* This math is the derivative of the ideal PID equation:
     * output = bias + ((P*error) + (I*errorsum) - (D*derivative)), but with
     * P and D only using PV and not the error (or setpoint) to help avoid 
     * overshoot once properly tuned
     */

    deriv = PV - (PVarray[0]<<1) + PVarray[1];

    Kp = ((long)(PV - PVarray[0]) * flash4.egoKP);
    Ki = ((egoerr * (long)flash4.egoKI * (long)looptime) / 7812L);
    Kd = ((deriv * (long)flash4.egoKD*781) / (long)looptime);

    PVarray[1] = PVarray[0];
    PVarray[0] = PV;

    *egostep = (long)((Kp - Ki + Kd)) / (PID_scale_factor);
}
