/* $Id: ms2_extra_ign.c,v 1.120 2011-10-28 20:40:42 racingmini Exp $ */
#include "ms2_extra.h"

unsigned char decode_errs;
unsigned long dtpred_adder;

void noisefilter_lookup(void)
{
    unsigned int utmp1;

    if (flash4.NoiseFilterOpts & 0x01) {
        unsigned int noiserpm;
        if (outpc.rpm < 10) {
            noiserpm = 32767;
        } else {
            noiserpm = outpc.rpm;
        }
        utmp1 = intrp_1ditable(noiserpm,4,(unsigned int *)pg10_ptr->NoiseFilterRpm, 0,
                (unsigned int *)pg10_ptr->NoiseFilterLen);

        DISABLE_INTERRUPTS;
        NoiseFilterMin = (unsigned long)utmp1;
        ENABLE_INTERRUPTS;
    }
}

void ign_reset(void)
{
    // enter here at init and when in stall condition
    // Disable IC, Ign,Inj OC interrupts
    //    TIE &= 0x94; // may need review
    TIE = 0; // disable all IC/OC ints. Re-enable as required in a mo
    TSCR1 = 0x80;  // always leave timer enabled
    // reinitialize

    if (resetholdoff == 0) { // not within burn timeout period
        if (!(conf_err)) {
            PORTE &= ~0x10;   // Turn off fuel Pump.
            outpc.engine = 0;
            outpc.rpm = 0;
        }
        flagbyte2 |= flagbyte2_crank_ok;
        if ((spkmode == 2) && (flash4.spk_conf2 & 1)) {
            // Set HEI bypass to 0v
            PTM |= 0x10;
        }
    }

    tooth_diff_this = 0;
    tooth_diff_last = 0;
    tooth_diff_last_1 = 0;
    tooth_diff_last_2 = 0;
    TC_ovflow = 0;
    pulse_no = 0;  // This will inhibit overflow counters
    t_enable_IC = 0xFFFFFFFF;
    t_enable_IC2 = 0xFFFFFFFF;
    igncount = 0;
    altcount = 0;
    egocount = 0;
    egopstat[0] = egopstat[1] = 0;
    tpsaclk = 0;
    asecount = 0;
    outpc.status3 &= ~status3_cut_fuel;
    knk_clk = 0;
    knk_clk_test = flash4.knk_trtd;
    knk_stat = 0;
    knk_count = 0;
    outpc.knk_rtd = 0;
    spark_events = spark_events_a;
    dwell_events = dwell_events_a;
        if ((flash8.seq_inj & 0x03) != 0) {     
                fuelcount = 0;  
                fuel1_events = fuel1_events_a;  
                fuel2_events = fuel2_events_a;  
                fuel3_events = fuel3_events_a;  
                fuel4_events = fuel4_events_a;  
        }       

    // Turn off all spark outputs right away
#ifdef MICROSQUIRT
    FIRE_ALL_US;
#else
    FIRE_ALL;
#endif

    // Turn Off injectors
        if (seq_inj_ctrl & SEQ_STD_INJ) {
            TCTL2 &= ~0x44;   // set outputs lo in OL1,3
            CFORC |= 0x0A;
                PWME &= ~0x14;    // turn off pwms
        } else {
#ifdef MICROSQUIRT
            TCTL2 &= ~0x54;   // set outputs lo in OL1,2,3
                TCTL1 &= ~0x01;   // set output lo in OL4
            CFORC |= 0x1E;
#else
            TCTL2 &= ~0x44;   // set outputs lo in OL1,3
                TCTL1 &= ~0xA0;   // set outputs lo in OL6,7
            CFORC |= 0xCA;
#endif
        }
    *pPTMpin[3] &= ~0x08;   // turn off inj led
    outpc.squirt = 0;       // injectors off
    IgnOCpinstate = SPK;
    // enable timer & IC interrupt
    synch = SYNC_FIRST;
    decode_errs = 0;
    if (outpc.status1 & status1_syncok) { // was synced
        outpc.synccnt++;
        outpc.status1 &= ~(status1_syncok | status1_synclatch);
    }
    dtpred_adder = 0;
    TFLG1 = 0xff; // clear all pending ints
    TIE |= 0x01;
    if (flagbyte5 & FLAGBYTE5_CAM) {
        TIE |= TFLG_trig2;  // enable 2nd trig ISR
        flagbyte1 &= ~flagbyte1_trig2active; // reset software flag
        flagbyte2 &= ~flagbyte2_twintrignow; // reset software flag
    }

    pulse_no = 0;
    dwl[0] = 0; // 0 means not in use, so count starts at 1
    dwl[1] = 0;
    dwl[2] = 0;
    dwl[3] = 0;
    dwl[4] = 0;
    dwl[5] = 0;
    dwl[6] = 0;
    dwl[7] = 0;
    trig2cnt = 0;
    tooth_no = 0;
    flagbyte3 &= ~flagbyte3_toothinit;
    flagbyte1 &= ~flagbyte1_trig2active; // clear 2nd trig
    tooth_counter = 0;
    tooth_counter_main = 0;
    syncerr = 0;
    flagbyte0 &= ~flagbyte0_firstrpm;
    firstsync_iter = 0;
    NoiseFilterMin = 0;
    dwell_long = 0;
    dwell_us = 0;
    dwell_us2 = 0;
    last_edge = 255;
    last_edge2 = 255;
    dwellq[0].sel = 0;
    dwellq[1].sel = 0;
    return;
}

int coil_dur_table(int delta_volt)
{
    int ix;
    long interp, interp3;
    // returns correction for coil duration vs battery voltage deviation
    //  from 12 V from table lookup in .1 ms units
    // bound input arguments
    if(delta_volt > flash4.deltV_table[NO_COILCHG_PTS-1])  {
        return((int)flash4.deltDur_table[NO_COILCHG_PTS-1]);
    }
    if(delta_volt < flash4.deltV_table[0])  {
        return((int)flash4.deltDur_table[0]);
    }
    // delta_volt in V x 10
    for(ix = NO_COILCHG_PTS - 2; ix > -1; ix--)  {
        if(delta_volt > flash4.deltV_table[ix])  {
            break;
        }
    }
    if(ix < 0)ix = 0;

    interp = flash4.deltV_table[ix + 1] - flash4.deltV_table[ix];
    if(interp != 0)  {
        interp3 = (delta_volt - flash4.deltV_table[ix]);
        interp3 = (100 * interp3);
        interp = interp3 / interp;
        if(interp < 0)interp = 0;
    }
    return((int)(flash4.deltDur_table[ix] +
                interp * (flash4.deltDur_table[ix+1] - flash4.deltDur_table[ix])/ 100));
}

void wheel_fill_event_array(ign_event *spark_events_fill, ign_event *dwell_events_fill,
                            int spk_ang, int dwl_ang, ign_time last_tooth_time,
                            unsigned int last_tooth_ang, unsigned char rotary)
{
    char start, stop, iterate, tth, wfe_err;
    int tth_ang, tmp_ang, i, j;
    ign_time spk_time, dwl_time;
    long tmptime;

    if(rotary) {
        start = 2;
        stop = 4;
    } else {
        start = 0;
        stop = no_triggers;
    }
    for (i = start; i < stop; i++) {
        if (rotary) {
            j = i - 2;
        } else {
            j = i;
        }
        wfe_err = 0;
        iterate = 0;
        tth_ang = trig_angs[j]; // trigger angle for this trigger to allow for oddfire
        tth = trigger_teeth[j];
        while (!iterate) {
            if (tth_ang > spk_ang) {  // must both be signed to get comparison to work
                // found a suitable tooth
                iterate = 1;
            } else {
                //how far do we step back in deg
                tth--;
                if (tth < 1) {
                    tth = last_tooth;
                    wfe_err++;
                    if (wfe_err > 1) {
                        iterate = 2;
                    }
                }
                tth_ang += deg_per_tooth[tth - 1]; // add on time ahead of the tooth we stepped back to
            }
        } // end while


        if (iterate == 2) {
            DISABLE_INTERRUPTS;
            asm ( "nop\n" ); // something screwed up, place for breakpoint
            ENABLE_INTERRUPTS;
            // can't continue as didn't find a valid tooth
            return;
        }

        tmp_ang = tth_ang - spk_ang; // angle after trigger tooth we found
        //convert this small angle to time
        spk_time.time_32_bits = (tmp_ang * last_tooth_time.time_32_bits) / last_tooth_ang;

        wfe_err = 0;
        while ((wfe_err < 2) && (spk_time.time_32_bits < SPK_TIME_MIN)) {
            // too soon after tooth, need to step back
            tth--;
            if (tth < 1) {
                tth = last_tooth;
                wfe_err++;
            }
            tth_ang += deg_per_tooth[tth - 1]; // add on time ahead of the tooth we stepped back to
            // recalc
            tmp_ang = tth_ang - spk_ang;
            spk_time.time_32_bits = (tmp_ang * last_tooth_time.time_32_bits) / last_tooth_ang;
        }

        if (wfe_err > 1) {
            DISABLE_INTERRUPTS;
            asm ( "nop\n" ); // something screwed up, place for breakpoint
            ENABLE_INTERRUPTS;
            // can't continue as didn't find a valid tooth
            return;
        }

        spark_events_fill[(unsigned int)i].tooth = tth;
        spark_events_fill[(unsigned int)i].time = spk_time;
        spark_events_fill[(unsigned int)i].coil = i;

        // Code limits spark advance so spark point should always be ahead of or after
        // the trigger and not crossing it.
        // During next-cyl cranking we set this flag.
        // to force a spark at trigger.
        tmptime = (spk_ang * last_tooth_time.time_32_bits) / last_tooth_ang;

        if ((flash4.dwellmode & 3) == 3) {
            //if "charge on trigger", then dwell on same tooth as scheduling spark
            //might be ok for MSD in basic dizzy mode. Might give unpredictable short pulses
            // when combined with wheel mode.
            dwell_events_fill[(unsigned int)i].tooth = spark_events_fill[(unsigned int)i].tooth;
            dwell_events_fill[(unsigned int)i].time32 = 0;
        } else {
            // do normal dwell - assume that it must always start ahead of spark
            // so start from spark tooth

            wfe_err = 0;
            iterate = 0;
            while (!iterate) {
                if (tth_ang > dwl_ang) {
                    // found a suitable tooth
                    iterate = 1;
                } else {
                    //how far do we step back in deg
                    tth--;
                    if (tth < 1) {
                        tth = last_tooth;
                        wfe_err++;
                        if (wfe_err > 1) {
                            iterate = 2;
                        }
                    }
                    tth_ang += deg_per_tooth[tth - 1]; // add on time ahead of the tooth we stepped back to
                }
            } // end while

            if (iterate == 2) {
                DISABLE_INTERRUPTS;
                asm ( "nop\n" ); // something screwed up, place for breakpoint
                ENABLE_INTERRUPTS;
                // can't continue as didn't find a valid tooth
                return;
            }

            tmp_ang = tth_ang - dwl_ang; // angle after trigger tooth we found
            //convert this small angle to time
            dwl_time.time_32_bits = (tmp_ang * last_tooth_time.time_32_bits) / last_tooth_ang;

            wfe_err = 0;
            while ((wfe_err < 2) && (dwl_time.time_32_bits < SPK_TIME_MIN)) {
                // too soon after tooth, need to step back
                tth--;
                if (tth < 1) {
                    tth = last_tooth;
                    wfe_err++;
                }
                tth_ang += deg_per_tooth[tth - 1]; // add on time ahead of the tooth we stepped back to
                // recalc
                tmp_ang = tth_ang - dwl_ang;
                dwl_time.time_32_bits = (tmp_ang * last_tooth_time.time_32_bits) / last_tooth_ang;
            }

            if (wfe_err > 1) {
                DISABLE_INTERRUPTS;
                asm ( "nop\n" ); // something screwed up, place for breakpoint
                ENABLE_INTERRUPTS;
                // can't continue as didn't find a valid tooth
                return;
            }

            dwell_events_fill[(unsigned int)i].tooth = tth;
            dwell_events_fill[(unsigned int)i].time = dwl_time;
        }
        dwell_events_fill[(unsigned int)i].coil = i;

        // if dwell has stepped back then force dwell on tooth just before spark
        // or if dwell is on same tooth but fairly short then force it
        if ((dwell_events_fill[(unsigned int)i].tooth != spark_events_fill[(unsigned int)i].tooth)
                || ( (dwell_events_fill[(unsigned int)i].tooth == spark_events_fill[(unsigned int)i].tooth)
                    && (dwell_events_fill[(unsigned int)i].time32 < 170)
                    && (dwell_events_fill[(unsigned int)i].time32 >= 0) ) ) {
            spark_events_fill[(unsigned int)i].ftooth = spark_events_fill[(unsigned int)i].tooth;
        } else {
            spark_events_fill[(unsigned int)i].ftooth = 0;
        }
    }
}

void wheel_fill_fuel_event_array(fuel_event *fuel_events_fill, int fuel_ang, ign_time last_tooth_time,
                                 unsigned int last_tooth_ang, unsigned char siamese)
{
    char start, stop, iterate, tth, wfe_err;
    int tth_ang, tmp_ang;
    unsigned int fuel_time;
    unsigned char i, j, increment, pos=0;

    if(siamese == 4) {
        // Semi-sequential siamese: trigger on cylinder 1 (and 4)
        start = 0;
        stop = no_triggers;
        increment = 2;
    } else if (siamese < 4) {
        start = siamese;
        stop = siamese + 1;
        increment = 1;
        pos = 1 - (siamese / 2);
    } else {
        start = siamese - 10;
        stop = no_triggers;
        increment = no_triggers / no_squirts;
    }
    for (i = start, j = pos; i < stop; i+=increment, j++) {
        int tmp_inj_ang;

        wfe_err = 0;
        iterate = 0;
        tth_ang = trig_angs[i]; // trigger angle for this trigger to allow for oddfire
        tth = trigger_teeth[i];
        tmp_inj_ang = fuel_ang;

        if (tth_ang > tmp_inj_ang) {
            tmp_inj_ang += cycle_deg;
        }

        while (!iterate) {
            if (tth_ang > tmp_inj_ang) {  // must both be signed to get comparison to work
                // found a suitable tooth
                iterate = 1;
            } else {
                //how far do we step back in deg
                tth--;
                if (tth < 1) {
                    tth = last_tooth;
                    wfe_err++;
                    if (wfe_err > 2) {
                        iterate = 3;
                    }
                }
                tth_ang += deg_per_tooth[tth - 1]; // add on time ahead of the tooth we stepped back to
            }
        } // end while


        if (iterate == 3) {
            DISABLE_INTERRUPTS;
            asm ( "nop\n" ); // something screwed up, place for breakpoint
            ENABLE_INTERRUPTS;
            // can't continue as didn't find a valid tooth
            return;
        }

        tmp_ang = tth_ang - tmp_inj_ang; // angle after trigger tooth we found
        //convert this small angle to software timer count
        fuel_time = (unsigned int)(((tmp_ang * last_tooth_time.time_32_bits) / last_tooth_ang) / 192L);

        if (fuel_time < 1) {
            fuel_time = 1;
        }
        fuel_events_fill[j].tooth = tth;
        fuel_events_fill[j].time = fuel_time;
        fuel_events_fill[j].inj = j;
    }
}

void syncfirst(void)
{
    signed int tmp_tooth;
    unsigned char i, start_val;

/* check if we are somehow already at high rpms
   in that case skip these checks as not enough CPU time
    was previously preventing re-sync at higher rpms */
    if ((tooth_diff_this && (tooth_diff_this < 750)) || (no_triggers == 1)) {
        start_val = 255;
    } else {
        start_val = 0;
    }


/* find next dwell event so we spark ASAP */
    fuel_cntr = start_val;
    tmp_tooth = tooth_no;
    while (!fuel_cntr) {
        tmp_tooth++;
        if (tmp_tooth > last_tooth) {
            tmp_tooth = 0;
        }
        if (tmp_tooth == tooth_no) {
            // been all the way around without finding anything - oops!
            fuel_cntr = 255;
        }
        for (i = 0; i < no_triggers; i++) {
            if (dwell_events[i].tooth == tmp_tooth) {
                fuel_cntr = i;
            } 
        }
    }
    if (fuel_cntr == 255) {
        fuel_cntr = 0;
    }

    next_spark.time = spark_events[fuel_cntr].time;
    next_spark.tooth = spark_events[fuel_cntr].tooth;
    next_spark.coil = spark_events[fuel_cntr].coil;
    next_spark.ftooth = spark_events[fuel_cntr].ftooth;
    next_spark.fs = spark_events[fuel_cntr].fs;
    next_dwell.time = dwell_events[fuel_cntr].time;
    next_dwell.tooth = dwell_events[fuel_cntr].tooth;
    next_dwell.coil = dwell_events[fuel_cntr].coil;

/* find next map event so we capture map ASAP */
    fuel_cntr = start_val;
    tmp_tooth = tooth_no;
    while (!fuel_cntr) {
        tmp_tooth++;
        if (tmp_tooth > last_tooth) {
            tmp_tooth = 0;
        }
        if (tmp_tooth == tooth_no) {
            // been all the way around without finding anything - oops!
            fuel_cntr = 255;
        }
        for (i = 0; i < no_triggers; i++) {
            if (map_start_event[i].tooth == tmp_tooth) {
                fuel_cntr = i;
            } 
        }
    }
    if (fuel_cntr == 255) {
        fuel_cntr = 0;
    }

    next_map_start_event.time = map_start_event[fuel_cntr].time;
    next_map_start_event.tooth = map_start_event[fuel_cntr].tooth;
    next_map_start_event.evnum = map_start_event[fuel_cntr].evnum;
    // don't use ftooth or fs in dwell array
        if ((flash8.seq_inj & 0x03) != 0) {     
                unsigned char inj_event;
                if ((flash8.seq_inj & 0x03) > 1) {      
                        inj_event = fuel_cntr>>1;
                } else {
                        inj_event = fuel_cntr / no_inj;
                }
            next_fuel1_event.time = fuel1_events[inj_event].time;
            next_fuel1_event.tooth = fuel1_events[inj_event].tooth;
            next_fuel1_event.inj = fuel1_events[inj_event].inj;
            next_fuel2_event.time = fuel2_events[inj_event].time;
            next_fuel2_event.tooth = fuel2_events[inj_event].tooth;
            next_fuel2_event.inj = fuel2_events[inj_event].inj;
                if (!(seq_inj_ctrl & SEQ_STD_INJ)) {
                    next_fuel3_event.time = fuel3_events[inj_event].time;
                    next_fuel3_event.tooth = fuel3_events[inj_event].tooth;
                    next_fuel3_event.inj = fuel3_events[inj_event].inj;
                    next_fuel4_event.time = fuel4_events[inj_event].time;
                    next_fuel4_event.tooth = fuel4_events[inj_event].tooth;
                    next_fuel4_event.inj = fuel4_events[inj_event].inj;
                }
        }

/* find next fuel event */
    fuel_cntr = start_val;
    tmp_tooth = tooth_no;
    while (!fuel_cntr) {
        tmp_tooth++;
        if (tmp_tooth > last_tooth) {
            tmp_tooth = 0;
        }
        if (tmp_tooth == tooth_no) {
            // been all the way around without finding anything - oops!
            fuel_cntr = 255;
        }
        for (i = 0; i < no_triggers; i++) {
            if (trigger_teeth[i] == tmp_tooth) {
                fuel_cntr = i;
            } 
        }
    }
    if (fuel_cntr == 255) {
        fuel_cntr = 0;
    }
    next_fuel = trigger_teeth[fuel_cntr];
    if ((next_spark.tooth != 0) &&
            (next_dwell.tooth != 0)) {
        synch &= ~SYNC_FIRST;  // must have non zero values before declaring sync not first
    }

    if ((spkmode == 4) && (flash10.RotarySplitMode & 0x20)) {
        next_spk_trl.time = spark_events[2].time;
        next_spk_trl.tooth = spark_events[2].tooth;
        next_spk_trl.coil = spark_events[2].coil;
        next_dwl_trl.time = dwell_events[2].time;
        next_dwl_trl.tooth = dwell_events[2].tooth;
        next_dwl_trl.coil = dwell_events[2].coil;   
        if ((next_spk_trl.tooth != 0) && (next_dwl_trl.tooth != 0)) {
            synch &= ~SYNC_FIRST;  // must have non zero values before declaring sync not first
        }
    }

}

void SET_COIL(unsigned char *coil, unsigned char *bits) {
    if (flash10.RotarySplitMode & 0x20) {
        if (*coil == TRIGA) {
            *bits |= COILABIT;
        } else if (*coil == TRIGB) {
            *bits |= COILBBIT;
        } else if (*coil == TRIGC) {
            *bits |= COILCBIT;
        } else if (*coil == TRIGD) {
            *bits |= COILDBIT;
        }
    } else {
        if (*coil == TRIGA) {
            *bits |= COILABIT;
        } else if (*coil == TRIGB) {
            if (num_spk == 1) {
                *bits |= COILABIT;
            } else {
                *bits |= COILBBIT;
            }
        } else if (*coil == TRIGC) {
            if (num_spk == 1) {
                *bits |= COILABIT;
            } else if (num_spk == 2) {
                *bits |= COILABIT;
            } else {
                *bits |= COILCBIT;
            }
        } else if (*coil == TRIGD) {
            if (num_spk == 1) {
                *bits |= COILABIT;
            } else if (num_spk == 2) {
                *bits |= COILBBIT;
            } else if (num_spk == 3) {
                *bits |= COILABIT;
            } else {
                *bits |= COILDBIT;
            }
        } else if (*coil == TRIGE) {
            if (num_spk == 1) {
                *bits |= COILABIT;
            } else if (num_spk == 2) {
                *bits |= COILABIT;
            } else if (num_spk == 3) {
                *bits |= COILBBIT;
            } else if (num_spk == 4) {
                *bits |= COILABIT;
            } else {
                *bits |= COILEBIT;
            }
        } else if (*coil == TRIGF) {
            if (num_spk == 1) {
                *bits |= COILABIT;
            } else if (num_spk == 2) {
                *bits |= COILBBIT;
            } else if (num_spk == 3) {
                *bits |= COILCBIT;
            } else if (num_spk == 4) {
                *bits |= COILBBIT;
            } else {
                *bits |= COILFBIT;
            }
        } else if (*coil == TRIGG) {
            if (num_spk == 1) {
                *bits |= COILABIT;
            } else if (num_spk == 2) {
                *bits |= COILABIT;
            } else if (num_spk == 4) {
                *bits |= COILCBIT;
            } else {
                *bits |= COILGBIT;
            }
        } else if (*coil == TRIGH) {
            if (num_spk == 1) {
                *bits |= COILABIT;
            } else if (num_spk == 2) {
                *bits |= COILBBIT;
            } else if (num_spk == 4) {
                *bits |= COILDBIT;
            } else {
                *bits |= COILHBIT;
            }
        }
    }
}
