/* $Id: ms2_extra_ign_in.c,v 1.146 2011-12-08 15:04:05 jsmcortina Exp $ */
#include "ms2_extra.h"

void ISR_Ign_TimerIn(void)
{
    ISR_Ign_TimerIn_paged();    // call the paged function
}


// fire/dwell coils and syncfirst now in ign.c and section text

INTERRUPT void ISR_Ign_TimerIn_paged(void)
{
    static unsigned long dt2,dt3;
    static unsigned long tooth_time1, tooth_time2;
    long ddt2,ddt3;
    static unsigned long dtpred_old;
    static char missed_pulse;
    unsigned int sched_both, TC0this;
    unsigned long ltmp1;
    long coil_dur_calc = 0;
    unsigned char thistoothevents = 0, next, edge, edge2, portt_save;
    unsigned long temp1, TC0_32bits;
    static unsigned int swtimer_last;
    static unsigned long NoiseFilter1;
    static const void * const jumptab[40] = {
		&&SPKMODE2, &&SPKMODE3,
		&&SPKMODE4, &&SPKMODE5,
		&&SPKMODE6, &&SPKMODE7,
		&&SPKMODE8, &&SPKMODE9,
		&&SPKMODE10, &&SPKMODE11,
		&&SPKMODE12, &&SPKMODE13,
		&&SPKMODE14, &&SPKMODE15,
		&&SPKMODE16, &&SPKMODE17,
		&&SPKMODE18, &&SPKMODE19,
		&&SPKMODE20, &&SPKMODE21,
		&&SPKMODE22, &&SPKMODE23,
		&&SPKMODE24, &&SPKMODE25,
		&&EXIT, &&EXIT,
		&&SPKMODE28, &&SPKMODE29,
		&&SPKMODEFUEL, &&SPKMODEFUEL,
		&&SPKMODE_CAS360, &&SPKMODE_CAS360,
		&&SPKMODE_CAS360, &&SPKMODE_CAS360,
		&&SPKMODE_CAS360, &&SPKMODE_CAS360,
		&&SPKMODE_CAS360, &&SPKMODE_CAS360,
		&&SPKMODE40, &&SPKMODE41
    };
    const void *jumpto;

#define SPARK 0x1
#define DWELL 0x2
#define FUEL 0x4
#define ROTARY_SPK 0x8
#define ROTARY_DWL 0x10
#define MAPSTART 0x20
    if (flagbyte2 & flagbyte2_twintrignow) {  // use TC5/2 data for 2nd trig
        TC0this = TC_trig2;
        flagbyte4 |= flagbyte4_tach2;
    } else { // normal use this IC timer
        TFLG1 = 0x01;	             // clear IC interrupt flag
        TIE |= 0x01;		     // re-enable IC interrupt
        TC0this = TC0;
        flagbyte4 &= ~flagbyte4_tach2;
    }

    portt_save = PORTT;   // grab it asap to ensure it doesn't change

    // if we triggered a config error then stop! No running, report false data
    // in test mode we ignore IC ISR as well
    if ((outpc.status1 & status1_conferr) || (flagbyte1 & flagbyte1_tstmode)) {
        TFLG1 = 0x01; // clear IC interrupt flag
        TIE &= ~0x01; // disable main tach
        if (flagbyte2 & flagbyte2_twintrignow) {
            TFLG1 = TFLG_trig2;
            TIE &= ~TFLG_trig2; // disable secondary tach
        }
        return;
    }

    TC0_32bits = ((unsigned long)swtimer<<16) | TC0this;
    if ((flagbyte1 & flagbyte1_ovfclose) && ((TC0this < 0x1000) ||
                ((TC0this < TC0_last) && (swtimer == swtimer_last)))) {
        TC0_32bits += 0x10000;
    }

    TC0_last = TC0this;
    swtimer_last = swtimer;

    //Figure out which edge of input signal we are on if rising and falling enabled
    edge = 1;
    edge2 = 1; // doesn't get reset if single edge trigger on primary
    /* first figure out which edge we care about right now */
    // used by noise filter, dizzy with trigret and some spark modes
    if (flagbyte5 & FLAGBYTE5_CRK_BOTH) {
        if (flash4.ICIgnOption & 0x01) {
            if (!(portt_save & 0x01)) {
                /* this wasn't rise, don't store current timecounter value */
                edge = 0;
            }
            if (!(portt_save & TFLG_trig2)) {
                edge2 = 0;
            }
        } else {
            if (portt_save & 0x01) {
                /* This wasn't the falling edge, don't store timecounter value */
                edge = 0;
            }
            if (portt_save & TFLG_trig2) {
                edge2 = 0;
            }
        }
        // Ignition trigger LED, only works at present if using both edges
        if (flagbyte1 & flagbyte1_igntrig) {
            if (edge) {
                PTM |= 0x20; // D15
            } else {
                PTM &= ~0x20;
            }
        }
    }

// composite tooth logger - captures everything including noise
// logs are in comms page 0xf2, data actually stored in ram_data
// consists of 341 * 3 byte packets in the 1024 byte space
// 1024th byte (ramdata+0x3ff) now stores the logger format version.
// Hardcoded here AND in the isr_ign version of this code!


    if (flagbyte0 & flagbyte0_complog) {
        do_complog_pri(TC0_32bits); // re-written in assembler because gcc makes SUCH A MESS of it
        IC_last = TC0_32bits;
    }


    if (pulse_no == 0) {  // 1st input pulse
        pulse_no++;
        if (flash4.no_skip_pulses > 0) {
            tooth_no = flash4.no_skip_pulses - 1; // start down count of skip pulses
        } else {
            tooth_no = 0;
        }
        dt2 = 0;
        dt3 = 0;       // time difference between pulses, us
        outpc.dt3 = (int)dt3;				// for HP calculations
        ddt2 = 0;      // derivative of time difference
        ddt3 = 0;      // derivative of time difference
        dtpred = dt3;  // predicted time difference for next pulse
        missed_pulse = 0;
        tooth_time1 = TC0_32bits;
        tooth_time2 = 0;
        tooth_diff_this = 0;
        tooth_diff_last = 0;
        tooth_diff_last_1 = 0;
        tooth_diff_last_2 = 0;
        fuel_cntr = 0;
        firstsync_iter = 0;
        flagbyte4 &= ~flagbyte4_found_miss;
        flagbyte0 &= ~flagbyte0_foundfirst;
        NoiseFilter1 = 0;
        t_enable_IC = 0xFFFFFFFF;
        EAElagcomp_squirts = 0;
        EAElag_squirting = 0;
        trig2cnt = 0;
        flagbyte1 &= ~flagbyte1_trig2active;
        dwellq[0].sel = 0;
        dwellq[1].sel = 0;
        return;
    }

    /* The sequence for noise filtering is as follows (all can be enabled/disabled)
     * 1. if crank tach masking is enabled, we might not even have reached this ISR
     * (composite tooth logger happens here)
     * 2. noise filter
     * 3. if noise filter off, polarity check
     * 4. crank period filtering
     * (basic tooth logger happens here)
     */

    /* automatic polarity noise filter */
    if (flagbyte5 & FLAGBYTE5_CRK_BOTH) {
        if (last_edge < 2) {
            if (last_edge == edge) {
                //impossible!
                return;
            }
        }
        last_edge = edge;
    }

    /* Noise filter */
    if (flagbyte1 & flagbyte1_noisefilter) {
        if (!(flagbyte0 & flagbyte0_foundfirst)) {
            if (edge == 0) { /* We want to store the edge on the opposite one from the trigger */
                NoiseFilter1 = TC0_32bits;
            } else {
                return;
            }

            flagbyte0 |= flagbyte0_foundfirst;
            return;
        } else {
            /* This edge should be the opposite edge that we saw previously...
             * DON'T just use it! Check the polarity
             */
            if (edge == 0) {
                return; // must be noise - same edge as last time
            }

            flagbyte0 &= ~flagbyte0_foundfirst;

            if (outpc.rpm > 10) {
                if ((TC0_32bits - NoiseFilter1) < NoiseFilterMin) {
                    return;
                }
            }
        }
    /* or Polarity check (can't presently have both) */
    /* intentionally read from PORTT instead of portt_save, to allow a slight delay */
    } else if (flagbyte1 & flagbyte1_polarity) {
        if (flagbyte2 & flagbyte2_twintrignow) { // actually came from second trig
            if (flash4.ICIgnOption & 0x01) { // rising IC
                if ((PORTT & TFLG_trig2) == 0) { // but is actually low!
                    return; // bail out
                }
            } else { // falling edge
                if (PORTT & TFLG_trig2) { // but is actually high!
                    return; // bail out
                }
            }   
        } else { // normal
            if (flash4.ICIgnOption & 0x01) { // rising IC
                if ((PORTT & 0x01) == 0) { // but is actually low!
                    return; // bail out
                }
            } else { // falling edge
                if (PORTT & 0x01) { // but is actually high!
                    return; // bail out
                }
            }
        }   
    }

    flagbyte2 &= ~flagbyte2_twintrignow; // clear this

    /* Putting this here will cause code to think there's a stall if there are
     * a LOT of short pulses in a row, resetting ignition.
     */
    ltch_lmms = lmms;     // latch RTI .128 ms clk

    //*******************************************************************************

    if (spkmode < 2) {
        goto DO_EDIS;
    }
    //*******************************************************************************

    temp1 = TC0_32bits - tooth_time1; // tooth gap that just happened

    // False trigger period rejection
    if (false_period_crk_tix) {
        if ((unsigned int)temp1 < false_period_crk_tix) {
            // assume this is a false trigger
            return;
        }
    }

    //Trigger return handling
    if ((spkmode == 3) && (!edge)) {
        if ((synch & SYNC_SYNCED) && (outpc.engine & ENGINE_CRANK) ) {
            // trigger return, cranking, return edge
            TIE &= ~0x04;
            TFLG1 = 0x04;
            coilsel = 1;
            fire_coil();
        }
        // always bail on the return pulse anyway. Not used for timing (anymore)
        return;
    }

    tooth_time2 = tooth_time1; // Do this _after_ the rejection code
    tooth_time1 = TC0_32bits;  // so it only runs for real teeth

    tooth_diff_last_2 = tooth_diff_last_1; // the one before that
    tooth_diff_last_1 = tooth_diff_last; // the one before
    tooth_diff_last = tooth_diff_this;  // previous gap

    tooth_diff_this = temp1; // tooth gap that just happened

    //2nd trig polling removed as now input capture

    //tooth logger
    if ((flagbyte0 & flagbyte0_tthlog) && edge) {
        unsigned long log_tooth;
        if (flagbyte5 & FLAGBYTE5_CRK_DOUBLE) {
            log_tooth = tooth_diff_this + tooth_diff_last;
        } else {
            log_tooth = tooth_diff_this;
        }

        __asm__ __volatile__ (
                "ldab  %1\n"
                "andb  #0xf\n"
                "brclr %3, #1, tlnot_sync\n" // #0x01 is SYNC_SYNCED -> 0x10 in log top byte
                "orab  #0x10\n"
                "tlnot_sync:\n"
                "brclr %3, #8, tlnot_semi\n" // #0x08 is SYNC_SEMI -> 0x40 in log top byte
                "orab  #0x40\n"
                "tlnot_semi:\n"
                "brclr %3, #0x10, tlnot_semi2\n" // #0x10 is SYNC_SEMI2 -> 0x80 in log top byte
                "orab  #0x80\n"
                "tlnot_semi2:\n"
                "brclr %4,#1,tlnot_trg2\n" // #0x01 is flagbyte1_trig2active -> 0x20 in log top byte
                "orab  #0x20\n"
                "tlnot_trg2:\n"
                "stab  0,Y\n"

                "ldd  %2\n"
                "std  1,Y\n"
                :
                : "y" (log_offset+ram_data),
            "m" (*((unsigned char *)&log_tooth+1)), // byte 3:**2**:1:0
            "m" (*((unsigned int *)&log_tooth+1)),  // bytes 3:2:**1**:**0**
            "m" (synch),
            "m" (flagbyte1)
                );
        log_offset+=3;


        if (log_offset > 1023) {
            flagbyte0 &= ~flagbyte0_tthlog; // turn off logger
            outpc.status3 |= status3_donelog;
        }
    }

    if (spkmode == 31) {  // go for it right away - no need to sync
        goto SPKMODEFUEL;
    }

    // start with sync off, and wait a few pulses before trying to sync
    if ( (!(synch & SYNC_SYNCED)) && (!(synch & SYNC_SEMI)) && (!(synch & SYNC_SEMI2)))  {
        // not synced yet, count down to 0 on tooth_no.
        if (tooth_no > 0) {
            tooth_no--;
            trig2cnt = 0;
            flagbyte1 &= ~flagbyte1_trig2active; // ensure we see 2nd trigger at right time
            return;
        }
    }

    /*
     * Jump to code by spark mode -- default to fuel only mode.
     */
    jumpto = &&SPKMODEFUEL;
    if (spkmode >= 2 && spkmode <= 41) {
	    jumpto = jumptab[spkmode - 2];
    }
    goto *jumpto;

    /************ missing tooth wheel & missing and 2nd trigger wheel mode *************/
SPKMODE4:
    if ((flash4.spk_config & 0xc) == 0x8) {
        goto SPKMODE4B;
    }
    /* this is the "find missing" step */
    // look for missing tooth (subtract last tooth time from this tooth
    // count taking overflow into account, and then multiply previous
    // tooth time by 1.5 and see

    if (firstsync_iter == 0) {
        /* Here we will look for missing */

        temp1 = tooth_diff_last + (tooth_diff_last >> 1);

        if (tooth_diff_this > temp1) {
            firstsync_iter = 1;
        }
        return;
    } else if (firstsync_iter == 1) {
        /* tooth after what we thought was missing, lets make sure this one is short
         * on the first sync, we miss tooth #1, but that's ok as long as we catch it next time
         * split this into 2 operations so compiler doesn't call subroutine
         */
        temp1 = (tooth_diff_last >> 1); /* 1/2 of last value */
        temp1 = temp1 >> 1; /* 1/4th of last value */

        temp1 = tooth_diff_last - temp1; /* 3/4ths of last value */

        if (tooth_diff_this >= temp1) {
            /* this wasn't really the missing tooth... */
            firstsync_iter = 0;
            return;
        }

        firstsync_iter = 2;
        flagbyte4 |= flagbyte4_found_miss;
        set_count = 1;
    } else if (firstsync_iter == 2) {
        if (tooth_no == 0) { // this should not happen, so reset
            outpc.syncreason = 1;
            ign_reset();  // note that this sequence of setting reason, resetting ign and incrementing counter is
            return;
        }


            if ((tooth_no == last_tooth) ||
                (((flash4.spk_config & 0xc) == 0xc) && (tooth_no == mid_last_tooth))) {
                /* this means we should have the last tooth here, so check for missing */
                temp1 = tooth_diff_last + (tooth_diff_last >> 1); /* 1.5 * last tooth */

                if (tooth_diff_this <= temp1) {
// WANT TO MODIFY THIS
	                firstsync_iter = 0;
                    flagbyte4 &= ~flagbyte4_found_miss;
                    outpc.syncreason = 2;
                    ign_reset();
                    return; 
                }

                flagbyte4 |= flagbyte4_found_miss;
                set_count = 0;
            }
        }

        if (tooth_no == 1) {
            /* check to make sure this tooth is < 3/4th's of last tooth
             * If it's not, we lost sync...
             */

            temp1 = (tooth_diff_last >> 1);
            temp1 = temp1 >> 1;

            temp1 = tooth_diff_last - temp1;

            if (tooth_diff_this >= temp1) {
                /* lost sync */
                firstsync_iter = 0;
                outpc.syncreason = 5;
                ign_reset();
                return;
            }
        }

    if (flagbyte4 & flagbyte4_found_miss) {

        flagbyte4 &= ~flagbyte4_found_miss;

		// found the missing tooth
		if ((flash4.spk_config & 0xc) == 0xc) {
		    if (!(flagbyte1 & flagbyte1_trig2active) && !(synch & SYNC_SYNCED)) {
			goto common_wheel;
		    }
		}

        synch |= SYNC_SYNCED;

        if (synch & SYNC_FIRST) {
            syncfirst();
        }

        outpc.status1 |= status1_syncok; /* have sync */

		if ((flash4.spk_config & 0xc) != 0xc) {
		    tooth_no = set_count;
		} else {
		    if (flagbyte1 & flagbyte1_trig2active) {
			tooth_no = set_count;
			flagbyte1 &= ~flagbyte1_trig2active;
		    } else {
			tooth_no += flash4.No_Miss_Teeth;
		    }
		}
    }
    goto common_wheel;

    /************ 2nd trigger non-missing mode *************/
SPKMODE4B:
/* new method - like used on missing tooth wheel - only check for cam trigger when we are expecting it
   Will also need some method of ensuring that masking/period rejection isn't trigger by incorrect
   noise pulse
*/
        if (!(synch & SYNC_SYNCED)) {
            if (!(flagbyte1 & flagbyte1_trig2active)) {
                return;                 // wait until we get a second trigger
            }
            /* can only get here if we have received a 2nd trigger */
            synch |= SYNC_SYNCED;
            outpc.status1 |= status1_syncok;
            tooth_no = 0;
        } else {
            if (tooth_no == no_teeth) {           
                /* recheck sync */
                if (flagbyte1 & flagbyte1_trig2active) {
                    /* all is well, got the second trigger when expected */
                    tooth_no = 0;
                } else {
                    /* didn't received the second trigger when expected - sync error */
                    outpc.syncreason = 17;
                    ign_reset();
                }
            } else {
                /* not time to check sync */
                if (flagbyte1 & flagbyte1_trig2active) { // had a trigger on cam we shouldn't have done
                    ltch_lmms2 = 0xffffffff; // reset this data
                    TIE |= TFLG_trig2; // ensure 2nd trig ISR is on
                    TC_trig2_last = TC_trig2_last2; // restore previous tooth time to ignore false pulse
                    outpc.syncreason = 11; // let the user know there is a potential problem without losing sync
                }
                /* do nothing else, just count the teeth in this mode */
            }
        }
    flagbyte1 &= ~flagbyte1_trig2active; // clear flag
    goto common_wheel;

    /************ dizzy mode *************/
SPKMODE2:
SPKMODE3:
    if ((!(synch & SYNC_SYNCED)) && (!edge) ) {
        return; // only sync on correct edge
    }
    //check we are still synced up
    if ((!edge) && (!(tooth_no & 1))) { // out of sync
        outpc.syncreason = 13;
        ign_reset(); // kill the lot
        return;
    }

    //oddfire sync
    // concern that heavy accel/decel on slightly odd engines might lose sync
    // sync if  this < last  and  last > last_1  i.e. period coming up is long

    if (flash4.ICIgnOption & 0x8) {
        if (!(synch & SYNC_SYNCED)) {
            if ((!tooth_diff_this) || (!tooth_diff_last) || (!tooth_diff_last_1)) {
                return; // not enough data yet
            }
            if (!((tooth_diff_this > tooth_diff_last) && (tooth_diff_last < tooth_diff_last_1))) {
                return;             // not found right pattern yet
            }
        } else {
            // re-check for sync, tooth_no here is 1 less than normal as ++ below
            if  ((tooth_no & 1) == 0) {
                if ((tooth_diff_this < tooth_diff_last) && (tooth_diff_last > tooth_diff_last_1)) {
                    outpc.syncreason = 14;
                    ign_reset();        // out of sync
                    return;
                }
            }
        }
    }

    synch |= SYNC_SYNCED; // always synced in dizzy mode
    outpc.status1 |= status1_syncok;
    if (synch & SYNC_FIRST) {
        tooth_no = 0; // syncfirst now follows common_wheel
    }
    goto common_wheel;

    /************ 420A/Neon mode *************/
SPKMODE5:
    //initial sync

    if (!edge) {  // only sync or do spark on falling edge
        flagbyte1 &= ~flagbyte1_trig2active; // clear 2nd trig
        return;
    }

    if (!(synch & SYNC_SYNCED)) {
        if ((!tooth_diff_last) || (!tooth_diff_last) || (!tooth_diff_last_1) || (!tooth_diff_last_2)){
            return; // only sync on falling edge
        }
        // see if we've got sync. Look for a tooth that is a lot longer than previous teeth
        if (tooth_diff_last > (tooth_diff_last_1 <<1)) {
            if (tooth_diff_this > (tooth_diff_last_1 <<1)) {
                tooth_no = 0; // this tooth is 1
                synch |= SYNC_SYNCED;
                outpc.status1 |= status1_syncok;
            } else if ((tooth_diff_last > (tooth_diff_this <<1)) && (tooth_diff_last > ((tooth_diff_last_1 + tooth_diff_last_2)<<1))) {
                tooth_no = 4; // this tooth is 5
                synch |= SYNC_SYNCED;
                outpc.status1 |= status1_syncok;
    	    } else {
                flagbyte1 &= ~flagbyte1_trig2active; // clear 2nd trig, in phase when it should be low
                return;
            }
        }

        // if COP or allow-CAM, check cam phase
        if ( (((flash4.spk_mode & 0xc0) == 0x80) || (flash4.spk_conf2 & 0x08)) && (flagbyte1 & flagbyte1_trig2active)) {
            tooth_no = tooth_no + 8;
        }
    } else {
        // recheck for sync
        if ((tooth_no == 16) || (tooth_no == 12) || (tooth_no == 8) || (tooth_no == 4)) {
            // see if we've got sync. Look for the pre 69deg tooth

            if (tooth_diff_last > (tooth_diff_last_1 <<1)) {
                if (tooth_diff_this > (tooth_diff_last_1 <<1)) {
                    if ((tooth_no != 8) && (tooth_no != 16)) {
                        outpc.syncreason = 23;
                        ign_reset();
                        return;
                    }
                    // if COP or allow-CAM, check cam phase
                    if (((flash4.spk_mode & 0xc0) == 0x80) || (flash4.spk_conf2 & 0x08)) {
                        if ((tooth_no == 8) && (flagbyte1 & flagbyte1_trig2active)) {
                            tooth_no = 8; // only halfway through cycle
                        } else if ((tooth_no == 16) && ((flagbyte1 & flagbyte1_trig2active) == 0)) {
                            tooth_no = 0; // start of cycle
                        } else {
                            outpc.syncreason = 24;
                            ign_reset(); // cam phase wrong
                        }
                    } else {
                        tooth_no = 0; // this tooth is 1
                    }
                } else if ((tooth_diff_last > (tooth_diff_this <<1)) && (tooth_diff_last > ((tooth_diff_last_1 + tooth_diff_last_2)<<1))) {
                    if ((tooth_no != 4) && (tooth_no != 12)) {
                        outpc.syncreason = 25;
                        ign_reset();
                        return;
                    }
                    // tooth no. ok
                } else {
                    outpc.syncreason = 26;
                    ign_reset();
                    return;
                }
            } else {
                // got out of sync
                outpc.syncreason = 27;
                ign_reset();
                return;
            }
        }
    }

    flagbyte1 &= ~flagbyte1_trig2active; // clear 2nd trig

    goto common_wheel;

    /************ 36-1+1 36-2+2 NGC mode *************/
  SPKMODE6:
    /* The designers here use a common crank pattern across a number   *
     * of models, but 4,6,8 use a different cam pattern.               *
     * That cam pattern could be used as a fallback and run the engine *
     * if the crank sensor fails, but it makes it a pain to decode.    *
     * Only 4cyl cam pattern supported at this time                    *
     */
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
        if ((!edge) || (!tooth_diff_this) || (!tooth_diff_last)
            || (!tooth_diff_last_1) || (!tooth_diff_last_2)) {
            return;             // only sync on falling edge
        }
        // see if we've got sync. Look for the +1/-1 tooth
        if ((tooth_diff_this + tooth_diff_last) > ((tooth_diff_last_1 + tooth_diff_last_2) << 1)) {
            synch |= SYNC_SYNCED;
            outpc.status1 |= status1_syncok;

            if (tooth_diff_last > (tooth_diff_this << 1)) {
                if ((!edge2) && (flagbyte5 & FLAGBYTE5_CAM)) {  // simple cam sync for 4cyl only
                    tooth_no = 32;      // this tooth is 1
                } else {
                    tooth_no = 0;       // without cam or cam high
                }
            } else {
                if ((edge2) && (flagbyte5 & FLAGBYTE5_CAM)) {
                    if (flash4.spk_conf2 & 0x40) {
                        tooth_no = 16;      // alternate cam
                    } else {
                        tooth_no = 48;      // standard cam
                    }
                } else {
                    if ((flash4.spk_conf2 & 0x40) && (flagbyte5 & FLAGBYTE5_CAM))  {
                        tooth_no = 48;      // alternate cam
                    } else {
                        tooth_no = 16;      // standard cam
                    }
                }
            }
        } else {
            return;             // not found right sequence yet
        }
    } else {
        //while synced only use falling edge for further calcs
        if (!edge) {
            return;
            //ignore the rising edge for timing purposes, only count falling edge as a tooth
        }
        // recheck for sync
        if ((tooth_no == 32) || (tooth_no == 16) || (tooth_no == 64) || (tooth_no == 48)) {     // remove leading 1
            // see if we've got sync. Look for the +1/-1 tooth
            if ((tooth_diff_this + tooth_diff_last) > ((tooth_diff_last_1 + tooth_diff_last_2) << 1)) {
                // only check crank
        		if (tooth_diff_last > (tooth_diff_this <<1)) {
                    if (tooth_no & 0x1f) { // not 0x20 or 0x00
                        outpc.syncreason = 61;
                        goto spkmode6_loss;
                    } else if ((tooth_no == 64) || ((tooth_no == 32) && ((flagbyte5 & FLAGBYTE5_CAM) == 0)))  {
                        tooth_no = 0;
                    }
                    if (flagbyte5 & FLAGBYTE5_CAM) {
                        if (!trig2cnt) { // no cam transitions since last +1/-1
                            outpc.syncreason = 70;
                            goto spkmode6_loss;
                        } else {
                            trig2cnt = 0;
                        }
                    } 
                } else {
                    if ((tooth_no & 0xdf) != 0x10) { // not 0x30 or 0x10
                        outpc.syncreason = 62;
                        goto spkmode6_loss;
                    }
                }
    	    } else {
                outpc.syncreason = 28;
spkmode6_loss:;
                ign_reset();    // got out of sync
                return;
            }
        }
    }

    // be certain we stop here unless correct edge
    if (!edge) {
        return;
        //ignore the rising edge for timing purposes, only count falling edge as a tooth
    }
    //only do this on active edges
    goto common_wheel;

    /************ 36-2-2-2 mode *************/
SPKMODE7:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
        if  ((!tooth_diff_this) || (!tooth_diff_last) || (!tooth_diff_last_1)) {
            return; // only sync when there's enough data
        }

        // when unsynced we wait until we see a missing double tooth after a couple
        // of shorter ones

        if (!(synch & SYNC_SEMI)) { // just starting
            if ( (tooth_diff_this > (tooth_diff_last<<1))
                    && (tooth_diff_this < (tooth_diff_last<<2))
                    && (tooth_diff_this > (tooth_diff_last_1<<1))
                    && (tooth_diff_this < (tooth_diff_last_1<<2)) ) {
                synch |= SYNC_SEMI; // started sync sequence
                tooth_no = 0;
            }
            return;
        } else { // started sequence, check possible sync points
            tooth_no++;
            if (tooth_no == 1) {
                if ( (tooth_diff_this > (tooth_diff_last_1<<1))
                        && (tooth_diff_this < (tooth_diff_last_1<<2)) ){
                    // compare against tooth before double missing
                    // found double tooth sequence, set tooth and go
                    tooth_no = 17;
                    goto WHL36_2_2_2_OK;
                }
            } else if ( (tooth_diff_this > (tooth_diff_last<<1))
                    && (tooth_diff_this < (tooth_diff_last<<2)) ) {
                if (tooth_no == 13) {
                    tooth_no = 0;
                    goto WHL36_2_2_2_OK;
                } else if (tooth_no == 16) {
                    tooth_no = 16;
                    goto WHL36_2_2_2_OK;
                }
            } else if (tooth_no > 30) {
                // PS Deviant track 9
                outpc.syncreason = 29;
                ign_reset();
            }
            return;
        }
WHL36_2_2_2_OK:

	synch &= ~SYNC_SEMI;
	synch |= SYNC_SYNCED;
	outpc.status1 |= status1_syncok;

    } else {
        // recheck for sync
        if ((tooth_no == 16) || (tooth_no == 30)) {  // (one less)
            if (tooth_diff_this <= (tooth_diff_last<<1)) {
                //fell over
                if (tooth_no == 16) {
                    outpc.syncreason = 30;
                } else {
                    outpc.syncreason = 52;
                }
                ign_reset();
                return;
            }
        }
    }

    if (tooth_no == 30) {
        tooth_no = 0;
    }

    goto common_wheel;

    /************ Subaru 6/7 mode *************/
SPKMODE8:
    //  initial sync - wait for two crank teeth with at least one cam tooth in between
    if (!(synch & SYNC_SYNCED)) {
        if ((!tooth_diff_this) || (!tooth_diff_last) || (trig2cnt == 0)) {
            trig2cnt = 0;
            return;             // only sync when there's enough data
        }
        // use cam data for cylinder ID and sequential
        if (((flash4.spk_mode & 0xc0) == 0x80) || (flash4.spk_conf2 & 0x08)) {
            // only sync on 2 or 3 cam teeth. Don't sync on single one as it has no phase info.
            if (trig2cnt > 2) {
                tooth_no = 0;
                synch |= SYNC_SYNCED;
                outpc.status1 |= status1_syncok;
            } else if (trig2cnt > 1) {
                tooth_no = 6;
                synch |= SYNC_SYNCED;
                outpc.status1 |= status1_syncok;
            }
        } else {
            if (trig2cnt > 1) {
                tooth_no = 0;
            } else {
                tooth_no = 3;
            }
            synch |= SYNC_SYNCED;
            outpc.status1 |= status1_syncok;
        }
        trig2cnt = 0;
    } else {
        // recheck for sync only on teeth 1 (6) and 4(3) and second rotation
        if (tooth_no == 6) {    // (last tooth we saw)
// new sync method, use tooth times to check for sync and check cam tooth numbers over two teeth. 
            if ((tooth_diff_this < tooth_diff_last) || (tooth_diff_this < tooth_diff_last_1) || (trig2cnt < 2)) {       // must have at least one tooth in this period
                //fell over
                outpc.syncreason = 20;
                ign_reset();
                return;
            } else {
                if (!(((flash4.spk_mode & 0xc0) == 0x80) || (flash4.spk_conf2 & 0x08))) {
                    tooth_no = 0;
                }
                trig2cnt = 0;
            }
        } else if (tooth_no == 12) {    // (last tooth we saw)
// new sync method, use tooth times to check for sync and check cam tooth numbers over two teeth. 
            if ((tooth_diff_this < tooth_diff_last) || (tooth_diff_this < tooth_diff_last_1) || (trig2cnt < 2)) {       // must have at least one tooth in this period
                //fell over
                outpc.syncreason = 20;
                ign_reset();
                return;
            } else {
                tooth_no = 0;
                trig2cnt = 0;
            }
        } else if (tooth_no == 3) {
            if ((tooth_diff_this < tooth_diff_last)
                || (tooth_diff_this < tooth_diff_last_1)
                || (trig2cnt != 1)) {
                //fell over
                outpc.syncreason = 21;
                ign_reset();
                return;
            } else {
                trig2cnt = 0;
            }
        } else if ((tooth_no == 1) || (tooth_no == 4)) {
            trig2cnt = 0;
        }                       // don't reset trig2cnt on tooth 2 or tooth 5
    }

    goto common_wheel;

    /************ 99-00 Miata *************/
SPKMODE9:
    //  initial sync - wait for two crank teeth with at least one cam tooth in between
    if (!(synch & SYNC_SYNCED)) {
    	if  ((!tooth_diff_this) || (!tooth_diff_last) || (trig2cnt == 0 )) {
    	    trig2cnt = 0;
    	    return; // only sync when there's enough data
    	}

    	if (trig2cnt == 1) {
    	    tooth_no = 0;
    	} else if (trig2cnt == 2) {
    	    tooth_no = 4;
    	} else {
    	    trig2cnt = 0;
	        return; // unexpected number of 2nd triggers (noise?)
    	}
    	synch |= SYNC_SYNCED;
    	outpc.status1 |= status1_syncok;

    } else {
      	// recheck for sync
	    if (tooth_no == 4) {   // (last tooth we saw)
	        if (trig2cnt < 2) {
             outpc.syncreason = 31;
	         ign_reset();
	         return;
	        }
	    } else if (tooth_no == 8) {   // (last tooth we saw)
    	    if (trig2cnt == 0) {
                outpc.syncreason = 32;
           		ign_reset();
	            return;
	        } else {
	            tooth_no = 0;
	        }
      	}
    }

    trig2cnt = 0;

    goto common_wheel;

    /************ Mitsubishi 6g72 mode *************/
SPKMODE10:
    //  initial sync - wait for two crank teeth
    if (!(synch & SYNC_SYNCED)) {
        if  ((!tooth_diff_this) || (!tooth_diff_last)) {
            goto m6g72_exit;
        }
        // to allow events to fill before actual rpm declared
        synch |= SYNC_SEMI2;
        outpc.engine |= ENGINE_CRANK;
        outpc.rpm = 1;

        if (!(synch & SYNC_SEMI)) {
            // using falling edge as active
            // until fully synced use "synthetic" tooth numbers
            if (!edge) {
                tooth_no = 2; // for mainloop
            } else {
                tooth_no = 1; // for mainloop
                if ((edge2) && (flagbyte1 & flagbyte1_trig2statl)) {
                    synch |= SYNC_SEMI; // found crank tooth with absent cam tooth
                    tooth_no = 5; // actual 5 or 11.
                }
            }
            goto m6g72_exit;
        } else {
            tooth_no++;

            if ( ((tooth_no == 6) && (edge2)) || (tooth_no>7) ) {
                ign_reset(); // incorrect sequence, abort syncing
                goto m6g72_exit;
            }

            if (tooth_no == 7) {
                if (!edge2) {
                    tooth_no = 0;
                    goto m6g72_sync;
                } else {
                    tooth_no = 6;
                    goto m6g72_sync;
                }
            }
        }
        //goto section only reached for exit
m6g72_exit:
        flagbyte1 &= ~flagbyte1_trig2active;
        // store last 2nd trigger status
        if (edge2) {
            flagbyte1 |= flagbyte1_trig2statl;
        } else {
            flagbyte1 &= ~flagbyte1_trig2statl;
        }
        return; // only sync when there's enough data

        //continue here if synced
m6g72_sync:
	synch |= SYNC_SYNCED;
	outpc.status1 |= status1_syncok;

    } else {
        // recheck for sync
        if (tooth_no == 2) {   // (last tooth we saw)
            // cam must be high now and low on last edge
            if ((edge2) || (!(flagbyte1 & flagbyte1_trig2statl))) {
                outpc.syncreason = 33;
                ign_reset();
                return;
            }
        } else if (tooth_no == 4) {   // (last tooth we saw)
            // cam must be low now and low on last edge
            if (!(edge2) || (!(flagbyte1 & flagbyte1_trig2statl))) {
                outpc.syncreason = 34;
                ign_reset();
                return;
            }
        }

    }

    // store last 2nd trigger status
    if (edge2) {
        flagbyte1 |= flagbyte1_trig2statl;
    } else {
        flagbyte1 &= ~flagbyte1_trig2statl;
    }

    if (tooth_no == 12) {
        tooth_no = 0;
    }

    goto common_wheel;

    /************ IAW Weber-Marelli *************/
    /* As used on Sierra Cosworth, some Fiats, Lancia */
SPKMODE11:
    if (!(synch & SYNC_SYNCED)) {
	    if (!(synch & SYNC_SEMI)) {
	        if ( (!tooth_diff_this) || (!tooth_diff_last) || (!trig2cnt) ) {
		        trig2cnt = 0;
		        return;
	        }
	        synch |= SYNC_SEMI;
	        tooth_no = 0;
	        outpc.engine |= ENGINE_CRANK;
	    } else {
            tooth_no++;
	        if (trig2cnt == 0 ) {
    		    return; // wait until we see a second cam tooth
	        }
            if (tooth_no == 2) {
                goto SM11_SYNC;
            } else if (tooth_no == 6) {
                tooth_no = 0;
                goto SM11_SYNC;
            } else {
                outpc.syncreason = 35;
		        ign_reset();
            }
SM11_SYNC:;
	        synch |= SYNC_SYNCED;
            synch &= ~SYNC_SEMI;
	        outpc.status1 |= status1_syncok;
	    }
    } else {
	    // recheck for sync
	    if (tooth_no == 8) {   // (last tooth we saw)
	        if (trig2cnt == 0) {
                outpc.syncreason = 35;
		        ign_reset();
        		return;
	        } else {
        		tooth_no = 0;
	        }
	    }
    }

    trig2cnt = 0;

    goto common_wheel;
    /************ CAS 4/1 mode *************/
SPKMODE12:
    //  initial sync - wait for second trigger
    if (!(synch & SYNC_SYNCED)) {
	if  ((!tooth_diff_this) || (!tooth_diff_last) || (!edge) || (!(flagbyte1 & flagbyte1_trig2active)) ) {
	    if (edge) {
		flagbyte1 &= ~flagbyte1_trig2active;
	    }
	    return;
	}
	tooth_no = 0;
	synch |= SYNC_SYNCED;
	outpc.status1 |= status1_syncok;

    } else {
	// recheck for sync
	if (tooth_no == 8) {
	    if ( (!edge) || (!(flagbyte1 & flagbyte1_trig2active)) ) {
        outpc.syncreason = 36;
		ign_reset();
		return;
	    } else {
		tooth_no = 0;  // OK, restart sequence
	    }
	}
    }

    if (edge) {
        flagbyte1 &= ~flagbyte1_trig2active;
    }

    goto common_wheel;
    /************ 4G63 (CAS 4/2) mode *************/
    // Actually M1 (NA) Miata 89-97
SPKMODE13:
    // CAS 4/2 mode tied into "Miata" (and others?) trigger disc
    // expects correct timing, trigger angle can be tweaked, but should be around 10BTDC
    // Falling edge of crank signal is "edge" triggers on both edges
    // 2nd trig ISR not actually used, code here polls the pin on appropriate crank edge

    if (!(synch & SYNC_SYNCED)) {
	unsigned char utmp13;
	// For sync first look for rising edge of crank when cam is high
	if (!(synch & SYNC_SEMI)) {
	    unsigned char utmp13;
	    if  ( (!tooth_diff_this) || (!tooth_diff_last) ) {
		return;
	    }
	    synch |= SYNC_SEMI2;
	    outpc.engine |= ENGINE_CRANK; // declare cranking
	    outpc.rpm = 1; // bogus low rpm
	    // this should allow the code to fill advance tables before we declare sync
	    if (edge) {
		tooth_no = 2;
		return;
	    } else {
		tooth_no = 1;
	    }
	    utmp13 = portt_save & (TFLG_trig2 | 0x01);
	    // check if crank and cam the same without checking edge trigger settings
	    if ((utmp13 == (TFLG_trig2 | 0x01)) || (utmp13 == 0)) {
		synch |= SYNC_SEMI;
	    } else {
		return;
	    }
	} else {
	    // have semi synced
	    if (!edge) {
		// something went wrong, should be "edge"
        outpc.syncreason = 37;
		ign_reset();
		return;
	    }

	    utmp13 = portt_save & (TFLG_trig2 | 0x01);
	    // crank is now low..
	    // if same then this tooth is 4, otherwise 8
	    if ((utmp13 == (TFLG_trig2 | 0x01)) || (utmp13 == 0x00)) {
		tooth_no = 3;
	    } else {
		tooth_no = 7;
	    }
	    synch |= SYNC_SYNCED;
	    outpc.status1 |= status1_syncok;
	}
    } else {
	unsigned char utmp13;
	// recheck for sync
	utmp13 = portt_save & (TFLG_trig2 | 0x01);
	if (tooth_no == 3) {
	    //if not an active falling edge or cam and crank are different then fail
	    if ( (!(edge)) || (utmp13 == TFLG_trig2) || (utmp13 == 0x01) ) {
        outpc.syncreason = 38;
		ign_reset();
		return;
	    }
	} else if (tooth_no == 7) {
	    //if not an active falling edge or cam and crank are same then fail
	    if ( (!(edge)) || (utmp13 == (TFLG_trig2 | 0x01)) || (utmp13 == 0x00) ) {
        outpc.syncreason = 39;
		ign_reset();
		return;
	    }
	} else if (tooth_no == 8) {
	    tooth_no = 0;  // restart sequence
	}

    }

    goto common_wheel;
    /************ Twin trigger (bike) mode *************/
SPKMODE14:
    if (!(synch & SYNC_SYNCED)) {
	    if  ((!tooth_diff_this) || (!tooth_diff_last)) {
	        tooth_no = 0;
	        synch &= ~SYNC_SEMI;
	        return; // only sync when there's enough data
	    }
	    if (!(synch & SYNC_SEMI)) {
	        if (flagbyte4 & flagbyte4_tach2) { // flag indicating we arrived via 2nd tach input
    		    tooth_no = 2;  // normally 0, but use 2 for this syncing
	        } else {
    		    tooth_no = 1;
	        }
	        synch |= SYNC_SEMI; // we force ourselves to check for both trigger inputs
	        return;
	    } else {
	        // seen one trigger, now check it is the other, else problems
	        if (flagbyte4 & flagbyte4_tach2) {
		        if (tooth_no == 2) {
                    outpc.syncreason = 40;
		            ign_reset();
		            return;
		        }
            } else {
		        if (tooth_no == 1) {
                    outpc.syncreason = 41;
		            ign_reset();
		            return;
		        }
	        }
	        synch &= ~SYNC_SEMI;
	        synch |= SYNC_SYNCED;
	        outpc.status1 |= status1_syncok;
	    }
    } else {
	// re-check phasing is correct (could occur due to miswiring)

	    // arranging like this instead of one long "if" generates smaller asm
	    if (flagbyte4 & flagbyte4_tach2) {
	        if (tooth_no == 2) {
                outpc.syncreason = 40;
		        ign_reset();
		        return;
	        }
	    } else {
	        if (tooth_no == 1) {
                outpc.syncreason = 41;
		        ign_reset();
		        return;
	        }
	    }
    }

    if (tooth_no == 2) {
        tooth_no = 0;
    }

    goto common_wheel;
    /************ Chrysler 2.2/2.5 *************/
SPKMODE15:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {

    	// when unsynced we wait until we see a high on the other input while we rise
	    if ((!edge) && (!edge2)) {
	        tooth_no = 0;
	        synch |= SYNC_SYNCED;
	        outpc.status1 |= status1_syncok;
	    } else {
	        return;
	    }

    } else {
	    // recheck for sync
	    if (tooth_no == 10) {  // (actually tooth 1)
	        if (edge2) {
                outpc.syncreason = 42;
	        	ign_reset();
	        	return;
	        } else {
	        	tooth_no = 0;
	        }
	    }
    }

    goto common_wheel;
    /************ Renix 44-2-2 / 66-2-2-2 *************/
SPKMODE16:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
	    if  ((!tooth_diff_this) || (!tooth_diff_last) ) {
            trig2cnt = 0;
	        return; // only sync when there's enough data
	    } else if (((flash4.spk_mode & 0xc0) || (flash4.spk_conf2 & 0x08)) && (trig2cnt == 0)) {
            return; // if W/S, COP or use-cam, need a cam pulse too
        }

	    // when unsynced we wait until we see a missing double tooth
	    if (tooth_diff_this > (tooth_diff_last<<1)) {
	        tooth_no = 0;
	        synch |= SYNC_SYNCED;
	        outpc.status1 |= status1_syncok;
	    } else {
	        return;
	    }

        } else {
	    // recheck for sync
	    if ((tooth_no == 20) || (tooth_no == 40) || (tooth_no == 60) || (tooth_no == 80) || (tooth_no == 100) || (tooth_no == 120)) {
	        if (tooth_diff_this <= (tooth_diff_last<<1)) {
                outpc.syncreason = 43;
		        ign_reset();
		        return;
	        } else {
                if (tooth_no == last_tooth) {
                    if ((trig2cnt) || !((flash4.spk_mode & 0xc0) || (flash4.spk_conf2 & 0x08)) ) {
                		tooth_no = 0;
                    } else {
                        // where's my cam
                        outpc.syncreason = 43;
		                ign_reset();
		                return;
                    }
                } else {
                    trig2cnt = 0;
                }
	        }
	    }
    }

    goto common_wheel;
    /************ Suzuki swift *************/
SPKMODE17:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
	if  ((!tooth_diff_this) || (!tooth_diff_last) ) {
	    return; // only sync when there's enough data
	}
	// look for tooth longer than either of last ones
	if ((tooth_diff_this > tooth_diff_last)
		&& (tooth_diff_this > tooth_diff_last_1) ) {
	    tooth_no = 0;
	    synch |= SYNC_SYNCED;
	    outpc.status1 |= status1_syncok;
	} else {
	    return;
	}

    } else {
	// recheck for sync
	if (tooth_no == 6) {  // (one less)
	    if ((tooth_diff_this < tooth_diff_last)
		    || (tooth_diff_this < tooth_diff_last_1) ) {
        outpc.syncreason = 44;
		ign_reset();
		return;
	    } else {
		tooth_no = 0;
	    }
	}
    }

    goto common_wheel;

    /************ Suzuki vitara 2.0 *************/
SPKMODE18:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
	if  ((!tooth_diff_this) || (!tooth_diff_last) ) {
	    return; // only sync when there's enough data
	}
	if (!(synch & SYNC_SEMI)) {
	    // look for short tooth after two long ones
	    if ( ((tooth_diff_this+(tooth_diff_this>>1)) < tooth_diff_last)
		    && ((tooth_diff_this+(tooth_diff_this>>1)) < tooth_diff_last_1) ) {
		tooth_no = 0;
		synch |= SYNC_SEMI;
	    } else {
		return;
	    }
	} else {
	    // semi synced, wait a few teeth
	    tooth_no++;
	    if (tooth_no < 2) {
		return;
	    }
	    if ((tooth_diff_this+(tooth_diff_this>>1)) < tooth_diff_last) {
		tooth_no = 2;
		synch |= SYNC_SYNCED;
		outpc.status1 |= status1_syncok;
	    } else if (tooth_diff_this > (tooth_diff_last+(tooth_diff_last>>2))) {
		tooth_no = 8;
		synch |= SYNC_SYNCED;
		outpc.status1 |= status1_syncok;
	    } else {
		// failed to sync for some reason
		ign_reset();
		return;
	    }
	}

    } else {
	// recheck for sync
	if (tooth_no == 11) {  // (one less)
	    if ((tooth_diff_this > tooth_diff_last)
		    || (tooth_diff_this > tooth_diff_last_1) ) {
        outpc.syncreason = 45;
		ign_reset();
		return;
	    } else {
		tooth_no = 0;
	    }
	} else if (tooth_no == 6) {  // (one less)
	    if ((tooth_diff_this > tooth_diff_last)
		    || (tooth_diff_this > tooth_diff_last_1) ) {
        outpc.syncreason = 46;
		ign_reset();
		return;
	    }
	}
    }

    goto common_wheel;

    /************ Daihatsu 3 cyl *************/
SPKMODE19:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
	if  ((!tooth_diff_this) || (!tooth_diff_last) || (!tooth_diff_last_1)) {
	    return; // only sync when there's enough data
	}
	//look for short tooth gap - this is tooth no.1
	ltmp1 = tooth_diff_this <<1;
	if ( (tooth_diff_last > ltmp1) && (tooth_diff_last_1 > ltmp1) ) {
	    tooth_no = 0;
	    synch |= SYNC_SYNCED;
	    outpc.status1 |= status1_syncok;
	} else {
	    return;
	}

    } else {
	// recheck for sync
	if (tooth_no == 4) {  // (one less)
	    ltmp1 = tooth_diff_this <<1;
	    if ( (tooth_diff_last > ltmp1) && (tooth_diff_last_1 > ltmp1) ) {
		    tooth_no = 0;
	    } else {
            outpc.syncreason = 47;
		    ign_reset();
		    return;
	    }
	}
    }

    goto common_wheel;

    /************ Daihatsu 4 cyl *************/
SPKMODE20:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
	if  ((!tooth_diff_this) || (!tooth_diff_last) || (!tooth_diff_last_1)) {
	    return; // only sync when there's enough data
	}
	//look for short tooth gap - this is tooth no.1
	ltmp1 = tooth_diff_this <<1;
	if ( (tooth_diff_last > ltmp1) && (tooth_diff_last_1 > ltmp1) ) {
	    tooth_no = 0;
	    synch |= SYNC_SYNCED;
	    outpc.status1 |= status1_syncok;
	} else {
	    return;
	}

    } else {
	// recheck for sync
	if (tooth_no == 5) {  // (one less)
	    ltmp1 = tooth_diff_this <<1;
	    if ( (tooth_diff_last > ltmp1) && (tooth_diff_last_1 > ltmp1) ) {
    		tooth_no = 0;
	    } else {
            outpc.syncreason = 48;
    		ign_reset();
		return;
	    }
	}
    }

    goto common_wheel;

    /************ Honda VTR1000 *************/
SPKMODE21:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
	if  ((!tooth_diff_this) || (!tooth_diff_last)) {
	    return; // only sync when there's enough data
	}
	//look for long tooth gap - this is tooth no.1
	ltmp1 = tooth_diff_this <<1;
	if ( tooth_diff_this > (tooth_diff_last << 1) ) {
	    tooth_no = 0;
	    synch |= SYNC_SYNCED;
	    outpc.status1 |= status1_syncok;
	} else {
	    return;
	}

    } else {
	// recheck for sync
	if (tooth_no == 9) {  // (one less)
	    if ( tooth_diff_this > (tooth_diff_last << 1) ) {
    		tooth_no = 0;
	    } else {
            outpc.syncreason = 49;
    		ign_reset();
		return;
	    }
	}

    }

    goto common_wheel;

    /************ Rover 36-1-1 mode *************/
SPKMODE22:
//initial sync
            if (!(synch & SYNC_SYNCED)) {
                if  ((!tooth_diff_this) || (!tooth_diff_last) ) {
                    return; // only sync when there's enough data
                }
                // when unsynced we wait until we see a missing tooth
                temp1 = tooth_diff_last + (tooth_diff_last>>1); // 1.5*
                if (tooth_diff_this > temp1) {
                    tooth_no = 0;
                    synch |= SYNC_SYNCED;
                    outpc.status1 |= status1_syncok;
                } else {
                  return;
                }

    } else {
        // recheck for sync - revised method
        // this now does the calc on every tooth - previously only did it on tooth 17
        temp1 = tooth_diff_last + (tooth_diff_last>>1); // 1.5*
        if (tooth_diff_this > temp1) { // missing tooth
            if (tooth_no != 17) {  // we are expecting tooth no. 17 (one less)
                //fell over
//                ign_reset(); // old method - one shot and you are out
                // be more tolerant
	            syncerr++;
                outpc.synccnt++;
                return;
            }
            tooth_no = 0;
        }
    }

    goto common_wheel;

    /************ Rover 36-1-1-1-1 mode2 (EU3) *************/
    // used on SPI Mini
SPKMODE23:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
        if  ((!tooth_diff_this) || (!tooth_diff_last) || (!tooth_diff_last_1)) {
            flagbyte1 &= ~flagbyte1_trig2active;
            return; // only sync when there's enough data
        }

        // when unsynced we wait until we see a missing tooth and then another one
        // and count the teeth in-between

        if (!(synch & SYNC_SEMI)) { // just starting
            temp1 = tooth_diff_last + (tooth_diff_last>>1); // 1.5*
            if (tooth_diff_this > temp1) {
                tooth_no = 0;
                synch |= SYNC_SEMI; // started sync sequence
            }
            flagbyte1 &= ~flagbyte1_trig2active; // assume that cam tooth must occur between missing tooth segments
            return;
        } else { // started sequence, check possible sync points
            tooth_no++;
            if (!(synch & SYNC_SEMI2)) { // just starting
                temp1 = tooth_diff_last + (tooth_diff_last>>1); // 1.5*
                if (tooth_diff_this > temp1) {
                    if (tooth_no == 2) {
                        tooth_no = 0; // tooth 1
                        goto WHL_ROV2_OK;
                    } else if (tooth_no == 3) {
                        tooth_no = 17; // tooth 18
                        goto WHL_ROV2_OK;
                    } else if (tooth_no == 13) {
                        tooth_no = 30; // tooth 15
                        goto WHL_ROV2_OK;
                    } else if (tooth_no == 14) {
                        tooth_no = 14; // tooth 31
                        goto WHL_ROV2_OK;
                    } else {
                        tooth_no = 0; // doesn't make sense, so try again from this missing tooth
                    }
                }
                return;
            }
        }
WHL_ROV2_OK:

	    synch &= ~SYNC_SEMI;
	    synch &= ~SYNC_SEMI2;
	    synch |= SYNC_SYNCED;
	    outpc.status1 |= status1_syncok;

        if (((flash4.spk_mode & 0xc0) == 0x80) || (flash4.spk_conf2 & 0x08)) { // COP or use-cam
            if (flagbyte1 & flagbyte1_trig2active) {
                tooth_no += 32;
                flagbyte1 &= ~flagbyte1_trig2active;
            }
        }

    } else {
        // recheck for sync in normal running
        if ((tooth_no == 14) || (tooth_no == 17) || (tooth_no == 30) || (tooth_no == 32) || (tooth_no == 46) || (tooth_no == 49) || (tooth_no == 62) || (tooth_no == 64) ) {  // (one less)
            temp1 = tooth_diff_last + (tooth_diff_last>>1); // 1.5*
            if (tooth_diff_this <= temp1) {
                outpc.syncreason = 22;
                ign_reset();
                return;
            } else {
                // sync recheck passed, now if in cam/cop mode, see if we are on right phase
                // intended to allow us to sync on wrong phase and 'fix' it soon afterwards
                // ought to start on wasted cop too, but not implemented yet
                if (((flash4.spk_mode & 0xc0) == 0x80) || (flash4.spk_conf2 & 0x08)) { // COP or use-cam
                    if ((tooth_no < 33) && (flagbyte1 & flagbyte1_trig2active) ) {
                        tooth_no += 32;
                    }
                }
            }           
            if (tooth_no == 32) {
                if (!(((flash4.spk_mode & 0xc0) == 0x80) || (flash4.spk_conf2 & 0x08))) { // COP or use-cam
                    tooth_no = 0;
                }
            } else if (tooth_no == 64) {
                tooth_no = 0;
            }
            flagbyte1 &= ~flagbyte1_trig2active;
        }
    }

    goto common_wheel;

    /************ Rover 36-1-1-1-1 mode3 - do not know application *************/
SPKMODE24:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
        if  ((!tooth_diff_this) || (!tooth_diff_last) || (!tooth_diff_last_1)) {
            return; // only sync when there's enough data
        }

        // when unsynced we wait until we see a missing tooth and then another one
        // and count the teeth in-between

        if (!(synch & SYNC_SEMI)) { // just starting
            temp1 = tooth_diff_last + (tooth_diff_last>>1); // 1.5*
            if (tooth_diff_this > temp1) {
                tooth_no = 0;
                synch |= SYNC_SEMI; // started sync sequence
            }
            return;
        } else { // started sequence, check possible sync points
            tooth_no++;
            if (!(synch & SYNC_SEMI2)) { // just starting
                temp1 = tooth_diff_last + (tooth_diff_last>>1); // 1.5*
                if (tooth_diff_this > temp1) {
                    if (tooth_no == 4) {
                        tooth_no = 0; // tooth 1
                        goto WHL_ROV3_OK;
                    } else if (tooth_no == 5) {
                        tooth_no = 16; // tooth 17
                        goto WHL_ROV3_OK;
                    } else if (tooth_no == 11) {
                        tooth_no = 11; // tooth 12
                        goto WHL_ROV3_OK;
                    } else if (tooth_no == 12) {
                        tooth_no = 28; // tooth 29
                        goto WHL_ROV3_OK;
                    } else {
                        tooth_no = 0; // doesn't make sense, so try again from this missing tooth
                    }
                }
                return;
            }
        }
WHL_ROV3_OK:

	    synch &= ~SYNC_SEMI;
	    synch &= ~SYNC_SEMI2;
	    synch |= SYNC_SYNCED;
	    outpc.status1 |= status1_syncok;

    } else {
        // recheck for sync
        if ((tooth_no == 11) || (tooth_no == 16) || (tooth_no == 28) || (tooth_no == 32)) {  // (one less)
            temp1 = tooth_diff_last + (tooth_diff_last>>1); // 1.5*
            if (tooth_diff_this <= temp1) {
                outpc.syncreason = 50;
                ign_reset();
                return;
            }
            if (tooth_no == 32) {
                tooth_no = 0;
            }
        }
    }

    goto common_wheel;

    /************ GM 7X native *************/
SPKMODE25:
    //initial sync
    if (!(synch & SYNC_SYNCED)) {
	    if  ((!tooth_diff_this) || (!tooth_diff_last) || (!tooth_diff_last_1)) {
	        return; // only sync when there's enough data
	    }
	    //look for short tooth gap - this is tooth no.7
	    ltmp1 = tooth_diff_this <<1;
	    if ( (tooth_diff_last > ltmp1) && (tooth_diff_last_1 > ltmp1) ) {
	        tooth_no = 6;
	        synch |= SYNC_SYNCED;
	        outpc.status1 |= status1_syncok;
	    } else {
	        return;
	    }

    } else {
	    // recheck for sync
	    if (tooth_no == 6) {  // (one less)
	        ltmp1 = tooth_diff_this <<1;
	        if (!( (tooth_diff_last > ltmp1) && (tooth_diff_last_1 > ltmp1) )) {
                outpc.syncreason = 51;
		        ign_reset();
		        return;
	        }
	    } else if (tooth_no == 7) {
            tooth_no = 0;
        }
    }

    goto common_wheel;
/* Nissan CAS and optispark to go in here LATER!*/

        /************  Nissan QR25DE *************/
        /* This is 36-2-2 with a number of cam notches for id */
        /* find a missing tooth, declare SEMI, count cam teeth then SYNC */
  SPKMODE28:
//initial sync
    if (!(synch & SYNC_SYNCED)) {
        if ((!tooth_diff_this) || (!tooth_diff_last)) {
            return;             // only sync when there's enough data
        }
        if (!(synch & SYNC_SEMI)) {
            // when unsynced we wait until we see a missing double tooth
            temp1 = tooth_diff_last << 1;       // *2
            if (tooth_diff_this > temp1) {
                tooth_no = 0;
                synch |= SYNC_SEMI;
                trig2cnt = 0;
            } else {
                return;
            }
        } else {
            // we've seen one missing tooth, now look for the second
            tooth_no++;
            if (tooth_no == 16) {
                temp1 = tooth_diff_last << 1;       // *2
                if (tooth_diff_this > temp1) {
        // NOTE! Only care about the cam this once
        //these tooth numbers are made up
                    if (trig2cnt == 1) {
                        tooth_no = 0;
                    } else if (trig2cnt == 3) {
                        tooth_no = 16;
                    } else if (trig2cnt == 4) {
                        tooth_no = 32;
                    } else if (trig2cnt == 2) {
                        tooth_no = 48;
                    } else {
                        //failed to get cam sync correctly
                        goto mode25_semi_fail;
                    }
                    synch |= SYNC_SYNCED;
                    outpc.status1 |= status1_syncok;
                    trig2cnt = 0;
                } else {
mode25_semi_fail:;
                    // went wrong
                    outpc.syncreason = 63;
                    ign_reset();
                    return;
                }
            } else {
                return; // not there yet
            }
        }
    } else {
        //re-sync on crank only. No need to re-check cam.
        if ((tooth_no == 16) || (tooth_no == 32) || (tooth_no == 48) || (tooth_no == 64)) {
            temp1 = tooth_diff_last << 1;       // *2
            if (tooth_diff_this > temp1) {
                if (tooth_no == 64) {
                    tooth_no = 0;
                }
            } else {
                outpc.syncreason = 63;
                ign_reset();
                return;
            }
        }
    }
    goto common_wheel;

        /* ----------------------  Honda RC-51  --------------------*/
SPKMODE29:
    //  initial sync - wait for two crank teeth with at least one cam tooth in between
    if (!(synch & SYNC_SYNCED)) {
        if (!(synch & SYNC_SEMI)) {
        	if  ((!tooth_diff_this) || (!tooth_diff_last) || (!(flagbyte1 & flagbyte1_trig2active))) {
        	    flagbyte1 &= ~flagbyte1_trig2active;
        	    return; // only sync when there's enough data
        	}
            // just found the first cam pulse
            synch |= SYNC_SEMI;
            tooth_no = 0;
      	    flagbyte1 &= ~flagbyte1_trig2active;
            return;
        } else {
            tooth_no++;
            if (!(flagbyte1 & flagbyte1_trig2active)) {
                return;
            }
            // now we've had two cam pulses
            if (tooth_no == 10) {
                tooth_no = 16;
                goto rc51_ok;
            } else if (tooth_no == 2) {
                tooth_no = 18;
                goto rc51_ok;
            } else if (tooth_no == 12) {
                tooth_no = 6;
                goto rc51_ok;
            } else {
                outpc.syncreason = 53;
		        ign_reset();
		        return;
            }
        }
rc51_ok:
    	synch &= ~SYNC_SEMI;
    	synch |= SYNC_SYNCED;
    	outpc.status1 |= status1_syncok;
    } else {
        if ((tooth_no == 6) || (tooth_no == 16) || (tooth_no == 18)) {
            if (!(flagbyte1 & flagbyte1_trig2active)) {
                if (tooth_no == 6) {
                    outpc.syncreason = 54;
                } else if (tooth_no == 16) {
                    outpc.syncreason = 55;
                } else {
                    outpc.syncreason = 56;
                }
		        ign_reset();
		        return; 
            }
        } else if (tooth_no == 24) {
            tooth_no = 0;
        }
    }

    flagbyte1 &= ~flagbyte1_trig2active;

    goto common_wheel;
    /************ CAS 360 modes *************/
SPKMODE_CAS360:
    return; // nothing yet
    /************ GM LS1 *************/
  SPKMODE40:
    if (!(synch & SYNC_SYNCED)) {
        if ((!tooth_diff_this) || (!tooth_diff_last) ) {      // wait for at least two teeth
            return;
        }
        
        if (!(synch & SYNC_SEMI)) {
            if (edge || (tooth_diff_this > (tooth_diff_last << 1)) || ((tooth_diff_this << 1) < tooth_diff_last)) {
                // bail if falling edge or teeth are not similar
                return;
            } else {
                // have no found two similar (equal) sized teeth
                synch |= SYNC_SEMI;
                ls1_sl = 0;
                ls1_ls = 0;
            } 
        } else {
            // semi code
            if (edge) { // count on falling
                if (tooth_diff_this > (tooth_diff_last << 1)) {
                    ls1_sl++;
                } else if ((tooth_diff_this << 1) < tooth_diff_last) {
                    ls1_ls++;
                }
                return;
            } else { // check on rising
                if ((tooth_diff_this > (tooth_diff_last << 1)) 
                    || ((tooth_diff_this << 1) < tooth_diff_last)) {
                    return;
                } else {
                    // equal sized - check for sync
                    if ((ls1_sl == 5) && (ls1_ls == 0)) {
                        tooth_no = 4;
                        goto SPKMODE40_COM;
                    } else if ((ls1_sl == 3) && (ls1_ls == 0)) {
                        tooth_no = 8;
                        goto SPKMODE40_COM;
                    } else if ((ls1_sl == 0) && (ls1_ls == 2)) {
                        tooth_no = 10;
                        goto SPKMODE40_COM;
                    } else if ((ls1_sl == 2) && (ls1_ls == 0)) {
                        tooth_no = 12;
                        goto SPKMODE40_COM;
                    } else if ((ls1_sl == 0) && (ls1_ls == 3)) {
                        tooth_no = 15;
                        goto SPKMODE40_COM;
                    } else if ((ls1_sl == 0) && (ls1_ls == 5)) {
                        tooth_no = 23;
SPKMODE40_COM:;
                        synch |= SYNC_SYNCED;
                        synch &= ~SYNC_SEMI;
                    	outpc.status1 |= status1_syncok;
                    } else {
                        // invalid tooth count, try again
                            ls1_sl = 0;
                            ls1_ls = 0;
                    }
                }
            }
        }

        return;
    } else {
        // resync code - none yet
        if (tooth_no >= last_tooth) {
            tooth_no = 0;
        } else if ((!edge) && ((tooth_no == 4) || (tooth_no == 10) || (tooth_no == 16))) { // check on rising
// re-sync on 23 removed - was giving a false sync-loss
            if ((tooth_diff_this > (tooth_diff_last << 1)) || ((tooth_diff_this << 1) < tooth_diff_last)) {
                outpc.syncreason = 68;
                ign_reset();
                return;
            }
        }
    }

    // only use falling edge for timing
    if (!edge) {
        return;
    }

    goto common_wheel;
    /************ YZF1000 *************/
  SPKMODE41:
    if (!(synch & SYNC_SYNCED)) {
        unsigned long tmp_tooth, tmp_tooth2;
        if ((!tooth_diff_this) || (!tooth_diff_last) || (!tooth_diff_last_1) ) {      // wait for at least three teeth
            return;
        }
        tmp_tooth = tooth_diff_this + (tooth_diff_this >> 1);
        tmp_tooth2 = tooth_diff_last_1 + (tooth_diff_last_1 >> 1);
        if ((tmp_tooth < tooth_diff_last) && ((tooth_diff_this + tooth_diff_last) > tmp_tooth2)) {
            // found the first regular tooth after the weird one
            synch |= SYNC_SYNCED;
        	outpc.status1 |= status1_syncok;
            tooth_no = 0;
        } else {
            return;
        }
    } else {
        // these are invalid tooth no.s but should be ok as we don't reach common_wheel
        if (tooth_no == 7) {
            tooth_no++;
            return; // we ignore this tooth for timing, handle tooth 0 specially below
        } else if (tooth_no == 8) {
            unsigned long tmp_tooth, tmp_tooth2;
            tmp_tooth = tooth_diff_this + (tooth_diff_this >> 1);
            tmp_tooth2 = tooth_diff_last_1 + (tooth_diff_last_1 >> 1);
            if ((tmp_tooth < tooth_diff_last) && ((tooth_diff_this + tooth_diff_last) > tmp_tooth2)) {
                // found the first regular tooth after the weird one
                tooth_no = 0;
            } else {
                outpc.syncreason = 69;
                ign_reset();
                return;
            }
        }
    }

    goto common_wheel;
    /************ fuel only mode *************/
SPKMODEFUEL:
    synch |= SYNC_SYNCED;
    outpc.status1 |= status1_syncok; /* have sync */
    thistoothevents |= FUEL; // every tach event is a fuel tooth
    /************ end of the long if for different variants of wheel mode *************/

common_wheel:
    if (synch & SYNC_FIRST) {
        syncfirst();
    }
    if (synch & SYNC_SYNCED) {
        tooth_no++;
        if (tooth_no > last_tooth) {
	        if (!((spkmode == 2) || (spkmode == 3) || (spkmode == 31)) ) { // NOT 2,3, 31
                outpc.syncreason = 10;
	            syncerr++;
                outpc.synccnt++;
            }
	        tooth_no = 1;
	    }

        if ((spkmode == 5) || (spkmode == 6) || (spkmode == 40) || ((spkmode == 41) && (tooth_no == 1)))  {
            // Neon/420A and 36-1+1 join up tooth times. Same for YZF1000 over weird tooth
            dtpred_adder += tooth_diff_this + tooth_diff_last; // look for more flexible way to do this
            tooth_diff_rpm_last = tooth_diff_rpm;
            tooth_diff_rpm.time_32_bits = tooth_diff_this+tooth_diff_last;
            tooth_no_rpm = tooth_no;
        } else {
            dtpred_adder += tooth_diff_this;
            tooth_no_rpm = tooth_no;
            tooth_diff_rpm_last = tooth_diff_rpm;
            tooth_diff_rpm.time_32_bits = tooth_diff_this;
        }
        // log to ring buffer for mainloop to extract tooth times
        act_tooth_time[tooth_counter] = tooth_diff_rpm;
        act_tooth_num[tooth_counter] = tooth_no;
        tooth_counter++;
        if (tooth_counter >= WHEEL_NUM_TEETH) {
            tooth_counter = 0;
        }

        if (outpc.rpm == 0) {
            outpc.rpm = 1; // fake non zero rpm
            outpc.engine |= ENGINE_CRANK; // declare cranking
        }

    }
    //--- added JSM
    // if we get repeated additional or lost teeth then something is wrong
    if (syncerr > 3) {
        outpc.syncreason = 12;
        ign_reset();
        return;
    }
    //---

    /* update the dwell and spark time... if possible.
     * Make sure that dwell and spark tooth are both
     * still the same, otherwise don't update.
     */
    if ((next_dwell.tooth == dwell_events[next_dwell.coil].tooth) &&
            (next_spark.tooth == spark_events[next_spark.coil].tooth)) {
        next_dwell.time32 = dwell_events[next_dwell.coil].time32;
        next_spark.time32 = spark_events[next_spark.coil].time32;
    }

	if ((flash8.seq_inj & 0x03) != 0) {	
	    if (next_fuel1_event.tooth == fuel1_events[next_fuel1_event.inj].tooth) {
	        next_fuel1_event.time = fuel1_events[next_fuel1_event.inj].time;
	    }
	    if (next_fuel2_event.tooth == fuel2_events[next_fuel2_event.inj].tooth) {
	        next_fuel2_event.time = fuel2_events[next_fuel2_event.inj].time;
	    }
	    if (next_fuel3_event.tooth == fuel3_events[next_fuel3_event.inj].tooth) {
	        next_fuel3_event.time = fuel3_events[next_fuel3_event.inj].time;
	    }
	    if (next_fuel4_event.tooth == fuel4_events[next_fuel4_event.inj].tooth) {
	        next_fuel4_event.time = fuel4_events[next_fuel4_event.inj].time;
	    }
	}

    if (flash10.RotarySplitMode & 0x20) {
        if ((next_dwl_trl.tooth == dwell_events[next_dwl_trl.coil].tooth) &&
                (next_spk_trl.tooth == spark_events[next_spk_trl.coil].tooth)) {
            next_dwl_trl.time32 = dwell_events[next_dwl_trl.coil].time32;
            next_spk_trl.time32 = spark_events[next_spk_trl.coil].time32;
        }
    }

    /* now I need to figure out which coil I want to fire,
     * or if I'm on a "fuel tooth"
     */

    // distributor mode
    // calc the spark and dwell timing right here for best accuracy with the low tooth count
    if ((spkmode == 2) || (spkmode == 3)) {  // 2,3
        unsigned long tooth_diff_next;

        if ((coilsel) && (pg4_ptr->adv_offset < 200)) {
            // there's a spark pending, fire it
            TIE &= ~TFLG_ign;
            TFLG1 = TFLG_ign;
            fire_coil();
        }

        if (flash4.ICIgnOption & 0x08) {
            // isn't the next period at all (reflects the odd period we just had) but is the best estimate used to
            // calculate the delay until spark
            // For oddfire we using two periods for the scaling calc
            tooth_diff_next = tooth_diff_this + tooth_diff_last;
            if (tooth_diff_last_1 && tooth_diff_last_2) { // enough old data to do prediction
                tooth_diff_next = (tooth_diff_next << 1) - tooth_diff_last_1 - tooth_diff_last_2; // 1st deriv prediction over longer period
            }
        } else {
            tooth_diff_next = (tooth_diff_this << 1) - tooth_diff_last; // 1st deriv prediction worked fine in MS1.
        }

        if ((spkmode == 3) && ((outpc.rpm < 100) || (outpc.engine & ENGINE_CRANK))) {
            // In trigger return during cranking we'll use the late timer driven spark while
            // expecting that the return will actually do the business
            next_spark.time32 = muldiv(trigret_scaler, tooth_diff_next);
        } else {
            next_spark.time32 = muldiv(dizzy_scaler[tooth_no-1], tooth_diff_next);
        }

        if (next_spark.time32 < 150) { // same number as below
            next_spark.time32 = 151; // prevent it getting too close to trigger
        }
  
        thistoothevents |= SPARK;
        if (num_spk > 1) { // i.e. 2
            if (tooth_no & 1) {
                tmpcoilsel = 1;
            } else {
                tmpcoilsel = 2;
            }
        } else {
            tmpcoilsel = 1;
        }
      
        if (flash4.dwellmode != 2) {
            unsigned long tmp_next_sparktime;
            unsigned char tmp_tooth;
            tmpdwellsel = 1; // FIXME oddfire ?

            if (flash4.ICIgnOption & 0x08) { // oddfire
                tmp_tooth = tooth_no;
                if (tmp_tooth >= no_teeth) { // look at next tooth period
                    tmp_tooth = 0;
                }
                // redo spark calc for period coming up (as best we can) using old data
                tmp_next_sparktime = muldiv(dizzy_scaler[tmp_tooth], tooth_diff_next);
            } else {
                if ((spkmode == 3) && ((outpc.rpm < 100) || (outpc.engine & ENGINE_CRANK))) {
                    // in trigger return figure out when we think the return-spark ought to happen 
                    tmp_next_sparktime = muldiv(dizzy_scaler[tooth_no-1], tooth_diff_next);
                } else {
                    tmp_next_sparktime = next_spark.time32;
                }
            }

            // choose to schedule dwell from this trigger (low speeds)
            if (next_spark.time32 > (dwell_long + 70)) {
                // have time to schedule dwell from here
                // this is for a dwell coming after this trigger and before the spark
                thistoothevents |= DWELL;
                if ((spkmode == 3) && ((outpc.rpm < 100) || (outpc.engine & ENGINE_CRANK))) {
                    next_dwell.time32 = tmp_next_sparktime - dwell_long;
                } else { // normal
                    next_dwell.time32 = next_spark.time32 - dwell_long;
                }
                dwell_us = 0;
            } else {
                // this is when the dwell happens before the trigger i.e. after the spark
                next_dwell.time32 = 0;
                thistoothevents &= ~DWELL;
                // always dwell here in case of rapid accel where stepback happened too fast
                if (!spk_cutx) { // see a rogue pulse otherwise
                    dwellsel = 1;
                    dwell_coil_cut();
                }
            }

            // and/or to schedule from the back of the previous spark (high speeds)
            // during the transition, both can happen harmlessly
            if ((dwell_long > (tmp_next_sparktime - 250)) || (tmp_next_sparktime < 251)) {
                unsigned long tt;
                if (flash4.ICIgnOption & 0x08) { // oddfire, grab the real period (expected period coming up)
                    tooth_diff_next = tooth_diff_last;
                }

                tt = tooth_diff_next - dwell_long;
                if (pg4_ptr->adv_offset < 200) { // next-cyl
                    tt = tt + tmp_next_sparktime - next_spark.time32;
                }

                if ((unsigned int)(tt >> 16)) { // if (tt > 65535) {
                    // shouldn't happen.. must be extreme advance at low rpms
                    // fire dwell very shortly from now
                    dwell_us = 0;
                    dwellsel_next = 0;
                } else {
                    dwell_us = (unsigned int)tt;

                    if (num_spk > 1) { // i.e. 2
                        if (tooth_no & 1) {
                            dwellsel_next = 2;
                        } else {
                            dwellsel_next = 1;
                        }
                    } else {
                        dwellsel_next = 1;
                    }
                }
            } else {
                dwell_us = 0;
            }
        }

    /************* twin trigger ************ */
    } else if (spkmode == 14) { // twin trigger
        unsigned long tooth_diff_next;
        // here we'll handle the twin trigger almost like two independent 'distributors'
        // so odd or even is irrelevant

        if (tooth_diff_last_2) {
            tooth_diff_next = ((tooth_diff_this + tooth_diff_last) << 1) - (tooth_diff_last_1 + tooth_diff_last_2); // 1st deriv prediction
        } else if (tooth_diff_last) {
            tooth_diff_next = tooth_diff_this + tooth_diff_last;
        } else {
            tooth_diff_next = tooth_diff_this << 1; // would be a problem if oddfire. Condition avoided with enough skip_teeth
        }

        if (tooth_no == 1) {
            if ((coilsel) && (flash4.adv_offset < 200)) {
                // there's a spark pending, fire it
                TIE &= ~TFLG_ign;
                TFLG1 = TFLG_ign;
                fire_coil();
            }

            next_spark.time32 = muldiv(dizzy_scaler[0], tooth_diff_next);

            if (next_spark.time32 < 150) { // same number as below
                next_spark.time32 = 151; // prevent it getting too close to trigger
            }
      
            thistoothevents |= SPARK;
            tmpcoilsel = 1;
          
            if (flash4.dwellmode != 2) {
                unsigned long tmp_next_sparktime;
                tmpdwellsel = 1;

                tmp_next_sparktime = next_spark.time32;

                // choose to schedule dwell from this trigger (low speeds)
                if (next_spark.time32 > (dwell_long + 70)) {
                    // have time to schedule dwell from here
                    // this is for a dwell coming after this trigger and before the spark
                    thistoothevents |= DWELL;
                    next_dwell.time32 = next_spark.time32 - dwell_long;
                    dwell_us = 0;
                } else {
                    // this is when the dwell happens before the trigger i.e. after the spark
                    next_dwell.time32 = 0;
                    thistoothevents &= ~DWELL;
                    if (!spk_cutx) {
                        dwellsel = 1;
                        dwell_coil_cut();
                    }
                }

                // and/or to schedule from the back of the previous spark (high speeds)
                // during the transition, both can happen harmlessly
                if ((dwell_long > (tmp_next_sparktime - 250)) || (tmp_next_sparktime < 251)) {
                    unsigned long tt;

                    tt = tooth_diff_next - dwell_long;
                    if (pg4_ptr->adv_offset < 200) { // next-cyl
                        tt = tt + tmp_next_sparktime - next_spark.time32;
                    }

                    if ((unsigned int)(tt >> 16)) { // if (tt > 65535)
                        // shouldn't happen.. must be extreme advance at low rpms
                        // fire dwell very shortly from now
                        dwell_us = 0;
                        dwellsel_next = 0;
                    } else {
                        dwell_us = (unsigned int)tt;
                        dwellsel_next = 1;
                    }
                } else {
                    dwell_us = 0;
                }
            }

        } else { // tooth_no == 2

            // For the second spark output we'll use the rotary dwell and spark timers
            // to give an independent spark system

            if ((rotaryspksel) && (pg4_ptr->adv_offset < 200)) {
                // there's a spark pending, fire it
                TIE &= ~TFLG_rotINJ4;
                TFLG1 = TFLG_rotINJ4;
                tt2s_sub();
            }

            next_spk_trl.time32 = muldiv(dizzy_scaler[1], tooth_diff_next);

            if (next_spk_trl.time32 < 150) { // same number as below
                next_spk_trl.time32 = 151; // prevent it getting too close to trigger
            }

            thistoothevents |= ROTARY_SPK;
            rotaryspksel = 1;
          
            if (flash4.dwellmode != 2) {
                unsigned long tmp_next_sparktime;
                rotarydwlsel = 1;

                tmp_next_sparktime = next_spk_trl.time32;

                // choose to schedule dwell from this trigger (low speeds)
                if (next_spk_trl.time32 > (dwell_long + 70)) {
                    // have time to schedule dwell from here
                    // this is for a dwell coming after this trigger and before the spark
                    thistoothevents |= ROTARY_DWL;
                    next_dwl_trl.time32 = next_spk_trl.time32 - dwell_long;
                    dwell_us2 = 0;
                } else {
                    // this is when the dwell happens before the trigger i.e. after the spark
                    next_dwl_trl.time32 = 0;
                    thistoothevents &= ~ROTARY_DWL;
                    rotarydwlsel = 1;
                    tt2d_sub();
                }

                // and/or to schedule from the back of the previous spark (high speeds)
                // during the transition, both can happen harmlessly
                if ((dwell_long > (tmp_next_sparktime - 250)) || (tmp_next_sparktime < 251)) {
                    unsigned long tt;

                    tt = tooth_diff_next - dwell_long;
                    if (pg4_ptr->adv_offset < 200) { // next-cyl
                        tt = tt+ tmp_next_sparktime - next_spk_trl.time32;
                    }

                    if ((unsigned int)(tt >> 16)) { // if (tt > 65535)
                        // shouldn't happen.. must be extreme advance at low rpms
                        // fire dwell very shortly from now
                        dwell_us2 = 0;
                    } else {
                        dwell_us2 = (unsigned int)tt;
                    }
                } else {
                    dwell_us2 = 0;
                }

            }
        }

    } else { // regular wheel modes

        if (next_spark.tooth == tooth_no) {
            thistoothevents = SPARK;
            tmpcoilsel = 0;
            SET_COIL(&next_spark.coil, &tmpcoilsel);
        }

        if ((next_dwell.tooth == tooth_no) && (flash4.dwellmode != 2)) {
            thistoothevents |= DWELL;
            tmpdwellsel = 0;
            SET_COIL(&next_dwell.coil, &tmpdwellsel);
        }

        if (flash10.RotarySplitMode & 0x20) {
            if (next_spk_trl.tooth == tooth_no) {
                thistoothevents |= ROTARY_SPK;
                SET_COIL(&next_spk_trl.coil, &rotaryspksel);
            }

            if (next_dwl_trl.tooth == tooth_no) {
                thistoothevents |= ROTARY_DWL;
                SET_COIL(&next_dwl_trl.coil, &rotarydwlsel);
            }
        }
    }

    if (next_map_start_event.tooth == tooth_no) {
        thistoothevents |= MAPSTART;
    }

    if (next_fuel == tooth_no) {
        thistoothevents |= FUEL;
    }

    /* set the timer here. */
    if (thistoothevents & SPARK) {
        /* used by all modes */
        unsigned int lp = 0;
TDE_S:;
        if (next_spark.time32 < 140) {
            // check how long dwell has been on delay spark if needed
            // not written yet
            TIE &= ~TFLG_ign;  //*** JB was 0x04
            coilsel = tmpcoilsel;
            fire_coil();
        } else if (next_spark.time32 < 250) {
            TC_ign = (unsigned short)(TC0this + next_spark.time16_low);
            TIE |= TFLG_ign;
            TFLG1 = TFLG_ign;	 // clear ign OC interrupt flag
            coilsel = tmpcoilsel;
        } else {
            /* use queue - allows up to 8 seconds */
            unsigned int time_mms, time_us;
//            time_mms = (next_spark.time32 / 192);
            time_mms = muldiv(341, next_spark.time32); // same effect but should be faster
            if (time_mms > 4) {
                time_mms-= 4;
            } else {
                time_mms = 1;
            }
            time_us = TC0this + next_spark.time16_low;
            if (spkq[0].sel == 0) {
                spkq[0].sel = tmpcoilsel;
                spkq[0].time_us = time_us;
                spkq[0].time_mms = time_mms;
            } else {
                spkq[1].sel = tmpcoilsel;
                spkq[1].time_us = time_us;
                spkq[1].time_mms = time_mms;
            }
        }

        if (spkmode != 14) {
            /* next one */
            if (next_spark.coil == no_triggers - 1) {
                next = 0;
            } else {
                next = next_spark.coil + 1;
            }
            next_spark.time = spark_events[next].time;
            next_spark.tooth = spark_events[next].tooth;
            next_spark.coil = spark_events[next].coil;
            next_spark.ftooth = spark_events[next].ftooth;
            next_spark.fs = spark_events[next].fs;

            /* re-check for a second event from same tooth */
            if ((next_spark.tooth == tooth_no) && (lp < 2)) {
                lp++;
                tmpcoilsel = 0;
                SET_COIL(&next_spark.coil, &tmpcoilsel);
                goto TDE_S;
            }
        }
    }

    if (thistoothevents & DWELL) {
        /* not used by dizzy or twin-trigger which schedule dwell after spark in ign_in */
        unsigned int lp = 0;
TDE_D:;
        if (next_dwell.time32 < 140) {
            TIE &= ~TFLG_dwl;
            dwellsel = tmpdwellsel;
            dwell_coil_cut();
        } else if (next_dwell.time32 < 250) {
            TC_dwl = (unsigned short)(TC0this + next_dwell.time16_low);
            TIE |= TFLG_dwl;
            TFLG1 = TFLG_dwl;	 // clear dwell OC interrupt flag
            dwellsel = tmpdwellsel;
        } else {
            /* use queue - allows up to 8 seconds */
            unsigned int time_mms, time_us;
//            time_mms = (next_dwell.time32 / 192);
            time_mms = muldiv(341, next_dwell.time32); // same effect but should be faster
            if (time_mms > 4) {
                time_mms-= 4;
            } else {
                time_mms = 1;
            }
            time_us = TC0this + next_dwell.time16_low;
            if (dwellq[0].sel == 0) {
                dwellq[0].sel = tmpdwellsel;
                dwellq[0].time_us = time_us;
                dwellq[0].time_mms = time_mms;
            } else {
                dwellq[1].sel = tmpdwellsel;
                dwellq[1].time_us = time_us;
                dwellq[1].time_mms = time_mms;
            }
        }

        if (spkmode != 14) {
            /* next one */
            if (next_dwell.coil == no_triggers - 1) {
                next = 0;
            } else {
                next = next_dwell.coil + 1;
            }
            next_dwell.time = dwell_events[next].time;
            next_dwell.tooth = dwell_events[next].tooth;
            next_dwell.coil = dwell_events[next].coil;
        
            /* re-check for a second event from same tooth */
            if ((next_dwell.tooth == tooth_no) && (flash4.dwellmode != 2)
                && (lp < 2)) {
                lp++;
                tmpdwellsel = 0;
                SET_COIL(&next_dwell.coil, &tmpdwellsel);
                goto TDE_D;
            }
        }
    }

    if (thistoothevents & ROTARY_DWL) {
        if(next_dwl_trl.time32 < 150) {
            TIE &= ~TFLG_rotINJ3;  //*** JB was 0x80
            if (spkmode == 14) {
                tt2d_sub();
            } else {
                dwell_coil_rotary();
            }
        } else if (!next_dwl_trl.time16_high) {
            TC_rotINJ3 = (unsigned short)(TC0this + next_dwl_trl.time16_low);  //*** JB was TC7
            TIE |= TFLG_rotINJ3;  //*** JB was 0x80
            TFLG1 = TFLG_rotINJ3;  //*** JB was 0x80
        } else {
            wheeldec_ovflo |= OVFLO_ROT_DWL;
            dwl_time_ovflo_trl.time_32_bits = next_dwl_trl.time32 + TC0_32bits;
        }

        if (spkmode != 14) {
            if (next_dwl_trl.coil == 2) {
                next = 3;
            } else {
                next = 2;
            }

            next_dwl_trl.time = dwell_events[next].time;
            next_dwl_trl.tooth = dwell_events[next].tooth;
            next_dwl_trl.coil = dwell_events[next].coil;
        }
    }

    if (thistoothevents & ROTARY_SPK) {
        if (next_spk_trl.time32 < 150) {
            TIE &= ~TFLG_rotINJ4;
            if (spkmode == 14) {
                tt2s_sub();
            } else {
                fire_coil_rotary();
            }
        } else if (!next_spk_trl.time16_high) {
            TC_rotINJ4 = (unsigned short)(TC0this + next_spk_trl.time16_low);
            TIE |= TFLG_rotINJ4;
            TFLG1 = TFLG_rotINJ4;
        } else {
            wheeldec_ovflo |= OVFLO_ROT_SPK;
            spk_time_ovflo_trl.time_32_bits = next_spk_trl.time32 + TC0_32bits;
        }

        if (spkmode != 14) {
            if (next_spk_trl.coil == 2) {
                next = 3;
            } else {
                next = 2;
            }

            next_spk_trl.time = spark_events[next].time;
            next_spk_trl.tooth = spark_events[next].tooth;
            next_spk_trl.coil = spark_events[next].coil;
        }
    }

     if (thistoothevents & MAPSTART) {
        map_start_countdown = next_map_start_event.time;
        map_window_set = next_map_start_event.map_window_set;
        if (next_map_start_event.evnum == no_triggers - 1) {
            next = 0;
        } else {
            next = next_map_start_event.evnum + 1;
        }

        next_map_start_event.tooth = map_start_event[next].tooth;
        next_map_start_event.time = map_start_event[next].time;
        next_map_start_event.map_window_set = map_start_event[next].map_window_set;
        next_map_start_event.evnum = map_start_event[next].evnum;
        map_deadman++;
    }

	if (((flash8.seq_inj & 0x03) != 0) && ((outpc.status3 & status3_cut_fuel) == 0)) {	
		schedule_fuel(TC0this);
	}

    if (thistoothevents & FUEL) {
		// keep this even with timed injection for housekeeping

        // trigger logger
        if (flagbyte0 & flagbyte0_trglog) {

            __asm__ __volatile__ (
                    "ldab  %1\n"
                    "andb  #0xf\n" // top 4 bits not used in trigger logger for consistency
                    "stab  0,Y\n"
                    "ldd  %2\n"
                    "std  1,Y\n"
                    :
                    : "y" (log_offset+ram_data),
                    "m" (*((unsigned char *)&dtpred+1)), // byte 3:**2**:1:0
                    "m" (*((unsigned int *)&dtpred+1))  // bytes 3:2:**1**:**0**
                    );
            log_offset+=3;


            if (log_offset > 1023) {
                flagbyte0 &= ~flagbyte0_trglog; // turn off logger
                outpc.status3 |= status3_donelog;
            }
        }



        if (fuel_cntr == no_triggers - 1) {
            fuel_cntr = 0;
        } else {
            fuel_cntr++;
        }
        next_fuel = trigger_teeth[(unsigned)fuel_cntr];
        dtpred_last3 = dtpred_last2;
        dtpred_last2 = dtpred_last;
        dtpred_last = dtpred;
        dtpred = dtpred_adder;
        dtpred_adder = 0;
        synch |= SYNC_RPMCALC;
        goto START_INJ;
    }
    goto IC_EXIT;

    //*******************************************************************************
DO_EDIS:
    // calculate new dt. All times in ticks to save *3/2 or *2/3
    tooth_time2 = tooth_time1;
    tooth_time1 = TC0_32bits;
    dt2 = dt3;
    dt3 = tooth_time1 - tooth_time2;

    // make the MAP sample code sample.

    map_start_countdown = 1;
    map_window_set = 1;

    if(pulse_no >= flash4.no_skip_pulses)  {
        // after 1st few pulses, start checking for missed/ extra pulses
        if(PulseTol < 100)  {
            if(dt3 < ((100 - PulseTol) * dt2) / 100)  {
                // reject false trigger
                tooth_time1 = tooth_time2;
                dt3 = dt2;
                outpc.dt3 = (int)dt3;
                // clear IC interrupt flag
                TFLG1 = 0x01;
                return;                     // wait for next (true) pulse
            }
        }
        ltmp1 = ((100 + PulseTol) * dt2) / 100;
        if(dt3 > ltmp1)  {
            missed_pulse++;
            if(missed_pulse > 2)  {
                PORTE &= ~0x10;   // Turn off fuel Pump
                *pPTMpin[2] &= ~0x04;  // Turn off fast idle ** Bug Fix By Guy Hill **
                outpc.syncreason = 15;
                ign_reset();
                return;
            }
            // make up for missing pulse - set dt3 to last dt2
            dt3 = dt2;
        }
        else  {
            missed_pulse = 0;
        }
    }
    outpc.dt3 = dt3;

    // if we got here then we are alive
    outpc.status1 |= status1_syncok; /* show sync on MT display */
    synch |= SYNC_SYNCED; // ensure stall timeout runs

    // use last period
    dtpred_old = dtpred;
    dtpred = dt3;
    if(pulse_no < flash4.no_skip_pulses)  {  // skip 1st few (>1) pulses
        pulse_no++;
        // clear IC interrupt flag
        TFLG1 = 0x01;
//        return;
        goto START_INJ; // squirt some fuel right away for faster starts
    }
    else  {
        if(pulse_no < 3)
            pulse_no++;
    }
    // calculate rpm in mainloop

    if (dtpred <= 100)  {
        // Noise or beyond rev limit, clear all in engine
        PORTE &= ~0x10;   // Turn off fuel Pump
        *pPTMpin[2] &= ~0x04;  // Turn off fast idle ** Bug Fix By Guy Hill **
        outpc.syncreason = 16;
        ign_reset();
        return;
    }

    synch |= SYNC_RPMCALC;

// trigger logger (tooth logger not relevant or supported for EDIS)
    if (flagbyte0 & flagbyte0_trglog) {

        __asm__ __volatile__ (
                "ldab  %1\n"
                "andb  #0xf\n" // top 4 bits not used in trigger logger for consistency
                "stab  0,Y\n"
                "ldd  %2\n"
                "std  1,Y\n"
                :
                : "y" (log_offset+ram_data),
            "m" (*((unsigned char *)&dtpred+1)), // byte 3:**2**:1:0
            "m" (*((unsigned int *)&dtpred+1))  // bytes 3:2:**1**:**0**
                );
        log_offset+=3;


        if (log_offset > 1023) {
            flagbyte0 &= ~flagbyte0_trglog; // turn off logger
            outpc.status3 |= status3_donelog;
        }
    }

    // EDIS Ignition Output
    // cyl n                                   cyl n+1
    // tdc                                        tdc
    //  |-------- dtpred ---------------------------|
    //  |-delay- __________                         |
    //  |       |          |                        |
    //  |       |---SAW----|                        |
    //  |       |          |                        |
    //  |_______|          |________________________|
    // TC0
    //
    // send SAW pulse after delay, so we don't send
    // SAW while still sparking (send at 64us atdc)
    charge_time = 96;   //64us
    // SAW pulse calculation
    ltmp1 = coil_dur; // calculated in mainloop
    // multispk EDIS
    if(spkmode== 1)  {
        if (flagbyte4 & flagbyte4_first_edis)  {		 // 1st SAW for multispk is 2048 us
            flagbyte4 &= ~flagbyte4_first_edis;
            ltmp1 = 3072;      //2048us  1024 if ever have 10 cyl
        }
        else if(outpc.rpm < 1200)  {
            ltmp1 += 3072;     //2048us 1024 if ever have 10 cyl
        }
    }
    coil_dur_calc = ltmp1;
    outpc.coil_dur = coil_dur_calc;
    coil_dur_set = coil_dur_calc;
    IgnOCpinstate = SPK;
    ign_setpin = CHG;  // use to set OC o/p in OL5
    // load OC compare register, 64us after start of ISR
    TC5 = 400 + TC0;  // added delay to keep away from spark noise.
    // Set Ign OC pin & enable interrupt
//    TCTL1 = (TCTL1 & 0xFB) | (ign_setpin << 2);
    if (ign_setpin) {
        TCTL1 |= 0x04;
    } else {
        TCTL1 &= ~0x04;
    }
    TIE |= 0x20;
    TFLG1 = 0x20;	 // clear ign OC interrupt flag

    //	    goto START_INJ;

    //*******************************************************************************

START_INJ:
    // Set up for Injector squirt(s)
    if(igncount == 0)
        asecount++;
    egocount++;

    staged_num_events++;

    // Turn on fuel pump
    PORTE |= 0x10;
    outpc.engine |= ENGINE_READY;   // set engine running

    //low-res period timer
    lowres = lowres_ctr;
    lowres_ctr = 0;

    //do tacho output
    if ((flash5.tacho_opt & 0x80) && (flash4.userlevel > 127)) {
		tacho_out();
    }

    if(outpc.engine & ENGINE_CRANK)goto SCHED_SQUIRT;
    if(!(flagbyte3 & flagbyte3_toothinit))goto SCHED_SQUIRT;

    igncount++;
    if (divider == 1) {
        EAElag_squirting = 0;
        goto SCHED_SQUIRT;
    } else {
        if(igncount < divider) {
            if (!(flagbyte2 & flagbyte2_EAElag)) {
                if ((EAElagcomp_squirts > 0) && (EAElagcomp_squirts < num_cyl)) {
                    EAElagcomp_squirts++;
                    EAElag_squirting = 1;
                    goto SCHED_SQUIRT_NOEAE;
                }
                EAElagcomp_squirts = 0;
                EAElag_squirting = 0;
                goto IC_EXIT;				  // skip Divider tach pulses
            } else {
                EAElagcomp_squirts++;
                if (EAElagcomp_squirts == num_cyl) {
                    EAElagcomp_squirts = 0;
                }
                EAElag_squirting = 1;
                goto SCHED_SQUIRT_NOEAE;
            }
        }
    }

SCHED_SQUIRT:
    if (flash4.EAEOption) {
        WF1 += AWA1;
        if (SOA1 <= WF1) {
            WF1 -= SOA1;
        } else {
            WF1 = 0;
        }
        WF2 += AWA2;
        if (SOA2 <= WF2) {
            WF2 -= SOA2;
        } else {
            WF2 = 0;
        }
    }
    igncount = 0;

SCHED_SQUIRT_NOEAE:
    if(flash4.RevLimOption & 2)  {
        if (outpc.rpm > RevLimRpm2) {
            // Cut fuel for Over Rev
            outpc.status3 |= status3_cut_fuel;
        } else if (outpc.rpm < RevLimRpm1) {
            // restore fuel
            outpc.status3 &= ~status3_cut_fuel;
        }
        if (outpc.status3 & status3_cut_fuel)  {
            outpc.pw1 = 0;   // Jedrik fix - let world know injectors are off
			req_pw1 = 0;
            outpc.pw2 = 0;
			req_pw2 = 0;
			if (!(seq_inj_ctrl & SEQ_STD_INJ)) {
	            outpc.pw3 = 0;   // Jedrik fix - let world know injectors are off
				req_pw3 = 0;
	            outpc.pw4 = 0;
				req_pw4 = 0;
			}
            goto IC_EXIT;
        }
    }
    if (flash4.OverBoostOption & 0x01) {
        if (outpc.status2 & status2_overboost_active) {
            outpc.status3 |= status3_cut_fuel;
        } else {
            outpc.status3 &= ~status3_cut_fuel;
        }
        if (outpc.status3 & status3_cut_fuel)  {
            outpc.pw1 = 0;   // Jedrik fix - let world know injectors are off
			req_pw1 = 0;
            outpc.pw2 = 0;
			req_pw2 = 0;
			if (!(seq_inj_ctrl & SEQ_STD_INJ)) {
	            outpc.pw3 = 0;   // Jedrik fix - let world know injectors are off
				req_pw3 = 0;
	            outpc.pw4 = 0;
				req_pw4 = 0;
			}
            goto IC_EXIT;
        }
    }

    if (outpc.engine & ENGINE_CRANK) { // if engine cranking
        flagbyte3 &= ~flagbyte3_toothinit;
        if ((!(flagbyte3 & flagbyte3_toothinit)) && (flash4.Alternate & 0x02)) { 
            // alternate during cranking option
            goto DO_ALT;
        }
        sched_both = 1;
        goto SCHED1;
    }

    // run mode
    if (flash10.feature3 & 0x08) {
        if (tooth_no == tooth_init) {  // wait for chosen tooth
            if (!(flagbyte3 & flagbyte3_toothinit)) {
                flagbyte3 |= flagbyte3_toothinit;
                igncount = 0;
                altcount = 1;
            }
        } else {
            if (!(flagbyte3 & flagbyte3_toothinit)) {
                sched_both = 1;
                goto SCHED1;
            }
        }
    } else {
        flagbyte3 |= flagbyte3_toothinit;
    }

    if (!(flash4.Alternate & 0x01))  { // if no alternate option (i.e. simultaneous)
        sched_both = 1;
        goto SCHED1;
    }

DO_ALT:
    sched_both = 0;
    altcount = 1 - altcount;
    if(altcount)
        goto SCHED2;

SCHED1:
	if ((flash8.seq_inj & 0x03) != 0) {	
		goto IC_EXIT;
	}

    /* Catch a rare race condition that can cause semi-sequential
     * to pick the wrong tooth
     */ 
    if ((flash10.feature3 & 0x08) && (tooth_init != tooth_no)) {
        flagbyte3 &= ~flagbyte3_toothinit;
        sched_both = 1;
    }
    // Turn On Inj1
    // Set up to turn Off Inj1 when get to pw us
    inj1cntdown = injtime;
    if (EAElag_squirting) {
        outpc.pw1 = pwcalc_eae1;
        inj1cntdown = injtime_EAElagcomp;
    } else {
        outpc.pw1 = add_open(pwcalc1, pw_open1);
    }
	req_pw1 = outpc.pw1;
    igncount = 0; 

    if(!sched_both) {
        goto IC_EXIT;
    }

SCHED2:
	if ((flash8.seq_inj & 0x03) != 0) {	
		goto IC_EXIT;
	}

    inj2cntdown = injtime;
    // Set up to turn Off Inj2 when get to pw us
    if (EAElag_squirting) {
        outpc.pw2 = pwcalc_eae2;
        inj2cntdown = injtime_EAElagcomp;
    } else {
        outpc.pw2 = add_open(pwcalc2, pw_open2);
    }
	req_pw2 = outpc.pw2;

IC_EXIT:
    if (false_mask_crk) {
        // Set up to re-enable IC interrupt in Timer ISR after a part of the time
        //  to next IC has elapsed to avoid noise false interrupts
        t_enable_IC = ltch_lmms + false_mask_crk;
        TIE &= ~0x01;   // disable interrupt
        TFLG1 = 0x01;		// clear flag
    } else {
        t_enable_IC = 0xffffffff; // keep int enabled
    }

    //IC_END:
    //    outpc.istatus5 = TCNT - TC0; // how long did ISR take
EXIT:
    return;
}

void tacho_out(void)
{
    //do tacho output
	unsigned char tmp_opt;
	if (flash5.tacho_opt & 0x40) {
		if (flagbyte0 & flagbyte0_to) {
			flagbyte0 &= ~flagbyte0_to;
			tacho_targ = lowres;
		} else {
			flagbyte0 |= flagbyte0_to;
			tacho_targ = 1; // i.e. turn off asap
			return;
		}
	} else {
		tacho_targ = lowres >>1;
	}
	tmp_opt = flash5.tacho_opt & 0x3f;
	if (tmp_opt == 0) {
		PORTT |= 0x20;
	} else if (tmp_opt == 1) {
		PORTT |= 0x80;
	} else if (tmp_opt == 2) {
		PORTT |= 0x40;
	} else if (tmp_opt == 3) {
		PORTA |= 0x01;
	} else if (tmp_opt == 4) {
		PORTM |= 0x04;
	} else if (tmp_opt == 5) {
		PORTM |= 0x08;
	} else if (tmp_opt == 6) {
		PORTM |= 0x10;
	} else if (tmp_opt == 7) {
		PORTM |= 0x20;
	} else if (tmp_opt == 8) {
		PTAD |= 0x40;
	} else if (tmp_opt == 9) {
		PTAD |= 0x80;
	}
}
